/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.client.util;

import com.google.gwt.core.client.GWT;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.RpcRequestBuilder;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.kura.web.shared.ForwardedEventTopic;
import org.eclipse.kura.web.shared.model.GwtEventInfo;
import org.eclipse.kura.web.shared.service.GwtEventService;
import org.eclipse.kura.web.shared.service.GwtEventServiceAsync;

public final class EventService {
    private static final int ON_FAILURE_RESEND_DELAY = 5000;
    private static final EventService instance = new EventService();
    private final GwtEventServiceAsync gwtEventService = (GwtEventServiceAsync)GWT.create(GwtEventService.class);
    private HashMap<String, LinkedList<Handler>> subscribedHandlers = new HashMap();
    private long lastEventTimestamp = 0L;
    private Timer resendTimer;
    private final AsyncCallback<List<GwtEventInfo>> eventCallback = new AsyncCallback<List<GwtEventInfo>>(){

        public void onSuccess(List<GwtEventInfo> result) {
            for (GwtEventInfo event : result) {
                this.processEvent(event);
            }
            this.stopResendTimer();
            EventService.this.gwtEventService.getNextEvents(Long.toString(EventService.this.lastEventTimestamp), (AsyncCallback<List<GwtEventInfo>>)EventService.this.eventCallback);
        }

        public void onFailure(Throwable caught) {
            this.startResendTimer(5000);
        }

        private void processEvent(GwtEventInfo event) {
            if (event == null) {
                return;
            }
            EventService.this.lastEventTimestamp = Long.parseLong(event.getTimestamp());
            LinkedList topicHandlers = (LinkedList)EventService.this.subscribedHandlers.get(event.getTopic());
            if (topicHandlers != null) {
                for (Handler handler : topicHandlers) {
                    handler.handleEvent(event);
                }
            }
        }

        private void startResendTimer(int timeout) {
            this.stopResendTimer();
            EventService.this.resendTimer = new Timer(){

                public void run() {
                    EventService.this.gwtEventService.getNextEvents(Long.toString(EventService.this.lastEventTimestamp), (AsyncCallback<List<GwtEventInfo>>)EventService.this.eventCallback);
                }
            };
            EventService.this.resendTimer.schedule(timeout);
        }

        private void stopResendTimer() {
            if (EventService.this.resendTimer != null) {
                EventService.this.resendTimer.cancel();
            }
            EventService.this.resendTimer = null;
        }
    };

    private EventService() {
        ((ServiceDefTarget)this.gwtEventService).setRpcRequestBuilder((RpcRequestBuilder)new TimeoutRequestBuilder());
        this.gwtEventService.getLastEventTimestamp(new AsyncCallback<String>(){

            public void onSuccess(String result) {
                EventService.this.lastEventTimestamp = Long.parseLong(result);
                EventService.this.gwtEventService.getNextEvents(Long.toString(EventService.this.lastEventTimestamp), (AsyncCallback<List<GwtEventInfo>>)EventService.this.eventCallback);
            }

            public void onFailure(Throwable caught) {
            }
        });
    }

    public static void subscribe(ForwardedEventTopic topic, Handler handler) {
        LinkedList<Handler> topicHandlers = EventService.instance.subscribedHandlers.get(topic.toString());
        if (topicHandlers == null) {
            topicHandlers = new LinkedList();
            EventService.instance.subscribedHandlers.put(topic.toString(), topicHandlers);
        }
        topicHandlers.push(handler);
    }

    public static void unsubscribe(ForwardedEventTopic topic, Handler handler) {
        LinkedList<Handler> topicHandlers = EventService.instance.subscribedHandlers.get(topic.toString());
        if (topicHandlers != null) {
            topicHandlers.remove(handler);
        }
    }

    public static interface Handler {
        public void handleEvent(GwtEventInfo var1);
    }

    private class TimeoutRequestBuilder
    extends RpcRequestBuilder {
        private TimeoutRequestBuilder() {
        }

        protected RequestBuilder doCreate(String serviceEntryPoint) {
            RequestBuilder builder = super.doCreate(serviceEntryPoint);
            builder.setTimeoutMillis(30000);
            return builder;
        }
    }
}

