/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.server;

import com.google.gwt.user.server.rpc.SerializationPolicy;
import com.google.gwt.user.server.rpc.SerializationPolicyLoader;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.kura.web.Console;
import org.eclipse.kura.web.server.KuraRemoteServiceServlet;

public class OsgiRemoteServiceServlet
extends KuraRemoteServiceServlet {
    private static final long serialVersionUID = -8826193840033103296L;

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Thread currentThread = Thread.currentThread();
        ClassLoader oldContextClassLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        try {
            super.service(req, resp);
        }
        finally {
            currentThread.setContextClassLoader(oldContextClassLoader);
        }
    }

    protected SerializationPolicy doGetSerializationPolicy(HttpServletRequest request, String moduleBaseURL, String strongName) {
        String contextPath = request.getContextPath();
        String modulePath = null;
        String servletRoot = Console.getServletRoot();
        if (moduleBaseURL != null) {
            try {
                modulePath = new URL(moduleBaseURL).getPath();
            }
            catch (MalformedURLException ex) {
                this.log("Malformed moduleBaseURL: " + moduleBaseURL, ex);
            }
        }
        SerializationPolicy serializationPolicy = null;
        if (modulePath == null || !modulePath.startsWith(contextPath)) {
            String message = "ERROR: The module path requested, " + modulePath + ", is not in the same web application as this servlet, " + contextPath + ".  Your module may not be properly configured or your client and server code maybe out of date.";
            this.log(message, null);
        } else {
            String file;
            String contextRelativePath = modulePath.substring(contextPath.length());
            String serializationPolicyFilePath = SerializationPolicyLoader.getSerializationPolicyFileName((String)(String.valueOf(contextRelativePath) + strongName));
            InputStream is = this.getServletContext().getResourceAsStream(serializationPolicyFilePath);
            if (is == null) {
                file = "/www" + servletRoot + serializationPolicyFilePath.substring(serializationPolicyFilePath.indexOf("/", 1));
                this.log("Trying www resource2: " + file);
                is = Thread.currentThread().getContextClassLoader().getResourceAsStream(file);
            }
            if (is == null) {
                this.log("Trying " + servletRoot + servletRoot + " resource1: " + serializationPolicyFilePath);
                is = Thread.currentThread().getContextClassLoader().getResourceAsStream(serializationPolicyFilePath);
            }
            if (is == null) {
                file = serializationPolicyFilePath.substring(serializationPolicyFilePath.indexOf("/", 1));
                this.log("Trying " + servletRoot + " resource3: " + file);
                is = Thread.currentThread().getContextClassLoader().getResourceAsStream(file);
            }
            if (is == null) {
                file = serializationPolicyFilePath.substring(serializationPolicyFilePath.lastIndexOf("/"));
                this.log("Trying / resource4: " + file);
                is = Thread.currentThread().getContextClassLoader().getResourceAsStream(file);
            }
            try {
                if (is != null) {
                    try {
                        serializationPolicy = SerializationPolicyLoader.loadFromStream((InputStream)is, null);
                    }
                    catch (ParseException e) {
                        this.log("ERROR: Failed to parse the policy file '" + serializationPolicyFilePath + "'", e);
                    }
                    catch (IOException e) {
                        this.log("ERROR: Could not read the policy file '" + serializationPolicyFilePath + "'", e);
                    }
                } else {
                    String message = "ERROR: The serialization policy file '" + serializationPolicyFilePath + "' was not found; did you forget to include it in this deployment?";
                    this.log(message, null);
                }
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return serializationPolicy;
    }
}

