/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin.spi;

import java.io.IOException;
import java.util.HashMap;
import org.apache.felix.deploymentadmin.AbstractDeploymentPackage;
import org.apache.felix.deploymentadmin.AbstractInfo;
import org.apache.felix.deploymentadmin.ResourceInfoImpl;
import org.apache.felix.deploymentadmin.spi.Command;
import org.apache.felix.deploymentadmin.spi.CommitResourceCommand;
import org.apache.felix.deploymentadmin.spi.DeploymentSessionImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.deploymentadmin.DeploymentException;
import org.osgi.service.deploymentadmin.spi.ResourceProcessor;
import org.osgi.service.deploymentadmin.spi.ResourceProcessorException;

public class ProcessResourceCommand
extends Command {
    private final CommitResourceCommand m_commitCommand;

    public ProcessResourceCommand(CommitResourceCommand commitCommand) {
        this.m_commitCommand = commitCommand;
    }

    public void execute(DeploymentSessionImpl session) throws DeploymentException {
        this.addRollback(new RollbackCommitAction(session));
        AbstractDeploymentPackage source = session.getSourceAbstractDeploymentPackage();
        BundleContext context = session.getBundleContext();
        HashMap<String, AbstractInfo> expectedResources = new HashMap<String, AbstractInfo>();
        AbstractInfo[] resourceInfos = source.getResourceInfos();
        for (int i = 0; i < resourceInfos.length; ++i) {
            AbstractInfo resourceInfo = resourceInfos[i];
            if (resourceInfo.isMissing()) continue;
            expectedResources.put(resourceInfo.getPath(), resourceInfo);
        }
        try {
            String allowForeignCustomerizers = System.getProperty("org.apache.felix.deploymentadmin.allowforeigncustomizers", "false");
            while (!expectedResources.isEmpty()) {
                AbstractInfo jarEntry = source.getNextEntry();
                if (jarEntry == null) {
                    throw new DeploymentException(463, "Expected more resources in the stream: " + expectedResources.keySet());
                }
                String name = jarEntry.getPath();
                ResourceInfoImpl resourceInfo = (ResourceInfoImpl)expectedResources.remove(name);
                if (resourceInfo == null) {
                    throw new DeploymentException(463, "Resource '" + name + "' is not described in the manifest.");
                }
                ServiceReference ref = source.getResourceProcessor(name);
                if (ref != null) {
                    String serviceOwnerSymName = ref.getBundle().getSymbolicName();
                    if (source.getBundleInfoByName(serviceOwnerSymName) != null || "true".equals(allowForeignCustomerizers)) {
                        ResourceProcessor resourceProcessor = (ResourceProcessor)context.getService(ref);
                        if (resourceProcessor != null) {
                            try {
                                if (this.m_commitCommand.addResourceProcessor(resourceProcessor)) {
                                    resourceProcessor.begin(session);
                                }
                                resourceProcessor.process(name, source.getCurrentEntryStream());
                                continue;
                            }
                            catch (ResourceProcessorException rpe) {
                                if (rpe.getCode() == 461) {
                                    throw new DeploymentException(461, "Sharing violation while processing resource '" + name + "'", rpe);
                                }
                                throw new DeploymentException(463, "Error while processing resource '" + name + "'", rpe);
                            }
                        }
                        throw new DeploymentException(464, "No resource processor for resource: '" + name + "'");
                    }
                    throw new DeploymentException(458, "Resource processor for resource '" + name + "' belongs to foreign deployment package");
                }
                throw new DeploymentException(464, "No resource processor for resource: '" + name + "'");
            }
        }
        catch (IOException e) {
            throw new DeploymentException(463, "Problem while reading stream", e);
        }
    }

    private class RollbackCommitAction
    implements Runnable {
        private final DeploymentSessionImpl m_session;

        public RollbackCommitAction(DeploymentSessionImpl session) {
            this.m_session = session;
        }

        public void run() {
            ProcessResourceCommand.this.m_commitCommand.rollback(this.m_session);
        }
    }
}

