/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.deployment.install;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.cloudconnection.publisher.CloudNotificationPublisher;
import org.eclipse.kura.core.deployment.CloudDeploymentHandlerV2;
import org.eclipse.kura.core.deployment.DeploymentPackageOptions;
import org.eclipse.kura.core.deployment.InstallStatus;
import org.eclipse.kura.core.deployment.download.DeploymentPackageDownloadOptions;
import org.eclipse.kura.core.deployment.install.DeploymentPackageInstallOptions;
import org.eclipse.kura.core.deployment.install.KuraInstallPayload;
import org.eclipse.kura.core.util.ProcessUtil;
import org.eclipse.kura.core.util.SafeProcess;
import org.eclipse.kura.message.KuraResponsePayload;
import org.osgi.service.deploymentadmin.DeploymentAdmin;
import org.osgi.service.deploymentadmin.DeploymentException;
import org.osgi.service.deploymentadmin.DeploymentPackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstallImpl {
    private static final Logger s_logger = LoggerFactory.getLogger(InstallImpl.class);
    private static final int PROGRESS_COMPLETE = 100;
    private static final String MESSAGE_CONFIGURATION_FILE_NOT_SPECIFIED = "Configuration file not specified";
    public static final String RESOURCE_INSTALL = "install";
    public static final String PERSISTANCE_SUFFIX = "_persistance";
    public static final String PERSISTANCE_FOLDER_NAME = "persistance";
    public static final String PERSISTANCE_VERIFICATION_FOLDER_NAME = "verification";
    public static final String PERSISTANCE_FILE_NAME = "persistance.file.name";
    private DeploymentPackageInstallOptions options;
    private final CloudDeploymentHandlerV2 callback;
    private DeploymentAdmin deploymentAdmin;
    private Properties m_installPersistance;
    private String dpaConfPath;
    private final String m_installVerifDir;
    private final String m_installPersistanceDir;
    private String packagesPath;

    public InstallImpl(CloudDeploymentHandlerV2 callback, String kuraDataDir) {
        this.callback = callback;
        StringBuilder pathSB = new StringBuilder();
        pathSB.append(kuraDataDir);
        pathSB.append(File.separator);
        pathSB.append(PERSISTANCE_FOLDER_NAME);
        this.m_installPersistanceDir = pathSB.toString();
        File installPersistanceDir = new File(this.m_installPersistanceDir);
        if (!installPersistanceDir.exists()) {
            installPersistanceDir.mkdir();
        }
        pathSB = new StringBuilder();
        pathSB.append(this.m_installPersistanceDir);
        pathSB.append(File.separator);
        pathSB.append(PERSISTANCE_VERIFICATION_FOLDER_NAME);
        this.m_installVerifDir = pathSB.toString();
        File installVerificationDir = new File(this.m_installVerifDir);
        if (!installVerificationDir.exists()) {
            installVerificationDir.mkdir();
        }
    }

    public String getVerificationDirectory() {
        return this.m_installVerifDir;
    }

    public Properties getDeployedPackages() {
        Properties deployedPackages = new Properties();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileInputStream fis = new FileInputStream(this.dpaConfPath);){
                deployedPackages.load(fis);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            s_logger.error("Error opening package configuration file", (Throwable)e);
        }
        return deployedPackages;
    }

    public void setOptions(DeploymentPackageInstallOptions options) {
        this.options = options;
    }

    public void setPackagesPath(String packagesPath) {
        this.packagesPath = packagesPath;
    }

    public void setDeploymentAdmin(DeploymentAdmin deploymentAdmin) {
        this.deploymentAdmin = deploymentAdmin;
    }

    public void setDpaConfPath(String dpaConfPath) {
        this.dpaConfPath = dpaConfPath;
    }

    public void installDp(DeploymentPackageInstallOptions options, File dpFile) throws KuraException {
        SafeProcess proc = null;
        try {
            try {
                this.installDeploymentPackageInternal(dpFile);
                this.installCompleteAsync(options, dpFile.getName());
                s_logger.info("Install completed!");
                if (options.isReboot()) {
                    Thread.sleep(options.getRebootDelay());
                    proc = ProcessUtil.exec((String)"reboot");
                }
            }
            catch (Exception e) {
                s_logger.info("Install failed!");
                this.installFailedAsync(options, dpFile.getName(), e);
                if (proc != null) {
                    ProcessUtil.destroy(proc);
                }
            }
        }
        finally {
            if (proc != null) {
                ProcessUtil.destroy(proc);
            }
        }
    }

    public void installSh(DeploymentPackageOptions options, File shFile) throws KuraException {
        this.updateInstallPersistance(shFile.getName(), options);
        SafeProcess proc = null;
        try {
            try {
                proc = ProcessUtil.exec((String)("chmod 700 " + shFile.getCanonicalPath()));
            }
            catch (IOException iOException) {
                throw new KuraException(KuraErrorCode.INTERNAL_ERROR);
            }
        }
        catch (Throwable throwable) {
            if (proc != null) {
                ProcessUtil.destroy(proc);
            }
            throw throwable;
        }
        if (proc != null) {
            ProcessUtil.destroy((SafeProcess)proc);
        }
        SafeProcess proc2 = null;
        try {
            try {
                proc2 = ProcessUtil.exec((String)shFile.getCanonicalPath());
            }
            catch (IOException iOException) {
                throw new KuraException(KuraErrorCode.INTERNAL_ERROR);
            }
        }
        finally {
            if (proc2 != null) {
                ProcessUtil.destroy((SafeProcess)proc2);
            }
        }
    }

    public void installInProgressSyncMessage(KuraResponsePayload respPayload) {
        respPayload.setTimestamp(new Date());
        respPayload.addMetric("dp.install.status", (Object)InstallStatus.IN_PROGRESS.getStatusString());
        respPayload.addMetric("dp.name", (Object)this.options.getDpName());
        respPayload.addMetric("dp.version", (Object)this.options.getDpVersion());
    }

    public void installIdleSyncMessage(KuraResponsePayload respPayload) {
        respPayload.setTimestamp(new Date());
        respPayload.addMetric("dp.install.status", (Object)InstallStatus.IDLE.getStatusString());
    }

    public void installCompleteAsync(DeploymentPackageOptions options, String dpName) throws KuraException {
        KuraInstallPayload notify = new KuraInstallPayload(options.getClientId());
        notify.setTimestamp(new Date());
        notify.setInstallStatus(InstallStatus.COMPLETED.getStatusString());
        notify.setJobId(options.getJobId());
        notify.setDpName(dpName);
        notify.setInstallProgress(100);
        this.callback.publishMessage(options, notify, RESOURCE_INSTALL);
    }

    public void installFailedAsync(DeploymentPackageInstallOptions options, String dpName, Exception e) throws KuraException {
        KuraInstallPayload notify = new KuraInstallPayload(options.getClientId());
        notify.setTimestamp(new Date());
        notify.setInstallStatus(InstallStatus.FAILED.getStatusString());
        notify.setJobId(options.getJobId());
        notify.setDpName(dpName);
        notify.setInstallProgress(0);
        if (e != null) {
            notify.setErrorMessage(e.getMessage());
        }
        this.callback.publishMessage(options, notify, RESOURCE_INSTALL);
    }

    public void sendInstallConfirmations(String notificationPublisherPid, CloudNotificationPublisher notificationPublisher) {
        s_logger.info("Ready to send Confirmations");
        File verificationDir = new File(this.m_installVerifDir);
        if (verificationDir.listFiles() != null) {
            File[] fileArray = verificationDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                block22: {
                    File fileEntry = fileArray[n2];
                    if (fileEntry.isFile() && (fileEntry.getName().endsWith(".sh") || fileEntry.getName().endsWith(".bat")) && this.isCorrectNotificationPublisher(notificationPublisherPid, fileEntry.getName())) {
                        block20: {
                            SafeProcess proc = null;
                            try {
                                try {
                                    proc = ProcessUtil.exec((String)("chmod 700 " + fileEntry.getCanonicalPath()));
                                }
                                catch (IOException iOException) {
                                    if (proc != null) {
                                        ProcessUtil.destroy(proc);
                                    }
                                    break block20;
                                }
                            }
                            catch (Throwable throwable) {
                                if (proc != null) {
                                    ProcessUtil.destroy(proc);
                                }
                                throw throwable;
                            }
                            if (proc != null) {
                                ProcessUtil.destroy((SafeProcess)proc);
                            }
                        }
                        SafeProcess proc2 = null;
                        try {
                            try {
                                proc2 = ProcessUtil.exec((String)fileEntry.getCanonicalPath());
                                int exitValue = proc2.exitValue();
                                if (exitValue == 0) {
                                    this.sendSysUpdateSuccess(fileEntry.getName(), notificationPublisher);
                                } else {
                                    this.sendSysUpdateFailure(fileEntry.getName(), notificationPublisher);
                                }
                            }
                            catch (Exception exception) {
                                fileEntry.delete();
                                if (proc2 != null) {
                                    ProcessUtil.destroy((SafeProcess)proc2);
                                }
                                break block22;
                            }
                        }
                        catch (Throwable throwable) {
                            fileEntry.delete();
                            if (proc2 != null) {
                                ProcessUtil.destroy((SafeProcess)proc2);
                            }
                            throw throwable;
                        }
                        fileEntry.delete();
                        if (proc2 != null) {
                            ProcessUtil.destroy((SafeProcess)proc2);
                        }
                    }
                }
                ++n2;
            }
        }
    }

    private DeploymentPackage installDeploymentPackageInternal(File fileReference) throws DeploymentException, IOException {
        DeploymentPackage dp = null;
        File dpPersistentFile = null;
        File downloadedFile = fileReference;
        try {
            try {
                Throwable throwable = null;
                Object var6_7 = null;
                try (FileInputStream dpInputStream = new FileInputStream(downloadedFile);){
                    String dpBasename = fileReference.getName();
                    StringBuilder pathSB = new StringBuilder();
                    pathSB.append(this.packagesPath);
                    pathSB.append(File.separator);
                    pathSB.append(dpBasename);
                    String dpPersistentFilePath = pathSB.toString();
                    dpPersistentFile = new File(dpPersistentFilePath);
                    dp = this.deploymentAdmin.installDeploymentPackage((InputStream)dpInputStream);
                    if (!downloadedFile.getCanonicalPath().equals(dpPersistentFile.getCanonicalPath())) {
                        s_logger.debug("dpFile.getCanonicalPath(): {}", (Object)downloadedFile.getCanonicalPath());
                        s_logger.debug("dpPersistentFile.getCanonicalPath(): {}", (Object)dpPersistentFile.getCanonicalPath());
                        FileUtils.copyFile((File)downloadedFile, (File)dpPersistentFile);
                        this.addPackageToConfFile(dp.getName(), "file:" + dpPersistentFilePath);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                if (dpPersistentFile != null && !downloadedFile.getCanonicalPath().equals(dpPersistentFile.getCanonicalPath())) {
                    downloadedFile.delete();
                }
            }
        }
        finally {
            if (dpPersistentFile != null && !downloadedFile.getCanonicalPath().equals(dpPersistentFile.getCanonicalPath())) {
                downloadedFile.delete();
            }
        }
        return dp;
    }

    private void updateInstallPersistance(String fileName, DeploymentPackageOptions options) {
        this.m_installPersistance = new Properties();
        this.m_installPersistance.setProperty("client.id", options.getClientId());
        this.m_installPersistance.setProperty("job.id", Long.toString(options.getJobId()));
        this.m_installPersistance.setProperty("dp.name", fileName);
        this.m_installPersistance.setProperty("dp.version", options.getDpVersion());
        this.m_installPersistance.setProperty("requester.client.id", options.getRequestClientId());
        this.m_installPersistance.setProperty(PERSISTANCE_FILE_NAME, fileName);
        this.m_installPersistance.setProperty("publisherpid", options.getNotificationPublisherPid());
        if (this.m_installPersistanceDir == null) {
            s_logger.warn(MESSAGE_CONFIGURATION_FILE_NOT_SPECIFIED);
            return;
        }
        StringBuilder pathSB = new StringBuilder();
        pathSB.append(this.m_installPersistanceDir);
        pathSB.append(File.separator);
        pathSB.append(fileName);
        pathSB.append(PERSISTANCE_SUFFIX);
        String persistanceFile = pathSB.toString();
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (FileOutputStream fos = new FileOutputStream(persistanceFile);){
                this.m_installPersistance.store(fos, null);
                fos.flush();
                fos.getFD().sync();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            s_logger.error("Error writing remote install configuration file", (Throwable)e);
        }
    }

    private void addPackageToConfFile(String packageName, String packageUrl) {
        Properties deployedPackages = this.getDeployedPackages();
        deployedPackages.setProperty(packageName, packageUrl);
        if (this.dpaConfPath == null) {
            s_logger.warn(MESSAGE_CONFIGURATION_FILE_NOT_SPECIFIED);
            return;
        }
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileOutputStream fos = new FileOutputStream(this.dpaConfPath);){
                deployedPackages.store(fos, null);
                fos.flush();
                fos.getFD().sync();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            s_logger.error("Error writing package configuration file", (Throwable)e);
        }
    }

    public void removePackageFromConfFile(String packageName) {
        Properties deployedPackages = this.getDeployedPackages();
        deployedPackages.remove(packageName);
        if (this.dpaConfPath == null) {
            s_logger.warn(MESSAGE_CONFIGURATION_FILE_NOT_SPECIFIED);
            return;
        }
        FileOutputStream fos = null;
        try {
            try {
                fos = new FileOutputStream(this.dpaConfPath);
                deployedPackages.store(fos, null);
                fos.flush();
                fos.getFD().sync();
            }
            catch (IOException e) {
                s_logger.error("Error writing package configuration file", (Throwable)e);
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException e2) {
                    s_logger.error("Exception while closing opened resources!", (Throwable)e2);
                }
            }
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                s_logger.error("Exception while closing opened resources!", (Throwable)e);
            }
        }
    }

    private void sendSysUpdateSuccess(String verificationFileName, CloudNotificationPublisher notificationPublisher) throws KuraException {
        s_logger.info("Ready to send success after install");
        String executableName = verificationFileName.split("_verifier")[0];
        File installDir = new File(this.m_installPersistanceDir);
        File[] fileArray = installDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File fileEntry = fileArray[n2];
            if (fileEntry.isFile() && fileEntry.getName().endsWith(PERSISTANCE_SUFFIX) && fileEntry.getName().contains(executableName)) {
                Properties downloadProperties = this.loadInstallPersistance(fileEntry);
                String deployUrl = downloadProperties.getProperty("dp.uri");
                String dpName = downloadProperties.getProperty("dp.name");
                String dpVersion = downloadProperties.getProperty("dp.version");
                String clientId = downloadProperties.getProperty("client.id");
                Long jobId = Long.valueOf(downloadProperties.getProperty("job.id"));
                String fileSystemFileName = downloadProperties.getProperty(PERSISTANCE_FILE_NAME);
                String requestClientId = downloadProperties.getProperty("requester.client.id");
                String notificationPid = downloadProperties.getProperty("publisherpid");
                DeploymentPackageDownloadOptions deployOptions = new DeploymentPackageDownloadOptions(deployUrl, dpName, dpVersion);
                deployOptions.setClientId(clientId);
                deployOptions.setJobId(jobId);
                deployOptions.setRequestClientId(requestClientId);
                deployOptions.setNotificationPublisherPid(notificationPid);
                deployOptions.setNotificationPublisher(notificationPublisher);
                try {
                    this.installCompleteAsync(deployOptions, fileSystemFileName);
                    s_logger.info("Sent install complete");
                    fileEntry.delete();
                    break;
                }
                catch (KuraException kuraException) {
                    throw new KuraException(KuraErrorCode.INTERNAL_ERROR);
                }
            }
            ++n2;
        }
    }

    private void sendSysUpdateFailure(String verificationFileName, CloudNotificationPublisher notificationPublisher) throws KuraException {
        File installDir = new File(this.m_installPersistanceDir);
        File[] fileArray = installDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File fileEntry = fileArray[n2];
            if (fileEntry.isFile() && fileEntry.getName().endsWith(PERSISTANCE_SUFFIX) && fileEntry.getName().contains(verificationFileName)) {
                Properties downloadProperties = this.loadInstallPersistance(fileEntry);
                String deployUrl = downloadProperties.getProperty("dp.uri");
                String dpName = downloadProperties.getProperty("dp.name");
                String dpVersion = downloadProperties.getProperty("dp.version");
                String clientId = downloadProperties.getProperty("client.id");
                Long jobId = Long.valueOf(downloadProperties.getProperty("job.id"));
                String fileSystemFileName = downloadProperties.getProperty(PERSISTANCE_FILE_NAME);
                String requestClientId = downloadProperties.getProperty("requester.client.id");
                String notificationPid = downloadProperties.getProperty("publisherpid");
                DeploymentPackageDownloadOptions deployOptions = new DeploymentPackageDownloadOptions(deployUrl, dpName, dpVersion);
                deployOptions.setClientId(clientId);
                deployOptions.setJobId(jobId);
                deployOptions.setRequestClientId(requestClientId);
                deployOptions.setNotificationPublisherPid(notificationPid);
                deployOptions.setNotificationPublisher(notificationPublisher);
                try {
                    this.installFailedAsync(deployOptions, fileSystemFileName, (Exception)((Object)new KuraException(KuraErrorCode.INTERNAL_ERROR)));
                    s_logger.info("Sent install failed");
                    fileEntry.delete();
                    break;
                }
                catch (KuraException kuraException) {
                    throw new KuraException(KuraErrorCode.INTERNAL_ERROR);
                }
            }
            ++n2;
        }
    }

    private Properties loadInstallPersistance(File installedDpPersistance) {
        Properties downloadProperies = new Properties();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileReader fr = new FileReader(installedDpPersistance);){
                downloadProperies.load(fr);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            s_logger.error("Exception loading install configuration file", (Throwable)e);
        }
        return downloadProperies;
    }

    public boolean isCorrectNotificationPublisher(String pid, String verificationFileName) {
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (Stream<Path> filesStream = Files.list(Paths.get(this.m_installPersistanceDir, new String[0]));){
                List availableFiles = filesStream.filter(path -> Files.isRegularFile(path, new LinkOption[0])).filter(filePath -> {
                    boolean isPersistanceFile = filePath.toFile().getName().endsWith(PERSISTANCE_SUFFIX);
                    if (isPersistanceFile) {
                        Properties downloadProperties = this.loadInstallPersistance(filePath.toFile());
                        String notificationPid = downloadProperties.getProperty("publisherpid");
                        String executableFileName = downloadProperties.getProperty(PERSISTANCE_FILE_NAME);
                        if (pid.equals(notificationPid) && verificationFileName.contains(executableFileName)) {
                            return true;
                        }
                    }
                    return false;
                }).collect(Collectors.toList());
                boolean result = false;
                if (!availableFiles.isEmpty()) {
                    result = true;
                }
                return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            s_logger.info("Unable to parse persistance dir");
            return false;
        }
    }
}

