/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.broker.artemis.simple.mqtt;

import com.google.common.io.Resources;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.eclipse.kura.broker.artemis.core.ServerConfiguration;
import org.eclipse.kura.broker.artemis.core.ServerManager;
import org.eclipse.kura.broker.artemis.core.UserAuthentication;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.eclipse.kura.crypto.CryptoService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ServiceComponent
implements ConfigurableComponent {
    private static final Logger logger = LoggerFactory.getLogger(ServiceComponent.class);
    private ServerConfiguration configuration;
    private ServerManager server;
    private CryptoService cryptoService;

    public void setCryptoService(CryptoService cryptoService) {
        this.cryptoService = cryptoService;
    }

    public void activate(Map<String, Object> properties) throws Exception {
        ServerConfiguration cfg = this.parse(properties);
        if (cfg != null) {
            this.start(cfg);
        }
    }

    public void modified(Map<String, Object> properties) throws Exception {
        ServerConfiguration cfg = this.parse(properties);
        if (this.configuration == cfg) {
            logger.debug("Configuration identical ... skipping update");
            return;
        }
        if (this.configuration != null && this.configuration.equals(cfg)) {
            logger.debug("Configuration equal ... skipping update");
            return;
        }
        this.stop();
        if (cfg != null) {
            this.start(cfg);
        }
    }

    public void deactivate() throws Exception {
        this.stop();
    }

    private void start(ServerConfiguration configuration) throws Exception {
        logger.info("Starting Artemis");
        this.server = new ServerManager(configuration);
        this.server.start();
        this.configuration = configuration;
    }

    private void stop() throws Exception {
        logger.info("Stopping Artemis");
        if (this.server != null) {
            this.server.stop();
            this.server = null;
        }
        this.configuration = null;
    }

    private ServerConfiguration parse(Map<String, Object> properties) throws Exception {
        if (!Boolean.TRUE.equals(properties.get("enabled"))) {
            return null;
        }
        UserAuthentication.Builder auth = new UserAuthentication.Builder();
        String user = (String)properties.get("user");
        String password = (String)properties.get("password");
        if (user == null || user.isEmpty()) {
            user = "mqtt";
        }
        if (password == null || password.isEmpty()) {
            auth.defaultUser(user);
            password = "";
        } else {
            password = String.valueOf(this.cryptoService.decryptAes(password.toCharArray()));
        }
        auth.addUser(user, password, Collections.singleton("amq"));
        ServerConfiguration cfg = new ServerConfiguration();
        cfg.setBrokerXml(this.createBrokerXml(properties));
        cfg.setRequiredProtocols(Collections.singleton("MQTT"));
        cfg.setUserAuthentication(auth.build());
        return cfg;
    }

    private String createBrokerXml(Map<String, Object> properties) throws Exception {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream input = Resources.getResource(ServiceComponent.class, (String)"broker.xml").openStream();){
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(input);
            this.customizeDocument(document, properties);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            transformer.transform(new DOMSource(document), result);
            sw.close();
            return sw.toString();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void customizeDocument(Document document, Map<String, Object> properties) throws Exception {
        Integer port;
        Objects.requireNonNull(document);
        Objects.requireNonNull(properties);
        String address = (String)properties.get("address");
        if (address == null || address.isEmpty()) {
            address = "localhost";
        }
        if ((port = (Integer)properties.get("port")) == null) {
            port = 1883;
        }
        XPath xpath = XPathFactory.newInstance().newXPath();
        Node nameNode = (Node)xpath.evaluate("/configuration/core/name", document, XPathConstants.NODE);
        nameNode.setTextContent("simple-mqtt-broker");
        Node acceptorNode = (Node)xpath.evaluate("//acceptor[@name='mqtt']", document, XPathConstants.NODE);
        String mqttAcceptor = String.format("tcp://%s:%s?tcpSendBufferSize=1048576;tcpReceiveBufferSize=1048576;protocols=MQTT", address, port);
        acceptorNode.setTextContent(mqttAcceptor);
    }
}

