/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.client.ui.wires;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.List;
import org.eclipse.kura.web.client.ui.EntryClassUi;
import org.eclipse.kura.web.client.util.DownloadHelper;
import org.eclipse.kura.web.client.util.FailureHandler;
import org.eclipse.kura.web.shared.model.GwtConfigComponent;
import org.eclipse.kura.web.shared.model.GwtWireComposerStaticInfo;
import org.eclipse.kura.web.shared.model.GwtWireGraphConfiguration;
import org.eclipse.kura.web.shared.model.GwtXSRFToken;
import org.eclipse.kura.web.shared.service.GwtComponentService;
import org.eclipse.kura.web.shared.service.GwtComponentServiceAsync;
import org.eclipse.kura.web.shared.service.GwtSecurityTokenService;
import org.eclipse.kura.web.shared.service.GwtSecurityTokenServiceAsync;
import org.eclipse.kura.web.shared.service.GwtWireGraphService;
import org.eclipse.kura.web.shared.service.GwtWireGraphServiceAsync;

public final class WiresRPC {
    private static final GwtComponentServiceAsync gwtComponentService = (GwtComponentServiceAsync)GWT.create(GwtComponentService.class);
    private static final GwtWireGraphServiceAsync gwtWireGraphService = (GwtWireGraphServiceAsync)GWT.create(GwtWireGraphService.class);
    private static final GwtSecurityTokenServiceAsync gwtXSRFService = (GwtSecurityTokenServiceAsync)GWT.create(GwtSecurityTokenService.class);

    private WiresRPC() {
    }

    public static void loadStaticInfo(final Callback<GwtWireComposerStaticInfo> callback) {
        EntryClassUi.showWaitModal();
        gwtXSRFService.generateSecurityToken(new AsyncCallback<GwtXSRFToken>(){

            public void onFailure(Throwable ex) {
                EntryClassUi.hideWaitModal();
                FailureHandler.handle(ex);
            }

            public void onSuccess(GwtXSRFToken result) {
                gwtWireGraphService.getWireComposerStaticInfo(result, new AsyncCallback<GwtWireComposerStaticInfo>(){

                    public void onFailure(Throwable ex) {
                        EntryClassUi.hideWaitModal();
                        FailureHandler.handle(ex);
                    }

                    public void onSuccess(GwtWireComposerStaticInfo result) {
                        EntryClassUi.hideWaitModal();
                        callback.onSuccess(result);
                    }
                });
            }
        });
    }

    public static void loadWiresConfiguration(final Callback<GwtWireGraphConfiguration> callback) {
        EntryClassUi.showWaitModal();
        gwtXSRFService.generateSecurityToken(new AsyncCallback<GwtXSRFToken>(){

            public void onFailure(Throwable ex) {
                EntryClassUi.hideWaitModal();
                FailureHandler.handle(ex);
            }

            public void onSuccess(GwtXSRFToken result) {
                gwtWireGraphService.getWiresConfiguration(result, new AsyncCallback<GwtWireGraphConfiguration>(){

                    public void onFailure(Throwable ex) {
                        EntryClassUi.hideWaitModal();
                        FailureHandler.handle(ex);
                    }

                    public void onSuccess(GwtWireGraphConfiguration result) {
                        EntryClassUi.hideWaitModal();
                        callback.onSuccess(result);
                    }
                });
            }
        });
    }

    public static void updateWiresConfiguration(final GwtWireGraphConfiguration wireGraph, final List<GwtConfigComponent> additionalConfigs, final Callback<Void> callback) {
        EntryClassUi.showWaitModal();
        gwtXSRFService.generateSecurityToken(new AsyncCallback<GwtXSRFToken>(){

            public void onFailure(Throwable ex) {
                EntryClassUi.hideWaitModal();
                FailureHandler.handle(ex);
            }

            public void onSuccess(GwtXSRFToken result) {
                gwtWireGraphService.updateWireConfiguration(result, wireGraph, additionalConfigs, new AsyncCallback<Void>(){

                    public void onFailure(Throwable ex) {
                        EntryClassUi.hideWaitModal();
                        FailureHandler.handle(ex);
                    }

                    public void onSuccess(Void result) {
                        EntryClassUi.hideWaitModal();
                        callback.onSuccess(null);
                    }
                });
            }
        });
    }

    public static void createNewDriver(final String factoryPid, final String pid, final Callback<GwtConfigComponent> callback) {
        EntryClassUi.showWaitModal();
        gwtXSRFService.generateSecurityToken(new AsyncCallback<GwtXSRFToken>(){

            public void onFailure(Throwable ex) {
                EntryClassUi.hideWaitModal();
                FailureHandler.handle(ex);
            }

            public void onSuccess(GwtXSRFToken result) {
                gwtComponentService.createFactoryComponent(result, factoryPid, pid, new AsyncCallback<Void>(){

                    public void onFailure(Throwable ex) {
                        EntryClassUi.hideWaitModal();
                        FailureHandler.handle(ex);
                    }

                    public void onSuccess(Void result) {
                        gwtXSRFService.generateSecurityToken(new AsyncCallback<GwtXSRFToken>(){

                            public void onFailure(Throwable ex) {
                                EntryClassUi.hideWaitModal();
                                FailureHandler.handle(ex);
                            }

                            public void onSuccess(GwtXSRFToken result) {
                                gwtWireGraphService.getGwtChannelDescriptor(result, pid, new AsyncCallback<GwtConfigComponent>(){

                                    public void onFailure(Throwable ex) {
                                        EntryClassUi.hideWaitModal();
                                        FailureHandler.handle(ex);
                                    }

                                    public void onSuccess(GwtConfigComponent result) {
                                        EntryClassUi.hideWaitModal();
                                        callback.onSuccess(result);
                                    }
                                });
                            }
                        });
                    }
                });
            }
        });
    }

    public static void downloadWiresSnapshot() {
        EntryClassUi.showWaitModal();
        gwtXSRFService.generateSecurityToken(new AsyncCallback<GwtXSRFToken>(){

            public void onFailure(Throwable ex) {
                EntryClassUi.hideWaitModal();
                FailureHandler.handle(ex);
            }

            public void onSuccess(GwtXSRFToken token) {
                EntryClassUi.hideWaitModal();
                DownloadHelper.instance().startDownload(token, "/wiresSnapshot");
            }
        });
    }

    public static interface Callback<T> {
        public void onSuccess(T var1);
    }
}

