/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.client.ui.wires;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Widget;
import org.eclipse.kura.web.client.util.DragSupport;
import org.gwtbootstrap3.client.ui.AnchorListItem;
import org.gwtbootstrap3.client.ui.constants.IconType;

public class WireComponentsAnchorListItem
extends AnchorListItem {
    private final boolean isEmitter;
    private final boolean isReceiver;
    private Listener listener;

    public WireComponentsAnchorListItem(String label, final String factoryPid, boolean isEmitter, boolean isReceiver) {
        this.isEmitter = isEmitter;
        this.isReceiver = isReceiver;
        super.setIcon(this.getFactoryIcon());
        super.setText(label);
        DragSupport drag = DragSupport.addIfSupported((Widget)this);
        if (drag != null) {
            drag.setListener(new DragSupport.Listener(){

                @Override
                public void onDragStart(DragSupport.DragEvent event) {
                    event.setTextData("factory://" + factoryPid);
                }
            });
        }
        super.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (WireComponentsAnchorListItem.this.listener != null) {
                    WireComponentsAnchorListItem.this.listener.onClick(factoryPid);
                }
            }
        });
    }

    private IconType getFactoryIcon() {
        if (this.isEmitter && this.isReceiver) {
            return IconType.EXCHANGE;
        }
        if (this.isEmitter) {
            return IconType.LONG_ARROW_LEFT;
        }
        return IconType.LONG_ARROW_RIGHT;
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public static interface Listener {
        public void onClick(String var1);
    }
}

