/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.client.ui.drivers.assets;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.kura.web.client.ui.drivers.assets.AssetModel;
import org.eclipse.kura.web.client.util.LabelComparator;
import org.eclipse.kura.web.shared.AssetConstants;
import org.eclipse.kura.web.shared.model.GwtConfigComponent;
import org.eclipse.kura.web.shared.model.GwtConfigParameter;

public class AssetModelImpl
implements AssetModel {
    public static final LabelComparator<LegacyChannelModel> CHANNEL_LABEL_COMPARATOR = new LabelComparator();
    private GwtConfigComponent assetConfiguration;
    private GwtConfigComponent channelDescriptor;
    private Set<String> channelNames = new HashSet<String>();
    private Map<String, Integer> paramIndexes = new HashMap<String, Integer>();
    private List<AssetModel.ChannelModel> channelModels = new ArrayList<AssetModel.ChannelModel>();

    public AssetModelImpl(GwtConfigComponent assetConfiguration, GwtConfigComponent channelDescriptor, GwtConfigComponent baseChannelDescriptor) {
        this.assetConfiguration = assetConfiguration;
        this.channelDescriptor = new GwtConfigComponent();
        int i = 0;
        for (GwtConfigParameter param : baseChannelDescriptor.getParameters()) {
            this.channelDescriptor.getParameters().add(param);
            this.paramIndexes.put(param.getId(), i);
            ++i;
        }
        for (GwtConfigParameter param : channelDescriptor.getParameters()) {
            this.channelDescriptor.getParameters().add(param);
            this.paramIndexes.put(param.getId(), i);
            ++i;
        }
        this.findChannelNames();
        this.loadChannelModels();
    }

    private String getChannelName(String propertyName) {
        int separatorIndex = propertyName.indexOf(AssetConstants.CHANNEL_PROPERTY_SEPARATOR.value());
        if (separatorIndex != -1) {
            return propertyName.substring(0, separatorIndex);
        }
        return null;
    }

    private String getChannelPropertyName(String propertyName) {
        int separatorIndex = propertyName.indexOf(AssetConstants.CHANNEL_PROPERTY_SEPARATOR.value());
        if (separatorIndex != -1) {
            return propertyName.substring(separatorIndex + 1);
        }
        return null;
    }

    private void findChannelNames() {
        HashSet<String> result = new HashSet<String>();
        for (GwtConfigParameter param : this.assetConfiguration.getParameters()) {
            String name = this.getChannelName(param.getId());
            if (name == null || result.contains(name)) continue;
            result.add(name);
        }
        this.channelNames = result;
    }

    private void loadChannelModels() {
        HashMap<String, Integer> channelIndexes = new HashMap<String, Integer>();
        int i = 0;
        for (GwtConfigParameter param : this.channelDescriptor.getParameters()) {
            channelIndexes.put(param.getId(), i);
            ++i;
        }
        HashMap<String, LegacyChannelModel> models = new HashMap<String, LegacyChannelModel>();
        for (GwtConfigParameter param : this.assetConfiguration.getParameters()) {
            String propertyName;
            String channelName = this.getChannelName(param.getId());
            if (channelName == null || (propertyName = this.getChannelPropertyName(param.getId())) == null) continue;
            LegacyChannelModel model = (LegacyChannelModel)models.get(channelName);
            if (model == null) {
                model = new LegacyChannelModel(channelName, i);
                models.put(channelName, model);
            }
            model.parameters[((Integer)channelIndexes.get((Object)propertyName)).intValue()] = param;
        }
        ArrayList sortedModels = new ArrayList(models.entrySet());
        Collections.sort(sortedModels, CHANNEL_LABEL_COMPARATOR);
        ArrayList<LegacyChannelModel> sortedLegacyChannelModels = new ArrayList<LegacyChannelModel>();
        for (Map.Entry entry : sortedModels) {
            sortedLegacyChannelModels.add((LegacyChannelModel)entry.getValue());
        }
        this.channelModels.clear();
        this.channelModels.addAll(sortedLegacyChannelModels);
    }

    @Override
    public List<AssetModel.ChannelModel> getChannels() {
        return this.channelModels;
    }

    @Override
    public AssetModel.ChannelModel createNewChannel(String channelName) {
        LegacyChannelModel result = new LegacyChannelModel(channelName, this.channelDescriptor.getParameters().size());
        int i = 0;
        for (GwtConfigParameter param : this.channelDescriptor.getParameters()) {
            GwtConfigParameter cloned = new GwtConfigParameter(param);
            String paramId = String.valueOf(channelName) + AssetConstants.CHANNEL_PROPERTY_SEPARATOR.value() + param.getId();
            cloned.setId(paramId);
            cloned.setName(paramId);
            cloned.setValue(cloned.getDefault());
            this.assetConfiguration.getParameters().add(cloned);
            result.parameters[i] = cloned;
            ++i;
        }
        result.setValue(AssetConstants.NAME.value(), channelName);
        this.channelNames.add(channelName);
        this.channelModels.add(result);
        return result;
    }

    @Override
    public Set<String> getChannelNames() {
        return this.channelNames;
    }

    @Override
    public GwtConfigComponent getChannelDescriptor() {
        return this.channelDescriptor;
    }

    private AssetModel.ChannelModel getChannelModel(String channelName) {
        for (AssetModel.ChannelModel model : this.channelModels) {
            if (!model.getChannelName().equals(channelName)) continue;
            return model;
        }
        return null;
    }

    @Override
    public void deleteChannel(String channelName) {
        this.channelNames.remove(channelName);
        Iterator<AssetModel.ChannelModel> iter = this.channelModels.iterator();
        while (iter.hasNext()) {
            AssetModel.ChannelModel model = iter.next();
            if (!model.getChannelName().equals(channelName)) continue;
            iter.remove();
            ((LegacyChannelModel)model).remove();
            return;
        }
    }

    @Override
    public GwtConfigComponent getConfiguration() {
        return this.assetConfiguration;
    }

    @Override
    public String getAssetPid() {
        return this.assetConfiguration.getComponentId();
    }

    private class LegacyChannelModel
    implements AssetModel.ChannelModel {
        String channelName;
        GwtConfigParameter[] parameters;

        public LegacyChannelModel(String channelName, int parameterCount) {
            this.channelName = channelName;
            this.parameters = new GwtConfigParameter[parameterCount];
        }

        @Override
        public String getChannelName() {
            return this.channelName;
        }

        @Override
        public GwtConfigParameter getParameter(int index) {
            return this.parameters[index];
        }

        @Override
        public void setValue(String id, String value) {
            Integer index = (Integer)AssetModelImpl.this.paramIndexes.get(id);
            if (index == null) {
                return;
            }
            this.parameters[index].setValue(value);
        }

        @Override
        public String getValue(String id) {
            Integer index = (Integer)AssetModelImpl.this.paramIndexes.get(id);
            if (index == null) {
                return null;
            }
            return this.parameters[index].getValue();
        }

        private void remove() {
            Iterator<GwtConfigParameter> iterator = AssetModelImpl.this.assetConfiguration.getParameters().iterator();
            while (iterator.hasNext()) {
                GwtConfigParameter param = iterator.next();
                int i = 0;
                while (i < this.parameters.length) {
                    if (this.parameters[i] == param) {
                        iterator.remove();
                    }
                    ++i;
                }
            }
        }
    }
}

