/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.cloud;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.util.Base64;
import java.util.Date;
import org.eclipse.kura.core.cloud.CloudPayloadJsonFields;
import org.eclipse.kura.message.KuraPayload;
import org.eclipse.kura.message.KuraPosition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudPayloadJsonDecoder {
    private static final Logger logger = LoggerFactory.getLogger(CloudPayloadJsonDecoder.class);

    private CloudPayloadJsonDecoder() {
    }

    public static KuraPayload buildFromByteArray(byte[] array) {
        String stringJson = new String(array);
        JsonObject json = Json.parse((String)stringJson).asObject();
        KuraPayload payload = new KuraPayload();
        try {
            for (JsonObject.Member member : json) {
                String name = member.getName();
                JsonValue value = member.getValue();
                if (CloudPayloadJsonFields.SENTON.value().equalsIgnoreCase(name)) {
                    CloudPayloadJsonDecoder.decodeTimestamp(payload, value);
                    continue;
                }
                if (CloudPayloadJsonFields.BODY.value().equalsIgnoreCase(name)) {
                    CloudPayloadJsonDecoder.decodeBody(payload, value);
                    continue;
                }
                if (CloudPayloadJsonFields.POSITION.value().equalsIgnoreCase(name) && value.isObject()) {
                    CloudPayloadJsonDecoder.decodePosition(payload, value.asObject());
                    continue;
                }
                if (CloudPayloadJsonFields.METRICS.value().equalsIgnoreCase(name) && value.isObject()) {
                    CloudPayloadJsonDecoder.decodeMetric(payload, value.asObject());
                    continue;
                }
                throw new IllegalArgumentException(String.format("Unrecognized value: %s", name));
            }
        }
        catch (Exception e) {
            logger.warn("Cannot parse Json", (Throwable)e);
            payload = new KuraPayload();
            payload.setBody(array);
        }
        return payload;
    }

    private static void decodeTimestamp(KuraPayload payload, JsonValue timestampValue) {
        if (timestampValue != null && timestampValue.isNumber()) {
            long timestamp = timestampValue.asLong();
            payload.setTimestamp(new Date(timestamp));
        }
    }

    private static void decodeBody(KuraPayload payload, JsonValue body) {
        if (body != null && body.isString()) {
            payload.setBody(Base64.getDecoder().decode(body.asString()));
        }
    }

    private static void decodePosition(KuraPayload payload, JsonObject positionObject) {
        KuraPosition position = new KuraPosition();
        payload.setPosition(position);
        for (JsonObject.Member member : positionObject) {
            String name = member.getName();
            JsonValue value = member.getValue();
            if (CloudPayloadJsonFields.CloudPayloadJsonPositionFields.LATITUDE.value().equalsIgnoreCase(name) && value.isNumber()) {
                position.setLatitude(value.asDouble());
                continue;
            }
            if (CloudPayloadJsonFields.CloudPayloadJsonPositionFields.LONGITUDE.value().equalsIgnoreCase(name) && value.isNumber()) {
                position.setLongitude(value.asDouble());
                continue;
            }
            if (CloudPayloadJsonFields.CloudPayloadJsonPositionFields.ALTITUDE.value().equalsIgnoreCase(name) && value.isNumber()) {
                position.setAltitude(value.asDouble());
                continue;
            }
            if (CloudPayloadJsonFields.CloudPayloadJsonPositionFields.HEADING.value().equalsIgnoreCase(name) && value.isNumber()) {
                position.setHeading(value.asDouble());
                continue;
            }
            if (CloudPayloadJsonFields.CloudPayloadJsonPositionFields.PRECISION.value().equalsIgnoreCase(name) && value.isNumber()) {
                position.setPrecision(value.asDouble());
                continue;
            }
            if (CloudPayloadJsonFields.CloudPayloadJsonPositionFields.SATELLITES.value().equalsIgnoreCase(name) && value.isNumber()) {
                position.setSatellites(value.asInt());
                continue;
            }
            if (CloudPayloadJsonFields.CloudPayloadJsonPositionFields.SPEED.value().equalsIgnoreCase(name) && value.isNumber()) {
                position.setSpeed(value.asDouble());
                continue;
            }
            if (CloudPayloadJsonFields.CloudPayloadJsonPositionFields.TIMESTAMP.value().equalsIgnoreCase(name) && value.isNumber()) {
                position.setTimestamp(new Date(value.asLong()));
                continue;
            }
            if (CloudPayloadJsonFields.CloudPayloadJsonPositionFields.STATUS.value().equalsIgnoreCase(name) && value.isNumber()) {
                position.setStatus(value.asInt());
                continue;
            }
            throw new IllegalArgumentException(String.format("Cannot parse position: %s.", name));
        }
    }

    private static void decodeMetric(KuraPayload payload, JsonObject metricsObject) {
        if (metricsObject == null) {
            throw new IllegalArgumentException("Cannot parse metric object!");
        }
        for (JsonObject.Member member : metricsObject) {
            Object javaValue;
            String name = member.getName();
            JsonValue value = member.getValue();
            if (value.isNumber()) {
                try {
                    javaValue = value.asLong();
                }
                catch (Exception exception) {
                    javaValue = value.asDouble();
                }
            } else if (value.isBoolean()) {
                javaValue = value.asBoolean();
            } else if (value.isString()) {
                javaValue = value.asString();
            } else {
                throw new IllegalArgumentException(String.format("Unparsable metric %s", name));
            }
            payload.addMetric(name, javaValue);
        }
    }
}

