/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.linux.bluetooth.le.beacon;

import org.eclipse.kura.bluetooth.BluetoothBeaconCommandListener;
import org.eclipse.kura.linux.bluetooth.util.BluetoothProcessListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BluetoothConfigurationProcessListener
implements BluetoothProcessListener {
    private static final Logger s_logger = LoggerFactory.getLogger(BluetoothConfigurationProcessListener.class);
    private BluetoothBeaconCommandListener m_listener = null;

    public BluetoothConfigurationProcessListener(BluetoothBeaconCommandListener listener) {
        this.m_listener = listener;
    }

    @Override
    public void processInputStream(String string) {
        s_logger.debug("Command response : {}", (Object)string);
        String[] lines = string.split("\n");
        if (lines[0].toLowerCase().contains("usage")) {
            s_logger.info("Command failed. Error in command syntax.");
            this.m_listener.onCommandFailed(null);
        } else {
            String lastLine = lines[lines.length - 1];
            String exitCode = lastLine.substring(11, 13);
            if (exitCode.equals("00")) {
                s_logger.info("Command " + lines[0].substring(15, 35) + " Succeeded.");
                this.m_listener.onCommandResults(lastLine);
            } else {
                s_logger.info("Command " + lines[0].substring(15, 35) + " failed. Error " + exitCode);
                this.m_listener.onCommandFailed(exitCode);
            }
        }
    }

    @Override
    public void processInputStream(int ch) {
    }

    @Override
    public void processErrorStream(String string) {
    }
}

