/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.system;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import org.eclipse.kura.core.util.ProcessUtil;
import org.eclipse.kura.system.SystemAdminService;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemAdminServiceImpl
implements SystemAdminService {
    private static final Logger s_logger = LoggerFactory.getLogger(SystemAdminServiceImpl.class);
    private static final String OS_LINUX = "Linux";
    private static final String OS_MAC_OSX = "Mac OS X";
    private static final String OS_WINDOWS = "Windows";
    private static final String UNKNOWN = "UNKNOWN";
    private ComponentContext m_ctx;

    protected void activate(ComponentContext componentContext) {
        this.m_ctx = componentContext;
    }

    protected void deactivate(ComponentContext componentContext) {
        this.m_ctx = null;
    }

    public String getUptime() {
        String uptimeStr = UNKNOWN;
        long uptime = 0L;
        if (OS_LINUX.equals(this.getOsName())) {
            try {
                File file = new File("/proc/uptime");
                FileReader fr = new FileReader(file);
                BufferedReader br = new BufferedReader(fr);
                String line = br.readLine();
                br.close();
                uptime = (long)(Double.parseDouble(line.substring(0, line.indexOf(" "))) * 1000.0);
                uptimeStr = Long.toString(uptime);
            }
            catch (Exception e) {
                s_logger.error("Could not read uptime", (Throwable)e);
            }
        } else if (OS_MAC_OSX.equals(this.getOsName())) {
            try {
                String systemUptime = this.runSystemCommand("uptime");
                if (!systemUptime.isEmpty()) {
                    String[] uptimeParts = systemUptime.split("up\\s+")[1].split("\\s*,\\s*");
                    int days = 0;
                    int hours = 0;
                    int mins = 0;
                    String uptimePart = uptimeParts[0];
                    if (uptimePart.contains("days")) {
                        days = Integer.parseInt(uptimePart.split("\\s+days")[0]);
                        uptimePart = uptimeParts[1];
                    } else if (uptimePart.contains("day")) {
                        days = Integer.parseInt(uptimePart.split("\\s+day")[0]);
                        uptimePart = uptimeParts[1];
                    }
                    if (uptimePart.contains(":")) {
                        hours = Integer.parseInt(uptimePart.split(":")[0]);
                        mins = Integer.parseInt(uptimePart.split(":")[1]);
                    } else if (uptimePart.contains("hr")) {
                        hours = Integer.parseInt(uptimePart.split("\\s*hr")[0]);
                    } else if (uptimePart.contains("mins")) {
                        mins = Integer.parseInt(uptimePart.split("\\s*mins")[0]);
                    } else {
                        s_logger.error("uptime could not be parsed correctly: " + uptimeParts[0]);
                    }
                    uptime = ((days * 24 + hours) * 60 + mins) * 60;
                    uptimeStr = Long.toString(uptime * 1000L);
                }
            }
            catch (Exception e) {
                s_logger.error("Could not parse uptime", (Throwable)e);
            }
        }
        return uptimeStr;
    }

    public void reboot() {
        String cmd = "";
        if (OS_LINUX.equals(this.getOsName()) || OS_MAC_OSX.equals(this.getOsName())) {
            cmd = "reboot";
        } else if (this.getOsName().startsWith(OS_WINDOWS)) {
            cmd = "shutdown -r";
        } else {
            s_logger.error("Unsupported OS for reboot()");
            return;
        }
        Process proc = null;
        try {
            try {
                proc = ProcessUtil.exec(cmd);
            }
            catch (Exception e) {
                s_logger.error("failed to issue reboot", (Throwable)e);
                ProcessUtil.destroy(proc);
            }
        }
        finally {
            ProcessUtil.destroy(proc);
        }
    }

    public void sync() {
        String cmd = "";
        if (!OS_LINUX.equals(this.getOsName()) && !OS_MAC_OSX.equals(this.getOsName())) {
            s_logger.error("Unsupported OS for sync()");
            return;
        }
        cmd = "sync";
        Process proc = null;
        try {
            try {
                proc = ProcessUtil.exec(cmd);
                int status = proc.waitFor();
                if (status != 0) {
                    s_logger.error("sync command failed with exit code of " + status);
                }
            }
            catch (Exception e) {
                s_logger.error("failed to issue sync command", (Throwable)e);
                ProcessUtil.destroy(proc);
            }
        }
        finally {
            ProcessUtil.destroy(proc);
        }
    }

    private String getOsName() {
        return System.getProperty("os.name");
    }

    private String runSystemCommand(String command) {
        return this.runSystemCommand(command.split("\\s+"));
    }

    /*
     * Unable to fully structure code
     */
    private String runSystemCommand(String[] commands) {
        block7: {
            proc = null;
            response = new StringBuffer();
            try {
                try {
                    proc = ProcessUtil.exec(commands);
                    proc.waitFor();
                    br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                    line = null;
                    newLine = "";
                    while ((line = br.readLine()) != null) {
                        response.append(newLine);
                        response.append(line);
                        newLine = "\n";
                    }
                    break block7;
                }
                catch (Exception e) {
                    command = "";
                    delim = "";
                    i = 0;
                    ** while (i < commands.length)
                }
lbl-1000:
                // 1 sources

                {
                    command = String.valueOf(command) + delim + commands[i];
                    delim = " ";
                    ++i;
                    continue;
                }
lbl28:
                // 1 sources

                SystemAdminServiceImpl.s_logger.error("failed to run commands " + command, (Throwable)e);
            }
            finally {
                ProcessUtil.destroy(proc);
            }
        }
        return response.toString();
    }
}

