/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.net;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.core.net.AbstractNetInterface;
import org.eclipse.kura.core.net.EthernetInterfaceConfigImpl;
import org.eclipse.kura.core.net.LoopbackInterfaceConfigImpl;
import org.eclipse.kura.core.net.NetInterfaceAddressConfigImpl;
import org.eclipse.kura.core.net.NetInterfaceAddressImpl;
import org.eclipse.kura.core.net.NetworkConfigurationVisitor;
import org.eclipse.kura.core.net.WifiInterfaceAddressConfigImpl;
import org.eclipse.kura.core.net.WifiInterfaceAddressImpl;
import org.eclipse.kura.core.net.WifiInterfaceConfigImpl;
import org.eclipse.kura.core.net.modem.ModemInterfaceAddressConfigImpl;
import org.eclipse.kura.core.net.modem.ModemInterfaceConfigImpl;
import org.eclipse.kura.core.net.util.NetworkUtil;
import org.eclipse.kura.core.util.NetUtil;
import org.eclipse.kura.net.IP4Address;
import org.eclipse.kura.net.IP6Address;
import org.eclipse.kura.net.IPAddress;
import org.eclipse.kura.net.NetConfig;
import org.eclipse.kura.net.NetConfigIP4;
import org.eclipse.kura.net.NetConfigIP6;
import org.eclipse.kura.net.NetInterfaceAddress;
import org.eclipse.kura.net.NetInterfaceAddressConfig;
import org.eclipse.kura.net.NetInterfaceConfig;
import org.eclipse.kura.net.NetInterfaceState;
import org.eclipse.kura.net.NetInterfaceStatus;
import org.eclipse.kura.net.NetInterfaceType;
import org.eclipse.kura.net.dhcp.DhcpServerConfig;
import org.eclipse.kura.net.dhcp.DhcpServerConfig4;
import org.eclipse.kura.net.dhcp.DhcpServerConfigIP4;
import org.eclipse.kura.net.firewall.FirewallAutoNatConfig;
import org.eclipse.kura.net.modem.ModemConfig;
import org.eclipse.kura.net.modem.ModemConnectionStatus;
import org.eclipse.kura.net.modem.ModemConnectionType;
import org.eclipse.kura.net.modem.ModemInterface;
import org.eclipse.kura.net.modem.ModemInterfaceAddress;
import org.eclipse.kura.net.modem.ModemPowerMode;
import org.eclipse.kura.net.modem.ModemTechnologyType;
import org.eclipse.kura.net.wifi.WifiAccessPoint;
import org.eclipse.kura.net.wifi.WifiBgscan;
import org.eclipse.kura.net.wifi.WifiCiphers;
import org.eclipse.kura.net.wifi.WifiConfig;
import org.eclipse.kura.net.wifi.WifiInterface;
import org.eclipse.kura.net.wifi.WifiInterfaceAddress;
import org.eclipse.kura.net.wifi.WifiMode;
import org.eclipse.kura.net.wifi.WifiRadioMode;
import org.eclipse.kura.net.wifi.WifiSecurity;
import org.eclipse.kura.usb.UsbDevice;
import org.eclipse.kura.usb.UsbNetDevice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkConfiguration {
    private static final Logger s_logger = LoggerFactory.getLogger(NetworkConfiguration.class);
    private Map<String, NetInterfaceConfig<? extends NetInterfaceAddressConfig>> m_netInterfaceConfigs;
    private Map<String, Object> m_properties;
    private boolean m_recomputeProperties;
    private List<String> m_modifiedInterfaceNames;

    public NetworkConfiguration() {
        s_logger.debug("Created empty NetworkConfiguration");
        this.m_netInterfaceConfigs = new HashMap<String, NetInterfaceConfig<? extends NetInterfaceAddressConfig>>();
    }

    /*
     * Unable to fully structure code
     */
    public NetworkConfiguration(Map<String, Object> properties) throws UnknownHostException, KuraException {
        block8: {
            super();
            NetworkConfiguration.s_logger.debug("Creating NetworkConfiguration from properties");
            this.m_netInterfaceConfigs = new HashMap<String, NetInterfaceConfig<? extends NetInterfaceAddressConfig>>();
            availableInterfaces = null;
            try {
                availableInterfaces = (String[])properties.get("net.interfaces");
                break block8;
            }
            catch (ClassCastException v0) {
                interfaces = (String)properties.get("net.interfaces");
                st = new StringTokenizer(interfaces, ",");
                interfacesArray = new ArrayList<String>();
                ** while (st.hasMoreTokens())
            }
lbl-1000:
            // 1 sources

            {
                interfacesArray.add(st.nextToken());
                continue;
            }
lbl16:
            // 1 sources

            availableInterfaces = interfacesArray.toArray(new String[interfacesArray.size()]);
        }
        if (availableInterfaces != null) {
            NetworkConfiguration.s_logger.debug("There are " + availableInterfaces.length + " interfaces to add to the new configuration");
            i = 0;
            while (i < availableInterfaces.length) {
                currentNetInterface = availableInterfaces[i];
                keyBuffer = new StringBuffer();
                keyBuffer.append("net.interface.").append(currentNetInterface).append(".type");
                type = NetInterfaceType.UNKNOWN;
                if (properties.get(keyBuffer.toString()) != null) {
                    type = NetInterfaceType.valueOf((String)((String)properties.get(keyBuffer.toString())));
                }
                NetworkConfiguration.s_logger.trace("Adding interface: " + availableInterfaces[i] + " of type " + type);
                this.addInterfaceConfiguration(availableInterfaces[i], type, properties);
                ++i;
            }
        }
        this.m_modifiedInterfaceNames = new ArrayList<String>();
        modifiedInterfaces = (String)properties.get("modified.interface.names");
        if (modifiedInterfaces != null) {
            var7_10 = modifiedInterfaces.split(",");
            var6_9 = var7_10.length;
            var5_7 = 0;
            while (var5_7 < var6_9) {
                interfaceName = var7_10[var5_7];
                this.m_modifiedInterfaceNames.add(interfaceName);
                ++var5_7;
            }
        }
        this.m_recomputeProperties = true;
    }

    public void setModifiedInterfaceNames(List<String> modifiedInterfaceNames) {
        if (modifiedInterfaceNames != null && !modifiedInterfaceNames.isEmpty()) {
            this.m_modifiedInterfaceNames = modifiedInterfaceNames;
            this.m_recomputeProperties = true;
        }
    }

    public List<String> getModifiedInterfaceNames() {
        return this.m_modifiedInterfaceNames;
    }

    public void accept(NetworkConfigurationVisitor visitor) throws KuraException {
        visitor.visit(this);
    }

    public void addNetInterfaceConfig(NetInterfaceConfig<? extends NetInterfaceAddressConfig> netInterfaceConfig) {
        this.m_netInterfaceConfigs.put(netInterfaceConfig.getName(), netInterfaceConfig);
        this.m_recomputeProperties = true;
    }

    public void addNetConfig(String interfaceName, NetInterfaceType netInterfaceType, NetConfig netConfig) throws KuraException {
        AbstractNetInterface netInterfaceConfig = this.m_netInterfaceConfigs.get(interfaceName);
        if (netInterfaceConfig == null) {
            switch (netInterfaceType) {
                case LOOPBACK: {
                    netInterfaceConfig = new LoopbackInterfaceConfigImpl(interfaceName);
                    break;
                }
                case ETHERNET: {
                    netInterfaceConfig = new EthernetInterfaceConfigImpl(interfaceName);
                    break;
                }
                case WIFI: {
                    netInterfaceConfig = new WifiInterfaceConfigImpl(interfaceName);
                    break;
                }
                case MODEM: {
                    netInterfaceConfig = new ModemInterfaceConfigImpl(interfaceName);
                }
            }
        }
        List netInterfaceAddressConfigs = netInterfaceConfig.getNetInterfaceAddresses();
        s_logger.trace("Adding a netConfig: " + netConfig);
        for (NetInterfaceAddressConfig netInterfaceAddressConfig : netInterfaceAddressConfigs) {
            NetInterfaceAddressConfigImpl netInterfaceAddressConfigImpl = (NetInterfaceAddressConfigImpl)netInterfaceAddressConfig;
            List netConfigs = netInterfaceAddressConfig.getConfigs();
            netConfigs.add(netConfig);
            netInterfaceAddressConfigImpl.setNetConfigs(netConfigs);
        }
        this.m_recomputeProperties = true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator<String> it = this.m_netInterfaceConfigs.keySet().iterator();
        while (it.hasNext()) {
            NetInterfaceConfig<? extends NetInterfaceAddressConfig> netInterfaceConfig = this.m_netInterfaceConfigs.get(it.next());
            sb.append("\nname: " + netInterfaceConfig.getName());
            sb.append(" :: Loopback? " + netInterfaceConfig.isLoopback());
            sb.append(" :: Point to Point? " + netInterfaceConfig.isPointToPoint());
            sb.append(" :: Up? " + netInterfaceConfig.isUp());
            sb.append(" :: Virtual? " + netInterfaceConfig.isVirtual());
            sb.append(" :: Driver: " + netInterfaceConfig.getDriver());
            sb.append(" :: Driver Version: " + netInterfaceConfig.getDriverVersion());
            sb.append(" :: Firmware Version: " + netInterfaceConfig.getFirmwareVersion());
            sb.append(" :: MTU: " + netInterfaceConfig.getMTU());
            if (netInterfaceConfig.getHardwareAddress() != null) {
                sb.append(" :: Hardware Address: " + new String(netInterfaceConfig.getHardwareAddress()));
            }
            sb.append(" :: State: " + netInterfaceConfig.getState());
            sb.append(" :: Type: " + netInterfaceConfig.getType());
            sb.append(" :: Usb Device: " + netInterfaceConfig.getUsbDevice());
            List netInterfaceAddresses = netInterfaceConfig.getNetInterfaceAddresses();
            for (NetInterfaceAddress netInterfaceAddress : netInterfaceAddresses) {
                if (netInterfaceAddress.getAddress() != null) {
                    sb.append(" :: Address: " + netInterfaceAddress.getAddress().getHostAddress());
                }
                sb.append(" :: Prefix: " + netInterfaceAddress.getNetworkPrefixLength());
                if (netInterfaceAddress.getNetmask() != null) {
                    sb.append(" :: Netmask: " + netInterfaceAddress.getNetmask().getHostAddress());
                }
                if (netInterfaceAddress.getBroadcast() == null) continue;
                sb.append(" :: Broadcast: " + netInterfaceAddress.getBroadcast().getHostAddress());
            }
            List netInterfaceAddressConfigs = netInterfaceConfig.getNetInterfaceAddresses();
            if (netInterfaceAddressConfigs == null) continue;
            for (NetInterfaceAddressConfig netInterfaceAddressConfig : netInterfaceAddressConfigs) {
                List netConfigs = netInterfaceAddressConfig.getConfigs();
                if (netConfigs == null) continue;
                for (NetConfig netConfig : netConfigs) {
                    List dnsServers;
                    if (netConfig instanceof NetConfigIP4) {
                        sb.append("\n\tIPv4 ");
                        if (((NetConfigIP4)netConfig).isDhcp()) {
                            sb.append(" :: is DHCP client");
                            Map dhcp4Map = ((NetConfigIP4)netConfig).getProperties();
                            for (String dhcpKey : dhcp4Map.keySet()) {
                                sb.append(" :: " + dhcpKey + ": " + dhcp4Map.get(dhcpKey));
                            }
                            continue;
                        }
                        if (((NetConfigIP4)netConfig).getAddress() == null) {
                            sb.append(" :: is not configured for STATIC or DHCP");
                            continue;
                        }
                        sb.append(" :: is STATIC client");
                        if (((NetConfigIP4)netConfig).getAddress() != null) {
                            sb.append(" :: Address: " + ((IP4Address)((NetConfigIP4)netConfig).getAddress()).getHostAddress());
                        }
                        sb.append(" :: Prefix: " + ((NetConfigIP4)netConfig).getNetworkPrefixLength());
                        if (((NetConfigIP4)netConfig).getGateway() != null) {
                            sb.append(" :: Gateway: " + ((IP4Address)((NetConfigIP4)netConfig).getGateway()).getHostAddress());
                        }
                        dnsServers = ((NetConfigIP4)netConfig).getDnsServers();
                        List winsServers = ((NetConfigIP4)netConfig).getWinsServers();
                        List domains = ((NetConfigIP4)netConfig).getDomains();
                        if (dnsServers != null) {
                            for (IP4Address dnsServer : dnsServers) {
                                sb.append(" :: DNS : " + dnsServer.getHostAddress());
                            }
                        }
                        if (winsServers != null) {
                            for (IP4Address winsServer : winsServers) {
                                sb.append(" :: WINS Server : " + winsServer.getHostAddress());
                            }
                        }
                        if (domains == null) continue;
                        for (String domain : domains) {
                            sb.append(" :: Domains : " + domain);
                        }
                        continue;
                    }
                    if (netConfig instanceof NetConfigIP6) {
                        sb.append("\n\tIPv6 ");
                        if (((NetConfigIP6)netConfig).isDhcp()) {
                            sb.append(" :: is DHCP client");
                            Map dhcp6Map = ((NetConfigIP6)netConfig).getProperties();
                            for (String dhcpKey : dhcp6Map.keySet()) {
                                sb.append(" :: " + dhcpKey + ": " + dhcp6Map.get(dhcpKey));
                            }
                            continue;
                        }
                        sb.append(" :: is STATIC client");
                        if (((NetConfigIP6)netConfig).getAddress() != null) {
                            sb.append(" :: Address: " + ((IP6Address)((NetConfigIP6)netConfig).getAddress()).getHostAddress());
                        }
                        dnsServers = ((NetConfigIP6)netConfig).getDnsServers();
                        List domains = ((NetConfigIP6)netConfig).getDomains();
                        for (IP6Address dnsServer : dnsServers) {
                            sb.append(" :: DNS : " + dnsServer.getHostAddress());
                        }
                        for (String domain : domains) {
                            sb.append(" :: Domains : " + domain);
                        }
                        continue;
                    }
                    if (netConfig instanceof WifiConfig) {
                        sb.append("\n\tWifiConfig ");
                        sb.append(" :: SSID: " + ((WifiConfig)netConfig).getSSID());
                        sb.append(" :: BgScan: " + ((WifiConfig)netConfig).getBgscan());
                        sb.append(" :: Broadcast: " + ((WifiConfig)netConfig).getBroadcast());
                        int[] channels = ((WifiConfig)netConfig).getChannels();
                        if (channels != null && channels.length > 0) {
                            int i = 0;
                            while (i < channels.length) {
                                sb.append(channels[i]);
                                if (i + 1 < channels.length) {
                                    sb.append(",");
                                }
                                ++i;
                            }
                        }
                        sb.append(" :: Group Ciphers: " + ((WifiConfig)netConfig).getGroupCiphers());
                        sb.append(" :: Hardware Mode: " + ((WifiConfig)netConfig).getHardwareMode());
                        sb.append(" :: Mode: " + ((WifiConfig)netConfig).getMode());
                        sb.append(" :: Pairwise Ciphers: " + ((WifiConfig)netConfig).getPairwiseCiphers());
                        sb.append(" :: Passkey: " + ((WifiConfig)netConfig).getPasskey());
                        sb.append(" :: Security: " + ((WifiConfig)netConfig).getSecurity());
                        continue;
                    }
                    if (netConfig instanceof ModemConfig) {
                        sb.append("\n\tModemConfig ");
                        sb.append(" :: APN: " + ((ModemConfig)netConfig).getApn());
                        sb.append(" :: Data Compression: " + ((ModemConfig)netConfig).getDataCompression());
                        sb.append(" :: Dial String: " + ((ModemConfig)netConfig).getDialString());
                        sb.append(" :: Header Compression: " + ((ModemConfig)netConfig).getHeaderCompression());
                        sb.append(" :: Password: " + ((ModemConfig)netConfig).getPassword());
                        sb.append(" :: PPP number: " + ((ModemConfig)netConfig).getPppNumber());
                        sb.append(" :: Profile ID: " + ((ModemConfig)netConfig).getProfileID());
                        sb.append(" :: Username: " + ((ModemConfig)netConfig).getUsername());
                        sb.append(" :: Auth Type: " + ((ModemConfig)netConfig).getAuthType());
                        sb.append(" :: IP Address: " + ((ModemConfig)netConfig).getIpAddress());
                        sb.append(" :: PDP Type: " + ((ModemConfig)netConfig).getPdpType());
                        continue;
                    }
                    if (netConfig instanceof DhcpServerConfig) {
                        sb.append("\n\tDhcpServerConfig ");
                        continue;
                    }
                    if (netConfig instanceof FirewallAutoNatConfig) {
                        sb.append("\n\tFirewallAutoNatConfig ");
                        continue;
                    }
                    if (netConfig != null && netConfig.getClass() != null) {
                        sb.append("\n\tUNKNOWN CONFIG TYPE???: " + netConfig.getClass().getName());
                        continue;
                    }
                    sb.append("\n\tNULL NETCONFIG PRESENT?!?");
                }
            }
        }
        return sb.toString();
    }

    public List<NetInterfaceConfig<? extends NetInterfaceAddressConfig>> getModifiedNetInterfaceConfigs() {
        List<NetInterfaceConfig<? extends NetInterfaceAddressConfig>> netInterfaceConfigs = null;
        if (this.m_modifiedInterfaceNames != null && !this.m_modifiedInterfaceNames.isEmpty()) {
            netInterfaceConfigs = new ArrayList<NetInterfaceConfig<? extends NetInterfaceAddressConfig>>();
            for (String interfaceName : this.m_modifiedInterfaceNames) {
                netInterfaceConfigs.add(this.m_netInterfaceConfigs.get(interfaceName));
            }
        } else {
            netInterfaceConfigs = this.getNetInterfaceConfigs();
        }
        return netInterfaceConfigs;
    }

    public List<NetInterfaceConfig<? extends NetInterfaceAddressConfig>> getNetInterfaceConfigs() {
        ArrayList<NetInterfaceConfig<? extends NetInterfaceAddressConfig>> netInterfaceConfigs = new ArrayList<NetInterfaceConfig<? extends NetInterfaceAddressConfig>>();
        Iterator<String> it = this.m_netInterfaceConfigs.keySet().iterator();
        while (it.hasNext()) {
            netInterfaceConfigs.add(this.m_netInterfaceConfigs.get(it.next()));
        }
        return netInterfaceConfigs;
    }

    public NetInterfaceConfig<? extends NetInterfaceAddressConfig> getNetInterfaceConfig(String interfaceName) {
        return this.m_netInterfaceConfigs.get(interfaceName);
    }

    public Map<String, Object> getConfigurationProperties() {
        if (this.m_recomputeProperties) {
            this.recomputeNetworkProperties();
            this.m_recomputeProperties = false;
        }
        return this.m_properties;
    }

    public boolean isValid() throws KuraException {
        Iterator<String> it = this.m_netInterfaceConfigs.keySet().iterator();
        while (it.hasNext()) {
            NetInterfaceConfig<? extends NetInterfaceAddressConfig> netInterfaceConfig = this.m_netInterfaceConfigs.get(it.next());
            if (netInterfaceConfig.getMTU() < 0) {
                s_logger.error("MTU must be greater than 0");
                return false;
            }
            NetInterfaceType type = netInterfaceConfig.getType();
            if (type != NetInterfaceType.ETHERNET && type != NetInterfaceType.WIFI && type != NetInterfaceType.LOOPBACK) {
                s_logger.error("Type must be ETHERNET, WIFI, or LOOPBACK - type is " + type);
                return false;
            }
            List netInterfaceAddressConfigs = netInterfaceConfig.getNetInterfaceAddresses();
            for (NetInterfaceAddressConfig netInterfaceAddressConfig : netInterfaceAddressConfigs) {
                List netConfigs = netInterfaceAddressConfig.getConfigs();
                if (netConfigs == null) continue;
                for (NetConfig netConfig : netConfigs) {
                    if (netConfig.isValid()) continue;
                    s_logger.error("Invalid config " + netConfig.toString());
                    return false;
                }
            }
        }
        return true;
    }

    private void recomputeNetworkProperties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        String netIfPrefix = null;
        String netIfReadOnlyPrefix = null;
        String netIfConfigPrefix = null;
        StringBuilder sbPrefix = null;
        StringBuilder sbInterfaces = new StringBuilder();
        if (this.m_modifiedInterfaceNames != null && !this.m_modifiedInterfaceNames.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            String prefix = "";
            for (String interfaceName : this.m_modifiedInterfaceNames) {
                sb.append(prefix);
                prefix = ",";
                sb.append(interfaceName);
            }
            s_logger.debug("Set modified interface names: " + sb.toString());
            properties.put("modified.interface.names", sb.toString());
        }
        Iterator<String> it = this.m_netInterfaceConfigs.keySet().iterator();
        while (it.hasNext()) {
            EnumSet<WifiInterface.Capability> capabilities;
            NetInterfaceConfig<? extends NetInterfaceAddressConfig> netInterfaceConfig = this.m_netInterfaceConfigs.get(it.next());
            if (sbInterfaces.length() != 0) {
                sbInterfaces.append(",");
            }
            sbInterfaces.append(netInterfaceConfig.getName());
            sbPrefix = new StringBuilder("net.interface.").append(netInterfaceConfig.getName()).append(".");
            netIfReadOnlyPrefix = sbPrefix.toString();
            netIfPrefix = sbPrefix.append("config.").toString();
            netIfConfigPrefix = sbPrefix.toString();
            properties.put(String.valueOf(netIfReadOnlyPrefix) + "type", netInterfaceConfig.getType().toString());
            properties.put(String.valueOf(netIfPrefix) + "name", netInterfaceConfig.getName());
            if (netInterfaceConfig.getState() != null) {
                properties.put(String.valueOf(netIfPrefix) + "state", netInterfaceConfig.getState().toString());
            }
            properties.put(String.valueOf(netIfPrefix) + "autoconnect", netInterfaceConfig.isAutoConnect());
            properties.put(String.valueOf(netIfPrefix) + "mtu", netInterfaceConfig.getMTU());
            properties.put(String.valueOf(netIfReadOnlyPrefix) + "driver", netInterfaceConfig.getDriver());
            properties.put(String.valueOf(netIfReadOnlyPrefix) + "driver.version", netInterfaceConfig.getDriverVersion());
            properties.put(String.valueOf(netIfReadOnlyPrefix) + "firmware.version", netInterfaceConfig.getFirmwareVersion());
            properties.put(String.valueOf(netIfReadOnlyPrefix) + "mac", NetUtil.hardwareAddressToString((byte[])netInterfaceConfig.getHardwareAddress()));
            properties.put(String.valueOf(netIfReadOnlyPrefix) + "loopback", netInterfaceConfig.isLoopback());
            properties.put(String.valueOf(netIfReadOnlyPrefix) + "ptp", netInterfaceConfig.isPointToPoint());
            properties.put(String.valueOf(netIfReadOnlyPrefix) + "up", netInterfaceConfig.isUp());
            properties.put(String.valueOf(netIfReadOnlyPrefix) + "virtual", netInterfaceConfig.isVirtual());
            if (netInterfaceConfig.getUsbDevice() != null) {
                UsbDevice usbDev = netInterfaceConfig.getUsbDevice();
                properties.put(String.valueOf(netIfReadOnlyPrefix) + "usb.vendor.id", usbDev.getVendorId());
                properties.put(String.valueOf(netIfReadOnlyPrefix) + "usb.vendor.name", usbDev.getManufacturerName());
                properties.put(String.valueOf(netIfReadOnlyPrefix) + "usb.product.id", usbDev.getProductId());
                properties.put(String.valueOf(netIfReadOnlyPrefix) + "usb.product.name", usbDev.getProductName());
                properties.put(String.valueOf(netIfReadOnlyPrefix) + "usb.busNumber", usbDev.getUsbBusNumber());
                properties.put(String.valueOf(netIfReadOnlyPrefix) + "usb.devicePath", usbDev.getUsbDevicePath());
            }
            if (netInterfaceConfig instanceof EthernetInterfaceConfigImpl) {
                properties.put(String.valueOf(netIfReadOnlyPrefix) + "eth.link.up", ((EthernetInterfaceConfigImpl)netInterfaceConfig).isLinkUp());
            } else if (netInterfaceConfig instanceof WifiInterfaceConfigImpl && (capabilities = ((WifiInterfaceConfigImpl)netInterfaceConfig).getCapabilities()) != null && capabilities.size() > 0) {
                StringBuilder sb = new StringBuilder();
                for (WifiInterface.Capability capability : capabilities) {
                    sb.append(capability.toString());
                    sb.append(",");
                }
                String capabilitiesString = sb.toString();
                capabilitiesString = capabilitiesString.substring(0, capabilitiesString.length() - 1);
                properties.put(String.valueOf(netIfReadOnlyPrefix) + "wifi.capabilities", capabilitiesString);
            }
            if (netInterfaceConfig.getType() == NetInterfaceType.WIFI) {
                StringBuilder sbCapabilities = new StringBuilder();
                EnumSet capabilities2 = ((WifiInterface)netInterfaceConfig).getCapabilities();
                if (capabilities2 != null) {
                    Iterator it2 = ((WifiInterface)netInterfaceConfig).getCapabilities().iterator();
                    while (it2.hasNext()) {
                        sbCapabilities.append(((WifiInterface.Capability)it2.next()).name()).append(" ");
                    }
                    properties.put(String.valueOf(netIfReadOnlyPrefix) + "wifi.capabilities", sbCapabilities.toString());
                }
            }
            if (netInterfaceConfig.getType() == NetInterfaceType.MODEM) {
                String delim;
                StringBuffer revisionIdBuf = new StringBuffer();
                String[] revisionId = ((ModemInterface)netInterfaceConfig).getRevisionId();
                if (revisionId != null) {
                    delim = null;
                    String[] stringArray = revisionId;
                    int n = revisionId.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String rev = stringArray[n2];
                        if (delim != null) {
                            revisionIdBuf.append(delim);
                        }
                        revisionIdBuf.append(rev);
                        delim = ",";
                        ++n2;
                    }
                }
                StringBuffer techTypesBuf = new StringBuffer();
                List techTypes = ((ModemInterface)netInterfaceConfig).getTechnologyTypes();
                if (techTypes != null) {
                    delim = null;
                    for (ModemTechnologyType techType : techTypes) {
                        if (delim != null) {
                            techTypesBuf.append(delim);
                        }
                        techTypesBuf.append(techType.toString());
                        delim = ",";
                    }
                }
                ModemPowerMode powerMode = ModemPowerMode.UNKNOWN;
                if (((ModemInterface)netInterfaceConfig).getPowerMode() != null) {
                    powerMode = ((ModemInterface)netInterfaceConfig).getPowerMode();
                }
                properties.put(String.valueOf(netIfReadOnlyPrefix) + "manufacturer", ((ModemInterface)netInterfaceConfig).getManufacturer());
                properties.put(String.valueOf(netIfReadOnlyPrefix) + "model", ((ModemInterface)netInterfaceConfig).getModel());
                properties.put(String.valueOf(netIfReadOnlyPrefix) + "revisionId", revisionIdBuf.toString());
                properties.put(String.valueOf(netIfReadOnlyPrefix) + "serialNum", ((ModemInterface)netInterfaceConfig).getSerialNumber());
                properties.put(String.valueOf(netIfReadOnlyPrefix) + "technologyTypes", techTypesBuf.toString());
                properties.put(String.valueOf(netIfConfigPrefix) + "identifier", ((ModemInterface)netInterfaceConfig).getModemIdentifier());
                properties.put(String.valueOf(netIfConfigPrefix) + "powerMode", powerMode.toString());
                properties.put(String.valueOf(netIfConfigPrefix) + "pppNum", ((ModemInterface)netInterfaceConfig).getPppNum());
                properties.put(String.valueOf(netIfConfigPrefix) + "poweredOn", ((ModemInterface)netInterfaceConfig).isPoweredOn());
            }
            for (NetInterfaceAddress nia : netInterfaceConfig.getNetInterfaceAddresses()) {
                String typePrefix = "ip4.";
                if (nia == null) continue;
                if (nia.getAddress() != null) {
                    properties.put(String.valueOf(netIfReadOnlyPrefix) + typePrefix + "address", nia.getAddress().getHostAddress());
                }
                if (nia.getBroadcast() != null) {
                    properties.put(String.valueOf(netIfReadOnlyPrefix) + typePrefix + "broadcast", nia.getBroadcast().getHostAddress());
                }
                if (nia.getGateway() != null) {
                    properties.put(String.valueOf(netIfReadOnlyPrefix) + typePrefix + "gateway", nia.getGateway().getHostAddress());
                }
                if (nia.getNetmask() != null) {
                    properties.put(String.valueOf(netIfReadOnlyPrefix) + typePrefix + "netmask", nia.getNetmask().getHostAddress());
                }
                if (nia.getNetmask() != null) {
                    properties.put(String.valueOf(netIfReadOnlyPrefix) + typePrefix + "prefix", nia.getNetworkPrefixLength());
                }
                if (nia.getDnsServers() != null) {
                    StringBuilder dnsServers = new StringBuilder();
                    for (IPAddress dnsServer : nia.getDnsServers()) {
                        if (dnsServers.length() != 0) {
                            dnsServers.append(",");
                        }
                        dnsServers.append(dnsServer);
                    }
                    properties.put(String.valueOf(netIfReadOnlyPrefix) + typePrefix + "dnsServers", dnsServers.toString());
                }
                if (nia instanceof WifiInterfaceAddress) {
                    WifiAccessPoint wap = ((WifiInterfaceAddress)nia).getWifiAccessPoint();
                    long bitrate = ((WifiInterfaceAddress)nia).getBitrate();
                    properties.put(String.valueOf(netIfReadOnlyPrefix) + "wifi.bitrate", bitrate);
                    WifiMode wifiMode = ((WifiInterfaceAddress)nia).getMode() != null ? ((WifiInterfaceAddress)nia).getMode() : WifiMode.UNKNOWN;
                    properties.put(String.valueOf(netIfPrefix) + "wifi.mode", wifiMode.toString());
                }
                if (!(nia instanceof ModemInterfaceAddress)) continue;
                if (((ModemInterfaceAddress)nia).getConnectionType() != null) {
                    properties.put(String.valueOf(netIfConfigPrefix) + "connection.type", ((ModemInterfaceAddress)nia).getConnectionType().toString());
                }
                if (((ModemInterfaceAddress)nia).getConnectionStatus() == null) continue;
                properties.put(String.valueOf(netIfConfigPrefix) + "connection.status", ((ModemInterfaceAddress)nia).getConnectionStatus().toString());
            }
            List netInterfaceAddressConfigs = netInterfaceConfig.getNetInterfaceAddresses();
            s_logger.trace("netInterfaceAddressConfigs.size() for " + netInterfaceConfig.getName() + ": " + netInterfaceAddressConfigs.size());
            for (NetInterfaceAddressConfig netInterfaceAddressConfig : netInterfaceAddressConfigs) {
                List netConfigs = netInterfaceAddressConfig.getConfigs();
                if (netConfigs == null) continue;
                s_logger.trace("netConfigs.size(): " + netConfigs.size());
                for (NetConfig netConfig : netConfigs) {
                    if (netConfig instanceof WifiConfig) {
                        s_logger.trace("adding netconfig WifiConfigIP4 for " + netInterfaceConfig.getName());
                        this.addWifiConfigIP4Properties((WifiConfig)netConfig, netIfConfigPrefix, properties);
                        continue;
                    }
                    if (netConfig instanceof ModemConfig) {
                        s_logger.trace("adding netconfig ModemConfig for " + netInterfaceConfig.getName());
                        this.addModemConfigProperties((ModemConfig)netConfig, netIfConfigPrefix, properties);
                        continue;
                    }
                    if (netConfig instanceof NetConfigIP4) {
                        s_logger.trace("adding netconfig NetConfigIP4 for " + netInterfaceConfig.getName());
                        this.addNetConfigIP4Properties((NetConfigIP4)netConfig, netIfConfigPrefix, properties);
                        continue;
                    }
                    if (netConfig instanceof NetConfigIP6) {
                        s_logger.trace("adding netconfig NetConfigIP6 for " + netInterfaceConfig.getName());
                        this.addNetConfigIP6Properties((NetConfigIP6)netConfig, netIfConfigPrefix, properties);
                        continue;
                    }
                    if (netConfig instanceof DhcpServerConfig4) {
                        s_logger.trace("adding netconfig DhcpServerConfig4 for " + netInterfaceConfig.getName());
                        this.addDhcpServerConfig4((DhcpServerConfig4)netConfig, netIfConfigPrefix, properties);
                        continue;
                    }
                    if (!(netConfig instanceof FirewallAutoNatConfig)) continue;
                    s_logger.trace("adding netconfig FirewallNatConfig for " + netInterfaceConfig.getName());
                    this.addFirewallNatConfig((FirewallAutoNatConfig)netConfig, netIfConfigPrefix, properties);
                }
            }
        }
        properties.put("net.interfaces", sbInterfaces.toString());
        this.m_properties = properties;
    }

    private void addWifiConfigIP4Properties(WifiConfig wifiConfig, String netIfConfigPrefix, Map<String, Object> properties) {
        WifiMode mode = wifiConfig.getMode();
        if (mode == null) {
            s_logger.trace("WifiMode is null - could not add wifiConfig: " + wifiConfig);
            return;
        }
        StringBuilder prefix = new StringBuilder(netIfConfigPrefix).append("wifi.").append(mode.toString().toLowerCase());
        int[] channels = wifiConfig.getChannels();
        StringBuffer sbChannel = new StringBuffer();
        if (channels != null) {
            int i = 0;
            while (i < channels.length) {
                sbChannel.append(channels[i]);
                if (i < channels.length - 1) {
                    sbChannel.append(' ');
                }
                ++i;
            }
        }
        properties.put(prefix + ".ssid", wifiConfig.getSSID());
        properties.put(prefix + ".driver", wifiConfig.getDriver());
        if (wifiConfig.getMode() != null) {
            properties.put(prefix + ".mode", wifiConfig.getMode().toString());
        } else {
            properties.put(prefix + ".mode", WifiMode.UNKNOWN.toString());
        }
        if (wifiConfig.getSecurity() != null) {
            properties.put(prefix + ".securityType", wifiConfig.getSecurity().toString());
        } else {
            properties.put(prefix + ".securityType", WifiSecurity.NONE.toString());
        }
        properties.put(prefix + ".channel", sbChannel.toString());
        if (wifiConfig != null && wifiConfig.getPasskey() != null) {
            properties.put(prefix + ".passphrase", wifiConfig.getPasskey());
        } else {
            properties.put(prefix + ".passphrase", "");
        }
        if (wifiConfig != null && wifiConfig.getHardwareMode() != null) {
            properties.put(prefix + ".hardwareMode", wifiConfig.getHardwareMode());
        } else {
            properties.put(prefix + ".hardwareMode", "");
        }
        properties.put(prefix + ".broadcast", wifiConfig.getBroadcast());
        if (wifiConfig.getRadioMode() != null) {
            properties.put(prefix + ".radioMode", wifiConfig.getRadioMode().toString());
        }
        if (wifiConfig.getPairwiseCiphers() != null) {
            properties.put(prefix + ".pairwiseCiphers", wifiConfig.getPairwiseCiphers().name());
        }
        if (wifiConfig.getGroupCiphers() != null) {
            properties.put(prefix + ".groupCiphers", wifiConfig.getGroupCiphers().name());
        }
        properties.put(prefix + ".pingAccessPoint", wifiConfig.pingAccessPoint());
        properties.put(prefix + ".ignoreSSID", wifiConfig.ignoreSSID());
    }

    private WifiConfig getWifiConfig(String netIfConfigPrefix, WifiMode mode, Map<String, Object> properties) throws KuraException {
        Boolean broadcast;
        String passphrase;
        StringTokenizer st;
        int tokens;
        WifiConfig wifiConfig = new WifiConfig();
        StringBuilder prefix = new StringBuilder(netIfConfigPrefix).append("wifi.").append(mode.toString().toLowerCase());
        s_logger.trace("mode is " + mode.toString());
        wifiConfig.setMode(mode);
        String key = prefix + ".ssid";
        String ssid = (String)properties.get(key);
        if (ssid == null) {
            ssid = "";
        }
        s_logger.trace("SSID is " + ssid);
        wifiConfig.setSSID(ssid);
        key = prefix + ".driver";
        String driver = (String)properties.get(key);
        if (driver == null) {
            driver = "";
        }
        s_logger.trace("driver is " + driver);
        wifiConfig.setDriver(driver);
        key = prefix + ".securityType";
        WifiSecurity wifiSecurity = WifiSecurity.NONE;
        String securityString = (String)properties.get(key);
        s_logger.trace("securityString is " + securityString);
        if (securityString != null && !securityString.isEmpty()) {
            try {
                wifiSecurity = WifiSecurity.valueOf((String)securityString);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new KuraException(KuraErrorCode.INTERNAL_ERROR, new Object[]{"Could not parse wifi security " + securityString});
            }
        }
        wifiConfig.setSecurity(wifiSecurity);
        key = prefix + ".channel";
        String channelsString = (String)properties.get(key);
        s_logger.trace("channelsString is " + channelsString);
        if (channelsString != null && (channelsString = channelsString.trim()).length() > 0 && (tokens = (st = new StringTokenizer(channelsString, " ")).countTokens()) > 0) {
            int[] channels = new int[tokens];
            int i = 0;
            while (i < tokens) {
                String token = st.nextToken();
                try {
                    channels[i] = Integer.parseInt(token);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++i;
            }
            wifiConfig.setChannels(channels);
        }
        if ((passphrase = (String)properties.get(key = prefix + ".passphrase")) == null) {
            passphrase = "";
        }
        s_logger.trace("passphrase is " + passphrase);
        wifiConfig.setPasskey(passphrase);
        key = prefix + ".hardwareMode";
        String hwMode = (String)properties.get(key);
        if (hwMode == null) {
            hwMode = "";
        }
        s_logger.trace("hwMode is " + hwMode);
        wifiConfig.setHardwareMode(hwMode);
        key = prefix + ".ignoreSSID";
        boolean ignoreSSID = false;
        if (properties.get(key) != null) {
            ignoreSSID = (Boolean)properties.get(key);
            s_logger.trace("Ignore SSID is {}", (Object)ignoreSSID);
        } else {
            s_logger.trace("Ignore SSID is null");
        }
        wifiConfig.setIgnoreSSID(ignoreSSID);
        if (mode == WifiMode.INFRA) {
            String groupCiphers;
            key = prefix + ".bgscan";
            String bgscan = (String)properties.get(key);
            if (bgscan == null) {
                bgscan = "";
            }
            s_logger.trace("bgscan is " + bgscan);
            wifiConfig.setBgscan(new WifiBgscan(bgscan));
            key = prefix + ".pairwiseCiphers";
            String pairwiseCiphers = (String)properties.get(key);
            if (pairwiseCiphers != null) {
                wifiConfig.setPairwiseCiphers(WifiCiphers.valueOf((String)pairwiseCiphers));
            }
            if ((groupCiphers = (String)properties.get(key = prefix + ".groupCiphers")) != null) {
                wifiConfig.setGroupCiphers(WifiCiphers.valueOf((String)groupCiphers));
            }
            key = prefix + ".pingAccessPoint";
            boolean pingAccessPoint = false;
            if (properties.get(key) != null) {
                pingAccessPoint = (Boolean)properties.get(key);
                s_logger.trace("Ping Access Point is {}", (Object)pingAccessPoint);
            } else {
                s_logger.trace("Ping Access Point is null");
            }
            wifiConfig.setPingAccessPoint(pingAccessPoint);
        }
        if ((broadcast = (Boolean)properties.get(key = prefix + ".broadcast")) != null) {
            wifiConfig.setBroadcast(broadcast.booleanValue());
        }
        s_logger.trace("hwMode is " + hwMode);
        key = prefix + ".radioMode";
        String radioModeString = (String)properties.get(key);
        s_logger.trace("radioModeString is " + radioModeString);
        if (radioModeString != null && !radioModeString.isEmpty()) {
            try {
                WifiRadioMode radioMode = WifiRadioMode.valueOf((String)radioModeString);
                wifiConfig.setRadioMode(radioMode);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new KuraException(KuraErrorCode.INTERNAL_ERROR, new Object[]{"Could not parse wifi radio mode " + radioModeString});
            }
        }
        if (!wifiConfig.isValid()) {
            return null;
        }
        s_logger.trace("Returning wifiConfig: " + wifiConfig);
        return wifiConfig;
    }

    private void addModemConfigProperties(ModemConfig modemConfig, String prefix, Map<String, Object> properties) {
        properties.put(String.valueOf(prefix) + "apn", modemConfig.getApn());
        properties.put(String.valueOf(prefix) + "authType", modemConfig.getAuthType() != null ? modemConfig.getAuthType().toString() : "");
        properties.put(String.valueOf(prefix) + "dataCompression", modemConfig.getDataCompression());
        properties.put(String.valueOf(prefix) + "dialString", modemConfig.getDialString());
        properties.put(String.valueOf(prefix) + "headerCompression", modemConfig.getHeaderCompression());
        properties.put(String.valueOf(prefix) + "ipAddress", modemConfig.getIpAddress() != null ? modemConfig.getIpAddress().toString() : "");
        properties.put(String.valueOf(prefix) + "password", modemConfig.getPassword());
        properties.put(String.valueOf(prefix) + "pdpType", modemConfig.getPdpType() != null ? modemConfig.getPdpType().toString() : "");
        properties.put(String.valueOf(prefix) + "pppNum", modemConfig.getPppNumber());
        properties.put(String.valueOf(prefix) + "persist", modemConfig.isPersist());
        properties.put(String.valueOf(prefix) + "maxFail", modemConfig.getMaxFail());
        properties.put(String.valueOf(prefix) + "idle", modemConfig.getIdle());
        properties.put(String.valueOf(prefix) + "activeFilter", modemConfig.getActiveFilter());
        properties.put(String.valueOf(prefix) + "resetTimeout", modemConfig.getResetTimeout());
        properties.put(String.valueOf(prefix) + "lcpEchoInterval", modemConfig.getLcpEchoInterval());
        properties.put(String.valueOf(prefix) + "lcpEchoFailure", modemConfig.getLcpEchoFailure());
        properties.put(String.valueOf(prefix) + "profileId", modemConfig.getProfileID());
        properties.put(String.valueOf(prefix) + "username", modemConfig.getUsername());
        properties.put(String.valueOf(prefix) + "enabled", modemConfig.isEnabled());
        properties.put(String.valueOf(prefix) + "gpsEnabled", modemConfig.isGpsEnabled());
    }

    private ModemConfig getModemConfig(String prefix, Map<String, Object> properties) throws KuraException {
        ModemConfig modemConfig = new ModemConfig();
        String key = String.valueOf(prefix) + "apn";
        String apn = (String)properties.get(key);
        s_logger.trace("APN is " + apn);
        modemConfig.setApn(apn);
        key = String.valueOf(prefix) + "authType";
        String authTypeString = (String)properties.get(key);
        ModemConfig.AuthType authType = ModemConfig.AuthType.NONE;
        s_logger.trace("Auth type is " + authTypeString);
        if (authTypeString != null && !authTypeString.isEmpty()) {
            try {
                authType = ModemConfig.AuthType.valueOf((String)authTypeString);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new KuraException(KuraErrorCode.INTERNAL_ERROR, new Object[]{"Could not parse auth type " + authTypeString});
            }
        } else {
            s_logger.trace("Auth type is null");
        }
        modemConfig.setAuthType(authType);
        key = String.valueOf(prefix) + "dataCompression";
        if (properties.get(key) != null) {
            int dataCompression = (Integer)properties.get(key);
            s_logger.trace("Data compression is " + dataCompression);
            modemConfig.setDataCompression(dataCompression);
        } else {
            s_logger.trace("Data compression is null");
        }
        key = String.valueOf(prefix) + "dialString";
        String dialString = (String)properties.get(key);
        s_logger.trace("Dial string is " + dialString);
        modemConfig.setDialString(dialString);
        key = String.valueOf(prefix) + "headerCompression";
        if (properties.get(key) != null) {
            int headerCompression = (Integer)properties.get(key);
            s_logger.trace("Header compression is " + headerCompression);
            modemConfig.setHeaderCompression(headerCompression);
        } else {
            s_logger.trace("Header compression is null");
        }
        String ipAddressString = (String)properties.get(String.valueOf(prefix) + "ipAddress");
        IPAddress ipAddress = null;
        s_logger.trace("IP address is " + ipAddressString);
        if (ipAddressString != null && !ipAddressString.isEmpty()) {
            try {
                IP4Address.parseHostAddress((String)ipAddressString);
            }
            catch (UnknownHostException unknownHostException) {
                throw new KuraException(KuraErrorCode.INTERNAL_ERROR, new Object[]{"Could not parse ip address " + ipAddressString});
            }
        } else {
            s_logger.trace("IP address is null");
        }
        modemConfig.setIpAddress(ipAddress);
        String password = (String)properties.get(String.valueOf(prefix) + "password");
        s_logger.trace("Password is " + password);
        modemConfig.setPassword(password);
        String pdpTypeString = (String)properties.get(String.valueOf(prefix) + "pdpType");
        ModemConfig.PdpType pdpType = ModemConfig.PdpType.UNKNOWN;
        if (pdpTypeString != null && !pdpTypeString.isEmpty()) {
            try {
                pdpType = ModemConfig.PdpType.valueOf((String)pdpTypeString);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new KuraException(KuraErrorCode.INTERNAL_ERROR, new Object[]{"Could not parse pdp type " + pdpTypeString});
            }
        }
        s_logger.trace("Pdp type is " + pdpTypeString);
        modemConfig.setPdpType(pdpType);
        key = String.valueOf(prefix) + "profileId";
        if (properties.get(key) != null) {
            int profileId = (Integer)properties.get(key);
            s_logger.trace("Profile id is " + profileId);
            modemConfig.setProfileID(profileId);
        } else {
            s_logger.trace("Profile id is null");
        }
        key = String.valueOf(prefix) + "pppNum";
        if (properties.get(key) != null) {
            int pppNum = (Integer)properties.get(key);
            s_logger.trace("PPP number is " + pppNum);
            modemConfig.setPppNumber(pppNum);
        } else {
            s_logger.trace("PPP number is null");
        }
        key = String.valueOf(prefix) + "persist";
        if (properties.get(key) != null) {
            boolean persist = (Boolean)properties.get(key);
            s_logger.trace("persist is " + persist);
            modemConfig.setPersist(persist);
        } else {
            s_logger.trace("persist is null");
        }
        key = String.valueOf(prefix) + "maxFail";
        if (properties.get(key) != null) {
            int maxFail = (Integer)properties.get(key);
            s_logger.trace("maxfail is " + maxFail);
            modemConfig.setMaxFail(maxFail);
        } else {
            s_logger.trace("maxfail is null");
        }
        key = String.valueOf(prefix) + "resetTimeout";
        if (properties.get(key) != null) {
            int resetTimeout = (Integer)properties.get(key);
            s_logger.trace("resetTimeout is " + resetTimeout);
            modemConfig.setResetTimeout(resetTimeout);
        } else {
            s_logger.trace("resetTimeout is null");
        }
        key = String.valueOf(prefix) + "idle";
        if (properties.get(key) != null) {
            int idle = (Integer)properties.get(key);
            s_logger.trace("idle is " + idle);
            modemConfig.setIdle(idle);
        } else {
            s_logger.trace("idle is null");
        }
        key = String.valueOf(prefix) + "activeFilter";
        if (properties.get(key) != null) {
            String activeFilter = (String)properties.get(key);
            s_logger.trace("activeFilter is " + activeFilter);
            modemConfig.setActiveFilter(activeFilter);
        } else {
            s_logger.trace("activeFilter is null");
        }
        key = String.valueOf(prefix) + "lcpEchoInterval";
        if (properties.get(key) != null) {
            int lcpEchoInterval = (Integer)properties.get(key);
            s_logger.trace("LCP Echo Interval is " + lcpEchoInterval);
            modemConfig.setLcpEchoInterval(lcpEchoInterval);
        } else {
            s_logger.trace("LCP Echo Interval is null");
        }
        key = String.valueOf(prefix) + "lcpEchoFailure";
        if (properties.get(key) != null) {
            int lcpEchoFailure = (Integer)properties.get(key);
            s_logger.trace("LCP Echo Failure is " + lcpEchoFailure);
            modemConfig.setLcpEchoFailure(lcpEchoFailure);
        } else {
            s_logger.trace("LCP Echo Failure is null");
        }
        String username = (String)properties.get(String.valueOf(prefix) + "username");
        s_logger.trace("Username is " + username);
        modemConfig.setUsername(username);
        key = String.valueOf(prefix) + "enabled";
        boolean enabled = false;
        if (properties.get(key) != null) {
            enabled = (Boolean)properties.get(key);
            s_logger.trace("Enabled is " + enabled);
        } else {
            s_logger.trace("Enabled is null");
        }
        modemConfig.setEnabled(enabled);
        key = String.valueOf(prefix) + "gpsEnabled";
        boolean gpsEnabled = false;
        if (properties.get(key) != null) {
            gpsEnabled = (Boolean)properties.get(key);
            s_logger.trace("GPS Enabled is {}", (Object)gpsEnabled);
        } else {
            s_logger.trace("GPS Enabled is null");
        }
        modemConfig.setGpsEnabled(gpsEnabled);
        return modemConfig;
    }

    private void addNetConfigIP4Properties(NetConfigIP4 nc, String netIfConfigPrefix, Map<String, Object> properties) {
        properties.put(String.valueOf(netIfConfigPrefix) + "autoconnect", nc.isAutoConnect());
        properties.put(String.valueOf(netIfConfigPrefix) + "ip4.status", nc.getStatus().toString());
        StringBuilder sbDnsAddresses = new StringBuilder();
        if (nc.getDnsServers() != null) {
            for (IP4Address ip : nc.getDnsServers()) {
                if (sbDnsAddresses.length() != 0) {
                    sbDnsAddresses.append(",");
                }
                sbDnsAddresses.append(ip.getHostAddress());
            }
        }
        properties.put(String.valueOf(netIfConfigPrefix) + "ip4.dnsServers", sbDnsAddresses.toString());
        if (nc.isDhcp()) {
            properties.put(String.valueOf(netIfConfigPrefix) + "dhcpClient4.enabled", true);
        } else {
            properties.put(String.valueOf(netIfConfigPrefix) + "dhcpClient4.enabled", false);
            if (nc.getAddress() != null) {
                properties.put(String.valueOf(netIfConfigPrefix) + "ip4.address", ((IP4Address)nc.getAddress()).getHostAddress());
            } else {
                properties.put(String.valueOf(netIfConfigPrefix) + "ip4.address", "");
            }
            properties.put(String.valueOf(netIfConfigPrefix) + "ip4.prefix", nc.getNetworkPrefixLength());
            if (nc.getGateway() != null) {
                properties.put(String.valueOf(netIfConfigPrefix) + "ip4.gateway", ((IP4Address)nc.getGateway()).getHostAddress());
            } else {
                properties.put(String.valueOf(netIfConfigPrefix) + "ip4.gateway", "");
            }
            StringBuilder sbWinsAddresses = new StringBuilder();
            if (nc.getWinsServers() != null) {
                for (IP4Address ip : nc.getWinsServers()) {
                    if (sbWinsAddresses.length() != 0) {
                        sbWinsAddresses.append(",");
                    }
                    sbWinsAddresses.append(ip.getHostAddress());
                }
            }
            properties.put(String.valueOf(netIfConfigPrefix) + "winsServers", sbWinsAddresses.toString());
            StringBuilder sbDomains = new StringBuilder();
            if (nc.getDomains() != null) {
                for (String domain : nc.getDomains()) {
                    if (sbDomains.length() != 0) {
                        sbDomains.append(",");
                    }
                    sbDomains.append(domain);
                }
            }
            properties.put(String.valueOf(netIfConfigPrefix) + "domains", sbDomains.toString());
        }
    }

    private void addNetConfigIP6Properties(NetConfigIP6 nc, String netIfConfigPrefix, Map<String, Object> properties) {
        properties.put(String.valueOf(netIfConfigPrefix) + "ip6.status", nc.getStatus().toString());
        if (nc.isDhcp()) {
            properties.put(String.valueOf(netIfConfigPrefix) + "dhcpClient6.enabled", true);
        } else {
            properties.put(String.valueOf(netIfConfigPrefix) + "dhcpClient6.enabled", false);
            if (nc.getAddress() != null) {
                properties.put(String.valueOf(netIfConfigPrefix) + "address", ((IP6Address)nc.getAddress()).getHostAddress());
            }
            StringBuilder sbDnsAddresses = new StringBuilder();
            for (IP6Address ip : nc.getDnsServers()) {
                if (sbDnsAddresses.length() != 0) {
                    sbDnsAddresses.append(",");
                }
                sbDnsAddresses.append(ip.getHostAddress());
            }
            properties.put(String.valueOf(netIfConfigPrefix) + "ip6.dnsServers", sbDnsAddresses.toString());
            StringBuilder sbDomains = new StringBuilder();
            for (String domain : nc.getDomains()) {
                if (sbDomains.length() != 0) {
                    sbDomains.append(",");
                }
                sbDomains.append(domain);
            }
            properties.put(String.valueOf(netIfConfigPrefix) + "domains", sbDomains.toString());
        }
    }

    private void addDhcpServerConfig4(DhcpServerConfig4 nc, String netIfConfigPrefix, Map<String, Object> properties) {
        properties.put(String.valueOf(netIfConfigPrefix) + "dhcpServer4.enabled", nc.isEnabled());
        properties.put(String.valueOf(netIfConfigPrefix) + "dhcpServer4.defaultLeaseTime", nc.getDefaultLeaseTime());
        properties.put(String.valueOf(netIfConfigPrefix) + "dhcpServer4.maxLeaseTime", nc.getMaximumLeaseTime());
        properties.put(String.valueOf(netIfConfigPrefix) + "dhcpServer4.prefix", nc.getPrefix());
        properties.put(String.valueOf(netIfConfigPrefix) + "dhcpServer4.rangeStart", nc.getRangeStart().toString());
        properties.put(String.valueOf(netIfConfigPrefix) + "dhcpServer4.rangeEnd", nc.getRangeEnd().toString());
        properties.put(String.valueOf(netIfConfigPrefix) + "dhcpServer4.passDns", nc.isPassDns());
    }

    private void addFirewallNatConfig(FirewallAutoNatConfig nc, String netIfConfigPrefix, Map<String, Object> properties) {
        properties.put(String.valueOf(netIfConfigPrefix) + "nat.enabled", true);
    }

    private void addInterfaceConfiguration(String interfaceName, NetInterfaceType type, Map<String, Object> props) throws UnknownHostException, KuraException {
        if (type == null) {
            s_logger.error("Null type for " + interfaceName);
            return;
        }
        switch (type) {
            case LOOPBACK: {
                LoopbackInterfaceConfigImpl loopbackInterfaceConfig = new LoopbackInterfaceConfigImpl(interfaceName);
                ArrayList<NetInterfaceAddressConfigImpl> loopbackInterfaceAddressConfigs = new ArrayList<NetInterfaceAddressConfigImpl>();
                loopbackInterfaceAddressConfigs.add(new NetInterfaceAddressConfigImpl());
                loopbackInterfaceConfig.setNetInterfaceAddresses(loopbackInterfaceAddressConfigs);
                this.populateNetInterfaceConfiguration(loopbackInterfaceConfig, props);
                this.m_netInterfaceConfigs.put(interfaceName, loopbackInterfaceConfig);
                break;
            }
            case ETHERNET: {
                EthernetInterfaceConfigImpl ethernetInterfaceConfig = new EthernetInterfaceConfigImpl(interfaceName);
                ArrayList<NetInterfaceAddressConfigImpl> ethernetInterfaceAddressConfigs = new ArrayList<NetInterfaceAddressConfigImpl>();
                ethernetInterfaceAddressConfigs.add(new NetInterfaceAddressConfigImpl());
                ethernetInterfaceConfig.setNetInterfaceAddresses(ethernetInterfaceAddressConfigs);
                this.populateNetInterfaceConfiguration(ethernetInterfaceConfig, props);
                this.m_netInterfaceConfigs.put(interfaceName, ethernetInterfaceConfig);
                break;
            }
            case WIFI: {
                WifiInterfaceConfigImpl wifiInterfaceConfig = new WifiInterfaceConfigImpl(interfaceName);
                ArrayList<WifiInterfaceAddressConfigImpl> wifiInterfaceAddressConfigs = new ArrayList<WifiInterfaceAddressConfigImpl>();
                wifiInterfaceAddressConfigs.add(new WifiInterfaceAddressConfigImpl());
                wifiInterfaceConfig.setNetInterfaceAddresses(wifiInterfaceAddressConfigs);
                this.populateNetInterfaceConfiguration(wifiInterfaceConfig, props);
                this.m_netInterfaceConfigs.put(interfaceName, wifiInterfaceConfig);
                break;
            }
            case MODEM: {
                ModemInterfaceConfigImpl modemInterfaceConfig = new ModemInterfaceConfigImpl(interfaceName);
                ArrayList<ModemInterfaceAddressConfigImpl> modemInterfaceAddressConfigs = new ArrayList<ModemInterfaceAddressConfigImpl>();
                modemInterfaceAddressConfigs.add(new ModemInterfaceAddressConfigImpl());
                modemInterfaceConfig.setNetInterfaceAddresses(modemInterfaceAddressConfigs);
                this.populateNetInterfaceConfiguration(modemInterfaceConfig, props);
                this.m_netInterfaceConfigs.put(interfaceName, modemInterfaceConfig);
                break;
            }
            case UNKNOWN: {
                s_logger.trace("Found interface of unknown type in current configuration: " + interfaceName);
                break;
            }
            default: {
                s_logger.error("Unsupported type " + type.toString() + " for interface " + interfaceName);
            }
        }
    }

    private void populateNetInterfaceConfiguration(AbstractNetInterface<? extends NetInterfaceAddressConfig> netInterfaceConfig, Map<String, Object> props) throws UnknownHostException, KuraException {
        int n;
        int n2;
        String[] stringArray;
        String upKey;
        String ptpKey;
        String loopbackKey;
        String macAddressKey;
        String firmwardVersionKey;
        String driverVersionKey;
        String driverKey;
        String mtuConfig;
        String interfaceName = netInterfaceConfig.getName();
        StringBuffer keyBuffer = new StringBuffer();
        keyBuffer.append("net.interface.").append(interfaceName).append(".type");
        NetInterfaceType interfaceType = NetInterfaceType.valueOf((String)((String)props.get(keyBuffer.toString())));
        s_logger.trace("Populating interface: " + interfaceName + " of type " + interfaceType);
        StringBuilder sbPrefix = new StringBuilder();
        sbPrefix.append("net.interface.").append(interfaceName).append(".");
        String netIfReadOnlyPrefix = sbPrefix.toString();
        String netIfPrefix = sbPrefix.append("config.").toString();
        String netIfConfigPrefix = sbPrefix.toString();
        String stateConfig = String.valueOf(netIfReadOnlyPrefix) + "state";
        if (props.containsKey(stateConfig)) {
            try {
                NetInterfaceState state = (NetInterfaceState)props.get(stateConfig);
                s_logger.trace("got state: " + state);
                netInterfaceConfig.setState(state);
            }
            catch (Exception e) {
                s_logger.error("Could not process State configuration. Retaining current value.", (Throwable)e);
            }
        }
        boolean autoConnect = false;
        String autoConnectKey = String.valueOf(netIfPrefix) + "autoconnect";
        if (props.containsKey(autoConnectKey)) {
            autoConnect = (Boolean)props.get(autoConnectKey);
            s_logger.trace("got autoConnect: " + autoConnect);
            netInterfaceConfig.setAutoConnect(autoConnect);
        }
        if (props.containsKey(mtuConfig = String.valueOf(netIfPrefix) + "mtu")) {
            int mtu = (Integer)props.get(mtuConfig);
            s_logger.trace("got MTU: " + mtu);
            netInterfaceConfig.setMTU(mtu);
        }
        if (props.containsKey(driverKey = String.valueOf(netIfReadOnlyPrefix) + "driver")) {
            String driver = (String)props.get(driverKey);
            s_logger.trace("got Driver: " + driver);
            netInterfaceConfig.setDriver(driver);
        }
        if (props.containsKey(driverVersionKey = String.valueOf(netIfReadOnlyPrefix) + "driver.version")) {
            String driverVersion = (String)props.get(driverVersionKey);
            s_logger.trace("got Driver Version: " + driverVersion);
            netInterfaceConfig.setDriverVersion(driverVersion);
        }
        if (props.containsKey(firmwardVersionKey = String.valueOf(netIfReadOnlyPrefix) + "firmware.version")) {
            String firmwareVersion = (String)props.get(firmwardVersionKey);
            s_logger.trace("got Firmware Version: " + firmwareVersion);
            netInterfaceConfig.setFirmwareVersion(firmwareVersion);
        }
        if (props.containsKey(macAddressKey = String.valueOf(netIfReadOnlyPrefix) + "mac")) {
            String macAddress = (String)props.get(macAddressKey);
            s_logger.trace("got Mac Address: " + macAddress);
            netInterfaceConfig.setHardwareAddress(NetUtil.hardwareAddressToBytes((String)macAddress));
        }
        if (props.containsKey(loopbackKey = String.valueOf(netIfReadOnlyPrefix) + "loopback")) {
            Boolean isLoopback = (Boolean)props.get(loopbackKey);
            s_logger.trace("got Is Loopback: " + isLoopback);
            netInterfaceConfig.setLoopback(isLoopback);
        }
        if (props.containsKey(ptpKey = String.valueOf(netIfReadOnlyPrefix) + "ptp")) {
            Boolean isPtp = (Boolean)props.get(ptpKey);
            s_logger.trace("got Is PtP: " + isPtp);
            netInterfaceConfig.setPointToPoint(isPtp);
        }
        if (props.containsKey(upKey = String.valueOf(netIfReadOnlyPrefix) + "up")) {
            Boolean isUp = (Boolean)props.get(upKey);
            s_logger.trace("got Is Up: " + isUp);
            netInterfaceConfig.setUp(isUp);
            if (isUp.booleanValue()) {
                netInterfaceConfig.setState(NetInterfaceState.ACTIVATED);
            } else {
                netInterfaceConfig.setState(NetInterfaceState.DISCONNECTED);
            }
        } else {
            s_logger.trace("Setting state to");
            netInterfaceConfig.setState(NetInterfaceState.DISCONNECTED);
        }
        String virtualKey = String.valueOf(netIfReadOnlyPrefix) + "virtual";
        if (props.containsKey(virtualKey)) {
            Boolean isVirtual = (Boolean)props.get(virtualKey);
            s_logger.trace("got Is Virtual: " + isVirtual);
            netInterfaceConfig.setVirtual(isVirtual);
        }
        String vendorId = (String)props.get(String.valueOf(netIfReadOnlyPrefix) + "usb.vendor.id");
        String vendorName = (String)props.get(String.valueOf(netIfReadOnlyPrefix) + "usb.vendor.name");
        String productId = (String)props.get(String.valueOf(netIfReadOnlyPrefix) + "usb.product.id");
        String productName = (String)props.get(String.valueOf(netIfReadOnlyPrefix) + "usb.product.name");
        String usbBusNumber = (String)props.get(String.valueOf(netIfReadOnlyPrefix) + "usb.busNumber");
        String usbDevicePath = (String)props.get(String.valueOf(netIfReadOnlyPrefix) + "usb.devicePath");
        if (vendorId != null && productId != null) {
            UsbNetDevice usbDevice = new UsbNetDevice(vendorId, productId, vendorName, productName, usbBusNumber, usbDevicePath, interfaceName);
            s_logger.trace("adding usbDevice: " + usbDevice + ", port: " + usbDevice.getUsbPort());
            netInterfaceConfig.setUsbDevice((UsbDevice)usbDevice);
        }
        if (netInterfaceConfig instanceof EthernetInterfaceConfigImpl) {
            String linkUpKey = String.valueOf(netIfReadOnlyPrefix) + "eth.link.up";
            if (props.containsKey(linkUpKey)) {
                Boolean linkUp = (Boolean)props.get(linkUpKey);
                s_logger.trace("got Is Link Up: " + linkUp);
                ((EthernetInterfaceConfigImpl)netInterfaceConfig).setLinkUp(linkUp);
            }
        } else if (netInterfaceConfig instanceof WifiInterfaceConfigImpl) {
            String[] capabilities;
            String capabilitiesString;
            String capabilitiesKey = String.valueOf(netIfReadOnlyPrefix) + "wifi.capabilities";
            if (props.containsKey(capabilitiesKey) && (capabilitiesString = (String)props.get(capabilitiesKey)) != null && (capabilities = capabilitiesString.split(" ")) != null && capabilities.length > 0) {
                EnumSet<WifiInterface.Capability> capabilitiesEnum = EnumSet.noneOf(WifiInterface.Capability.class);
                stringArray = capabilities;
                n2 = capabilities.length;
                n = 0;
                while (n < n2) {
                    String string = stringArray[n];
                    if (string != null && !string.isEmpty()) {
                        capabilitiesEnum.add(WifiInterface.Capability.valueOf((String)string));
                    }
                    ++n;
                }
                ((WifiInterfaceConfigImpl)netInterfaceConfig).setCapabilities(capabilitiesEnum);
            }
        } else if (netInterfaceConfig instanceof ModemInterfaceConfigImpl) {
            ModemInterfaceConfigImpl modemInterfaceConfig = (ModemInterfaceConfigImpl)netInterfaceConfig;
            String key = String.valueOf(netIfReadOnlyPrefix) + "manufacturer";
            if (props.containsKey(key)) {
                modemInterfaceConfig.setManufacturer((String)props.get(key));
            }
            if (props.containsKey(key = String.valueOf(netIfReadOnlyPrefix) + "model")) {
                modemInterfaceConfig.setModel((String)props.get(key));
            }
            if (props.containsKey(key = String.valueOf(netIfReadOnlyPrefix) + "revisionId")) {
                String revisionIdString = (String)props.get(key);
                modemInterfaceConfig.setRevisionId(revisionIdString.split(","));
            }
            if (props.containsKey(key = String.valueOf(netIfReadOnlyPrefix) + "serialNum")) {
                modemInterfaceConfig.setSerialNumber((String)props.get(key));
            }
            if (props.containsKey(key = String.valueOf(netIfReadOnlyPrefix) + "technologyTypes")) {
                ArrayList<ModemTechnologyType> technologyTypes = new ArrayList<ModemTechnologyType>();
                String techTypesString = (String)props.get(String.valueOf(netIfReadOnlyPrefix) + "technologyTypes");
                if (techTypesString != null && !techTypesString.isEmpty()) {
                    stringArray = techTypesString.split(",");
                    n2 = stringArray.length;
                    n = 0;
                    while (n < n2) {
                        String string = stringArray[n];
                        if (string != null && !string.isEmpty()) {
                            try {
                                ModemTechnologyType modemTechType = ModemTechnologyType.valueOf((String)string);
                                technologyTypes.add(modemTechType);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                s_logger.error("Could not parse type " + string);
                            }
                        }
                        ++n;
                    }
                    modemInterfaceConfig.setTechnologyTypes(technologyTypes);
                }
            }
            if (props.containsKey(key = String.valueOf(netIfConfigPrefix) + "identifier")) {
                modemInterfaceConfig.setModemIdentifier((String)props.get(key));
            }
            if (props.containsKey(key = String.valueOf(netIfConfigPrefix) + "powerMode")) {
                ModemPowerMode powerMode = ModemPowerMode.UNKNOWN;
                String modemPowerModeString = (String)props.get(String.valueOf(netIfConfigPrefix) + "powerMode");
                if (modemPowerModeString != null) {
                    powerMode = ModemPowerMode.valueOf((String)modemPowerModeString);
                    modemInterfaceConfig.setPowerMode(powerMode);
                }
            }
            if (props.containsKey(key = String.valueOf(netIfConfigPrefix) + "pppNum") && props.get(key) != null) {
                modemInterfaceConfig.setPppNum((Integer)props.get(key));
            }
            if (props.containsKey(key = String.valueOf(netIfConfigPrefix) + "poweredOn") && props.get(key) != null) {
                modemInterfaceConfig.setPoweredOn((Boolean)props.get(key));
            }
        }
        String configStatus4 = null;
        String configStatus4Key = "net.interface." + interfaceName + ".config.ip4.status";
        if (props.containsKey(configStatus4Key)) {
            configStatus4 = (String)props.get(configStatus4Key);
        }
        if (configStatus4 == null) {
            configStatus4 = NetInterfaceStatus.netIPv4StatusDisabled.name();
        }
        s_logger.trace("Status Ipv4? " + configStatus4);
        String configStatus6 = null;
        String configStatus6Key = "net.interface." + interfaceName + ".config.ip6.status";
        if (props.containsKey(configStatus6Key)) {
            configStatus6 = (String)props.get(configStatus6Key);
        }
        if (configStatus6 == null) {
            configStatus6 = NetInterfaceStatus.netIPv6StatusDisabled.name();
        }
        for (NetInterfaceAddressConfig netInterfaceAddressConfig : netInterfaceConfig.getNetInterfaceAddresses()) {
            String configIp6;
            String configDhcpServerEnabled;
            String configNatEnabled;
            String configDomains;
            IP4Address winsIp4;
            String configWINSs;
            IP4Address dnsIp422;
            String configDNSs;
            String configIp4;
            ArrayList<NetConfig> netConfigs = new ArrayList<NetConfig>();
            if (netInterfaceAddressConfig instanceof NetInterfaceAddressConfigImpl) {
                ((NetInterfaceAddressConfigImpl)netInterfaceAddressConfig).setNetConfigs(netConfigs);
            } else if (netInterfaceAddressConfig instanceof WifiInterfaceAddressConfigImpl) {
                ((WifiInterfaceAddressConfigImpl)netInterfaceAddressConfig).setNetConfigs(netConfigs);
            } else if (netInterfaceAddressConfig instanceof ModemInterfaceAddressConfigImpl) {
                ((ModemInterfaceAddressConfigImpl)netInterfaceAddressConfig).setNetConfigs(netConfigs);
            }
            if (netInterfaceAddressConfig instanceof NetInterfaceAddressImpl) {
                s_logger.trace("netInterfaceAddress is instanceof NetInterfaceAddressImpl");
                NetInterfaceAddressImpl netInterfaceAddressImpl = (NetInterfaceAddressImpl)netInterfaceAddressConfig;
                String addressType = ".ip4";
                String key = "net.interface." + interfaceName + addressType + ".address";
                if (props.containsKey(key)) {
                    IPAddress address = IP4Address.parseHostAddress((String)((String)props.get(key)));
                    s_logger.trace("got " + key + ": " + address);
                    netInterfaceAddressImpl.setAddress(address);
                }
                if (props.containsKey(key = "net.interface." + interfaceName + addressType + ".broadcast")) {
                    IPAddress broadcast = IP4Address.parseHostAddress((String)((String)props.get(key)));
                    s_logger.trace("got " + key + ": " + broadcast);
                    netInterfaceAddressImpl.setBroadcast(broadcast);
                }
                if (props.containsKey(key = "net.interface." + interfaceName + addressType + ".dnsServers")) {
                    ArrayList<IPAddress> dnsServers = new ArrayList<IPAddress>();
                    String dnsServersString = (String)props.get(key);
                    s_logger.trace("got " + key + ": " + dnsServersString);
                    String[] stringArray2 = dnsServersString.split(",");
                    int n3 = stringArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String dnsServer = stringArray2[n4];
                        dnsServers.add(IP4Address.parseHostAddress((String)dnsServer));
                        ++n4;
                    }
                    netInterfaceAddressImpl.setDnsServers(dnsServers);
                }
                if (props.containsKey(key = "net.interface." + interfaceName + addressType + ".gateway")) {
                    if (props.get(key) != null && !((String)props.get(key)).trim().equals("")) {
                        IPAddress gateway = IP4Address.parseHostAddress((String)((String)props.get(key)));
                        s_logger.trace("got " + key + ": " + gateway);
                        netInterfaceAddressImpl.setGateway(gateway);
                    } else {
                        s_logger.trace("got " + key + ": null");
                        netInterfaceAddressImpl.setGateway(null);
                    }
                }
                if (props.containsKey(key = "net.interface." + interfaceName + addressType + ".netmask")) {
                    IPAddress netmask = IP4Address.parseHostAddress((String)((String)props.get(key)));
                    s_logger.trace("got " + key + ": " + netmask);
                    netInterfaceAddressImpl.setBroadcast(netmask);
                }
                if (props.containsKey(key = "net.interface." + interfaceName + addressType + ".prefix")) {
                    Short prefix = (Short)props.get(key);
                    s_logger.trace("got " + key + ": " + prefix);
                    netInterfaceAddressImpl.setNetworkPrefixLength(prefix);
                }
            }
            if (netInterfaceAddressConfig instanceof WifiInterfaceAddressImpl) {
                s_logger.trace("netInterfaceAddress is instanceof WifiInterfaceAddressImpl");
                WifiInterfaceAddressImpl wifiInterfaceAddressImpl = (WifiInterfaceAddressImpl)netInterfaceAddressConfig;
                String configWifiMode = String.valueOf(netIfPrefix) + "wifi.mode";
                if (props.containsKey(configWifiMode)) {
                    WifiMode mode = WifiMode.INFRA;
                    if (props.get(configWifiMode) != null) {
                        mode = WifiMode.valueOf((String)((String)props.get(configWifiMode)));
                    }
                    s_logger.trace("Adding wifiMode: " + mode);
                    wifiInterfaceAddressImpl.setMode(mode);
                }
            }
            if (netInterfaceAddressConfig instanceof ModemInterfaceAddressConfigImpl) {
                String configConnStatus;
                s_logger.trace("netInterfaceAddress is instanceof ModemInterfaceAddressConfigImpl");
                ModemInterfaceAddressConfigImpl modemInterfaceAddressImpl = (ModemInterfaceAddressConfigImpl)netInterfaceAddressConfig;
                String configConnType = String.valueOf(netIfPrefix) + "connection.type";
                if (props.containsKey(configConnType)) {
                    ModemConnectionType connType = ModemConnectionType.PPP;
                    String connTypeStr = (String)props.get(configConnType);
                    if (connTypeStr != null && !connTypeStr.isEmpty()) {
                        connType = ModemConnectionType.valueOf((String)connTypeStr);
                    }
                    s_logger.trace("Adding modem connection type: " + connType);
                    modemInterfaceAddressImpl.setConnectionType(connType);
                }
                if (props.containsKey(configConnStatus = String.valueOf(netIfPrefix) + "connection.status")) {
                    ModemConnectionStatus connStatus = ModemConnectionStatus.UNKNOWN;
                    String connStatusStr = (String)props.get(configConnStatus);
                    if (connStatusStr != null && !connStatusStr.isEmpty()) {
                        connStatus = ModemConnectionStatus.valueOf((String)connStatusStr);
                    }
                    s_logger.trace("Adding modem connection status: " + connStatus);
                    modemInterfaceAddressImpl.setConnectionStatus(connStatus);
                }
            }
            String configDhcp4 = "net.interface." + interfaceName + ".config.dhcpClient4.enabled";
            NetConfigIP4 netConfigIP4 = null;
            boolean dhcpEnabled = false;
            if (props.containsKey(configDhcp4)) {
                dhcpEnabled = (Boolean)props.get(configDhcp4);
                s_logger.trace("DHCP 4 enabled? " + dhcpEnabled);
            }
            netConfigIP4 = new NetConfigIP4(NetInterfaceStatus.valueOf((String)configStatus4), autoConnect, dhcpEnabled);
            netConfigs.add((NetConfig)netConfigIP4);
            if (!dhcpEnabled && props.containsKey(configIp4 = "net.interface." + interfaceName + ".config.ip4.address")) {
                String configIp4Gateway;
                s_logger.trace("got " + configIp4 + ": " + props.get(configIp4));
                String addressIp4 = (String)props.get(configIp4);
                s_logger.trace("IPv4 address: " + addressIp4);
                if (addressIp4 != null && !addressIp4.isEmpty()) {
                    IP4Address ip4Address = (IP4Address)IPAddress.parseHostAddress((String)addressIp4);
                    netConfigIP4.setAddress((IPAddress)ip4Address);
                }
                String configIp4Prefix = "net.interface." + interfaceName + ".config.ip4.prefix";
                short networkPrefixLength = -1;
                if (props.containsKey(configIp4Prefix)) {
                    if (props.get(configIp4Prefix) instanceof Short) {
                        networkPrefixLength = (Short)props.get(configIp4Prefix);
                    } else if (props.get(configIp4Prefix) instanceof String) {
                        networkPrefixLength = Short.parseShort((String)props.get(configIp4Prefix));
                    }
                    try {
                        netConfigIP4.setNetworkPrefixLength(networkPrefixLength);
                    }
                    catch (KuraException e) {
                        e.printStackTrace();
                    }
                }
                if (props.containsKey(configIp4Gateway = "net.interface." + interfaceName + ".config.ip4.gateway")) {
                    String gatewayIp4 = (String)props.get(configIp4Gateway);
                    s_logger.trace("IPv4 gateway: " + gatewayIp4);
                    if (gatewayIp4 != null && !gatewayIp4.isEmpty()) {
                        IP4Address ip4Gateway = (IP4Address)IPAddress.parseHostAddress((String)gatewayIp4);
                        netConfigIP4.setGateway((IPAddress)ip4Gateway);
                    }
                }
            }
            if (props.containsKey(configDNSs = "net.interface." + interfaceName + ".config.ip4.dnsServers")) {
                String[] dnss;
                ArrayList<IP4Address> dnsIPs = new ArrayList<IP4Address>();
                String dnsAll = (String)props.get(configDNSs);
                String[] stringArray3 = dnss = dnsAll.split(",");
                int ip4Gateway = dnss.length;
                int gatewayIp4 = 0;
                while (gatewayIp4 < ip4Gateway) {
                    String dns = stringArray3[gatewayIp4];
                    if (dns != null && dns.length() > 0) {
                        s_logger.trace("IPv4 DNS: " + dns);
                        dnsIp422 = (IP4Address)IPAddress.parseHostAddress((String)dns);
                        dnsIPs.add(dnsIp422);
                    }
                    ++gatewayIp4;
                }
                netConfigIP4.setDnsServers(dnsIPs);
            }
            if (props.containsKey(configWINSs = "net.interface." + interfaceName + ".config.ip4.winsServers")) {
                IP4Address winss;
                ArrayList<IP4Address> winsIPs = new ArrayList<IP4Address>();
                String winsAll = (String)props.get(configWINSs);
                dnsIp422 = winss = winsAll.split(",");
                int n5 = ((String[])dnsIp422).length;
                int ip4Gateway = 0;
                while (ip4Gateway < n5) {
                    String wins = dnsIp422[ip4Gateway];
                    s_logger.trace("WINS: " + wins);
                    winsIp4 = (IP4Address)IPAddress.parseHostAddress((String)wins);
                    winsIPs.add(winsIp4);
                    ++ip4Gateway;
                }
                netConfigIP4.setWinsServers(winsIPs);
            }
            if (props.containsKey(configDomains = "net.interface." + interfaceName + ".config.ip4.domains")) {
                IP4Address domains;
                ArrayList<IP4Address> domainNames = new ArrayList<IP4Address>();
                String domainsAll = (String)props.get(configDomains);
                winsIp4 = domains = domainsAll.split(",");
                int dnsIp422 = ((String[])winsIp4).length;
                int n6 = 0;
                while (n6 < dnsIp422) {
                    IP4Address domain = winsIp4[n6];
                    s_logger.trace("IPv4 Domain: " + (String)domain);
                    domainNames.add(domain);
                    ++n6;
                }
                netConfigIP4.setDomains(domainNames);
            }
            if (props.containsKey(configNatEnabled = "net.interface." + interfaceName + ".config.nat.enabled")) {
                boolean natEnabled = (Boolean)props.get(configNatEnabled);
                s_logger.trace("NAT enabled? " + natEnabled);
                if (natEnabled) {
                    FirewallAutoNatConfig natConfig = new FirewallAutoNatConfig(interfaceName, "unknown", true);
                    netConfigs.add((NetConfig)natConfig);
                }
            }
            if (props.containsKey(configDhcpServerEnabled = "net.interface." + interfaceName + ".config.dhcpServer4.enabled")) {
                String configDhcpServerPassDns;
                String configDhcpServerMaxLeaseTime;
                String configDhcpServerDefaultLeaseTime;
                String configDhcpServerRangeEnd;
                String configDhcpServerRangeStart;
                boolean dhcpServerEnabled = (Boolean)props.get(configDhcpServerEnabled);
                s_logger.trace("DHCP Server 4 enabled? " + dhcpServerEnabled);
                IP4Address subnet = null;
                IP4Address routerAddress = dhcpEnabled ? (IP4Address)netInterfaceAddressConfig.getAddress() : (IP4Address)netConfigIP4.getAddress();
                IP4Address subnetMask = null;
                int defaultLeaseTime = -1;
                int maximumLeaseTime = -1;
                short prefix = -1;
                IP4Address rangeStart = null;
                IP4Address rangeEnd = null;
                boolean passDns = false;
                ArrayList<IP4Address> dnServers = new ArrayList<IP4Address>();
                String configDhcpServerPrefix = "net.interface." + interfaceName + ".config.dhcpServer4.prefix";
                if (props.containsKey(configDhcpServerPrefix)) {
                    if (props.get(configDhcpServerPrefix) instanceof Short) {
                        prefix = (Short)props.get(configDhcpServerPrefix);
                    } else if (props.get(configDhcpServerPrefix) instanceof String) {
                        prefix = Short.parseShort((String)props.get(configDhcpServerPrefix));
                    }
                    s_logger.trace("DHCP Server prefix: " + prefix);
                }
                if (props.containsKey(configDhcpServerRangeStart = "net.interface." + interfaceName + ".config.dhcpServer4.rangeStart")) {
                    String dhcpServerRangeStart = (String)props.get(configDhcpServerRangeStart);
                    s_logger.trace("DHCP Server Range Start: " + dhcpServerRangeStart);
                    if (dhcpServerRangeStart != null && !dhcpServerRangeStart.isEmpty()) {
                        rangeStart = (IP4Address)IPAddress.parseHostAddress((String)dhcpServerRangeStart);
                    }
                }
                if (props.containsKey(configDhcpServerRangeEnd = "net.interface." + interfaceName + ".config.dhcpServer4.rangeEnd")) {
                    String dhcpServerRangeEnd = (String)props.get(configDhcpServerRangeEnd);
                    s_logger.trace("DHCP Server Range End: " + dhcpServerRangeEnd);
                    if (dhcpServerRangeEnd != null && !dhcpServerRangeEnd.isEmpty()) {
                        rangeEnd = (IP4Address)IPAddress.parseHostAddress((String)dhcpServerRangeEnd);
                    }
                }
                if (props.containsKey(configDhcpServerDefaultLeaseTime = "net.interface." + interfaceName + ".config.dhcpServer4.defaultLeaseTime")) {
                    if (props.get(configDhcpServerDefaultLeaseTime) instanceof Integer) {
                        defaultLeaseTime = (Integer)props.get(configDhcpServerDefaultLeaseTime);
                    } else if (props.get(configDhcpServerDefaultLeaseTime) instanceof String) {
                        defaultLeaseTime = Integer.parseInt((String)props.get(configDhcpServerDefaultLeaseTime));
                    }
                    s_logger.trace("DHCP Server Default Lease Time: " + defaultLeaseTime);
                }
                if (props.containsKey(configDhcpServerMaxLeaseTime = "net.interface." + interfaceName + ".config.dhcpServer4.maxLeaseTime")) {
                    if (props.get(configDhcpServerMaxLeaseTime) instanceof Integer) {
                        maximumLeaseTime = (Integer)props.get(configDhcpServerMaxLeaseTime);
                    } else if (props.get(configDhcpServerMaxLeaseTime) instanceof String) {
                        maximumLeaseTime = Integer.parseInt((String)props.get(configDhcpServerMaxLeaseTime));
                    }
                    s_logger.trace("DHCP Server Maximum Lease Time: " + maximumLeaseTime);
                }
                if (props.containsKey(configDhcpServerPassDns = "net.interface." + interfaceName + ".config.dhcpServer4.passDns")) {
                    if (props.get(configDhcpServerPassDns) instanceof Boolean) {
                        passDns = (Boolean)props.get(configDhcpServerPassDns);
                    } else if (props.get(configDhcpServerPassDns) instanceof String) {
                        passDns = Boolean.parseBoolean((String)props.get(configDhcpServerPassDns));
                    }
                    s_logger.trace("DHCP Server Pass DNS?: " + passDns);
                }
                if (routerAddress != null && rangeStart != null && rangeEnd != null) {
                    short prefixInt = prefix;
                    int mask = ~((1 << 32 - prefixInt) - 1);
                    String subnetMaskString = NetworkUtil.dottedQuad(mask);
                    String subnetString = NetworkUtil.calculateNetwork(routerAddress.getHostAddress(), subnetMaskString);
                    subnet = (IP4Address)IPAddress.parseHostAddress((String)subnetString);
                    subnetMask = (IP4Address)IPAddress.parseHostAddress((String)subnetMaskString);
                    dnServers.add(routerAddress);
                    DhcpServerConfigIP4 dhcpServerConfig = new DhcpServerConfigIP4(interfaceName, dhcpServerEnabled, subnet, routerAddress, subnetMask, defaultLeaseTime, maximumLeaseTime, prefix, rangeStart, rangeEnd, passDns, dnServers);
                    netConfigs.add((NetConfig)dhcpServerConfig);
                } else {
                    s_logger.trace("Not including DhcpServerConfig - router: " + routerAddress + ", range start: " + rangeStart + ", range end: " + rangeEnd);
                }
            }
            String configDhcp6 = "net.interface." + interfaceName + ".config.dhcpClient6.enabled";
            Object netConfigIP6 = null;
            boolean dhcp6Enabled = false;
            if (props.containsKey(configDhcp6)) {
                dhcp6Enabled = (Boolean)props.get(configDhcp6);
                s_logger.trace("DHCP 6 enabled? " + dhcp6Enabled);
            }
            if (!dhcp6Enabled && props.containsKey(configIp6 = "net.interface." + interfaceName + ".config.ip6.address")) {
                String configDomains6;
                String configDNSs6;
                String addressIp6 = (String)props.get(configIp6);
                s_logger.trace("IPv6 address: " + addressIp6);
                if (addressIp6 != null && !addressIp6.isEmpty()) {
                    IP6Address ip6Address = (IP6Address)IPAddress.parseHostAddress((String)addressIp6);
                    netConfigIP6.setAddress((IPAddress)ip6Address);
                }
                if (props.containsKey(configDNSs6 = "net.interface." + interfaceName + ".config.ip6.dnsServers")) {
                    String[] dnss;
                    ArrayList<IP6Address> dnsIPs = new ArrayList<IP6Address>();
                    String dnsAll = (String)props.get(configDNSs6);
                    String[] stringArray4 = dnss = dnsAll.split(",");
                    int n7 = dnss.length;
                    int dnServers = 0;
                    while (dnServers < n7) {
                        String dns = stringArray4[dnServers];
                        s_logger.trace("IPv6 DNS: " + dns);
                        IP6Address dnsIp6 = (IP6Address)IPAddress.parseHostAddress((String)dns);
                        dnsIPs.add(dnsIp6);
                        ++dnServers;
                    }
                    netConfigIP6.setDnsServers(dnsIPs);
                }
                if (props.containsKey(configDomains6 = "net.interface." + interfaceName + ".config.ip6.domains")) {
                    String[] domains;
                    ArrayList<String> domainNames = new ArrayList<String>();
                    String domainsAll = (String)props.get(configDomains6);
                    String[] stringArray5 = domains = domainsAll.split(",");
                    int n8 = domains.length;
                    int n9 = 0;
                    while (n9 < n8) {
                        String domain = stringArray5[n9];
                        s_logger.trace("IPv6 Domain: " + domain);
                        domainNames.add(domain);
                        ++n9;
                    }
                    netConfigIP6.setDomains(domainNames);
                }
            }
            if (interfaceType == NetInterfaceType.WIFI) {
                s_logger.trace("Adding wifi netconfig");
                WifiConfig apConfig = this.getWifiConfig(netIfConfigPrefix, WifiMode.MASTER, props);
                if (apConfig != null) {
                    s_logger.trace("Adding AP wifi config");
                    netConfigs.add((NetConfig)apConfig);
                } else {
                    s_logger.warn("no AP wifi config specified");
                }
                WifiConfig infraConfig = this.getWifiConfig(netIfConfigPrefix, WifiMode.INFRA, props);
                if (infraConfig != null) {
                    s_logger.trace("Adding client INFRA wifi config");
                    netConfigs.add((NetConfig)infraConfig);
                } else {
                    s_logger.warn("no INFRA wifi config specified");
                }
            }
            if (interfaceType != NetInterfaceType.MODEM) continue;
            s_logger.trace("Adding modem netconfig");
            netConfigs.add((NetConfig)this.getModemConfig(netIfConfigPrefix, props));
        }
    }
}

