/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.net;

import java.util.List;
import org.eclipse.kura.net.IPAddress;
import org.eclipse.kura.net.NetInterfaceAddress;

public class NetInterfaceAddressImpl
implements NetInterfaceAddress {
    private IPAddress m_address;
    private short m_networkPrefixLength;
    private IPAddress m_netmask;
    private IPAddress m_gateway;
    private IPAddress m_broadcast;
    private List<? extends IPAddress> m_dnsAddresses;

    public NetInterfaceAddressImpl() {
    }

    public NetInterfaceAddressImpl(NetInterfaceAddress other) {
        this.m_address = other.getAddress();
        this.m_networkPrefixLength = other.getNetworkPrefixLength();
        this.m_netmask = other.getNetmask();
        this.m_gateway = other.getGateway();
        this.m_broadcast = other.getBroadcast();
        this.m_dnsAddresses = other.getDnsServers();
    }

    public IPAddress getAddress() {
        return this.m_address;
    }

    public void setAddress(IPAddress address) {
        this.m_address = address;
    }

    public short getNetworkPrefixLength() {
        return this.m_networkPrefixLength;
    }

    public void setNetworkPrefixLength(short networkPrefixLength) {
        this.m_networkPrefixLength = networkPrefixLength;
    }

    public IPAddress getNetmask() {
        return this.m_netmask;
    }

    public void setNetmask(IPAddress netmask) {
        this.m_netmask = netmask;
    }

    public IPAddress getGateway() {
        return this.m_gateway;
    }

    public void setGateway(IPAddress gateway) {
        this.m_gateway = gateway;
    }

    public IPAddress getBroadcast() {
        return this.m_broadcast;
    }

    public void setBroadcast(IPAddress broadcast) {
        this.m_broadcast = broadcast;
    }

    public List<? extends IPAddress> getDnsServers() {
        return this.m_dnsAddresses;
    }

    public void setDnsServers(List<? extends IPAddress> dnsAddresses) {
        this.m_dnsAddresses = dnsAddresses;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NetInterfaceAddress)) {
            return false;
        }
        NetInterfaceAddress other = (NetInterfaceAddress)obj;
        if (this.m_networkPrefixLength != other.getNetworkPrefixLength()) {
            return false;
        }
        if (!this.compare(this.m_address, other.getAddress())) {
            return false;
        }
        if (!this.compare(this.m_netmask, other.getNetmask())) {
            return false;
        }
        if (!this.compare(this.m_gateway, other.getGateway())) {
            return false;
        }
        if (!this.compare(this.m_broadcast, other.getBroadcast())) {
            return false;
        }
        return this.compare(this.m_dnsAddresses, other.getDnsServers());
    }

    protected boolean compare(Object obj1, Object obj2) {
        return obj1 == null ? obj2 == null : obj1.equals(obj2);
    }
}

