/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jusb.tools.text;

import javax.usb.UsbDevice;
import javax.usb.UsbHostManager;
import javax.usb.UsbHub;
import javax.usb.UsbPort;
import javax.usb.util.UsbUtil;

public class TextUsbView {
    private static int verbose = 0;

    public static void main(String[] argv) throws Exception {
        UsbHub rootHub = UsbHostManager.getUsbServices().getRootUsbHub();
        for (int i = 0; i < argv.length; ++i) {
            if (!"-v".equals(argv[i]) && !"--verbose".equals(argv[i])) continue;
            ++verbose;
        }
        TextUsbView.displayUsbDevice((UsbDevice)rootHub, "");
    }

    protected static void displayUsbDevice(UsbDevice device, String offset) throws Exception {
        TextUsbView.print(device.isUsbHub() ? "UsbHub" : "UsbDevice");
        if (1 < verbose) {
            TextUsbView.print(" " + device.getManufacturerString());
        }
        if (0 < verbose) {
            TextUsbView.print(" " + device.getProductString());
        }
        if (2 < verbose) {
            TextUsbView.print(" " + device.getSerialNumberString());
        }
        TextUsbView.println("");
        if (device.isUsbHub()) {
            UsbHub hub = (UsbHub)device;
            int ports = UsbUtil.unsignedInt((byte)hub.getNumberOfPorts());
            offset = offset + "  ";
            for (int i = 0; i < ports; ++i) {
                UsbPort port = hub.getUsbPort((byte)(i + 1));
                if (port.isUsbDeviceAttached()) {
                    TextUsbView.print(offset);
                    TextUsbView.displayUsbDevice(port.getUsbDevice(), offset);
                    continue;
                }
                if (2 >= verbose) continue;
                TextUsbView.println(offset + "UsbPort " + port.getPortNumber());
            }
        }
    }

    protected static void print(String s) {
        System.out.print(s);
    }

    protected static void println(String s) {
        System.out.println(s);
    }
}

