/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.data.transport.mqtt;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.eclipse.kura.KuraConnectException;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.KuraNotConnectedException;
import org.eclipse.kura.KuraTimeoutException;
import org.eclipse.kura.KuraTooManyInflightMessagesException;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.eclipse.kura.core.data.transport.mqtt.DataTransportListeners;
import org.eclipse.kura.core.data.transport.mqtt.MqttClientConfiguration;
import org.eclipse.kura.core.util.ValidationUtil;
import org.eclipse.kura.data.DataTransportListener;
import org.eclipse.kura.data.DataTransportService;
import org.eclipse.kura.data.DataTransportToken;
import org.eclipse.kura.ssl.SslManagerService;
import org.eclipse.kura.ssl.SslServiceListener;
import org.eclipse.kura.system.SystemService;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttPersistenceException;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.eclipse.paho.client.mqttv3.persist.MqttDefaultFilePersistence;
import org.osgi.service.component.ComponentContext;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttDataTransport
implements DataTransportService,
MqttCallback,
ConfigurableComponent,
SslServiceListener {
    private static final Logger s_logger = LoggerFactory.getLogger(MqttDataTransport.class);
    private static final String MQTT_SCHEME = "mqtt://";
    private static final String MQTTS_SCHEME = "mqtts://";
    private static final String TOPIC_PATTERN = "#([^\\s/]+)";
    private static final Pattern s_topicPattern = Pattern.compile("#([^\\s/]+)");
    private SystemService m_systemService;
    private SslManagerService m_sslManagerService;
    private MqttAsyncClient m_mqttClient;
    private DataTransportListeners m_dataTransportListeners;
    private MqttClientConfiguration m_clientConf;
    private boolean m_newSession;
    private String m_sessionId;
    MqttClientConfiguration.PersistenceType m_persistenceType;
    MqttClientPersistence m_persistence;
    private Map<String, String> m_topicContext = new HashMap<String, String>();
    private Map<String, Object> m_properties = new HashMap<String, Object>();
    private static final String MQTT_BROKER_URL_PROP_NAME = "broker-url";
    private static final String MQTT_USERNAME_PROP_NAME = "username";
    private static final String MQTT_PASSWORD_PROP_NAME = "password";
    private static final String MQTT_CLIENT_ID_PROP_NAME = "client-id";
    private static final String MQTT_KEEP_ALIVE_PROP_NAME = "keep-alive";
    private static final String MQTT_CLEAN_SESSION_PROP_NAME = "clean-session";
    private static final String MQTT_TIMEOUT_PROP_NAME = "timeout";
    private static final String MQTT_LWT_QOS_PROP_NAME = "lwt.qos";
    private static final String MQTT_LWT_RETAIN_PROP_NAME = "lwt.retain";
    private static final String MQTT_LWT_TOPIC_PROP_NAME = "lwt.topic";
    private static final String MQTT_LWT_PAYLOAD_PROP_NAME = "lwt.payload";
    private static final String CLOUD_ACCOUNT_NAME_PROP_NAME = "topic.context.account-name";
    private static final String PERSISTENCE_TYPE_PROP_NAME = "in-flight.persistence";
    private static final String TOPIC_ACCOUNT_NAME_CTX_NAME = "account-name";
    private static final String TOPIC_DEVICE_ID_CTX_NAME = "client-id";

    public void setSystemService(SystemService systemService) {
        this.m_systemService = systemService;
    }

    public void unsetSystemService(SystemService systemService) {
        this.m_systemService = null;
    }

    public void setSslManagerService(SslManagerService sslManagerService) {
        this.m_sslManagerService = sslManagerService;
    }

    public void unsetSslManagerService(SslManagerService sslManagerService) {
        this.m_sslManagerService = null;
    }

    protected void activate(ComponentContext componentContext, Map<String, Object> properties) {
        s_logger.info("Activating...");
        this.m_properties.putAll(properties);
        try {
            this.m_clientConf = this.buildConfiguration(this.m_properties);
            this.setupMqttSession();
        }
        catch (RuntimeException e) {
            s_logger.error("Invalid client configuration. Service will not be able to connect until the configuration is updated", (Throwable)e);
        }
        ServiceTracker listenersTracker = new ServiceTracker(componentContext.getBundleContext(), DataTransportListener.class, null);
        this.m_dataTransportListeners = new DataTransportListeners((ServiceTracker<DataTransportListener, DataTransportListener>)listenersTracker);
    }

    protected void deactivate(ComponentContext componentContext) {
        s_logger.debug("Deactivating...");
        if (this.isConnected()) {
            this.disconnect(0L);
        }
        this.m_dataTransportListeners.close();
    }

    public void updated(Map<String, Object> properties) {
        s_logger.info("Updating...");
        this.m_properties.clear();
        this.m_properties.putAll(properties);
        this.update();
    }

    private void update() {
        boolean wasConnected = this.isConnected();
        this.m_dataTransportListeners.onConfigurationUpdating(wasConnected);
        s_logger.info("Building new configuration...");
        this.m_clientConf = this.buildConfiguration(this.m_properties);
        this.m_dataTransportListeners.onConfigurationUpdated(wasConnected);
    }

    public synchronized void connect() throws KuraConnectException {
        if (this.isConnected()) {
            s_logger.error("Already connected");
            throw new IllegalStateException("Already connected");
        }
        this.setupMqttSession();
        if (this.m_mqttClient == null) {
            s_logger.error("Invalid configuration");
            throw new IllegalStateException("Invalid configuration");
        }
        s_logger.info("# ------------------------------------------------------------");
        s_logger.info("#  Connection Properties");
        s_logger.info("#  broker    = " + this.m_clientConf.getBrokerUrl());
        s_logger.info("#  clientId  = " + this.m_clientConf.getClientId());
        s_logger.info("#  username  = " + this.m_clientConf.getConnectOptions().getUserName());
        s_logger.info("#  password  = XXXXXXXXXXXXXX");
        s_logger.info("#  keepAlive = " + this.m_clientConf.getConnectOptions().getKeepAliveInterval());
        s_logger.info("#  timeout   = " + this.m_clientConf.getConnectOptions().getConnectionTimeout());
        s_logger.info("#  cleanSession    = " + this.m_clientConf.getConnectOptions().isCleanSession());
        s_logger.info("#  willDestination = " + this.m_clientConf.getConnectOptions().getWillDestination());
        s_logger.info("#  willMessage     = " + this.m_clientConf.getConnectOptions().getWillMessage());
        s_logger.info("#");
        s_logger.info("#  Connecting...");
        try {
            IMqttToken connectToken = this.m_mqttClient.connect(this.m_clientConf.getConnectOptions());
            connectToken.waitForCompletion(this.getTimeToWaitMillis() * 3L);
            s_logger.info("#  Connected!");
            s_logger.info("# ------------------------------------------------------------");
        }
        catch (MqttException e) {
            block9: {
                s_logger.warn("Connect failed. Forcing disconnect.", (Throwable)e);
                try {
                    try {
                        this.m_mqttClient.setCallback(null);
                        this.m_mqttClient.close();
                    }
                    catch (Exception de) {
                        s_logger.warn("Forced disconnect exception.", (Throwable)de);
                        this.m_mqttClient = null;
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    this.m_mqttClient = null;
                    throw throwable;
                }
                this.m_mqttClient = null;
            }
            throw new KuraConnectException((Throwable)e, (Object)"Cannot connect");
        }
        this.m_dataTransportListeners.onConnectionEstablished(this.m_newSession);
    }

    public boolean isConnected() {
        if (this.m_mqttClient != null) {
            return this.m_mqttClient.isConnected();
        }
        return false;
    }

    public String getBrokerUrl() {
        if (this.m_clientConf != null) {
            return this.m_clientConf.getBrokerUrl();
        }
        return "";
    }

    public String getAccountName() {
        if (this.m_clientConf != null) {
            return this.m_topicContext.get(TOPIC_ACCOUNT_NAME_CTX_NAME);
        }
        return "";
    }

    public String getUsername() {
        if (this.m_clientConf != null) {
            return this.m_clientConf.getConnectOptions().getUserName();
        }
        return "";
    }

    public String getClientId() {
        if (this.m_clientConf != null) {
            return this.m_clientConf.getClientId();
        }
        return "";
    }

    public synchronized void disconnect(long quiesceTimeout) {
        if (this.isConnected()) {
            s_logger.info("Disconnecting...");
            this.m_dataTransportListeners.onDisconnecting();
            try {
                IMqttToken token = this.m_mqttClient.disconnect(quiesceTimeout);
                token.waitForCompletion(this.getTimeToWaitMillis());
                s_logger.info("Disconnected");
            }
            catch (MqttException e) {
                s_logger.error("Disconnect failed", (Throwable)e);
            }
            this.m_dataTransportListeners.onDisconnected();
        } else {
            s_logger.warn("MQTT client already disconnected");
        }
    }

    public void subscribe(String topic, int qos) throws KuraTimeoutException, KuraException, KuraNotConnectedException {
        if (this.m_mqttClient == null || !this.m_mqttClient.isConnected()) {
            throw new KuraNotConnectedException((Object)"Not connected");
        }
        topic = this.replaceTopicVariables(topic);
        s_logger.info("Subscribing to topic: {} with QoS: {}", (Object)topic, (Object)qos);
        try {
            IMqttToken token = this.m_mqttClient.subscribe(topic, qos);
            token.waitForCompletion(this.getTimeToWaitMillis());
        }
        catch (MqttException e) {
            if (e.getReasonCode() == 32000) {
                s_logger.warn("Timeout subscribing to topic: {}", (Object)topic);
                throw new KuraTimeoutException("Timeout subscribing to topic: " + topic, (Throwable)e);
            }
            s_logger.error("Cannot subscribe to topic: " + topic, (Throwable)e);
            throw KuraException.internalError((Throwable)e, (String)("Cannot subscribe to topic: " + topic));
        }
    }

    public void unsubscribe(String topic) throws KuraTimeoutException, KuraException, KuraNotConnectedException {
        if (this.m_mqttClient == null || !this.m_mqttClient.isConnected()) {
            throw new KuraNotConnectedException((Object)"Not connected");
        }
        topic = this.replaceTopicVariables(topic);
        s_logger.info("Unsubscribing to topic: {}", (Object)topic);
        try {
            IMqttToken token = this.m_mqttClient.unsubscribe(topic);
            token.waitForCompletion(this.getTimeToWaitMillis());
        }
        catch (MqttException e) {
            if (e.getReasonCode() == 32000) {
                s_logger.warn("Timeout unsubscribing to topic: {}", (Object)topic);
                throw new KuraTimeoutException("Timeout unsubscribing to topic: " + topic, (Throwable)e);
            }
            s_logger.error("Cannot unsubscribe to topic: " + topic, (Throwable)e);
            throw KuraException.internalError((Throwable)e, (String)("Cannot unsubscribe to topic: " + topic));
        }
    }

    public DataTransportToken publish(String topic, byte[] payload, int qos, boolean retain) throws KuraTooManyInflightMessagesException, KuraException, KuraNotConnectedException {
        IMqttDeliveryToken token;
        if (this.m_mqttClient == null || !this.m_mqttClient.isConnected()) {
            throw new KuraNotConnectedException((Object)"Not connected");
        }
        topic = this.replaceTopicVariables(topic);
        s_logger.info("Publishing message on topic: {} with QoS: {}", (Object)topic, (Object)qos);
        MqttMessage message = new MqttMessage();
        message.setPayload(payload);
        message.setQos(qos);
        message.setRetained(retain);
        Integer messageId = null;
        try {
            token = this.m_mqttClient.publish(topic, message);
            s_logger.debug("Published message with ID: {}", (Object)token.getMessageId());
            if (qos > 0) {
                messageId = token.getMessageId();
            }
        }
        catch (MqttPersistenceException e) {
            s_logger.error("Cannot publish on topic: {}", (Object)topic, (Object)e);
            throw new IllegalStateException("Cannot publish on topic: " + topic, e);
        }
        catch (MqttException e) {
            if (e.getReasonCode() == 32202) {
                s_logger.info("Too many inflight messages");
                throw new KuraTooManyInflightMessagesException((Throwable)e, (Object)"Too many in-fligh messages");
            }
            s_logger.error("Cannot publish on topic: " + topic, (Throwable)e);
            throw KuraException.internalError((Throwable)e, (String)("Cannot publish on topic: " + topic));
        }
        token = null;
        if (messageId != null) {
            token = new DataTransportToken(messageId.intValue(), this.m_sessionId);
        }
        return token;
    }

    public void connectionLost(Throwable cause) {
        s_logger.warn("Connection Lost", cause);
        this.m_dataTransportListeners.onConnectionLost(cause);
    }

    public void deliveryComplete(IMqttDeliveryToken token) {
        int qos;
        if (token == null) {
            s_logger.error("null token");
            return;
        }
        MqttMessage msg = null;
        try {
            msg = token.getMessage();
        }
        catch (MqttException e) {
            s_logger.error("Cannot get message", (Throwable)e);
            return;
        }
        if (msg != null && (qos = msg.getQos()) == 0) {
            s_logger.debug("Ignoring deliveryComplete for messages published with QoS == 0");
            return;
        }
        int id = token.getMessageId();
        s_logger.debug("Delivery complete for message with ID: {}", (Object)id);
        DataTransportToken dataPublisherToken = new DataTransportToken(id, this.m_sessionId);
        this.m_dataTransportListeners.onMessageConfirmed(dataPublisherToken);
    }

    public void messageArrived(String topic, MqttMessage message) throws Exception {
        s_logger.debug("Message arrived on topic: {}", (Object)topic);
        this.m_dataTransportListeners.onMessageArrived(topic, message.getPayload(), message.getQos(), message.isRetained());
    }

    private long getTimeToWaitMillis() {
        long timeout = (long)this.m_clientConf.getConnectOptions().getConnectionTimeout() * 1000L;
        return timeout;
    }

    public void onConfigurationUpdated() {
        this.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MqttClientConfiguration buildConfiguration(Map<String, Object> properties) {
        String brokerUrl;
        String clientId;
        MqttConnectOptions conOpt;
        MqttClientConfiguration clientConfiguration;
        block19: {
            clientConfiguration = null;
            conOpt = new MqttConnectOptions();
            clientId = null;
            brokerUrl = null;
            try {
                clientId = (String)properties.get("client-id");
                if (clientId == null || clientId.trim().length() == 0) {
                    clientId = this.m_systemService.getPrimaryMacAddress();
                }
                ValidationUtil.notEmptyOrNull(clientId, "clientId");
                clientId = clientId.replace('/', '-');
                clientId = clientId.replace('+', '-');
                clientId = clientId.replace('#', '-');
                brokerUrl = (String)properties.get(MQTT_BROKER_URL_PROP_NAME);
                ValidationUtil.notEmptyOrNull(brokerUrl, MQTT_BROKER_URL_PROP_NAME);
                brokerUrl = brokerUrl.trim();
                brokerUrl = brokerUrl.replaceAll("^mqtt://", "tcp://");
                brokerUrl = brokerUrl.replaceAll("^mqtts://", "ssl://");
                brokerUrl = brokerUrl.replaceAll("/$", "");
                ValidationUtil.notEmptyOrNull(brokerUrl, "brokerUrl");
                ValidationUtil.notEmptyOrNull((String)properties.get(MQTT_USERNAME_PROP_NAME), MQTT_USERNAME_PROP_NAME);
                ValidationUtil.notEmptyOrNull((String)properties.get(MQTT_PASSWORD_PROP_NAME), MQTT_PASSWORD_PROP_NAME);
                ValidationUtil.notNegative((Integer)properties.get(MQTT_KEEP_ALIVE_PROP_NAME), MQTT_KEEP_ALIVE_PROP_NAME);
                ValidationUtil.notNegative((Integer)properties.get(MQTT_TIMEOUT_PROP_NAME), MQTT_TIMEOUT_PROP_NAME);
                ValidationUtil.notNull((Boolean)properties.get(MQTT_CLEAN_SESSION_PROP_NAME), MQTT_CLEAN_SESSION_PROP_NAME);
                conOpt.setUserName((String)properties.get(MQTT_USERNAME_PROP_NAME));
                conOpt.setPassword(((String)properties.get(MQTT_PASSWORD_PROP_NAME)).toCharArray());
                conOpt.setKeepAliveInterval(((Integer)properties.get(MQTT_KEEP_ALIVE_PROP_NAME)).intValue());
                conOpt.setConnectionTimeout(((Integer)properties.get(MQTT_TIMEOUT_PROP_NAME)).intValue());
                conOpt.setCleanSession(((Boolean)properties.get(MQTT_CLEAN_SESSION_PROP_NAME)).booleanValue());
                Map<String, String> map = this.m_topicContext;
                synchronized (map) {
                    this.m_topicContext.clear();
                    if (properties.get(CLOUD_ACCOUNT_NAME_PROP_NAME) != null) {
                        this.m_topicContext.put(TOPIC_ACCOUNT_NAME_CTX_NAME, (String)properties.get(CLOUD_ACCOUNT_NAME_PROP_NAME));
                    }
                    this.m_topicContext.put("client-id", clientId);
                }
                String willTopic = (String)properties.get(MQTT_LWT_TOPIC_PROP_NAME);
                if (willTopic == null || willTopic.isEmpty()) break block19;
                int willQos = 0;
                boolean willRetain = false;
                String willPayload = (String)properties.get(MQTT_LWT_PAYLOAD_PROP_NAME);
                if (properties.get(MQTT_LWT_QOS_PROP_NAME) != null) {
                    willQos = (Integer)properties.get(MQTT_LWT_QOS_PROP_NAME);
                }
                if (properties.get(MQTT_LWT_RETAIN_PROP_NAME) != null) {
                    willRetain = (Boolean)properties.get(MQTT_LWT_RETAIN_PROP_NAME);
                }
                willTopic = this.replaceTopicVariables(willTopic);
                byte[] payload = new byte[]{};
                if (willPayload != null && !willPayload.isEmpty()) {
                    try {
                        payload = willPayload.getBytes("UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        s_logger.error("Unsupported encoding", (Throwable)e);
                    }
                }
                conOpt.setWill(willTopic, payload, willQos, willRetain);
            }
            catch (KuraException e) {
                s_logger.error("Invalid configuration");
                throw new IllegalStateException("Invalid MQTT client configuration", e);
            }
        }
        if (brokerUrl.startsWith("ssl")) {
            try {
                String alias = this.m_topicContext.get(TOPIC_ACCOUNT_NAME_CTX_NAME);
                SSLSocketFactory ssf = this.m_sslManagerService.getSSLSocketFactory(alias);
                conOpt.setSocketFactory((SocketFactory)ssf);
            }
            catch (Exception e) {
                s_logger.error("SSL setup failed", (Throwable)e);
                throw new IllegalStateException("SSL setup failed", e);
            }
        }
        String sType = (String)properties.get(PERSISTENCE_TYPE_PROP_NAME);
        MqttClientConfiguration.PersistenceType persistenceType = null;
        if (sType.equals("file")) {
            persistenceType = MqttClientConfiguration.PersistenceType.FILE;
        } else if (sType.equals("memory")) {
            persistenceType = MqttClientConfiguration.PersistenceType.MEMORY;
        } else {
            throw new IllegalStateException("Invalid MQTT client configuration: persistenceType: " + (Object)((Object)persistenceType));
        }
        clientConfiguration = new MqttClientConfiguration(brokerUrl, clientId, persistenceType, conOpt);
        return clientConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String replaceTopicVariables(String topic) {
        boolean found;
        Matcher topicMatcher = s_topicPattern.matcher(topic);
        StringBuffer sb = new StringBuffer();
        do {
            if (!(found = topicMatcher.find())) continue;
            String replacement = topicMatcher.group(0);
            String variableName = topicMatcher.group(1);
            Map<String, String> map = this.m_topicContext;
            synchronized (map) {
                String value = this.m_topicContext.get(variableName);
                if (value != null) {
                    replacement = value;
                }
            }
            topicMatcher.appendReplacement(sb, replacement);
        } while (found);
        topicMatcher.appendTail(sb);
        String replacedTopic = sb.toString();
        s_logger.debug("Replaced tokens in topic {} with: {}", (Object)topic, (Object)replacedTopic);
        return replacedTopic;
    }

    private String generateSessionId() {
        return String.valueOf(this.m_clientConf.getClientId()) + "-" + this.m_clientConf.getBrokerUrl();
    }

    private void setupMqttSession() {
        block17: {
            if (this.m_clientConf == null) {
                throw new IllegalStateException("Invalid client configuration");
            }
            if (this.m_mqttClient != null) {
                String brokerUrl = this.m_mqttClient.getServerURI();
                String clientId = this.m_mqttClient.getClientId();
                if (!brokerUrl.equals(this.m_clientConf.getBrokerUrl()) || !clientId.equals(this.m_clientConf.getClientId()) || this.m_persistenceType != this.m_clientConf.getPersistenceType()) {
                    try {
                        try {
                            s_logger.info("Closing client...");
                            this.m_mqttClient.setCallback(null);
                            this.m_mqttClient.close();
                            s_logger.info("Closed");
                        }
                        catch (MqttException e) {
                            s_logger.error("Cannot close client", (Throwable)e);
                            this.m_mqttClient = null;
                            break block17;
                        }
                    }
                    catch (Throwable throwable) {
                        this.m_mqttClient = null;
                        throw throwable;
                    }
                    this.m_mqttClient = null;
                }
            }
        }
        boolean newSession = this.m_clientConf.getConnectOptions().isCleanSession();
        if (this.m_mqttClient == null) {
            IMqttDeliveryToken[] pendingDeliveryTokens;
            s_logger.info("Creating a new client instance");
            MqttClientConfiguration.PersistenceType persistenceType = this.m_clientConf.getPersistenceType();
            if (persistenceType == MqttClientConfiguration.PersistenceType.MEMORY) {
                s_logger.info("Using memory persistence for in-flight messages");
                this.m_persistence = new MemoryPersistence();
            } else {
                StringBuffer sb = new StringBuffer();
                sb.append(this.m_systemService.getKuraDataDirectory()).append(this.m_systemService.getFileSeparator()).append("paho-persistence");
                String dir = sb.toString();
                s_logger.info("Using file persistence for in-flight messages: {}", (Object)dir);
                if (this.m_persistence != null) {
                    try {
                        this.m_persistence.close();
                    }
                    catch (MqttPersistenceException e) {
                        s_logger.info("Failed to close persistence. Ignoring exception " + e.getMessage());
                        s_logger.debug("Failed to close persistence. Ignoring exception.", (Throwable)e);
                    }
                }
                this.m_persistence = new MqttDefaultFilePersistence(dir);
            }
            MqttAsyncClient mqttClient = null;
            try {
                mqttClient = new MqttAsyncClient(this.m_clientConf.getBrokerUrl(), this.m_clientConf.getClientId(), this.m_persistence);
            }
            catch (MqttException e) {
                s_logger.error("Client instantiation failed", (Throwable)e);
                throw new IllegalStateException("Client instantiation failed", e);
            }
            mqttClient.setCallback((MqttCallback)this);
            this.m_persistenceType = persistenceType;
            this.m_mqttClient = mqttClient;
            if (!this.m_clientConf.getConnectOptions().isCleanSession() && (pendingDeliveryTokens = this.m_mqttClient.getPendingDeliveryTokens()) != null && pendingDeliveryTokens.length != 0) {
                newSession = false;
            }
        }
        this.m_newSession = newSession;
        this.m_sessionId = this.generateSessionId();
    }
}

