/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.message;

import java.util.Iterator;
import org.eclipse.kura.message.KuraPayload;

public class KuraBirthPayload
extends KuraPayload {
    private static final String UPTIME = "uptime";
    private static final String DISPLAY_NAME = "display_name";
    private static final String MODEL_NAME = "model_name";
    private static final String MODEL_ID = "model_id";
    private static final String PART_NUMBER = "part_number";
    private static final String SERIAL_NUMBER = "serial_number";
    private static final String AVAILABLE_PROCESSORS = "available_processors";
    private static final String TOTAL_MEMORY = "total_memory";
    private static final String FIRMWARE_VERSION = "firmware_version";
    private static final String BIOS_VERSION = "bios_version";
    private static final String OS = "os";
    private static final String OS_VERSION = "os_version";
    private static final String OS_ARCH = "os_arch";
    private static final String JVM_NAME = "jvm_name";
    private static final String JVM_VERSION = "jvm_version";
    private static final String JVM_PROFILE = "jvm_profile";
    private static final String KURA_VERSION = "kura_version";
    private static final String OSGI_FRAMEWORK = "osgi_framework";
    private static final String OSGI_FRAMEWORK_VERSION = "osgi_framework_version";
    private static final String CONNECTION_INTERFACE = "connection_interface";
    private static final String CONNECTION_IP = "connection_ip";
    private static final String ACCEPT_ENCODING = "accept_encoding";
    private static final String APPLICATION_IDS = "application_ids";
    public static final String MODEM_IMEI = "modem_imei";
    public static final String MODEM_IMSI = "modem_imsi";
    public static final String MODME_ICCID = "modem_iccid";

    public KuraBirthPayload(String uptime, String displayName, String modelName, String modelId, String partNumber, String serialNumber, String firmwareVersion, String biosVersion, String os, String osVersion, String jvmName, String jvmVersion, String jvmProfile, String kuraVersion, String connectionInterface, String connectionIp) {
        this(uptime, displayName, modelName, modelId, partNumber, serialNumber, firmwareVersion, biosVersion, os, osVersion, jvmName, jvmVersion, jvmProfile, kuraVersion, connectionInterface, connectionIp, null, null, null, null, null, null, null);
    }

    public KuraBirthPayload(String uptime, String displayName, String modelName, String modelId, String partNumber, String serialNumber, String firmwareVersion, String biosVersion, String os, String osVersion, String jvmName, String jvmVersion, String jvmProfile, String kuraVersion, String connectionInterface, String connectionIp, String acceptEncoding) {
        this(uptime, displayName, modelName, modelId, partNumber, serialNumber, firmwareVersion, biosVersion, os, osVersion, jvmName, jvmVersion, jvmProfile, kuraVersion, connectionInterface, connectionIp, acceptEncoding, null, null, null, null, null, null);
    }

    public KuraBirthPayload(String uptime, String displayName, String modelName, String modelId, String partNumber, String serialNumber, String firmwareVersion, String biosVersion, String os, String osVersion, String jvmName, String jvmVersion, String jvmProfile, String kuraVersion, String connectionInterface, String connectionIp, String acceptEncoding, String applicationIdentifiers) {
        this(uptime, displayName, modelName, modelId, partNumber, serialNumber, firmwareVersion, biosVersion, os, osVersion, jvmName, jvmVersion, jvmProfile, kuraVersion, connectionInterface, connectionIp, acceptEncoding, applicationIdentifiers, null, null, null, null, null);
    }

    public KuraBirthPayload(String uptime, String displayName, String modelName, String modelId, String partNumber, String serialNumber, String firmwareVersion, String biosVersion, String os, String osVersion, String jvmName, String jvmVersion, String jvmProfile, String kuraVersion, String connectionInterface, String connectionIp, String acceptEncoding, String applicationIdentifiers, String availableProcessors, String totalMemory, String osArch, String osgiFramework, String osgiFrameworkVersion) {
        if (uptime != null) {
            this.addMetric(UPTIME, uptime);
        }
        if (displayName != null) {
            this.addMetric(DISPLAY_NAME, displayName);
        }
        if (modelName != null) {
            this.addMetric(MODEL_NAME, modelName);
        }
        if (modelId != null) {
            this.addMetric(MODEL_ID, modelId);
        }
        if (partNumber != null) {
            this.addMetric(PART_NUMBER, partNumber);
        }
        if (serialNumber != null) {
            this.addMetric(SERIAL_NUMBER, serialNumber);
        }
        if (firmwareVersion != null) {
            this.addMetric(FIRMWARE_VERSION, firmwareVersion);
        }
        if (biosVersion != null) {
            this.addMetric(BIOS_VERSION, biosVersion);
        }
        if (os != null) {
            this.addMetric(OS, os);
        }
        if (osVersion != null) {
            this.addMetric(OS_VERSION, osVersion);
        }
        if (jvmName != null) {
            this.addMetric(JVM_NAME, jvmName);
        }
        if (jvmVersion != null) {
            this.addMetric(JVM_VERSION, jvmVersion);
        }
        if (jvmProfile != null) {
            this.addMetric(JVM_PROFILE, jvmProfile);
        }
        if (kuraVersion != null) {
            this.addMetric(KURA_VERSION, kuraVersion);
        }
        if (connectionInterface != null) {
            this.addMetric(CONNECTION_INTERFACE, connectionInterface);
        }
        if (connectionIp != null) {
            this.addMetric(CONNECTION_IP, connectionIp);
        }
        if (acceptEncoding != null) {
            this.addMetric(ACCEPT_ENCODING, acceptEncoding);
        }
        if (applicationIdentifiers != null) {
            this.addMetric(APPLICATION_IDS, applicationIdentifiers);
        }
        if (availableProcessors != null) {
            this.addMetric(AVAILABLE_PROCESSORS, availableProcessors);
        }
        if (totalMemory != null) {
            this.addMetric(TOTAL_MEMORY, totalMemory);
        }
        if (osArch != null) {
            this.addMetric(OS_ARCH, osArch);
        }
        if (osgiFramework != null) {
            this.addMetric(OSGI_FRAMEWORK, osgiFramework);
        }
        if (osgiFrameworkVersion != null) {
            this.addMetric(OSGI_FRAMEWORK_VERSION, osgiFrameworkVersion);
        }
    }

    public KuraBirthPayload(KuraPayload edcMessage) {
        Iterator hdrIterator = edcMessage.metricsIterator();
        while (hdrIterator.hasNext()) {
            String hdrName = (String)hdrIterator.next();
            String hdrVal = (String)edcMessage.getMetric(hdrName);
            this.addMetric(hdrName, hdrVal);
        }
        this.setBody(edcMessage.getBody());
        this.setPosition(edcMessage.getPosition());
    }

    public String getUptime() {
        return (String)this.getMetric(UPTIME);
    }

    public String getDisplayName() {
        return (String)this.getMetric(DISPLAY_NAME);
    }

    public String getModelName() {
        return (String)this.getMetric(MODEL_NAME);
    }

    public String getModelId() {
        return (String)this.getMetric(MODEL_ID);
    }

    public String getPartNumber() {
        return (String)this.getMetric(PART_NUMBER);
    }

    public String getSerialNumber() {
        return (String)this.getMetric(SERIAL_NUMBER);
    }

    public String getFirmwareVersion() {
        return (String)this.getMetric(FIRMWARE_VERSION);
    }

    public String getBiosVersion() {
        return (String)this.getMetric(BIOS_VERSION);
    }

    public String getOs() {
        return (String)this.getMetric(OS);
    }

    public String getOsVersion() {
        return (String)this.getMetric(OS_VERSION);
    }

    public String getJvmName() {
        return (String)this.getMetric(JVM_NAME);
    }

    public String getJvmVersion() {
        return (String)this.getMetric(JVM_VERSION);
    }

    public String getJvmProfile() {
        return (String)this.getMetric(JVM_PROFILE);
    }

    public String getKuraVersion() {
        return (String)this.getMetric(KURA_VERSION);
    }

    public String getConnectionInterface() {
        return (String)this.getMetric(CONNECTION_INTERFACE);
    }

    public String getConnectionIp() {
        return (String)this.getMetric(CONNECTION_IP);
    }

    public String getAcceptEncoding() {
        return (String)this.getMetric(ACCEPT_ENCODING);
    }

    public String getApplicationIdentifiers() {
        return (String)this.getMetric(APPLICATION_IDS);
    }

    public String getAvailableProcessors() {
        return (String)this.getMetric(AVAILABLE_PROCESSORS);
    }

    public String getTotalMemory() {
        return (String)this.getMetric(TOTAL_MEMORY);
    }

    public String getOsArch() {
        return (String)this.getMetric(OS_ARCH);
    }

    public String getOsgiFramework() {
        return (String)this.getMetric(OSGI_FRAMEWORK);
    }

    public String getOsgiFrameworkVersion() {
        return (String)this.getMetric(OSGI_FRAMEWORK_VERSION);
    }

    public String toString() {
        return "EdcBirthMessage [getUptime()=" + this.getUptime() + ", getDisplayName()=" + this.getDisplayName() + ", getModelName()=" + this.getModelName() + ", getModelId()=" + this.getModelId() + ", getPartNumber()=" + this.getPartNumber() + ", getSerialNumber()=" + this.getSerialNumber() + ", getFirmwareVersion()=" + this.getFirmwareVersion() + ", getAvailableProcessors()=" + this.getAvailableProcessors() + ", getTotalMemory()=" + this.getTotalMemory() + ", getBiosVersion()=" + this.getBiosVersion() + ", getOs()=" + this.getOs() + ", getOsVersion()=" + this.getOsVersion() + ", getOsArch()=" + this.getOsArch() + ", getJvmName()=" + this.getJvmName() + ", getJvmVersion()=" + this.getJvmVersion() + ", getJvmProfile()=" + this.getJvmProfile() + ", getKuraVersion()=" + this.getKuraVersion() + ", getOsgiFramework()=" + this.getOsgiFramework() + ", getOsgiFrameworkVersion()=" + this.getOsgiFrameworkVersion() + ", getConnectionInterface()=" + this.getConnectionInterface() + ", getConnectionIp()=" + this.getConnectionIp() + ", getAcceptEncoding()=" + this.getAcceptEncoding() + ", getApplicationIdentifiers()=" + this.getApplicationIdentifiers() + "]";
    }
}

