/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.cloud;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.KuraInvalidMessageException;
import org.eclipse.kura.cloud.CloudClient;
import org.eclipse.kura.cloud.CloudConnectionEstablishedEvent;
import org.eclipse.kura.cloud.CloudConnectionLostEvent;
import org.eclipse.kura.cloud.CloudPayloadProtoBufDecoder;
import org.eclipse.kura.cloud.CloudPayloadProtoBufEncoder;
import org.eclipse.kura.cloud.CloudService;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.eclipse.kura.core.cloud.CloudClientImpl;
import org.eclipse.kura.core.cloud.CloudPayloadEncoder;
import org.eclipse.kura.core.cloud.CloudPayloadGZipEncoder;
import org.eclipse.kura.core.cloud.CloudPayloadProtoBufDecoderImpl;
import org.eclipse.kura.core.cloud.CloudPayloadProtoBufEncoderImpl;
import org.eclipse.kura.core.cloud.CloudServiceOptions;
import org.eclipse.kura.core.cloud.LifeCyclePayloadBuilder;
import org.eclipse.kura.core.message.KuraBirthPayload;
import org.eclipse.kura.data.DataService;
import org.eclipse.kura.data.DataServiceListener;
import org.eclipse.kura.message.KuraPayload;
import org.eclipse.kura.message.KuraTopic;
import org.eclipse.kura.net.NetworkService;
import org.eclipse.kura.net.modem.ModemReadyEvent;
import org.eclipse.kura.position.PositionService;
import org.eclipse.kura.system.SystemAdminService;
import org.eclipse.kura.system.SystemService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudServiceImpl
implements CloudService,
DataServiceListener,
ConfigurableComponent,
EventHandler,
CloudPayloadProtoBufEncoder,
CloudPayloadProtoBufDecoder {
    private static final Logger s_logger = LoggerFactory.getLogger(CloudServiceImpl.class);
    private static final String TOPIC_BA_APP = "BA";
    private ComponentContext m_ctx;
    private CloudServiceOptions m_options;
    private DataService m_dataService;
    private SystemService m_systemService;
    private SystemAdminService m_systemAdminService;
    private NetworkService m_networkService;
    private PositionService m_positionService;
    private EventAdmin m_eventAdmin;
    private List<CloudClientImpl> m_cloudClients = new CopyOnWriteArrayList<CloudClientImpl>();

    public void setDataService(DataService dataService) {
        this.m_dataService = dataService;
    }

    public void unsetDataService(DataService dataService) {
        this.m_dataService = null;
    }

    public DataService getDataService() {
        return this.m_dataService;
    }

    public void setSystemAdminService(SystemAdminService systemAdminService) {
        this.m_systemAdminService = systemAdminService;
    }

    public void unsetSystemAdminService(SystemAdminService systemAdminService) {
        this.m_systemAdminService = null;
    }

    public SystemAdminService getSystemAdminService() {
        return this.m_systemAdminService;
    }

    public void setSystemService(SystemService systemService) {
        this.m_systemService = systemService;
    }

    public void unsetSystemService(SystemService systemService) {
        this.m_systemService = null;
    }

    public SystemService getSystemService() {
        return this.m_systemService;
    }

    public void setNetworkService(NetworkService networkService) {
        this.m_networkService = networkService;
    }

    public void unsetNetworkService(NetworkService networkService) {
        this.m_networkService = null;
    }

    public NetworkService getNetworkService() {
        return this.m_networkService;
    }

    public void setPositionService(PositionService positionService) {
        this.m_positionService = positionService;
    }

    public void unsetPositionService(PositionService positionService) {
        this.m_positionService = null;
    }

    public PositionService getPositionService() {
        return this.m_positionService;
    }

    public void setEventAdmin(EventAdmin eventAdmin) {
        this.m_eventAdmin = eventAdmin;
    }

    public void unsetEventAdmin(EventAdmin eventAdmin) {
        this.m_eventAdmin = null;
    }

    protected void activate(ComponentContext componentContext, Map<String, Object> properties) {
        s_logger.info("activate...");
        this.m_ctx = componentContext;
        this.m_options = new CloudServiceOptions(properties, this.m_systemService);
        Hashtable<String, String[]> props = new Hashtable<String, String[]>();
        String[] eventTopics = new String[]{"org/eclipse/kura/position/locked", "org/eclipse/kura/net/modem/READY"};
        ((Dictionary)props).put("event.topics", eventTopics);
        this.m_ctx.getBundleContext().registerService(EventHandler.class.getName(), (Object)this, props);
    }

    public void updated(Map<String, Object> properties) {
        s_logger.info("updated...: " + properties);
        this.m_options = new CloudServiceOptions(properties, this.m_systemService);
        if (this.m_dataService != null && this.m_dataService.isConnected()) {
            this.publishBirthCertificate();
        }
    }

    protected void deactivate(ComponentContext componentContext) {
        s_logger.info("deactivate...");
        if (this.m_dataService != null && this.m_dataService.isConnected()) {
            this.publishDisconnectCertificate();
        }
        this.m_cloudClients.clear();
        this.m_dataService = null;
        this.m_systemService = null;
        this.m_systemAdminService = null;
        this.m_networkService = null;
        this.m_positionService = null;
        this.m_eventAdmin = null;
    }

    public void handleEvent(Event event) {
        if ("org/eclipse/kura/position/locked".contains(event.getTopic())) {
            if (this.m_dataService != null && this.m_dataService.isConnected() && this.m_options != null && this.m_options.getRepubBirthCertOnGpsLock()) {
                s_logger.debug("handleEvent() :: PositionLockedEvent :: Republishing Birth Certificate ...");
                this.publishBirthCertificate();
            }
        } else if ("org/eclipse/kura/net/modem/READY".contains(event.getTopic()) && this.m_dataService != null && this.m_options != null && this.m_options.getRepubBirthCertOnModemDetection()) {
            s_logger.debug("handleEvent() :: ModemReadyEvent :: Republishing Birth Certificate ...");
            ModemReadyEvent modemReadyEvent = (ModemReadyEvent)event;
            String imei = (String)modemReadyEvent.getProperty("IMEI");
            String imsi = (String)modemReadyEvent.getProperty("IMSI");
            String iccid = (String)modemReadyEvent.getProperty("ICCID");
            this.publishBirthCertificate(imei, imsi, iccid);
        }
    }

    public CloudClient newCloudClient(String applicationId) throws KuraException {
        CloudClientImpl cloudClient = new CloudClientImpl(applicationId, this.m_dataService, this);
        this.m_cloudClients.add(cloudClient);
        if (this.m_dataService != null && this.m_dataService.isConnected()) {
            this.publishAppCertificate();
        }
        return cloudClient;
    }

    public String[] getCloudApplicationIdentifiers() {
        ArrayList<String> appIds = new ArrayList<String>();
        for (CloudClientImpl cloudClient : this.m_cloudClients) {
            appIds.add(cloudClient.getApplicationId());
        }
        return appIds.toArray(new String[0]);
    }

    public boolean isConnected() {
        return this.m_dataService != null && this.m_dataService.isConnected();
    }

    public CloudServiceOptions getCloudServiceOptions() {
        return this.m_options;
    }

    public void removeCloudClient(CloudClientImpl cloudClient) {
        this.m_cloudClients.remove(cloudClient);
        if (this.m_dataService != null && this.m_dataService.isConnected()) {
            this.publishAppCertificate();
        }
    }

    byte[] encodePayload(KuraPayload payload) throws KuraException {
        byte[] bytes = new byte[]{};
        if (payload == null) {
            return bytes;
        }
        CloudPayloadEncoder encoder = new CloudPayloadProtoBufEncoderImpl(payload);
        if (this.m_options.getEncodeGzip()) {
            encoder = new CloudPayloadGZipEncoder(encoder);
        }
        try {
            bytes = encoder.getBytes();
            return bytes;
        }
        catch (IOException e) {
            throw new KuraException(KuraErrorCode.ENCODE_ERROR, (Throwable)e, new Object[0]);
        }
    }

    public void onConnectionEstablished() {
        this.publishBirthCertificate();
        this.m_eventAdmin.postEvent((Event)new CloudConnectionEstablishedEvent(new HashMap()));
        this.activateDeviceSubscriptions();
        for (CloudClientImpl cloudClient : this.m_cloudClients) {
            cloudClient.onConnectionEstablished();
        }
    }

    private void activateDeviceSubscriptions() {
        StringBuilder sbDeviceSubscription = new StringBuilder();
        sbDeviceSubscription.append(this.m_options.getTopicControlPrefix()).append(this.m_options.getTopicSeparator()).append(this.m_options.getTopicAccountToken()).append(this.m_options.getTopicSeparator()).append(this.m_options.getTopicClientIdToken()).append(this.m_options.getTopicSeparator()).append(this.m_options.getTopicWildCard());
        try {
            this.m_dataService.subscribe(sbDeviceSubscription.toString(), 1);
        }
        catch (KuraException e) {
            s_logger.error("Error - Cannot activate default subscriptions", (Throwable)e);
        }
    }

    public void onDisconnecting() {
        this.publishDisconnectCertificate();
    }

    public void onDisconnected() {
        this.m_eventAdmin.postEvent((Event)new CloudConnectionLostEvent(new HashMap()));
    }

    public void onConnectionLost(Throwable cause) {
        this.m_eventAdmin.postEvent((Event)new CloudConnectionLostEvent(new HashMap()));
        for (CloudClientImpl cloudClient : this.m_cloudClients) {
            cloudClient.onConnectionLost();
        }
    }

    public void onMessageArrived(String topic, byte[] payload, int qos, boolean retained) {
        s_logger.debug("Message arrived on topic: {}", (Object)topic);
        KuraTopic kuraTopic = new KuraTopic(topic);
        if (TOPIC_BA_APP.equals(kuraTopic.getApplicationId())) {
            s_logger.info("Ignoring feedback message from " + topic);
        } else {
            KuraPayload kuraPayload = null;
            try {
                kuraPayload = new CloudPayloadProtoBufDecoderImpl(payload).buildFromByteArray();
            }
            catch (Exception exception) {
                s_logger.debug("Received message on topic " + topic + " that could not be decoded. Wrapping it into an KuraPayload.");
                kuraPayload = new KuraPayload();
                kuraPayload.setBody(payload);
            }
            for (CloudClientImpl cloudClient : this.m_cloudClients) {
                if (!cloudClient.getApplicationId().equals(kuraTopic.getApplicationId())) continue;
                try {
                    if (this.m_options.getTopicControlPrefix().equals(kuraTopic.getPrefix())) {
                        cloudClient.onControlMessageArrived(kuraTopic.getDeviceId(), kuraTopic.getApplicationTopic(), kuraPayload, qos, retained);
                        continue;
                    }
                    cloudClient.onMessageArrived(kuraTopic.getDeviceId(), kuraTopic.getApplicationTopic(), kuraPayload, qos, retained);
                }
                catch (Exception e) {
                    s_logger.error("Error during CloudClientListener notification.", (Throwable)e);
                }
            }
        }
    }

    public void onMessagePublished(int messageId, String topic) {
        KuraTopic kuraTopic = new KuraTopic(topic);
        for (CloudClientImpl cloudClient : this.m_cloudClients) {
            if (!cloudClient.getApplicationId().equals(kuraTopic.getApplicationId())) continue;
            cloudClient.onMessagePublished(messageId, kuraTopic.getApplicationTopic());
        }
    }

    public void onMessageConfirmed(int messageId, String topic) {
        KuraTopic kuraTopic = new KuraTopic(topic);
        for (CloudClientImpl cloudClient : this.m_cloudClients) {
            if (!cloudClient.getApplicationId().equals(kuraTopic.getApplicationId())) continue;
            cloudClient.onMessageConfirmed(messageId, kuraTopic.getApplicationTopic());
        }
    }

    public byte[] getBytes(KuraPayload kuraPayload, boolean gzipped) throws KuraException {
        CloudPayloadEncoder encoder = new CloudPayloadProtoBufEncoderImpl(kuraPayload);
        if (gzipped) {
            encoder = new CloudPayloadGZipEncoder(encoder);
        }
        try {
            byte[] bytes = encoder.getBytes();
            return bytes;
        }
        catch (IOException e) {
            throw new KuraException(KuraErrorCode.ENCODE_ERROR, (Throwable)e, new Object[0]);
        }
    }

    public KuraPayload buildFromByteArray(byte[] payload) throws KuraException {
        CloudPayloadProtoBufDecoderImpl encoder = new CloudPayloadProtoBufDecoderImpl(payload);
        try {
            KuraPayload kuraPayload = encoder.buildFromByteArray();
            return kuraPayload;
        }
        catch (KuraInvalidMessageException e) {
            throw new KuraException(KuraErrorCode.DECODER_ERROR, (Throwable)e, new Object[0]);
        }
        catch (IOException e) {
            throw new KuraException(KuraErrorCode.DECODER_ERROR, (Throwable)e, new Object[0]);
        }
    }

    private void publishBirthCertificate() {
        StringBuilder sbTopic = new StringBuilder();
        sbTopic.append(this.m_options.getTopicControlPrefix()).append(this.m_options.getTopicSeparator()).append(this.m_options.getTopicAccountToken()).append(this.m_options.getTopicSeparator()).append(this.m_options.getTopicClientIdToken()).append(this.m_options.getTopicSeparator()).append(this.m_options.getTopicBirthSuffix());
        String topic = sbTopic.toString();
        KuraPayload payload = this.createBirthPayload();
        this.publishLifeCycleMessage(topic, payload);
    }

    private void publishBirthCertificate(String imei, String imsi, String iccid) {
        StringBuilder sbTopic = new StringBuilder();
        sbTopic.append(this.m_options.getTopicControlPrefix()).append(this.m_options.getTopicSeparator()).append(this.m_options.getTopicAccountToken()).append(this.m_options.getTopicSeparator()).append(this.m_options.getTopicClientIdToken()).append(this.m_options.getTopicSeparator()).append(this.m_options.getTopicBirthSuffix());
        String topic = sbTopic.toString();
        KuraPayload payload = this.createBirthPayload(imei, imsi, iccid);
        this.publishLifeCycleMessage(topic, payload);
    }

    private void publishDisconnectCertificate() {
        StringBuilder sbTopic = new StringBuilder();
        sbTopic.append(this.m_options.getTopicControlPrefix()).append(this.m_options.getTopicSeparator()).append(this.m_options.getTopicAccountToken()).append(this.m_options.getTopicSeparator()).append(this.m_options.getTopicClientIdToken()).append(this.m_options.getTopicSeparator()).append(this.m_options.getTopicDisconnectSuffix());
        String topic = sbTopic.toString();
        KuraPayload payload = this.createDisconnectPayload();
        this.publishLifeCycleMessage(topic, payload);
    }

    private void publishAppCertificate() {
        StringBuilder sbTopic = new StringBuilder();
        sbTopic.append(this.m_options.getTopicControlPrefix()).append(this.m_options.getTopicSeparator()).append(this.m_options.getTopicAccountToken()).append(this.m_options.getTopicSeparator()).append(this.m_options.getTopicClientIdToken()).append(this.m_options.getTopicSeparator()).append(this.m_options.getTopicAppsSuffix());
        String topic = sbTopic.toString();
        KuraPayload payload = this.createBirthPayload();
        this.publishLifeCycleMessage(topic, payload);
    }

    private KuraPayload createBirthPayload() {
        LifeCyclePayloadBuilder payloadBuilder = new LifeCyclePayloadBuilder(this);
        return payloadBuilder.buildBirthPayload();
    }

    private KuraPayload createBirthPayload(String imei, String imsi, String iccid) {
        LifeCyclePayloadBuilder payloadBuilder = new LifeCyclePayloadBuilder(this);
        KuraBirthPayload kuraBuildPayload = payloadBuilder.buildBirthPayload();
        if (imei != null && imei.length() > 0) {
            kuraBuildPayload.addMetric("modem_imei", imei);
        }
        if (imsi != null && imsi.length() > 0) {
            kuraBuildPayload.addMetric("modem_imsi", imsi);
        }
        if (iccid != null && iccid.length() > 0) {
            kuraBuildPayload.addMetric("modem_iccid", iccid);
        }
        return kuraBuildPayload;
    }

    private KuraPayload createDisconnectPayload() {
        LifeCyclePayloadBuilder payloadBuilder = new LifeCyclePayloadBuilder(this);
        return payloadBuilder.buildDisconnectPayload();
    }

    private void publishLifeCycleMessage(String topic, KuraPayload payload) {
        try {
            byte[] encodedPayload = this.encodePayload(payload);
            this.m_dataService.publish(topic, encodedPayload, this.m_options.getLifeCycleMessageQos(), this.m_options.getLifeCycleMessageRetain(), this.m_options.getLifeCycleMessagePriority());
        }
        catch (Exception e) {
            s_logger.error("Error publishing life-cycle message on topic: " + topic, (Throwable)e);
        }
    }
}

