/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.configuration;

import java.util.concurrent.Callable;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.core.configuration.ConfigurationServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RollbackCallable
implements Callable<Void> {
    private static Logger s_logger = LoggerFactory.getLogger(RollbackCallable.class);
    private Long m_snapshotId;
    private ConfigurationServiceImpl m_configurationService;

    public RollbackCallable(Long snapshotId, ConfigurationServiceImpl configurationService) {
        this.m_snapshotId = snapshotId;
        this.m_configurationService = configurationService;
    }

    @Override
    public Void call() throws Exception {
        Thread.currentThread().setName(this.getClass().getSimpleName());
        try {
            if (this.m_snapshotId == null) {
                this.m_configurationService.rollback();
            } else {
                this.m_configurationService.rollback(this.m_snapshotId);
            }
        }
        catch (KuraException e) {
            s_logger.error("Error rolling back to snapshot: {}", (Throwable)e);
            throw new KuraException(KuraErrorCode.CONFIGURATION_ROLLBACK, (Throwable)e, new Object[0]);
        }
        return null;
    }
}

