/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.config.image;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.eclipse.jkube.kit.common.util.EnvUtil;
import org.eclipse.jkube.kit.config.image.LogConfiguration;
import org.eclipse.jkube.kit.config.image.NetworkConfig;
import org.eclipse.jkube.kit.config.image.RestartPolicy;
import org.eclipse.jkube.kit.config.image.RunVolumeConfiguration;
import org.eclipse.jkube.kit.config.image.UlimitConfig;
import org.eclipse.jkube.kit.config.image.WaitConfiguration;
import org.eclipse.jkube.kit.config.image.build.Arguments;

public class RunImageConfiguration
implements Serializable {
    private static final long serialVersionUID = 439009097742935171L;
    public static final RunImageConfiguration DEFAULT = new RunImageConfiguration();
    private Map<String, String> env;
    private Map<String, String> labels;
    private String envPropertyFile;
    private Arguments cmd;
    private String domainname;
    private List<String> dependsOn;
    private Arguments entrypoint;
    private String hostname;
    private String user;
    private String workingDir;
    private Long shmSize;
    private Long memory;
    private Long memorySwap;
    private String portPropertyFile;
    private String net;
    private NetworkConfig network;
    private List<String> dns;
    private List<String> dnsSearch;
    private List<String> capAdd;
    private List<String> capDrop;
    private List<String> securityOpts;
    private Boolean privileged;
    private List<String> extraHosts;
    private Long cpuShares;
    private Long cpus;
    private String cpuSet;
    private List<String> ports;
    private String containerNamePattern;
    private String exposedPropertyKey;
    private RunVolumeConfiguration volumes;
    private List<String> links;
    private WaitConfiguration wait;
    private List<String> tmpfs;
    private LogConfiguration log;
    private RestartPolicy restartPolicy;
    private List<UlimitConfig> ulimits;
    private Boolean skip;
    private String imagePullPolicy;
    private Boolean readOnly;
    private Boolean autoRemove;

    public boolean isDefault() {
        return this == DEFAULT;
    }

    public String initAndValidate() {
        NetworkConfig config;
        if (this.entrypoint != null) {
            this.entrypoint.validate();
        }
        if (this.cmd != null) {
            this.cmd.validate();
        }
        if ((config = this.getNetworkingConfig()) != null && config.isCustomNetwork()) {
            return "1.21";
        }
        return null;
    }

    @Nonnull
    public List<String> getDependsOn() {
        return EnvUtil.splitAtCommasAndTrim(this.dependsOn);
    }

    @Nonnull
    public List<String> getPorts() {
        return EnvUtil.removeEmptyEntries(this.ports);
    }

    public NetworkConfig getNetworkingConfig() {
        if (this.network != null) {
            return this.network;
        }
        if (this.net != null) {
            return NetworkConfig.fromLegacyNetSpec(this.net);
        }
        return new NetworkConfig();
    }

    public RunVolumeConfiguration getVolumeConfiguration() {
        return this.volumes;
    }

    @Nonnull
    public List<String> getLinks() {
        return EnvUtil.splitAtCommasAndTrim(this.links);
    }

    public RestartPolicy getRestartPolicy() {
        return Optional.ofNullable(this.restartPolicy).orElse(RestartPolicy.DEFAULT);
    }

    public boolean skip() {
        return Optional.ofNullable(this.skip).orElse(false);
    }

    public static RunImageConfigurationBuilder builder() {
        return new RunImageConfigurationBuilder();
    }

    public RunImageConfigurationBuilder toBuilder() {
        return new RunImageConfigurationBuilder().env(this.env).labels(this.labels).envPropertyFile(this.envPropertyFile).cmd(this.cmd).domainname(this.domainname).dependsOn(this.dependsOn).entrypoint(this.entrypoint).hostname(this.hostname).user(this.user).workingDir(this.workingDir).shmSize(this.shmSize).memory(this.memory).memorySwap(this.memorySwap).portPropertyFile(this.portPropertyFile).net(this.net).network(this.network).dns(this.dns).dnsSearch(this.dnsSearch).capAdd(this.capAdd).capDrop(this.capDrop).securityOpts(this.securityOpts).privileged(this.privileged).extraHosts(this.extraHosts).cpuShares(this.cpuShares).cpus(this.cpus).cpuSet(this.cpuSet).ports(this.ports).containerNamePattern(this.containerNamePattern).exposedPropertyKey(this.exposedPropertyKey).volumes(this.volumes).links(this.links).wait(this.wait).tmpfs(this.tmpfs).log(this.log).restartPolicy(this.restartPolicy).ulimits(this.ulimits).skip(this.skip).imagePullPolicy(this.imagePullPolicy).readOnly(this.readOnly).autoRemove(this.autoRemove);
    }

    public RunImageConfiguration(Map<String, String> env, Map<String, String> labels, String envPropertyFile, Arguments cmd, String domainname, List<String> dependsOn, Arguments entrypoint, String hostname, String user, String workingDir, Long shmSize, Long memory, Long memorySwap, String portPropertyFile, String net, NetworkConfig network, List<String> dns, List<String> dnsSearch, List<String> capAdd, List<String> capDrop, List<String> securityOpts, Boolean privileged, List<String> extraHosts, Long cpuShares, Long cpus, String cpuSet, List<String> ports, String containerNamePattern, String exposedPropertyKey, RunVolumeConfiguration volumes, List<String> links, WaitConfiguration wait, List<String> tmpfs, LogConfiguration log, RestartPolicy restartPolicy, List<UlimitConfig> ulimits, Boolean skip, String imagePullPolicy, Boolean readOnly, Boolean autoRemove) {
        this.env = env;
        this.labels = labels;
        this.envPropertyFile = envPropertyFile;
        this.cmd = cmd;
        this.domainname = domainname;
        this.dependsOn = dependsOn;
        this.entrypoint = entrypoint;
        this.hostname = hostname;
        this.user = user;
        this.workingDir = workingDir;
        this.shmSize = shmSize;
        this.memory = memory;
        this.memorySwap = memorySwap;
        this.portPropertyFile = portPropertyFile;
        this.net = net;
        this.network = network;
        this.dns = dns;
        this.dnsSearch = dnsSearch;
        this.capAdd = capAdd;
        this.capDrop = capDrop;
        this.securityOpts = securityOpts;
        this.privileged = privileged;
        this.extraHosts = extraHosts;
        this.cpuShares = cpuShares;
        this.cpus = cpus;
        this.cpuSet = cpuSet;
        this.ports = ports;
        this.containerNamePattern = containerNamePattern;
        this.exposedPropertyKey = exposedPropertyKey;
        this.volumes = volumes;
        this.links = links;
        this.wait = wait;
        this.tmpfs = tmpfs;
        this.log = log;
        this.restartPolicy = restartPolicy;
        this.ulimits = ulimits;
        this.skip = skip;
        this.imagePullPolicy = imagePullPolicy;
        this.readOnly = readOnly;
        this.autoRemove = autoRemove;
    }

    public RunImageConfiguration() {
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public String getEnvPropertyFile() {
        return this.envPropertyFile;
    }

    public Arguments getCmd() {
        return this.cmd;
    }

    public String getDomainname() {
        return this.domainname;
    }

    public Arguments getEntrypoint() {
        return this.entrypoint;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getUser() {
        return this.user;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public Long getShmSize() {
        return this.shmSize;
    }

    public Long getMemory() {
        return this.memory;
    }

    public Long getMemorySwap() {
        return this.memorySwap;
    }

    public String getPortPropertyFile() {
        return this.portPropertyFile;
    }

    public String getNet() {
        return this.net;
    }

    public NetworkConfig getNetwork() {
        return this.network;
    }

    public List<String> getDns() {
        return this.dns;
    }

    public List<String> getDnsSearch() {
        return this.dnsSearch;
    }

    public List<String> getCapAdd() {
        return this.capAdd;
    }

    public List<String> getCapDrop() {
        return this.capDrop;
    }

    public List<String> getSecurityOpts() {
        return this.securityOpts;
    }

    public Boolean getPrivileged() {
        return this.privileged;
    }

    public List<String> getExtraHosts() {
        return this.extraHosts;
    }

    public Long getCpuShares() {
        return this.cpuShares;
    }

    public Long getCpus() {
        return this.cpus;
    }

    public String getCpuSet() {
        return this.cpuSet;
    }

    public String getContainerNamePattern() {
        return this.containerNamePattern;
    }

    public String getExposedPropertyKey() {
        return this.exposedPropertyKey;
    }

    public RunVolumeConfiguration getVolumes() {
        return this.volumes;
    }

    public WaitConfiguration getWait() {
        return this.wait;
    }

    public List<String> getTmpfs() {
        return this.tmpfs;
    }

    public LogConfiguration getLog() {
        return this.log;
    }

    public List<UlimitConfig> getUlimits() {
        return this.ulimits;
    }

    public Boolean getSkip() {
        return this.skip;
    }

    public String getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public Boolean getAutoRemove() {
        return this.autoRemove;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RunImageConfiguration)) {
            return false;
        }
        RunImageConfiguration other = (RunImageConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$shmSize = this.getShmSize();
        Long other$shmSize = other.getShmSize();
        if (this$shmSize == null ? other$shmSize != null : !((Object)this$shmSize).equals(other$shmSize)) {
            return false;
        }
        Long this$memory = this.getMemory();
        Long other$memory = other.getMemory();
        if (this$memory == null ? other$memory != null : !((Object)this$memory).equals(other$memory)) {
            return false;
        }
        Long this$memorySwap = this.getMemorySwap();
        Long other$memorySwap = other.getMemorySwap();
        if (this$memorySwap == null ? other$memorySwap != null : !((Object)this$memorySwap).equals(other$memorySwap)) {
            return false;
        }
        Boolean this$privileged = this.getPrivileged();
        Boolean other$privileged = other.getPrivileged();
        if (this$privileged == null ? other$privileged != null : !((Object)this$privileged).equals(other$privileged)) {
            return false;
        }
        Long this$cpuShares = this.getCpuShares();
        Long other$cpuShares = other.getCpuShares();
        if (this$cpuShares == null ? other$cpuShares != null : !((Object)this$cpuShares).equals(other$cpuShares)) {
            return false;
        }
        Long this$cpus = this.getCpus();
        Long other$cpus = other.getCpus();
        if (this$cpus == null ? other$cpus != null : !((Object)this$cpus).equals(other$cpus)) {
            return false;
        }
        Boolean this$skip = this.getSkip();
        Boolean other$skip = other.getSkip();
        if (this$skip == null ? other$skip != null : !((Object)this$skip).equals(other$skip)) {
            return false;
        }
        Boolean this$readOnly = this.getReadOnly();
        Boolean other$readOnly = other.getReadOnly();
        if (this$readOnly == null ? other$readOnly != null : !((Object)this$readOnly).equals(other$readOnly)) {
            return false;
        }
        Boolean this$autoRemove = this.getAutoRemove();
        Boolean other$autoRemove = other.getAutoRemove();
        if (this$autoRemove == null ? other$autoRemove != null : !((Object)this$autoRemove).equals(other$autoRemove)) {
            return false;
        }
        Map<String, String> this$env = this.getEnv();
        Map<String, String> other$env = other.getEnv();
        if (this$env == null ? other$env != null : !((Object)this$env).equals(other$env)) {
            return false;
        }
        Map<String, String> this$labels = this.getLabels();
        Map<String, String> other$labels = other.getLabels();
        if (this$labels == null ? other$labels != null : !((Object)this$labels).equals(other$labels)) {
            return false;
        }
        String this$envPropertyFile = this.getEnvPropertyFile();
        String other$envPropertyFile = other.getEnvPropertyFile();
        if (this$envPropertyFile == null ? other$envPropertyFile != null : !this$envPropertyFile.equals(other$envPropertyFile)) {
            return false;
        }
        Arguments this$cmd = this.getCmd();
        Arguments other$cmd = other.getCmd();
        if (this$cmd == null ? other$cmd != null : !((Object)this$cmd).equals(other$cmd)) {
            return false;
        }
        String this$domainname = this.getDomainname();
        String other$domainname = other.getDomainname();
        if (this$domainname == null ? other$domainname != null : !this$domainname.equals(other$domainname)) {
            return false;
        }
        List<String> this$dependsOn = this.getDependsOn();
        List<String> other$dependsOn = other.getDependsOn();
        if (this$dependsOn == null ? other$dependsOn != null : !((Object)this$dependsOn).equals(other$dependsOn)) {
            return false;
        }
        Arguments this$entrypoint = this.getEntrypoint();
        Arguments other$entrypoint = other.getEntrypoint();
        if (this$entrypoint == null ? other$entrypoint != null : !((Object)this$entrypoint).equals(other$entrypoint)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        String this$workingDir = this.getWorkingDir();
        String other$workingDir = other.getWorkingDir();
        if (this$workingDir == null ? other$workingDir != null : !this$workingDir.equals(other$workingDir)) {
            return false;
        }
        String this$portPropertyFile = this.getPortPropertyFile();
        String other$portPropertyFile = other.getPortPropertyFile();
        if (this$portPropertyFile == null ? other$portPropertyFile != null : !this$portPropertyFile.equals(other$portPropertyFile)) {
            return false;
        }
        String this$net = this.getNet();
        String other$net = other.getNet();
        if (this$net == null ? other$net != null : !this$net.equals(other$net)) {
            return false;
        }
        NetworkConfig this$network = this.getNetwork();
        NetworkConfig other$network = other.getNetwork();
        if (this$network == null ? other$network != null : !((Object)this$network).equals(other$network)) {
            return false;
        }
        List<String> this$dns = this.getDns();
        List<String> other$dns = other.getDns();
        if (this$dns == null ? other$dns != null : !((Object)this$dns).equals(other$dns)) {
            return false;
        }
        List<String> this$dnsSearch = this.getDnsSearch();
        List<String> other$dnsSearch = other.getDnsSearch();
        if (this$dnsSearch == null ? other$dnsSearch != null : !((Object)this$dnsSearch).equals(other$dnsSearch)) {
            return false;
        }
        List<String> this$capAdd = this.getCapAdd();
        List<String> other$capAdd = other.getCapAdd();
        if (this$capAdd == null ? other$capAdd != null : !((Object)this$capAdd).equals(other$capAdd)) {
            return false;
        }
        List<String> this$capDrop = this.getCapDrop();
        List<String> other$capDrop = other.getCapDrop();
        if (this$capDrop == null ? other$capDrop != null : !((Object)this$capDrop).equals(other$capDrop)) {
            return false;
        }
        List<String> this$securityOpts = this.getSecurityOpts();
        List<String> other$securityOpts = other.getSecurityOpts();
        if (this$securityOpts == null ? other$securityOpts != null : !((Object)this$securityOpts).equals(other$securityOpts)) {
            return false;
        }
        List<String> this$extraHosts = this.getExtraHosts();
        List<String> other$extraHosts = other.getExtraHosts();
        if (this$extraHosts == null ? other$extraHosts != null : !((Object)this$extraHosts).equals(other$extraHosts)) {
            return false;
        }
        String this$cpuSet = this.getCpuSet();
        String other$cpuSet = other.getCpuSet();
        if (this$cpuSet == null ? other$cpuSet != null : !this$cpuSet.equals(other$cpuSet)) {
            return false;
        }
        List<String> this$ports = this.getPorts();
        List<String> other$ports = other.getPorts();
        if (this$ports == null ? other$ports != null : !((Object)this$ports).equals(other$ports)) {
            return false;
        }
        String this$containerNamePattern = this.getContainerNamePattern();
        String other$containerNamePattern = other.getContainerNamePattern();
        if (this$containerNamePattern == null ? other$containerNamePattern != null : !this$containerNamePattern.equals(other$containerNamePattern)) {
            return false;
        }
        String this$exposedPropertyKey = this.getExposedPropertyKey();
        String other$exposedPropertyKey = other.getExposedPropertyKey();
        if (this$exposedPropertyKey == null ? other$exposedPropertyKey != null : !this$exposedPropertyKey.equals(other$exposedPropertyKey)) {
            return false;
        }
        RunVolumeConfiguration this$volumes = this.getVolumes();
        RunVolumeConfiguration other$volumes = other.getVolumes();
        if (this$volumes == null ? other$volumes != null : !((Object)this$volumes).equals(other$volumes)) {
            return false;
        }
        List<String> this$links = this.getLinks();
        List<String> other$links = other.getLinks();
        if (this$links == null ? other$links != null : !((Object)this$links).equals(other$links)) {
            return false;
        }
        WaitConfiguration this$wait = this.getWait();
        WaitConfiguration other$wait = other.getWait();
        if (this$wait == null ? other$wait != null : !((Object)this$wait).equals(other$wait)) {
            return false;
        }
        List<String> this$tmpfs = this.getTmpfs();
        List<String> other$tmpfs = other.getTmpfs();
        if (this$tmpfs == null ? other$tmpfs != null : !((Object)this$tmpfs).equals(other$tmpfs)) {
            return false;
        }
        LogConfiguration this$log = this.getLog();
        LogConfiguration other$log = other.getLog();
        if (this$log == null ? other$log != null : !((Object)this$log).equals(other$log)) {
            return false;
        }
        RestartPolicy this$restartPolicy = this.getRestartPolicy();
        RestartPolicy other$restartPolicy = other.getRestartPolicy();
        if (this$restartPolicy == null ? other$restartPolicy != null : !((Object)this$restartPolicy).equals(other$restartPolicy)) {
            return false;
        }
        List<UlimitConfig> this$ulimits = this.getUlimits();
        List<UlimitConfig> other$ulimits = other.getUlimits();
        if (this$ulimits == null ? other$ulimits != null : !((Object)this$ulimits).equals(other$ulimits)) {
            return false;
        }
        String this$imagePullPolicy = this.getImagePullPolicy();
        String other$imagePullPolicy = other.getImagePullPolicy();
        return !(this$imagePullPolicy == null ? other$imagePullPolicy != null : !this$imagePullPolicy.equals(other$imagePullPolicy));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RunImageConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $shmSize = this.getShmSize();
        result = result * 59 + ($shmSize == null ? 43 : ((Object)$shmSize).hashCode());
        Long $memory = this.getMemory();
        result = result * 59 + ($memory == null ? 43 : ((Object)$memory).hashCode());
        Long $memorySwap = this.getMemorySwap();
        result = result * 59 + ($memorySwap == null ? 43 : ((Object)$memorySwap).hashCode());
        Boolean $privileged = this.getPrivileged();
        result = result * 59 + ($privileged == null ? 43 : ((Object)$privileged).hashCode());
        Long $cpuShares = this.getCpuShares();
        result = result * 59 + ($cpuShares == null ? 43 : ((Object)$cpuShares).hashCode());
        Long $cpus = this.getCpus();
        result = result * 59 + ($cpus == null ? 43 : ((Object)$cpus).hashCode());
        Boolean $skip = this.getSkip();
        result = result * 59 + ($skip == null ? 43 : ((Object)$skip).hashCode());
        Boolean $readOnly = this.getReadOnly();
        result = result * 59 + ($readOnly == null ? 43 : ((Object)$readOnly).hashCode());
        Boolean $autoRemove = this.getAutoRemove();
        result = result * 59 + ($autoRemove == null ? 43 : ((Object)$autoRemove).hashCode());
        Map<String, String> $env = this.getEnv();
        result = result * 59 + ($env == null ? 43 : ((Object)$env).hashCode());
        Map<String, String> $labels = this.getLabels();
        result = result * 59 + ($labels == null ? 43 : ((Object)$labels).hashCode());
        String $envPropertyFile = this.getEnvPropertyFile();
        result = result * 59 + ($envPropertyFile == null ? 43 : $envPropertyFile.hashCode());
        Arguments $cmd = this.getCmd();
        result = result * 59 + ($cmd == null ? 43 : ((Object)$cmd).hashCode());
        String $domainname = this.getDomainname();
        result = result * 59 + ($domainname == null ? 43 : $domainname.hashCode());
        List<String> $dependsOn = this.getDependsOn();
        result = result * 59 + ($dependsOn == null ? 43 : ((Object)$dependsOn).hashCode());
        Arguments $entrypoint = this.getEntrypoint();
        result = result * 59 + ($entrypoint == null ? 43 : ((Object)$entrypoint).hashCode());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        String $workingDir = this.getWorkingDir();
        result = result * 59 + ($workingDir == null ? 43 : $workingDir.hashCode());
        String $portPropertyFile = this.getPortPropertyFile();
        result = result * 59 + ($portPropertyFile == null ? 43 : $portPropertyFile.hashCode());
        String $net = this.getNet();
        result = result * 59 + ($net == null ? 43 : $net.hashCode());
        NetworkConfig $network = this.getNetwork();
        result = result * 59 + ($network == null ? 43 : ((Object)$network).hashCode());
        List<String> $dns = this.getDns();
        result = result * 59 + ($dns == null ? 43 : ((Object)$dns).hashCode());
        List<String> $dnsSearch = this.getDnsSearch();
        result = result * 59 + ($dnsSearch == null ? 43 : ((Object)$dnsSearch).hashCode());
        List<String> $capAdd = this.getCapAdd();
        result = result * 59 + ($capAdd == null ? 43 : ((Object)$capAdd).hashCode());
        List<String> $capDrop = this.getCapDrop();
        result = result * 59 + ($capDrop == null ? 43 : ((Object)$capDrop).hashCode());
        List<String> $securityOpts = this.getSecurityOpts();
        result = result * 59 + ($securityOpts == null ? 43 : ((Object)$securityOpts).hashCode());
        List<String> $extraHosts = this.getExtraHosts();
        result = result * 59 + ($extraHosts == null ? 43 : ((Object)$extraHosts).hashCode());
        String $cpuSet = this.getCpuSet();
        result = result * 59 + ($cpuSet == null ? 43 : $cpuSet.hashCode());
        List<String> $ports = this.getPorts();
        result = result * 59 + ($ports == null ? 43 : ((Object)$ports).hashCode());
        String $containerNamePattern = this.getContainerNamePattern();
        result = result * 59 + ($containerNamePattern == null ? 43 : $containerNamePattern.hashCode());
        String $exposedPropertyKey = this.getExposedPropertyKey();
        result = result * 59 + ($exposedPropertyKey == null ? 43 : $exposedPropertyKey.hashCode());
        RunVolumeConfiguration $volumes = this.getVolumes();
        result = result * 59 + ($volumes == null ? 43 : ((Object)$volumes).hashCode());
        List<String> $links = this.getLinks();
        result = result * 59 + ($links == null ? 43 : ((Object)$links).hashCode());
        WaitConfiguration $wait = this.getWait();
        result = result * 59 + ($wait == null ? 43 : ((Object)$wait).hashCode());
        List<String> $tmpfs = this.getTmpfs();
        result = result * 59 + ($tmpfs == null ? 43 : ((Object)$tmpfs).hashCode());
        LogConfiguration $log = this.getLog();
        result = result * 59 + ($log == null ? 43 : ((Object)$log).hashCode());
        RestartPolicy $restartPolicy = this.getRestartPolicy();
        result = result * 59 + ($restartPolicy == null ? 43 : ((Object)$restartPolicy).hashCode());
        List<UlimitConfig> $ulimits = this.getUlimits();
        result = result * 59 + ($ulimits == null ? 43 : ((Object)$ulimits).hashCode());
        String $imagePullPolicy = this.getImagePullPolicy();
        result = result * 59 + ($imagePullPolicy == null ? 43 : $imagePullPolicy.hashCode());
        return result;
    }

    public static class RunImageConfigurationBuilder {
        private Map<String, String> env;
        private Map<String, String> labels;
        private String envPropertyFile;
        private Arguments cmd;
        private String domainname;
        private List<String> dependsOn;
        private Arguments entrypoint;
        private String hostname;
        private String user;
        private String workingDir;
        private Long shmSize;
        private Long memory;
        private Long memorySwap;
        private String portPropertyFile;
        private String net;
        private NetworkConfig network;
        private List<String> dns;
        private List<String> dnsSearch;
        private List<String> capAdd;
        private List<String> capDrop;
        private List<String> securityOpts;
        private Boolean privileged;
        private List<String> extraHosts;
        private Long cpuShares;
        private Long cpus;
        private String cpuSet;
        private List<String> ports;
        private String containerNamePattern;
        private String exposedPropertyKey;
        private RunVolumeConfiguration volumes;
        private List<String> links;
        private WaitConfiguration wait;
        private List<String> tmpfs;
        private LogConfiguration log;
        private RestartPolicy restartPolicy;
        private List<UlimitConfig> ulimits;
        private Boolean skip;
        private String imagePullPolicy;
        private Boolean readOnly;
        private Boolean autoRemove;

        RunImageConfigurationBuilder() {
        }

        public RunImageConfigurationBuilder env(Map<String, String> env) {
            this.env = env;
            return this;
        }

        public RunImageConfigurationBuilder labels(Map<String, String> labels) {
            this.labels = labels;
            return this;
        }

        public RunImageConfigurationBuilder envPropertyFile(String envPropertyFile) {
            this.envPropertyFile = envPropertyFile;
            return this;
        }

        public RunImageConfigurationBuilder cmd(Arguments cmd) {
            this.cmd = cmd;
            return this;
        }

        public RunImageConfigurationBuilder domainname(String domainname) {
            this.domainname = domainname;
            return this;
        }

        public RunImageConfigurationBuilder dependsOn(List<String> dependsOn) {
            this.dependsOn = dependsOn;
            return this;
        }

        public RunImageConfigurationBuilder entrypoint(Arguments entrypoint) {
            this.entrypoint = entrypoint;
            return this;
        }

        public RunImageConfigurationBuilder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public RunImageConfigurationBuilder user(String user) {
            this.user = user;
            return this;
        }

        public RunImageConfigurationBuilder workingDir(String workingDir) {
            this.workingDir = workingDir;
            return this;
        }

        public RunImageConfigurationBuilder shmSize(Long shmSize) {
            this.shmSize = shmSize;
            return this;
        }

        public RunImageConfigurationBuilder memory(Long memory) {
            this.memory = memory;
            return this;
        }

        public RunImageConfigurationBuilder memorySwap(Long memorySwap) {
            this.memorySwap = memorySwap;
            return this;
        }

        public RunImageConfigurationBuilder portPropertyFile(String portPropertyFile) {
            this.portPropertyFile = portPropertyFile;
            return this;
        }

        public RunImageConfigurationBuilder net(String net) {
            this.net = net;
            return this;
        }

        public RunImageConfigurationBuilder network(NetworkConfig network) {
            this.network = network;
            return this;
        }

        public RunImageConfigurationBuilder dns(List<String> dns) {
            this.dns = dns;
            return this;
        }

        public RunImageConfigurationBuilder dnsSearch(List<String> dnsSearch) {
            this.dnsSearch = dnsSearch;
            return this;
        }

        public RunImageConfigurationBuilder capAdd(List<String> capAdd) {
            this.capAdd = capAdd;
            return this;
        }

        public RunImageConfigurationBuilder capDrop(List<String> capDrop) {
            this.capDrop = capDrop;
            return this;
        }

        public RunImageConfigurationBuilder securityOpts(List<String> securityOpts) {
            this.securityOpts = securityOpts;
            return this;
        }

        public RunImageConfigurationBuilder privileged(Boolean privileged) {
            this.privileged = privileged;
            return this;
        }

        public RunImageConfigurationBuilder extraHosts(List<String> extraHosts) {
            this.extraHosts = extraHosts;
            return this;
        }

        public RunImageConfigurationBuilder cpuShares(Long cpuShares) {
            this.cpuShares = cpuShares;
            return this;
        }

        public RunImageConfigurationBuilder cpus(Long cpus) {
            this.cpus = cpus;
            return this;
        }

        public RunImageConfigurationBuilder cpuSet(String cpuSet) {
            this.cpuSet = cpuSet;
            return this;
        }

        public RunImageConfigurationBuilder ports(List<String> ports) {
            this.ports = ports;
            return this;
        }

        public RunImageConfigurationBuilder containerNamePattern(String containerNamePattern) {
            this.containerNamePattern = containerNamePattern;
            return this;
        }

        public RunImageConfigurationBuilder exposedPropertyKey(String exposedPropertyKey) {
            this.exposedPropertyKey = exposedPropertyKey;
            return this;
        }

        public RunImageConfigurationBuilder volumes(RunVolumeConfiguration volumes) {
            this.volumes = volumes;
            return this;
        }

        public RunImageConfigurationBuilder links(List<String> links) {
            this.links = links;
            return this;
        }

        public RunImageConfigurationBuilder wait(WaitConfiguration wait) {
            this.wait = wait;
            return this;
        }

        public RunImageConfigurationBuilder tmpfs(List<String> tmpfs) {
            this.tmpfs = tmpfs;
            return this;
        }

        public RunImageConfigurationBuilder log(LogConfiguration log) {
            this.log = log;
            return this;
        }

        public RunImageConfigurationBuilder restartPolicy(RestartPolicy restartPolicy) {
            this.restartPolicy = restartPolicy;
            return this;
        }

        public RunImageConfigurationBuilder ulimits(List<UlimitConfig> ulimits) {
            this.ulimits = ulimits;
            return this;
        }

        public RunImageConfigurationBuilder skip(Boolean skip) {
            this.skip = skip;
            return this;
        }

        public RunImageConfigurationBuilder imagePullPolicy(String imagePullPolicy) {
            this.imagePullPolicy = imagePullPolicy;
            return this;
        }

        public RunImageConfigurationBuilder readOnly(Boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        public RunImageConfigurationBuilder autoRemove(Boolean autoRemove) {
            this.autoRemove = autoRemove;
            return this;
        }

        public RunImageConfiguration build() {
            return new RunImageConfiguration(this.env, this.labels, this.envPropertyFile, this.cmd, this.domainname, this.dependsOn, this.entrypoint, this.hostname, this.user, this.workingDir, this.shmSize, this.memory, this.memorySwap, this.portPropertyFile, this.net, this.network, this.dns, this.dnsSearch, this.capAdd, this.capDrop, this.securityOpts, this.privileged, this.extraHosts, this.cpuShares, this.cpus, this.cpuSet, this.ports, this.containerNamePattern, this.exposedPropertyKey, this.volumes, this.links, this.wait, this.tmpfs, this.log, this.restartPolicy, this.ulimits, this.skip, this.imagePullPolicy, this.readOnly, this.autoRemove);
        }

        public String toString() {
            return "RunImageConfiguration.RunImageConfigurationBuilder(env=" + this.env + ", labels=" + this.labels + ", envPropertyFile=" + this.envPropertyFile + ", cmd=" + this.cmd + ", domainname=" + this.domainname + ", dependsOn=" + this.dependsOn + ", entrypoint=" + this.entrypoint + ", hostname=" + this.hostname + ", user=" + this.user + ", workingDir=" + this.workingDir + ", shmSize=" + this.shmSize + ", memory=" + this.memory + ", memorySwap=" + this.memorySwap + ", portPropertyFile=" + this.portPropertyFile + ", net=" + this.net + ", network=" + this.network + ", dns=" + this.dns + ", dnsSearch=" + this.dnsSearch + ", capAdd=" + this.capAdd + ", capDrop=" + this.capDrop + ", securityOpts=" + this.securityOpts + ", privileged=" + this.privileged + ", extraHosts=" + this.extraHosts + ", cpuShares=" + this.cpuShares + ", cpus=" + this.cpus + ", cpuSet=" + this.cpuSet + ", ports=" + this.ports + ", containerNamePattern=" + this.containerNamePattern + ", exposedPropertyKey=" + this.exposedPropertyKey + ", volumes=" + this.volumes + ", links=" + this.links + ", wait=" + this.wait + ", tmpfs=" + this.tmpfs + ", log=" + this.log + ", restartPolicy=" + this.restartPolicy + ", ulimits=" + this.ulimits + ", skip=" + this.skip + ", imagePullPolicy=" + this.imagePullPolicy + ", readOnly=" + this.readOnly + ", autoRemove=" + this.autoRemove + ")";
        }
    }
}

