/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.config.image;

import java.io.Serializable;
import java.util.List;
import java.util.Optional;

public class WaitConfiguration
implements Serializable {
    public static final String DEFAULT_HTTP_METHOD = "HEAD";
    public static final int DEFAULT_MIN_STATUS = 200;
    public static final int DEFAULT_MAX_STATUS = 399;
    public static final String DEFAULT_STATUS_RANGE = String.format("%d..%d", 200, 399);
    private Integer time;
    private HttpConfiguration http;
    private ExecConfiguration exec;
    private TcpConfiguration tcp;
    private Boolean healthy;
    private String log;
    private Integer shutdown;
    private Integer kill;
    private Integer exit;

    public WaitConfiguration(Integer time, String url, String method, String status, String postStart, String preStop, Boolean breakOnError, TcpConfigMode tcpMode, String tcpHost, List<Integer> tcpPorts, Boolean healthy, String log, Integer shutdown, Integer kill, Integer exit) {
        this.time = time;
        if (url != null) {
            this.http = new HttpConfiguration(url, method, status);
        }
        if (postStart != null || preStop != null) {
            this.exec = new ExecConfiguration(postStart, preStop, Optional.ofNullable(breakOnError).orElse(false));
        }
        if (tcpPorts != null) {
            this.tcp = new TcpConfiguration(tcpMode, tcpHost, tcpPorts);
        }
        this.healthy = healthy;
        this.log = log;
        this.shutdown = shutdown;
        this.kill = kill;
        this.exit = exit;
    }

    public String getUrl() {
        return Optional.ofNullable(this.http).map(HttpConfiguration::getUrl).orElse(null);
    }

    public static WaitConfigurationBuilder builder() {
        return new WaitConfigurationBuilder();
    }

    public WaitConfiguration(Integer time, HttpConfiguration http, ExecConfiguration exec, TcpConfiguration tcp, Boolean healthy, String log, Integer shutdown, Integer kill, Integer exit) {
        this.time = time;
        this.http = http;
        this.exec = exec;
        this.tcp = tcp;
        this.healthy = healthy;
        this.log = log;
        this.shutdown = shutdown;
        this.kill = kill;
        this.exit = exit;
    }

    public WaitConfiguration() {
    }

    public Integer getTime() {
        return this.time;
    }

    public HttpConfiguration getHttp() {
        return this.http;
    }

    public ExecConfiguration getExec() {
        return this.exec;
    }

    public TcpConfiguration getTcp() {
        return this.tcp;
    }

    public Boolean getHealthy() {
        return this.healthy;
    }

    public String getLog() {
        return this.log;
    }

    public Integer getShutdown() {
        return this.shutdown;
    }

    public Integer getKill() {
        return this.kill;
    }

    public Integer getExit() {
        return this.exit;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WaitConfiguration)) {
            return false;
        }
        WaitConfiguration other = (WaitConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$time = this.getTime();
        Integer other$time = other.getTime();
        if (this$time == null ? other$time != null : !((Object)this$time).equals(other$time)) {
            return false;
        }
        Boolean this$healthy = this.getHealthy();
        Boolean other$healthy = other.getHealthy();
        if (this$healthy == null ? other$healthy != null : !((Object)this$healthy).equals(other$healthy)) {
            return false;
        }
        Integer this$shutdown = this.getShutdown();
        Integer other$shutdown = other.getShutdown();
        if (this$shutdown == null ? other$shutdown != null : !((Object)this$shutdown).equals(other$shutdown)) {
            return false;
        }
        Integer this$kill = this.getKill();
        Integer other$kill = other.getKill();
        if (this$kill == null ? other$kill != null : !((Object)this$kill).equals(other$kill)) {
            return false;
        }
        Integer this$exit = this.getExit();
        Integer other$exit = other.getExit();
        if (this$exit == null ? other$exit != null : !((Object)this$exit).equals(other$exit)) {
            return false;
        }
        HttpConfiguration this$http = this.getHttp();
        HttpConfiguration other$http = other.getHttp();
        if (this$http == null ? other$http != null : !((Object)this$http).equals(other$http)) {
            return false;
        }
        ExecConfiguration this$exec = this.getExec();
        ExecConfiguration other$exec = other.getExec();
        if (this$exec == null ? other$exec != null : !((Object)this$exec).equals(other$exec)) {
            return false;
        }
        TcpConfiguration this$tcp = this.getTcp();
        TcpConfiguration other$tcp = other.getTcp();
        if (this$tcp == null ? other$tcp != null : !((Object)this$tcp).equals(other$tcp)) {
            return false;
        }
        String this$log = this.getLog();
        String other$log = other.getLog();
        return !(this$log == null ? other$log != null : !this$log.equals(other$log));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WaitConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $time = this.getTime();
        result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
        Boolean $healthy = this.getHealthy();
        result = result * 59 + ($healthy == null ? 43 : ((Object)$healthy).hashCode());
        Integer $shutdown = this.getShutdown();
        result = result * 59 + ($shutdown == null ? 43 : ((Object)$shutdown).hashCode());
        Integer $kill = this.getKill();
        result = result * 59 + ($kill == null ? 43 : ((Object)$kill).hashCode());
        Integer $exit = this.getExit();
        result = result * 59 + ($exit == null ? 43 : ((Object)$exit).hashCode());
        HttpConfiguration $http = this.getHttp();
        result = result * 59 + ($http == null ? 43 : ((Object)$http).hashCode());
        ExecConfiguration $exec = this.getExec();
        result = result * 59 + ($exec == null ? 43 : ((Object)$exec).hashCode());
        TcpConfiguration $tcp = this.getTcp();
        result = result * 59 + ($tcp == null ? 43 : ((Object)$tcp).hashCode());
        String $log = this.getLog();
        result = result * 59 + ($log == null ? 43 : $log.hashCode());
        return result;
    }

    public static class TcpConfiguration
    implements Serializable {
        private static final long serialVersionUID = 4809023624478231971L;
        private TcpConfigMode mode;
        private String host;
        private List<Integer> ports;

        public TcpConfiguration(TcpConfigMode mode, String host, List<Integer> ports) {
            this.mode = mode;
            this.host = host;
            this.ports = ports;
        }

        public TcpConfiguration() {
        }

        public TcpConfigMode getMode() {
            return this.mode;
        }

        public String getHost() {
            return this.host;
        }

        public List<Integer> getPorts() {
            return this.ports;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TcpConfiguration)) {
                return false;
            }
            TcpConfiguration other = (TcpConfiguration)o;
            if (!other.canEqual(this)) {
                return false;
            }
            TcpConfigMode this$mode = this.getMode();
            TcpConfigMode other$mode = other.getMode();
            if (this$mode == null ? other$mode != null : !((Object)((Object)this$mode)).equals((Object)other$mode)) {
                return false;
            }
            String this$host = this.getHost();
            String other$host = other.getHost();
            if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
                return false;
            }
            List<Integer> this$ports = this.getPorts();
            List<Integer> other$ports = other.getPorts();
            return !(this$ports == null ? other$ports != null : !((Object)this$ports).equals(other$ports));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TcpConfiguration;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TcpConfigMode $mode = this.getMode();
            result = result * 59 + ($mode == null ? 43 : ((Object)((Object)$mode)).hashCode());
            String $host = this.getHost();
            result = result * 59 + ($host == null ? 43 : $host.hashCode());
            List<Integer> $ports = this.getPorts();
            result = result * 59 + ($ports == null ? 43 : ((Object)$ports).hashCode());
            return result;
        }
    }

    public static enum TcpConfigMode {
        mapped,
        direct;

    }

    public static class HttpConfiguration
    implements Serializable {
        private static final long serialVersionUID = -4093004978420554981L;
        private String url;
        private String method = "HEAD";
        private String status = DEFAULT_STATUS_RANGE;
        private boolean allowAllHosts;

        private HttpConfiguration(String url, String method, String status) {
            this(url, method, status, false);
        }

        public HttpConfiguration(String url, String method, String status, boolean allowAllHosts) {
            this.url = url;
            this.method = method;
            this.status = status;
            this.allowAllHosts = allowAllHosts;
        }

        public HttpConfiguration() {
        }

        public String getUrl() {
            return this.url;
        }

        public String getMethod() {
            return this.method;
        }

        public String getStatus() {
            return this.status;
        }

        public boolean isAllowAllHosts() {
            return this.allowAllHosts;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HttpConfiguration)) {
                return false;
            }
            HttpConfiguration other = (HttpConfiguration)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isAllowAllHosts() != other.isAllowAllHosts()) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            String this$method = this.getMethod();
            String other$method = other.getMethod();
            if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
                return false;
            }
            String this$status = this.getStatus();
            String other$status = other.getStatus();
            return !(this$status == null ? other$status != null : !this$status.equals(other$status));
        }

        protected boolean canEqual(Object other) {
            return other instanceof HttpConfiguration;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isAllowAllHosts() ? 79 : 97);
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            String $method = this.getMethod();
            result = result * 59 + ($method == null ? 43 : $method.hashCode());
            String $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            return result;
        }
    }

    public static class ExecConfiguration
    implements Serializable {
        private String postStart;
        private String preStop;
        private boolean breakOnError;

        public ExecConfiguration(String postStart, String preStop, boolean breakOnError) {
            this.postStart = postStart;
            this.preStop = preStop;
            this.breakOnError = breakOnError;
        }

        public ExecConfiguration() {
        }

        public String getPostStart() {
            return this.postStart;
        }

        public String getPreStop() {
            return this.preStop;
        }

        public boolean isBreakOnError() {
            return this.breakOnError;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExecConfiguration)) {
                return false;
            }
            ExecConfiguration other = (ExecConfiguration)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isBreakOnError() != other.isBreakOnError()) {
                return false;
            }
            String this$postStart = this.getPostStart();
            String other$postStart = other.getPostStart();
            if (this$postStart == null ? other$postStart != null : !this$postStart.equals(other$postStart)) {
                return false;
            }
            String this$preStop = this.getPreStop();
            String other$preStop = other.getPreStop();
            return !(this$preStop == null ? other$preStop != null : !this$preStop.equals(other$preStop));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ExecConfiguration;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isBreakOnError() ? 79 : 97);
            String $postStart = this.getPostStart();
            result = result * 59 + ($postStart == null ? 43 : $postStart.hashCode());
            String $preStop = this.getPreStop();
            result = result * 59 + ($preStop == null ? 43 : $preStop.hashCode());
            return result;
        }
    }

    public static class WaitConfigurationBuilder {
        private Integer time;
        private String url;
        private String method;
        private String status;
        private String postStart;
        private String preStop;
        private Boolean breakOnError;
        private TcpConfigMode tcpMode;
        private String tcpHost;
        private List<Integer> tcpPorts;
        private Boolean healthy;
        private String log;
        private Integer shutdown;
        private Integer kill;
        private Integer exit;

        public WaitConfigurationBuilder tcpModeString(String tcpModeString) {
            this.tcpMode = Optional.ofNullable(tcpModeString).map(String::toLowerCase).map(TcpConfigMode::valueOf).orElse(null);
            return this;
        }

        WaitConfigurationBuilder() {
        }

        public WaitConfigurationBuilder time(Integer time) {
            this.time = time;
            return this;
        }

        public WaitConfigurationBuilder url(String url) {
            this.url = url;
            return this;
        }

        public WaitConfigurationBuilder method(String method) {
            this.method = method;
            return this;
        }

        public WaitConfigurationBuilder status(String status) {
            this.status = status;
            return this;
        }

        public WaitConfigurationBuilder postStart(String postStart) {
            this.postStart = postStart;
            return this;
        }

        public WaitConfigurationBuilder preStop(String preStop) {
            this.preStop = preStop;
            return this;
        }

        public WaitConfigurationBuilder breakOnError(Boolean breakOnError) {
            this.breakOnError = breakOnError;
            return this;
        }

        public WaitConfigurationBuilder tcpMode(TcpConfigMode tcpMode) {
            this.tcpMode = tcpMode;
            return this;
        }

        public WaitConfigurationBuilder tcpHost(String tcpHost) {
            this.tcpHost = tcpHost;
            return this;
        }

        public WaitConfigurationBuilder tcpPorts(List<Integer> tcpPorts) {
            this.tcpPorts = tcpPorts;
            return this;
        }

        public WaitConfigurationBuilder healthy(Boolean healthy) {
            this.healthy = healthy;
            return this;
        }

        public WaitConfigurationBuilder log(String log) {
            this.log = log;
            return this;
        }

        public WaitConfigurationBuilder shutdown(Integer shutdown) {
            this.shutdown = shutdown;
            return this;
        }

        public WaitConfigurationBuilder kill(Integer kill) {
            this.kill = kill;
            return this;
        }

        public WaitConfigurationBuilder exit(Integer exit) {
            this.exit = exit;
            return this;
        }

        public WaitConfiguration build() {
            return new WaitConfiguration(this.time, this.url, this.method, this.status, this.postStart, this.preStop, this.breakOnError, this.tcpMode, this.tcpHost, this.tcpPorts, this.healthy, this.log, this.shutdown, this.kill, this.exit);
        }

        public String toString() {
            return "WaitConfiguration.WaitConfigurationBuilder(time=" + this.time + ", url=" + this.url + ", method=" + this.method + ", status=" + this.status + ", postStart=" + this.postStart + ", preStop=" + this.preStop + ", breakOnError=" + this.breakOnError + ", tcpMode=" + (Object)((Object)this.tcpMode) + ", tcpHost=" + this.tcpHost + ", tcpPorts=" + this.tcpPorts + ", healthy=" + this.healthy + ", log=" + this.log + ", shutdown=" + this.shutdown + ", kill=" + this.kill + ", exit=" + this.exit + ")";
        }
    }
}

