/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.launching;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jdt.internal.launching.LaunchingMessages;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractVMInstallType
implements IVMInstallType,
IExecutableExtension {
    private final List<IVMInstall> fVMs = new ArrayList<IVMInstall>(10);
    private String fId;

    protected AbstractVMInstallType() {
    }

    @Override
    public synchronized IVMInstall[] getVMInstalls() {
        return (IVMInstall[])this.fVMs.toArray(IVMInstall[]::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disposeVMInstall(String id) {
        IVMInstall removedVM = null;
        AbstractVMInstallType abstractVMInstallType = this;
        synchronized (abstractVMInstallType) {
            int i = 0;
            while (i < this.fVMs.size()) {
                if (this.fVMs.get(i).getId().equals(id)) {
                    removedVM = this.fVMs.remove(i);
                    break;
                }
                ++i;
            }
        }
        if (removedVM != null) {
            JavaRuntime.fireVMRemoved(removedVM);
        }
    }

    @Override
    public synchronized IVMInstall findVMInstall(String id) {
        for (IVMInstall vm : this.fVMs) {
            if (!vm.getId().equals(id)) continue;
            return vm;
        }
        return null;
    }

    @Override
    public synchronized IVMInstall createVMInstall(String id) throws IllegalArgumentException {
        if (this.findVMInstall(id) != null) {
            String format = LaunchingMessages.vmInstallType_duplicateVM;
            throw new IllegalArgumentException(NLS.bind((String)format, (Object)id));
        }
        IVMInstall vm = this.doCreateVMInstall(id);
        this.fVMs.add(vm);
        return vm;
    }

    protected abstract IVMInstall doCreateVMInstall(String var1);

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) {
        this.fId = config.getAttribute("id");
    }

    @Override
    public String getId() {
        return this.fId;
    }

    @Override
    public synchronized IVMInstall findVMInstallByName(String name) {
        for (IVMInstall vm : this.fVMs) {
            if (!Objects.equals(vm.getName(), name)) continue;
            return vm;
        }
        return null;
    }

    public URL getDefaultJavadocLocation(File installLocation) {
        return null;
    }

    public String getDefaultVMArguments(File installLocation) {
        return null;
    }
}

