/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.january.dataset.BooleanDataset;
import org.eclipse.january.dataset.BroadcastIterator;
import org.eclipse.january.dataset.ByteDataset;
import org.eclipse.january.dataset.Comparisons;
import org.eclipse.january.dataset.ComplexDoubleDataset;
import org.eclipse.january.dataset.ComplexFloatDataset;
import org.eclipse.january.dataset.CompoundByteDataset;
import org.eclipse.january.dataset.CompoundDataset;
import org.eclipse.january.dataset.CompoundDoubleDataset;
import org.eclipse.january.dataset.CompoundFloatDataset;
import org.eclipse.january.dataset.CompoundIntegerDataset;
import org.eclipse.january.dataset.CompoundLongDataset;
import org.eclipse.january.dataset.CompoundShortDataset;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.DatasetUtils;
import org.eclipse.january.dataset.DoubleDataset;
import org.eclipse.january.dataset.FloatDataset;
import org.eclipse.january.dataset.GeneratedMaths;
import org.eclipse.january.dataset.IDataset;
import org.eclipse.january.dataset.IndexIterator;
import org.eclipse.january.dataset.IntegerDataset;
import org.eclipse.january.dataset.LongDataset;
import org.eclipse.january.dataset.Operations;
import org.eclipse.january.dataset.PositionIterator;
import org.eclipse.january.dataset.ShortDataset;
import org.eclipse.january.dataset.SingleInputBroadcastIterator;

public class Maths
extends GeneratedMaths {
    public static Object unwrap(Dataset o, Object a) {
        return a instanceof Dataset ? o : o.getObjectAbs(o.getOffset());
    }

    public static Object unwrap(Dataset o, Object a, Object b) {
        return a instanceof Dataset || b instanceof Dataset ? o : o.getObjectAbs(o.getOffset());
    }

    public static Object unwrap(Dataset o, Object ... a) {
        boolean isAnyDataset = false;
        Object[] objectArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj instanceof Dataset) {
                isAnyDataset = true;
                break;
            }
            ++n2;
        }
        return isAnyDataset ? o : o.getObjectAbs(o.getOffset());
    }

    public static Dataset floorDivide(Object a, Object b) {
        return Maths.floorDivide(a, b, null);
    }

    public static Dataset floorDivide(Object a, Object b, Dataset o) {
        return Maths.divideTowardsFloor(a, b, o).ifloor();
    }

    public static Dataset floorRemainder(Object a, Object b) {
        return Maths.floorRemainder(a, b, null);
    }

    public static Dataset floorRemainder(Object a, Object b, Dataset o) {
        Dataset da = a instanceof Dataset ? (Dataset)a : DatasetFactory.createFromObject(a);
        Dataset db = b instanceof Dataset ? (Dataset)b : DatasetFactory.createFromObject(b);
        Dataset dq = Maths.floorDivide(da, db);
        dq.imultiply(db);
        return Maths.subtract(da, dq, o);
    }

    public static Dataset reciprocal(Object a) {
        return Maths.reciprocal(a, null);
    }

    public static Dataset reciprocal(Object a, Dataset o) {
        Dataset da = a instanceof Dataset ? (Dataset)a : DatasetFactory.createFromObject(a);
        return Maths.divide(1, da, o);
    }

    public static Dataset abs(Object a) {
        return Maths.abs(a, null);
    }

    /*
     * Unable to fully structure code
     */
    public static Dataset abs(Object a, Dataset o) {
        da = a instanceof Dataset != false ? (Dataset)a : DatasetFactory.createFromObject(a);
        it = new SingleInputBroadcastIterator(da, o, true, true, false);
        result = it.getOutput();
        is = result.getElementsPerItem();
        dt = result.getDType();
        as = da.getElementsPerItem();
        switch (dt) {
            case 1: {
                oi8data = ((ByteDataset)result).data;
                it.setOutputDouble(false);
                while (it.hasNext()) {
                    oi8data[it.oIndex] = (byte)Math.abs(it.aLong);
                }
                break;
            }
            case 2: {
                oi16data = ((ShortDataset)result).data;
                it.setOutputDouble(false);
                while (it.hasNext()) {
                    oi16data[it.oIndex] = (short)Math.abs(it.aLong);
                }
                break;
            }
            case 3: {
                oi32data = ((IntegerDataset)result).data;
                it.setOutputDouble(false);
                while (it.hasNext()) {
                    oi32data[it.oIndex] = (int)Math.abs(it.aLong);
                }
                break;
            }
            case 4: {
                oi64data = ((LongDataset)result).data;
                it.setOutputDouble(false);
                while (it.hasNext()) {
                    oi64data[it.oIndex] = Math.abs(it.aLong);
                }
                break;
            }
            case 100: {
                oai8data = ((CompoundByteDataset)result).data;
                it.setOutputDouble(false);
                if (is == 1) {
                    while (it.hasNext()) {
                        oai8data[it.oIndex] = (byte)Math.abs(it.aLong);
                    }
                    break;
                }
                if (as != 1) ** GOTO lbl60
                while (it.hasNext()) {
                    ox = (byte)Math.abs(it.aLong);
                    j = 0;
                    while (j < is) {
                        oai8data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    oai8data[it.oIndex] = (byte)Math.abs(it.aLong);
                    j = 1;
                    while (j < is) {
                        oai8data[it.oIndex + j] = (byte)Math.abs(da.getElementLongAbs(it.aIndex + j));
                        ++j;
                    }
lbl60:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl61:
                // 1 sources

                break;
            }
            case 200: {
                oai16data = ((CompoundShortDataset)result).data;
                it.setOutputDouble(false);
                if (is == 1) {
                    while (it.hasNext()) {
                        oai16data[it.oIndex] = (short)Math.abs(it.aLong);
                    }
                    break;
                }
                if (as != 1) ** GOTO lbl86
                while (it.hasNext()) {
                    ox = (short)Math.abs(it.aLong);
                    j = 0;
                    while (j < is) {
                        oai16data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    oai16data[it.oIndex] = (short)Math.abs(it.aLong);
                    j = 1;
                    while (j < is) {
                        oai16data[it.oIndex + j] = (short)Math.abs(da.getElementLongAbs(it.aIndex + j));
                        ++j;
                    }
lbl86:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl87:
                // 1 sources

                break;
            }
            case 300: {
                oai32data = ((CompoundIntegerDataset)result).data;
                it.setOutputDouble(false);
                if (is == 1) {
                    while (it.hasNext()) {
                        oai32data[it.oIndex] = (int)Math.abs(it.aLong);
                    }
                    break;
                }
                if (as != 1) ** GOTO lbl112
                while (it.hasNext()) {
                    ox = (int)Math.abs(it.aLong);
                    j = 0;
                    while (j < is) {
                        oai32data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    oai32data[it.oIndex] = (int)Math.abs(it.aLong);
                    j = 1;
                    while (j < is) {
                        oai32data[it.oIndex + j] = (int)Math.abs(da.getElementLongAbs(it.aIndex + j));
                        ++j;
                    }
lbl112:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl113:
                // 1 sources

                break;
            }
            case 400: {
                oai64data = ((CompoundLongDataset)result).data;
                it.setOutputDouble(false);
                if (is == 1) {
                    while (it.hasNext()) {
                        oai64data[it.oIndex] = Math.abs(it.aLong);
                    }
                    break;
                }
                if (as != 1) ** GOTO lbl138
                while (it.hasNext()) {
                    ox = Math.abs(it.aLong);
                    j = 0;
                    while (j < is) {
                        oai64data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    oai64data[it.oIndex] = Math.abs(it.aLong);
                    j = 1;
                    while (j < is) {
                        oai64data[it.oIndex + j] = Math.abs(da.getElementLongAbs(it.aIndex + j));
                        ++j;
                    }
lbl138:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl139:
                // 1 sources

                break;
            }
            case 5: {
                of32data = ((FloatDataset)result).data;
                if (as != 1) ** GOTO lbl148
                while (it.hasNext()) {
                    of32data[it.oIndex] = (float)Math.abs(it.aDouble);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    of32data[it.oIndex] = (float)Math.hypot(it.aDouble, da.getElementDoubleAbs(it.aIndex + 1));
lbl148:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl149:
                // 1 sources

                break;
            }
            case 6: {
                of64data = ((DoubleDataset)result).data;
                if (as != 1) ** GOTO lbl158
                while (it.hasNext()) {
                    of64data[it.oIndex] = Math.abs(it.aDouble);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    of64data[it.oIndex] = Math.hypot(it.aDouble, da.getElementDoubleAbs(it.aIndex + 1));
lbl158:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl159:
                // 1 sources

                break;
            }
            case 500: {
                oaf32data = ((CompoundFloatDataset)result).data;
                if (is == 1) {
                    while (it.hasNext()) {
                        oaf32data[it.oIndex] = (float)Math.abs(it.aDouble);
                    }
                    break;
                }
                if (as != 1) ** GOTO lbl183
                while (it.hasNext()) {
                    ox = (float)Math.abs(it.aDouble);
                    j = 0;
                    while (j < is) {
                        oaf32data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    oaf32data[it.oIndex] = (float)Math.abs(it.aDouble);
                    j = 1;
                    while (j < is) {
                        oaf32data[it.oIndex + j] = (float)Math.abs(da.getElementDoubleAbs(it.aIndex + j));
                        ++j;
                    }
lbl183:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl184:
                // 1 sources

                break;
            }
            case 600: {
                oaf64data = ((CompoundDoubleDataset)result).data;
                if (is == 1) {
                    while (it.hasNext()) {
                        oaf64data[it.oIndex] = Math.abs(it.aDouble);
                    }
                    break;
                }
                if (as != 1) ** GOTO lbl209
                while (it.hasNext()) {
                    ix = it.aDouble;
                    ox = Math.abs(ix);
                    j = 0;
                    while (j < is) {
                        oaf64data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    oaf64data[it.oIndex] = Math.abs(it.aDouble);
                    j = 1;
                    while (j < is) {
                        oaf64data[it.oIndex + j] = Math.abs(da.getElementDoubleAbs(it.aIndex + j));
                        ++j;
                    }
lbl209:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl210:
                // 1 sources

                break;
            }
            case 7: {
                oc64data = ((ComplexFloatDataset)result).data;
                if (as != 1) ** GOTO lbl219
                while (it.hasNext()) {
                    oc64data[it.oIndex] = (float)Math.abs(it.aDouble);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    oc64data[it.oIndex] = (float)Math.hypot(it.aDouble, da.getElementDoubleAbs(it.aIndex + 1));
lbl219:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl220:
                // 1 sources

                break;
            }
            case 8: {
                oc128data = ((ComplexDoubleDataset)result).data;
                if (as != 1) ** GOTO lbl229
                while (it.hasNext()) {
                    oc128data[it.oIndex] = Math.abs(it.aDouble);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    oc128data[it.oIndex] = Math.hypot(it.aDouble, da.getElementDoubleAbs(it.aIndex + 1));
lbl229:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl230:
                // 1 sources

                break;
            }
            default: {
                throw new IllegalArgumentException("abs supports integer, compound integer, real, compound real, complex datasets only");
            }
        }
        Maths.addFunctionName(result, "abs");
        return result;
    }

    public static Dataset conjugate(Object a) {
        return Maths.conjugate(a, null);
    }

    public static Dataset conjugate(Object a, Dataset o) {
        Dataset da = a instanceof Dataset ? (Dataset)a : DatasetFactory.createFromObject(a);
        int at = da.getDType();
        IndexIterator it1 = da.getIterator();
        SingleInputBroadcastIterator it = new SingleInputBroadcastIterator(da, o, true, true, true);
        Dataset result = it.getOutput();
        switch (at) {
            case 7: {
                float[] c64data = ((ComplexFloatDataset)result).getData();
                int i = 0;
                while (it1.hasNext()) {
                    c64data[i++] = (float)da.getElementDoubleAbs(it1.index);
                    c64data[i++] = (float)(-da.getElementDoubleAbs(it1.index + 1));
                }
                result.setName(Operations.bracketIfNecessary(da.getName()).append("^*").toString());
                break;
            }
            case 8: {
                double[] c128data = ((ComplexDoubleDataset)result).getData();
                int i = 0;
                while (it1.hasNext()) {
                    c128data[i++] = da.getElementDoubleAbs(it1.index);
                    c128data[i++] = -da.getElementDoubleAbs(it1.index + 1);
                }
                result.setName(Operations.bracketIfNecessary(da.getName()).append("^*").toString());
                break;
            }
            default: {
                result = da;
            }
        }
        return result;
    }

    public static Dataset hypot(Object a, Object b) {
        return Maths.hypot(a, b, null);
    }

    /*
     * Unable to fully structure code
     */
    public static Dataset hypot(Object a, Object b, Dataset o) {
        da = a instanceof Dataset != false ? (Dataset)a : DatasetFactory.createFromObject(a);
        db = b instanceof Dataset != false ? (Dataset)b : DatasetFactory.createFromObject(b);
        it = BroadcastIterator.createIterator(da, db, o, true);
        result = it.getOutput();
        is = result.getElementsPerItem();
        as = da.getElementsPerItem();
        bs = db.getElementsPerItem();
        dt = result.getDType();
        switch (dt) {
            case 0: {
                bdata = ((BooleanDataset)result).getData();
                while (it.hasNext()) {
                    v0 = bdata[it.oIndex] = Math.hypot(it.aDouble, it.bDouble) != 0.0;
                }
                break;
            }
            case 1: {
                i8data = ((ByteDataset)result).getData();
                while (it.hasNext()) {
                    i8data[it.oIndex] = (byte)Maths.toLong(Math.hypot(it.aDouble, it.bDouble));
                }
                break;
            }
            case 2: {
                i16data = ((ShortDataset)result).getData();
                while (it.hasNext()) {
                    i16data[it.oIndex] = (short)Maths.toLong(Math.hypot(it.aDouble, it.bDouble));
                }
                break;
            }
            case 3: {
                i32data = ((IntegerDataset)result).getData();
                while (it.hasNext()) {
                    i32data[it.oIndex] = (int)Maths.toLong(Math.hypot(it.aDouble, it.bDouble));
                }
                break;
            }
            case 4: {
                i64data = ((LongDataset)result).getData();
                while (it.hasNext()) {
                    i64data[it.oIndex] = Maths.toLong(Math.hypot(it.aDouble, it.bDouble));
                }
                break;
            }
            case 5: {
                f32data = ((FloatDataset)result).getData();
                while (it.hasNext()) {
                    f32data[it.oIndex] = (float)Math.hypot(it.aDouble, it.bDouble);
                }
                break;
            }
            case 6: {
                f64data = ((DoubleDataset)result).getData();
                while (it.hasNext()) {
                    f64data[it.oIndex] = Math.hypot(it.aDouble, it.bDouble);
                }
                break;
            }
            case 100: {
                ai8data = ((CompoundByteDataset)result).getData();
                if (is == 1) {
                    while (it.hasNext()) {
                        ai8data[it.oIndex] = (byte)Maths.toLong(Math.hypot(it.aDouble, it.bDouble));
                    }
                    break;
                }
                if (as == 1) {
                    while (it.hasNext()) {
                        ai8data[it.oIndex] = (byte)Maths.toLong(Math.hypot(it.aDouble, it.bDouble));
                        j = 1;
                        while (j < is) {
                            ai8data[it.oIndex + j] = (byte)Maths.toLong(Math.hypot(it.aDouble, db.getElementDoubleAbs(it.bIndex + j)));
                            ++j;
                        }
                    }
                    break;
                }
                if (bs != 1) ** GOTO lbl85
                while (it.hasNext()) {
                    ai8data[it.oIndex] = (byte)Maths.toLong(Math.hypot(it.aDouble, it.bDouble));
                    j = 1;
                    while (j < is) {
                        ai8data[it.oIndex + j] = (byte)Maths.toLong(Math.hypot(da.getElementDoubleAbs(it.aIndex + j), it.bDouble));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ai8data[it.oIndex] = (byte)Maths.toLong(Math.hypot(it.aDouble, it.bDouble));
                    j = 1;
                    while (j < is) {
                        ai8data[it.oIndex + j] = (byte)Maths.toLong(Math.hypot(da.getElementDoubleAbs(it.aIndex + j), db.getElementDoubleAbs(it.bIndex + j)));
                        ++j;
                    }
lbl85:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl86:
                // 1 sources

                break;
            }
            case 200: {
                ai16data = ((CompoundShortDataset)result).getData();
                if (is == 1) {
                    while (it.hasNext()) {
                        ai16data[it.oIndex] = (short)Maths.toLong(Math.hypot(it.aDouble, it.bDouble));
                    }
                    break;
                }
                if (as == 1) {
                    while (it.hasNext()) {
                        ai16data[it.oIndex] = (short)Maths.toLong(Math.hypot(it.aDouble, it.bDouble));
                        j = 1;
                        while (j < is) {
                            ai16data[it.oIndex + j] = (short)Maths.toLong(Math.hypot(it.aDouble, db.getElementDoubleAbs(it.bIndex + j)));
                            ++j;
                        }
                    }
                    break;
                }
                if (bs != 1) ** GOTO lbl120
                while (it.hasNext()) {
                    ai16data[it.oIndex] = (short)Maths.toLong(Math.hypot(it.aDouble, it.bDouble));
                    j = 1;
                    while (j < is) {
                        ai16data[it.oIndex + j] = (short)Maths.toLong(Math.hypot(da.getElementDoubleAbs(it.aIndex + j), it.bDouble));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ai16data[it.oIndex] = (short)Maths.toLong(Math.hypot(it.aDouble, it.bDouble));
                    j = 1;
                    while (j < is) {
                        ai16data[it.oIndex + j] = (short)Maths.toLong(Math.hypot(da.getElementDoubleAbs(it.aIndex + j), db.getElementDoubleAbs(it.bIndex + j)));
                        ++j;
                    }
lbl120:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl121:
                // 1 sources

                break;
            }
            case 300: {
                ai32data = ((CompoundIntegerDataset)result).getData();
                if (is == 1) {
                    while (it.hasNext()) {
                        ai32data[it.oIndex] = (int)Maths.toLong(Math.hypot(it.aDouble, it.bDouble));
                    }
                    break;
                }
                if (as == 1) {
                    while (it.hasNext()) {
                        ai32data[it.oIndex] = (int)Maths.toLong(Math.hypot(it.aDouble, it.bDouble));
                        j = 1;
                        while (j < is) {
                            ai32data[it.oIndex + j] = (int)Maths.toLong(Math.hypot(it.aDouble, db.getElementDoubleAbs(it.bIndex + j)));
                            ++j;
                        }
                    }
                    break;
                }
                if (bs != 1) ** GOTO lbl155
                while (it.hasNext()) {
                    ai32data[it.oIndex] = (int)Maths.toLong(Math.hypot(it.aDouble, it.bDouble));
                    j = 1;
                    while (j < is) {
                        ai32data[it.oIndex + j] = (int)Maths.toLong(Math.hypot(da.getElementDoubleAbs(it.aIndex + j), it.bDouble));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ai32data[it.oIndex] = (int)Maths.toLong(Math.hypot(it.aDouble, it.bDouble));
                    j = 1;
                    while (j < is) {
                        ai32data[it.oIndex + j] = (int)Maths.toLong(Math.hypot(da.getElementDoubleAbs(it.aIndex + j), db.getElementDoubleAbs(it.bIndex + j)));
                        ++j;
                    }
lbl155:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl156:
                // 1 sources

                break;
            }
            case 400: {
                ai64data = ((CompoundLongDataset)result).getData();
                if (is == 1) {
                    while (it.hasNext()) {
                        ai64data[it.oIndex] = Maths.toLong(Math.hypot(it.aDouble, it.bDouble));
                    }
                    break;
                }
                if (as == 1) {
                    while (it.hasNext()) {
                        ai64data[it.oIndex] = Maths.toLong(Math.hypot(it.aDouble, it.bDouble));
                        j = 1;
                        while (j < is) {
                            ai64data[it.oIndex + j] = Maths.toLong(Math.hypot(it.aDouble, db.getElementDoubleAbs(it.bIndex + j)));
                            ++j;
                        }
                    }
                    break;
                }
                if (bs != 1) ** GOTO lbl190
                while (it.hasNext()) {
                    ai64data[it.oIndex] = Maths.toLong(Math.hypot(it.aDouble, it.bDouble));
                    j = 1;
                    while (j < is) {
                        ai64data[it.oIndex + j] = Maths.toLong(Math.hypot(da.getElementDoubleAbs(it.aIndex + j), it.bDouble));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ai64data[it.oIndex] = Maths.toLong(Math.hypot(it.aDouble, it.bDouble));
                    j = 1;
                    while (j < is) {
                        ai64data[it.oIndex + j] = Maths.toLong(Math.hypot(da.getElementDoubleAbs(it.aIndex + j), db.getElementDoubleAbs(it.bIndex + j)));
                        ++j;
                    }
lbl190:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl191:
                // 1 sources

                break;
            }
            case 500: {
                a32data = ((CompoundFloatDataset)result).getData();
                if (is == 1) {
                    while (it.hasNext()) {
                        a32data[it.oIndex] = (float)Math.hypot(it.aDouble, it.bDouble);
                    }
                    break;
                }
                if (as == 1) {
                    while (it.hasNext()) {
                        a32data[it.oIndex] = (float)Math.hypot(it.aDouble, it.bDouble);
                        j = 1;
                        while (j < is) {
                            a32data[it.oIndex + j] = (float)Math.hypot(it.aDouble, db.getElementDoubleAbs(it.bIndex + j));
                            ++j;
                        }
                    }
                    break;
                }
                if (bs != 1) ** GOTO lbl225
                while (it.hasNext()) {
                    a32data[it.oIndex] = (float)Math.hypot(it.aDouble, it.bDouble);
                    j = 1;
                    while (j < is) {
                        a32data[it.oIndex + j] = (float)Math.hypot(da.getElementDoubleAbs(it.aIndex + j), it.bDouble);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    a32data[it.oIndex] = (float)Math.hypot(it.aDouble, it.bDouble);
                    j = 1;
                    while (j < is) {
                        a32data[it.oIndex + j] = (float)Math.hypot(da.getElementDoubleAbs(it.aIndex + j), db.getElementDoubleAbs(it.bIndex + j));
                        ++j;
                    }
lbl225:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl226:
                // 1 sources

                break;
            }
            case 600: {
                a64data = ((CompoundDoubleDataset)result).getData();
                if (is == 1) {
                    while (it.hasNext()) {
                        a64data[it.oIndex] = Math.hypot(it.aDouble, it.bDouble);
                    }
                    break;
                }
                if (as == 1) {
                    while (it.hasNext()) {
                        a64data[it.oIndex] = Math.hypot(it.aDouble, it.bDouble);
                        j = 1;
                        while (j < is) {
                            a64data[it.oIndex + j] = Math.hypot(it.aDouble, db.getElementDoubleAbs(it.bIndex + j));
                            ++j;
                        }
                    }
                    break;
                }
                if (bs != 1) ** GOTO lbl260
                while (it.hasNext()) {
                    a64data[it.oIndex] = Math.hypot(it.aDouble, it.bDouble);
                    j = 1;
                    while (j < is) {
                        a64data[it.oIndex + j] = Math.hypot(da.getElementDoubleAbs(it.aIndex + j), it.bDouble);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    a64data[it.oIndex] = Math.hypot(it.aDouble, it.bDouble);
                    j = 1;
                    while (j < is) {
                        a64data[it.oIndex + j] = Math.hypot(da.getElementDoubleAbs(it.aIndex + j), db.getElementDoubleAbs(it.bIndex + j));
                        ++j;
                    }
lbl260:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl261:
                // 1 sources

                break;
            }
            default: {
                throw new UnsupportedOperationException("hypot does not support this dataset type");
            }
        }
        Maths.addFunctionName(da, db, result, "hypot");
        return result;
    }

    public static Dataset arctan2(Object a, Object b) {
        return Maths.arctan2(a, b, null);
    }

    /*
     * Unable to fully structure code
     */
    public static Dataset arctan2(Object a, Object b, Dataset o) {
        da = a instanceof Dataset != false ? (Dataset)a : DatasetFactory.createFromObject(a);
        db = b instanceof Dataset != false ? (Dataset)b : DatasetFactory.createFromObject(b);
        it = BroadcastIterator.createIterator(da, db, o, true);
        result = it.getOutput();
        is = result.getElementsPerItem();
        as = da.getElementsPerItem();
        bs = db.getElementsPerItem();
        dt = result.getDType();
        switch (dt) {
            case 0: {
                bdata = ((BooleanDataset)result).getData();
                while (it.hasNext()) {
                    v0 = bdata[it.oIndex] = Math.atan2(it.aDouble, it.bDouble) != 0.0;
                }
                break;
            }
            case 1: {
                i8data = ((ByteDataset)result).getData();
                while (it.hasNext()) {
                    i8data[it.oIndex] = (byte)Maths.toLong(Math.atan2(it.aDouble, it.bDouble));
                }
                break;
            }
            case 2: {
                i16data = ((ShortDataset)result).getData();
                while (it.hasNext()) {
                    i16data[it.oIndex] = (short)Maths.toLong(Math.atan2(it.aDouble, it.bDouble));
                }
                break;
            }
            case 3: {
                i32data = ((IntegerDataset)result).getData();
                while (it.hasNext()) {
                    i32data[it.oIndex] = (int)Maths.toLong(Math.atan2(it.aDouble, it.bDouble));
                }
                break;
            }
            case 4: {
                i64data = ((LongDataset)result).getData();
                while (it.hasNext()) {
                    i64data[it.oIndex] = Maths.toLong(Math.atan2(it.aDouble, it.bDouble));
                }
                break;
            }
            case 5: {
                f32data = ((FloatDataset)result).getData();
                while (it.hasNext()) {
                    f32data[it.oIndex] = (float)Math.atan2(it.aDouble, it.bDouble);
                }
                break;
            }
            case 6: {
                f64data = ((DoubleDataset)result).getData();
                while (it.hasNext()) {
                    f64data[it.oIndex] = Math.atan2(it.aDouble, it.bDouble);
                }
                break;
            }
            case 100: {
                ai8data = ((CompoundByteDataset)result).getData();
                if (is == 1) {
                    while (it.hasNext()) {
                        ai8data[it.oIndex] = (byte)Maths.toLong(Math.atan2(it.aDouble, it.bDouble));
                    }
                    break;
                }
                if (as == 1) {
                    while (it.hasNext()) {
                        ai8data[it.oIndex] = (byte)Maths.toLong(Math.atan2(it.aDouble, it.bDouble));
                        j = 1;
                        while (j < is) {
                            ai8data[it.oIndex + j] = (byte)Maths.toLong(Math.atan2(it.aDouble, db.getElementDoubleAbs(it.bIndex + j)));
                            ++j;
                        }
                    }
                    break;
                }
                if (bs != 1) ** GOTO lbl85
                while (it.hasNext()) {
                    ai8data[it.oIndex] = (byte)Maths.toLong(Math.atan2(it.aDouble, it.bDouble));
                    j = 1;
                    while (j < is) {
                        ai8data[it.oIndex + j] = (byte)Maths.toLong(Math.atan2(da.getElementDoubleAbs(it.aIndex + j), it.bDouble));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ai8data[it.oIndex] = (byte)Maths.toLong(Math.atan2(it.aDouble, it.bDouble));
                    j = 1;
                    while (j < is) {
                        ai8data[it.oIndex + j] = (byte)Maths.toLong(Math.atan2(da.getElementDoubleAbs(it.aIndex + j), db.getElementDoubleAbs(it.bIndex + j)));
                        ++j;
                    }
lbl85:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl86:
                // 1 sources

                break;
            }
            case 200: {
                ai16data = ((CompoundShortDataset)result).getData();
                if (is == 1) {
                    while (it.hasNext()) {
                        ai16data[it.oIndex] = (short)Maths.toLong(Math.atan2(it.aDouble, it.bDouble));
                    }
                    break;
                }
                if (as == 1) {
                    while (it.hasNext()) {
                        ai16data[it.oIndex] = (short)Maths.toLong(Math.atan2(it.aDouble, it.bDouble));
                        j = 1;
                        while (j < is) {
                            ai16data[it.oIndex + j] = (short)Maths.toLong(Math.atan2(it.aDouble, db.getElementDoubleAbs(it.bIndex + j)));
                            ++j;
                        }
                    }
                    break;
                }
                if (bs != 1) ** GOTO lbl120
                while (it.hasNext()) {
                    ai16data[it.oIndex] = (short)Maths.toLong(Math.atan2(it.aDouble, it.bDouble));
                    j = 1;
                    while (j < is) {
                        ai16data[it.oIndex + j] = (short)Maths.toLong(Math.atan2(da.getElementDoubleAbs(it.aIndex + j), it.bDouble));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ai16data[it.oIndex] = (short)Maths.toLong(Math.atan2(it.aDouble, it.bDouble));
                    j = 1;
                    while (j < is) {
                        ai16data[it.oIndex + j] = (short)Maths.toLong(Math.atan2(da.getElementDoubleAbs(it.aIndex + j), db.getElementDoubleAbs(it.bIndex + j)));
                        ++j;
                    }
lbl120:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl121:
                // 1 sources

                break;
            }
            case 300: {
                ai32data = ((CompoundIntegerDataset)result).getData();
                if (is == 1) {
                    while (it.hasNext()) {
                        ai32data[it.oIndex] = (int)Maths.toLong(Math.atan2(it.aDouble, it.bDouble));
                    }
                    break;
                }
                if (as == 1) {
                    while (it.hasNext()) {
                        ai32data[it.oIndex] = (int)Maths.toLong(Math.atan2(it.aDouble, it.bDouble));
                        j = 1;
                        while (j < is) {
                            ai32data[it.oIndex + j] = (int)Maths.toLong(Math.atan2(it.aDouble, db.getElementDoubleAbs(it.bIndex + j)));
                            ++j;
                        }
                    }
                    break;
                }
                if (bs != 1) ** GOTO lbl155
                while (it.hasNext()) {
                    ai32data[it.oIndex] = (int)Maths.toLong(Math.atan2(it.aDouble, it.bDouble));
                    j = 1;
                    while (j < is) {
                        ai32data[it.oIndex + j] = (int)Maths.toLong(Math.atan2(da.getElementDoubleAbs(it.aIndex + j), it.bDouble));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ai32data[it.oIndex] = (int)Maths.toLong(Math.atan2(it.aDouble, it.bDouble));
                    j = 1;
                    while (j < is) {
                        ai32data[it.oIndex + j] = (int)Maths.toLong(Math.atan2(da.getElementDoubleAbs(it.aIndex + j), db.getElementDoubleAbs(it.bIndex + j)));
                        ++j;
                    }
lbl155:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl156:
                // 1 sources

                break;
            }
            case 400: {
                ai64data = ((CompoundLongDataset)result).getData();
                if (is == 1) {
                    while (it.hasNext()) {
                        ai64data[it.oIndex] = Maths.toLong(Math.atan2(it.aDouble, it.bDouble));
                    }
                    break;
                }
                if (as == 1) {
                    while (it.hasNext()) {
                        ai64data[it.oIndex] = Maths.toLong(Math.atan2(it.aDouble, it.bDouble));
                        j = 1;
                        while (j < is) {
                            ai64data[it.oIndex + j] = Maths.toLong(Math.atan2(it.aDouble, db.getElementDoubleAbs(it.bIndex + j)));
                            ++j;
                        }
                    }
                    break;
                }
                if (bs != 1) ** GOTO lbl190
                while (it.hasNext()) {
                    ai64data[it.oIndex] = Maths.toLong(Math.atan2(it.aDouble, it.bDouble));
                    j = 1;
                    while (j < is) {
                        ai64data[it.oIndex + j] = Maths.toLong(Math.atan2(da.getElementDoubleAbs(it.aIndex + j), it.bDouble));
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ai64data[it.oIndex] = Maths.toLong(Math.atan2(it.aDouble, it.bDouble));
                    j = 1;
                    while (j < is) {
                        ai64data[it.oIndex + j] = Maths.toLong(Math.atan2(da.getElementDoubleAbs(it.aIndex + j), db.getElementDoubleAbs(it.bIndex + j)));
                        ++j;
                    }
lbl190:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl191:
                // 1 sources

                break;
            }
            case 500: {
                a32data = ((CompoundFloatDataset)result).getData();
                if (is == 1) {
                    while (it.hasNext()) {
                        a32data[it.oIndex] = (float)Math.atan2(it.aDouble, it.bDouble);
                    }
                    break;
                }
                if (as == 1) {
                    while (it.hasNext()) {
                        a32data[it.oIndex] = (float)Math.atan2(it.aDouble, it.bDouble);
                        j = 1;
                        while (j < is) {
                            a32data[it.oIndex + j] = (float)Math.atan2(it.aDouble, db.getElementDoubleAbs(it.bIndex + j));
                            ++j;
                        }
                    }
                    break;
                }
                if (bs != 1) ** GOTO lbl225
                while (it.hasNext()) {
                    a32data[it.oIndex] = (float)Math.atan2(it.aDouble, it.bDouble);
                    j = 1;
                    while (j < is) {
                        a32data[it.oIndex + j] = (float)Math.atan2(da.getElementDoubleAbs(it.aIndex + j), it.bDouble);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    a32data[it.oIndex] = (float)Math.atan2(it.aDouble, it.bDouble);
                    j = 1;
                    while (j < is) {
                        a32data[it.oIndex + j] = (float)Math.atan2(da.getElementDoubleAbs(it.aIndex + j), db.getElementDoubleAbs(it.bIndex + j));
                        ++j;
                    }
lbl225:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl226:
                // 1 sources

                break;
            }
            case 600: {
                a64data = ((CompoundDoubleDataset)result).getData();
                if (is == 1) {
                    while (it.hasNext()) {
                        a64data[it.oIndex] = Math.atan2(it.aDouble, it.bDouble);
                    }
                    break;
                }
                if (as == 1) {
                    while (it.hasNext()) {
                        a64data[it.oIndex] = Math.atan2(it.aDouble, it.bDouble);
                        j = 1;
                        while (j < is) {
                            a64data[it.oIndex + j] = Math.atan2(it.aDouble, db.getElementDoubleAbs(it.bIndex + j));
                            ++j;
                        }
                    }
                    break;
                }
                if (bs != 1) ** GOTO lbl260
                while (it.hasNext()) {
                    a64data[it.oIndex] = Math.atan2(it.aDouble, it.bDouble);
                    j = 1;
                    while (j < is) {
                        a64data[it.oIndex + j] = Math.atan2(da.getElementDoubleAbs(it.aIndex + j), it.bDouble);
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    a64data[it.oIndex] = Math.atan2(it.aDouble, it.bDouble);
                    j = 1;
                    while (j < is) {
                        a64data[it.oIndex + j] = Math.atan2(da.getElementDoubleAbs(it.aIndex + j), db.getElementDoubleAbs(it.bIndex + j));
                        ++j;
                    }
lbl260:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl261:
                // 1 sources

                break;
            }
            default: {
                throw new UnsupportedOperationException("atan2 does not support multiple-element dataset");
            }
        }
        Maths.addFunctionName(da, db, result, "atan2");
        return result;
    }

    public static Dataset angle(Object a) {
        return Maths.angle(a, false, null);
    }

    public static Dataset angle(Object a, boolean inDegrees) {
        return Maths.angle(a, inDegrees, null);
    }

    public static Dataset angle(Object a, Dataset o) {
        return Maths.angle(a, false, o);
    }

    /*
     * Unable to fully structure code
     */
    public static Dataset angle(Object a, boolean inDegrees, Dataset o) {
        v0 = da = a instanceof Dataset != false ? (Dataset)a : DatasetFactory.createFromObject(a);
        if (!da.isComplex()) {
            throw new UnsupportedOperationException("angle does not support this dataset type");
        }
        it = new SingleInputBroadcastIterator(da, o, true, false, false);
        result = it.getOutput();
        is = result.getElementsPerItem();
        dt = result.getDType();
        switch (dt) {
            case 1: {
                oi8data = ((ByteDataset)result).data;
                it.setOutputDouble(false);
                if (!inDegrees) ** GOTO lbl18
                while (it.hasNext()) {
                    oi8data[it.oIndex] = (byte)Maths.toLong(Math.toDegrees(Math.atan2(da.getElementDoubleAbs(it.aIndex + 1), it.aDouble)));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    oi8data[it.oIndex] = (byte)Maths.toLong(Math.atan2(da.getElementDoubleAbs(it.aIndex + 1), it.aDouble));
lbl18:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl19:
                // 1 sources

                break;
            }
            case 2: {
                oi16data = ((ShortDataset)result).data;
                it.setOutputDouble(false);
                if (!inDegrees) ** GOTO lbl29
                while (it.hasNext()) {
                    oi16data[it.oIndex] = (short)Maths.toLong(Math.toDegrees(Math.atan2(da.getElementDoubleAbs(it.aIndex + 1), it.aDouble)));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    oi16data[it.oIndex] = (short)Maths.toLong(Math.atan2(da.getElementDoubleAbs(it.aIndex + 1), it.aDouble));
lbl29:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl30:
                // 1 sources

                break;
            }
            case 3: {
                oi32data = ((IntegerDataset)result).data;
                it.setOutputDouble(false);
                if (!inDegrees) ** GOTO lbl40
                while (it.hasNext()) {
                    oi32data[it.oIndex] = (int)Maths.toLong(Math.toDegrees(Math.atan2(da.getElementDoubleAbs(it.aIndex + 1), it.aDouble)));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    oi32data[it.oIndex] = (int)Maths.toLong(Math.atan2(da.getElementDoubleAbs(it.aIndex + 1), it.aDouble));
lbl40:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl41:
                // 1 sources

                break;
            }
            case 4: {
                oi64data = ((LongDataset)result).data;
                it.setOutputDouble(false);
                if (!inDegrees) ** GOTO lbl51
                while (it.hasNext()) {
                    oi64data[it.oIndex] = Maths.toLong(Math.toDegrees(Math.atan2(da.getElementDoubleAbs(it.aIndex + 1), it.aDouble)));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    oi64data[it.oIndex] = Maths.toLong(Math.atan2(da.getElementDoubleAbs(it.aIndex + 1), it.aDouble));
lbl51:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl52:
                // 1 sources

                break;
            }
            case 100: {
                oai8data = ((CompoundByteDataset)result).data;
                it.setOutputDouble(false);
                if (!inDegrees) ** GOTO lbl72
                while (it.hasNext()) {
                    ox = (byte)Maths.toLong(Math.toDegrees(Math.atan2(da.getElementDoubleAbs(it.aIndex + 1), it.aDouble)));
                    j = 0;
                    while (j < is) {
                        oai8data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ox = (byte)Maths.toLong(Math.atan2(da.getElementDoubleAbs(it.aIndex + 1), it.aDouble));
                    j = 0;
                    while (j < is) {
                        oai8data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl72:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl73:
                // 1 sources

                break;
            }
            case 200: {
                oai16data = ((CompoundShortDataset)result).data;
                it.setOutputDouble(false);
                if (!inDegrees) ** GOTO lbl93
                while (it.hasNext()) {
                    ox = (short)Maths.toLong(Math.toDegrees(Math.atan2(da.getElementDoubleAbs(it.aIndex + 1), it.aDouble)));
                    j = 0;
                    while (j < is) {
                        oai16data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ox = (short)Maths.toLong(Math.atan2(da.getElementDoubleAbs(it.aIndex + 1), it.aDouble));
                    j = 0;
                    while (j < is) {
                        oai16data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl93:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl94:
                // 1 sources

                break;
            }
            case 300: {
                oai32data = ((CompoundIntegerDataset)result).data;
                it.setOutputDouble(false);
                if (!inDegrees) ** GOTO lbl114
                while (it.hasNext()) {
                    ox = (int)Maths.toLong(Math.toDegrees(Math.atan2(da.getElementDoubleAbs(it.aIndex + 1), it.aDouble)));
                    j = 0;
                    while (j < is) {
                        oai32data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ox = (int)Maths.toLong(Math.atan2(da.getElementDoubleAbs(it.aIndex + 1), it.aDouble));
                    j = 0;
                    while (j < is) {
                        oai32data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl114:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl115:
                // 1 sources

                break;
            }
            case 400: {
                oai64data = ((CompoundLongDataset)result).data;
                it.setOutputDouble(false);
                if (!inDegrees) ** GOTO lbl135
                while (it.hasNext()) {
                    ox = Maths.toLong(Math.toDegrees(Math.atan2(da.getElementDoubleAbs(it.aIndex + 1), it.aDouble)));
                    j = 0;
                    while (j < is) {
                        oai64data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ox = Maths.toLong(Math.atan2(da.getElementDoubleAbs(it.aIndex + 1), it.aDouble));
                    j = 0;
                    while (j < is) {
                        oai64data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl135:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl136:
                // 1 sources

                break;
            }
            case 5: {
                of32data = ((FloatDataset)result).data;
                if (!inDegrees) ** GOTO lbl145
                while (it.hasNext()) {
                    of32data[it.oIndex] = (float)Math.toDegrees(Math.atan2(da.getElementDoubleAbs(it.aIndex + 1), it.aDouble));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    of32data[it.oIndex] = (float)Math.atan2(da.getElementDoubleAbs(it.aIndex + 1), it.aDouble);
lbl145:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl146:
                // 1 sources

                break;
            }
            case 6: {
                of64data = ((DoubleDataset)result).data;
                if (!inDegrees) ** GOTO lbl155
                while (it.hasNext()) {
                    of64data[it.oIndex] = Math.toDegrees(Math.atan2(da.getElementDoubleAbs(it.aIndex + 1), it.aDouble));
                }
                break;
lbl-1000:
                // 1 sources

                {
                    of64data[it.oIndex] = Math.atan2(da.getElementDoubleAbs(it.aIndex + 1), it.aDouble);
lbl155:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl156:
                // 1 sources

                break;
            }
            case 500: {
                oaf32data = ((CompoundFloatDataset)result).data;
                if (!inDegrees) ** GOTO lbl175
                while (it.hasNext()) {
                    ox = (float)Math.toDegrees(Math.atan2(da.getElementDoubleAbs(it.aIndex + 1), it.aDouble));
                    j = 0;
                    while (j < is) {
                        oaf32data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ox = (float)Math.atan2(da.getElementDoubleAbs(it.aIndex + 1), it.aDouble);
                    j = 0;
                    while (j < is) {
                        oaf32data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl175:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl176:
                // 1 sources

                break;
            }
            case 600: {
                oaf64data = ((CompoundDoubleDataset)result).data;
                if (!inDegrees) ** GOTO lbl195
                while (it.hasNext()) {
                    ox = Math.toDegrees(Math.atan2(da.getElementDoubleAbs(it.aIndex + 1), it.aDouble));
                    j = 0;
                    while (j < is) {
                        oaf64data[it.oIndex + j] = ox;
                        ++j;
                    }
                }
                break;
lbl-1000:
                // 1 sources

                {
                    ox = Math.atan2(da.getElementDoubleAbs(it.aIndex + 1), it.aDouble);
                    j = 0;
                    while (j < is) {
                        oaf64data[it.oIndex + j] = ox;
                        ++j;
                    }
lbl195:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl196:
                // 1 sources

                break;
            }
            case 7: {
                oc64data = ((ComplexFloatDataset)result).data;
                if (!inDegrees) ** GOTO lbl207
                while (it.hasNext()) {
                    oc64data[it.oIndex] = (float)Math.toDegrees(Math.atan2(da.getElementDoubleAbs(it.aIndex + 1), it.aDouble));
                    oc64data[it.oIndex + 1] = 0.0f;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    oc64data[it.oIndex] = (float)Math.atan2(da.getElementDoubleAbs(it.aIndex + 1), it.aDouble);
                    oc64data[it.oIndex + 1] = 0.0f;
lbl207:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl208:
                // 1 sources

                break;
            }
            case 8: {
                oc128data = ((ComplexDoubleDataset)result).data;
                if (!inDegrees) ** GOTO lbl219
                while (it.hasNext()) {
                    oc128data[it.oIndex] = Math.toDegrees(Math.atan2(da.getElementDoubleAbs(it.aIndex + 1), it.aDouble));
                    oc128data[it.oIndex + 1] = 0.0;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    oc128data[it.oIndex] = Math.atan2(da.getElementDoubleAbs(it.aIndex + 1), it.aDouble);
                    oc128data[it.oIndex + 1] = 0.0;
lbl219:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl220:
                // 1 sources

                break;
            }
            default: {
                throw new IllegalArgumentException("angle does not support this dataset type");
            }
        }
        Maths.addFunctionName(result, "angle");
        return result;
    }

    public static Dataset phaseAsComplexNumber(Object a, boolean keepZeros) {
        return Maths.phaseAsComplexNumber(a, null, keepZeros);
    }

    /*
     * Unable to fully structure code
     */
    public static Dataset phaseAsComplexNumber(Object a, Dataset o, boolean keepZeros) {
        v0 = da = a instanceof Dataset != false ? (Dataset)a : DatasetFactory.createFromObject(a);
        if (!da.isComplex()) {
            throw new IllegalArgumentException("Input dataset is not of complex type");
        }
        v1 = result = o == null ? DatasetFactory.zeros(da) : o;
        if (!result.isComplex()) {
            throw new IllegalArgumentException("Output dataset is not of complex type");
        }
        dt = result.getDType();
        it = new SingleInputBroadcastIterator(da, result);
        switch (dt) {
            case 7: {
                z64data = ((ComplexFloatDataset)result).getData();
                if (!keepZeros) ** GOTO lbl30
                while (it.hasNext()) {
                    rr = it.aDouble;
                    ri = da.getElementDoubleAbs(it.aIndex + 1);
                    am = Math.hypot(rr, ri);
                    if (am == 0.0) {
                        z64data[it.oIndex] = 0.0f;
                        z64data[it.oIndex + 1] = 0.0f;
                        continue;
                    }
                    z64data[it.oIndex] = (float)(rr / am);
                    z64data[it.oIndex + 1] = (float)(ri / am);
                }
                break;
lbl-1000:
                // 1 sources

                {
                    rr = it.aDouble;
                    ri = da.getElementDoubleAbs(it.aIndex + 1);
                    am = Math.hypot(rr, ri);
                    z64data[it.oIndex] = (float)(rr / am);
                    z64data[it.oIndex + 1] = (float)(ri / am);
lbl30:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl31:
                // 1 sources

                break;
            }
            case 8: {
                z128data = ((ComplexDoubleDataset)result).getData();
                if (!keepZeros) ** GOTO lbl52
                while (it.hasNext()) {
                    rr = it.aDouble;
                    ri = da.getElementDoubleAbs(it.aIndex + 1);
                    am = Math.hypot(rr, ri);
                    if (am == 0.0) {
                        z128data[it.oIndex] = 0.0;
                        z128data[it.oIndex + 1] = 0.0;
                        continue;
                    }
                    z128data[it.oIndex] = rr / am;
                    z128data[it.oIndex + 1] = ri / am;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    rr = it.aDouble;
                    ri = da.getElementDoubleAbs(it.aIndex + 1);
                    am = Math.hypot(rr, ri);
                    z128data[it.oIndex] = rr / am;
                    z128data[it.oIndex + 1] = ri / am;
lbl52:
                    // 2 sources

                    ** while (it.hasNext())
                }
            }
        }
lbl53:
        // 5 sources

        Maths.addFunctionName(result, "phase");
        return result;
    }

    public static Dataset add(Collection<IDataset> sets, boolean requireClone) {
        if (sets.isEmpty()) {
            return null;
        }
        Iterator<IDataset> it = sets.iterator();
        if (sets.size() == 1) {
            return DatasetUtils.convertToDataset(it.next());
        }
        Dataset sum = requireClone ? ((Dataset)it.next()).clone() : (Dataset)it.next();
        while (it.hasNext()) {
            Maths.add(sum, it.next(), sum);
        }
        return sum;
    }

    public static Dataset multiply(Collection<IDataset> sets, boolean requireClone) {
        if (sets.isEmpty()) {
            return null;
        }
        Iterator<IDataset> it = sets.iterator();
        if (sets.size() == 1) {
            return DatasetUtils.convertToDataset(it.next());
        }
        Dataset product = requireClone ? ((Dataset)it.next()).clone() : (Dataset)it.next();
        while (it.hasNext()) {
            Maths.multiply(product, it.next(), product);
        }
        return product;
    }

    public static Dataset interpolate(Dataset x, Dataset d, IDataset x0, Number left, Number right) {
        boolean isReversed;
        assert (x.getRank() == 1);
        assert (d.getRank() == 1);
        DoubleDataset r = DatasetFactory.zeros(DoubleDataset.class, x0.getShape());
        Comparisons.Monotonicity mono = Comparisons.findMonotonicity(x);
        if (mono == Comparisons.Monotonicity.NOT_ORDERED) {
            throw new IllegalArgumentException("Dataset x must be ordered");
        }
        DoubleDataset dx = (DoubleDataset)DatasetUtils.cast(x, 6);
        Dataset dx0 = DatasetUtils.convertToDataset(x0);
        if (x == dx) {
            dx = (DoubleDataset)x.flatten();
        }
        double[] xa = dx.getData();
        int s = xa.length - 1;
        boolean bl = isReversed = mono == Comparisons.Monotonicity.STRICTLY_DECREASING || mono == Comparisons.Monotonicity.NONINCREASING;
        if (isReversed) {
            double[] txa = (double[])xa.clone();
            int i = 0;
            while (i <= s) {
                txa[s - i] = xa[i];
                ++i;
            }
            xa = txa;
        }
        IndexIterator it = dx0.getIterator();
        int k = -1;
        while (it.hasNext()) {
            ++k;
            double v = dx0.getElementDoubleAbs(it.index);
            int i = Arrays.binarySearch(xa, v);
            if (i < 0) {
                double t;
                double d1;
                if (i == -1) {
                    if (left != null) {
                        r.setAbs(k, left.doubleValue());
                        continue;
                    }
                    d1 = xa[0] - xa[1];
                    t = d1 - v + xa[0];
                    if (t >= 0.0) continue;
                    r.setAbs(k, (t /= d1) * d.getDouble(isReversed ? s : 0));
                    continue;
                }
                if (i == -s - 2) {
                    if (right != null) {
                        r.setAbs(k, right.doubleValue());
                        continue;
                    }
                    d1 = xa[s] - xa[s - 1];
                    t = d1 - v + xa[s];
                    if (t <= 0.0) continue;
                    r.setAbs(k, (t /= d1) * d.getDouble(isReversed ? 0 : s));
                    continue;
                }
                i = -i - 1;
                double t2 = (xa[i] - v) / (xa[i] - xa[i - 1]);
                if (isReversed) {
                    i = s - i;
                    r.setAbs(k, t2 * d.getDouble(i + 1) + (1.0 - t2) * d.getDouble(i));
                    continue;
                }
                r.setAbs(k, (1.0 - t2) * d.getDouble(i) + t2 * d.getDouble(i - 1));
                continue;
            }
            r.setAbs(k, d.getDouble(isReversed ? s - i : i));
        }
        return r;
    }

    public static double interpolate(Dataset d, double x0) {
        double f1;
        assert (d.getRank() == 1);
        int i0 = (int)Math.floor(x0);
        int e0 = d.getSize() - 1;
        if (i0 < -1 || i0 > e0) {
            return 0.0;
        }
        double u0 = x0 - (double)i0;
        double r = 0.0;
        double d2 = f1 = i0 < 0 ? 0.0 : d.getDouble(i0);
        r = u0 > 0.0 ? (1.0 - u0) * f1 + (i0 == e0 ? 0.0 : u0 * d.getDouble(i0 + 1)) : f1;
        return r;
    }

    public static double interpolate(Dataset d, Dataset m, double x0) {
        double f1;
        assert (d.getRank() == 1);
        assert (m.getRank() == 1);
        int i0 = (int)Math.floor(x0);
        int e0 = d.getSize() - 1;
        if (i0 < -1 || i0 > e0) {
            return 0.0;
        }
        double u0 = x0 - (double)i0;
        double r = 0.0;
        double d2 = f1 = i0 < 0 ? 0.0 : d.getDouble(i0) * m.getDouble(i0);
        r = u0 > 0.0 ? (1.0 - u0) * f1 + (i0 == e0 ? 0.0 : u0 * d.getDouble(i0 + 1) * m.getDouble(i0 + 1)) : f1;
        return r;
    }

    public static void interpolate(double[] values, CompoundDataset d, double x0) {
        assert (d.getRank() == 1);
        int is = d.getElementsPerItem();
        if (is != values.length) {
            throw new IllegalArgumentException("Output array length must match elements in item");
        }
        int i0 = (int)Math.floor(x0);
        int e0 = d.getSize() - 1;
        if (i0 < -1 || i0 > e0) {
            Arrays.fill(values, 0.0);
            return;
        }
        double u0 = x0 - (double)i0;
        if (u0 > 0.0) {
            double[] f1 = new double[is];
            if (i0 >= 0) {
                d.getDoubleArray(f1, i0);
            }
            double t = 1.0 - u0;
            if (i0 == e0) {
                int j = 0;
                while (j < is) {
                    values[j] = t * f1[j];
                    ++j;
                }
            } else {
                double[] f2 = new double[is];
                d.getDoubleArray(f2, i0 + 1);
                int j = 0;
                while (j < is) {
                    values[j] = t * f1[j] + u0 * f2[j];
                    ++j;
                }
            }
        } else if (i0 >= 0) {
            d.getDoubleArray(values, i0);
        } else {
            Arrays.fill(values, 0.0);
        }
    }

    public static double interpolate(Dataset d, double x0, double x1) {
        double f1;
        int[] s = d.getShape();
        assert (s.length == 2);
        int e0 = s[0] - 1;
        int e1 = s[1] - 1;
        int i0 = (int)Math.floor(x0);
        int i1 = (int)Math.floor(x1);
        double u0 = x0 - (double)i0;
        double u1 = x1 - (double)i1;
        if (i0 < -1 || i0 > e0 || i1 < -1 || i1 > e1) {
            return 0.0;
        }
        double r = 0.0;
        double d2 = f1 = i0 < 0 || i1 < 0 ? 0.0 : d.getDouble(i0, i1);
        if (u1 > 0.0) {
            if (u0 > 0.0) {
                double f3;
                double f4;
                double f2;
                if (i0 == e0) {
                    f2 = 0.0;
                    f4 = 0.0;
                    f3 = i1 == e1 ? 0.0 : d.getDouble(i0, i1 + 1);
                } else {
                    double d3 = f2 = i1 < 0 ? 0.0 : d.getDouble(i0 + 1, i1);
                    if (i1 == e1) {
                        f4 = 0.0;
                        f3 = 0.0;
                    } else {
                        f4 = d.getDouble(i0 + 1, i1 + 1);
                        f3 = i0 < 0 ? 0.0 : d.getDouble(i0, i1 + 1);
                    }
                }
                r = (1.0 - u0) * (1.0 - u1) * f1 + u0 * (1.0 - u1) * f2 + (1.0 - u0) * u1 * f3 + u0 * u1 * f4;
            } else {
                double f3 = i0 < 0 || i1 == e1 ? 0.0 : d.getDouble(i0, i1 + 1);
                r = (1.0 - u1) * f1 + u1 * f3;
            }
        } else if (u0 > 0.0) {
            double f2 = i0 == e0 || i1 < 0 ? 0.0 : d.getDouble(i0 + 1, i1);
            r = (1.0 - u0) * f1 + u0 * f2;
        } else {
            r = f1;
        }
        return r;
    }

    public static double interpolate(Dataset d, Dataset m, double x0, double x1) {
        double f1;
        if (m == null) {
            return Maths.interpolate(d, x0, x1);
        }
        int[] s = d.getShape();
        assert (s.length == 2);
        assert (m.getRank() == 2);
        int e0 = s[0] - 1;
        int e1 = s[1] - 1;
        int i0 = (int)Math.floor(x0);
        int i1 = (int)Math.floor(x1);
        double u0 = x0 - (double)i0;
        double u1 = x1 - (double)i1;
        if (i0 < -1 || i0 > e0 || i1 < -1 || i1 > e1) {
            return 0.0;
        }
        double r = 0.0;
        double d2 = f1 = i0 < 0 || i1 < 0 ? 0.0 : d.getDouble(i0, i1) * m.getDouble(i0, i1);
        if (u1 > 0.0) {
            double f3;
            double f4;
            double f2;
            if (i0 == e0) {
                f2 = 0.0;
                f4 = 0.0;
                f3 = i1 == e1 ? 0.0 : d.getDouble(i0, i1 + 1) * m.getDouble(i0, i1 + 1);
            } else {
                double d3 = f2 = i1 < 0 ? 0.0 : d.getDouble(i0 + 1, i1) * m.getDouble(i0 + 1, i1);
                if (i1 == e1) {
                    f4 = 0.0;
                    f3 = 0.0;
                } else {
                    f4 = d.getDouble(i0 + 1, i1 + 1) * m.getDouble(i0 + 1, i1 + 1);
                    f3 = i0 < 0 ? 0.0 : d.getDouble(i0, i1 + 1) * m.getDouble(i0, i1 + 1);
                }
            }
            r = (1.0 - u0) * (1.0 - u1) * f1 + u0 * (1.0 - u1) * f2 + (1.0 - u0) * u1 * f3 + u0 * u1 * f4;
        } else if (u0 > 0.0) {
            double f2 = i0 == e0 || i1 < 0 ? 0.0 : d.getDouble(i0 + 1, i1) * m.getDouble(i0 + 1, i1);
            r = (1.0 - u0) * f1 + u0 * f2;
        } else {
            r = f1;
        }
        return r;
    }

    public static void interpolate(double[] values, CompoundDataset d, double x0, double x1) {
        int[] s = d.getShapeRef();
        assert (s.length == 2);
        int is = d.getElementsPerItem();
        if (is != values.length) {
            throw new IllegalArgumentException("Output array length must match elements in item");
        }
        int e0 = s[0] - 1;
        int e1 = s[1] - 1;
        int i0 = (int)Math.floor(x0);
        int i1 = (int)Math.floor(x1);
        double u0 = x0 - (double)i0;
        double u1 = x1 - (double)i1;
        if (i0 < -1 || i0 > e0 || i1 < -1 || i1 > e1) {
            Arrays.fill(values, 0.0);
            return;
        }
        double[] f1 = new double[is];
        if (i0 >= 0 && i1 >= 0) {
            d.getDoubleArray(f1, i0, i1);
        }
        if (u1 > 0.0) {
            if (u0 > 0.0) {
                double[] f2 = new double[is];
                double[] f3 = new double[is];
                double[] f4 = new double[is];
                if (i0 != e0) {
                    if (i1 != e1) {
                        d.getDoubleArray(f3, i0 + 1, i1 + 1);
                    }
                    if (i1 >= 0) {
                        d.getDoubleArray(f4, i0 + 1, i1);
                    }
                }
                if (i0 >= 0 && i1 != e1) {
                    d.getDoubleArray(f2, i0, i1 + 1);
                }
                double t0 = 1.0 - u0;
                double t1 = 1.0 - u1;
                double w1 = t0 * t1;
                double w2 = t0 * u1;
                double w3 = u0 * u1;
                double w4 = u0 * t1;
                int j = 0;
                while (j < is) {
                    values[j] = w1 * f1[j] + w2 * f2[j] + w3 * f3[j] + w4 * f4[j];
                    ++j;
                }
            } else {
                double[] f2 = new double[is];
                if (i0 >= 0 && i1 != e1) {
                    d.getDoubleArray(f2, i0, i1 + 1);
                }
                double t1 = 1.0 - u1;
                int j = 0;
                while (j < is) {
                    values[j] = t1 * f1[j] + u1 * f2[j];
                    ++j;
                }
            }
        } else if (u0 > 0.0) {
            double[] f4 = new double[is];
            if (i0 != e0 && i1 >= 0) {
                d.getDoubleArray(f4, i0 + 1, i1);
            }
            double t0 = 1.0 - u0;
            int j = 0;
            while (j < is) {
                values[j] = t0 * f1[j] + u0 * f4[j];
                ++j;
            }
        } else if (i0 >= 0 && i1 >= 0) {
            d.getDoubleArray(values, i0, i1);
        } else {
            Arrays.fill(values, 0.0);
        }
    }

    public static double interpolate(Dataset d, double ... x) {
        return Maths.interpolate(d, null, x);
    }

    /*
     * Unable to fully structure code
     */
    public static double interpolate(Dataset d, Dataset m, double ... x) {
        block14: {
            r = d.getRank();
            if (r != x.length) {
                throw new IllegalArgumentException("Number of coordinates must be equal to rank of dataset");
            }
            switch (r) {
                case 1: {
                    return m == null ? Maths.interpolate(d, x[0]) : Maths.interpolate(d, m, x[0]);
                }
                case 2: {
                    return m == null ? Maths.interpolate(d, x[0], x[1]) : Maths.interpolate(d, m, x[0], x[1]);
                }
            }
            if (m != null && r != m.getRank()) {
                throw new IllegalArgumentException("Rank of mask dataset must be equal to rank of dataset");
            }
            l = new int[r];
            f = new double[r];
            i = 0;
            while (i < r) {
                xi = x[i];
                l[i] = (int)Math.floor(xi);
                f[i] = xi - (double)l[i];
                ++i;
            }
            s = d.getShape();
            n = 1 << r;
            results = new double[n];
            twos = new int[r];
            Arrays.fill(twos, 2);
            it = new PositionIterator(twos);
            ip = it.getPos();
            j = 0;
            if (m != null) ** GOTO lbl56
            while (it.hasNext()) {
                p = (int[])l.clone();
                omit = false;
                i = 0;
                while (i < r) {
                    pi = p[i] + ip[i];
                    if (pi < 0 || pi >= s[i]) {
                        omit = true;
                        break;
                    }
                    p[i] = pi;
                    ++i;
                }
                v0 = results[j++] = omit != false ? 0.0 : d.getDouble(p);
            }
            break block14;
lbl-1000:
            // 1 sources

            {
                p = (int[])l.clone();
                omit = false;
                i = 0;
                while (i < r) {
                    pi = p[i] + ip[i];
                    if (pi < 0 || pi >= s[i]) {
                        omit = true;
                        break;
                    }
                    p[i] = pi;
                    ++i;
                }
                v1 = results[j++] = omit != false ? 0.0 : d.getDouble(p) * m.getDouble(p);
lbl56:
                // 2 sources

                ** while (it.hasNext())
            }
        }
        i = r - 1;
        while (i >= 0) {
            results = Maths.combine(results, f[i], 1 << i);
            --i;
        }
        return results[0];
    }

    private static double[] combine(double[] values, double f, int n) {
        double g = 1.0 - f;
        double[] results = new double[n];
        int j = 0;
        while (j < n) {
            int tj = 2 * j;
            results[j] = g * values[tj] + f * values[tj + 1];
            ++j;
        }
        return results;
    }

    public static void interpolate(double[] values, CompoundDataset d, double ... x) {
        int r = d.getRank();
        if (r != x.length) {
            throw new IllegalArgumentException("Number of coordinates must be equal to rank of dataset");
        }
        switch (r) {
            case 1: {
                Maths.interpolate(values, d, x[0]);
                return;
            }
            case 2: {
                Maths.interpolate(values, d, x[0], x[1]);
                return;
            }
        }
        int is = d.getElementsPerItem();
        if (is != values.length) {
            throw new IllegalArgumentException("Output array length must match elements in item");
        }
        int[] l = new int[r];
        double[] f = new double[r];
        int i = 0;
        while (i < r) {
            double xi = x[i];
            l[i] = (int)Math.floor(xi);
            f[i] = xi - (double)l[i];
            ++i;
        }
        int[] s = d.getShape();
        int n = 1 << r;
        double[][] results = new double[n][is];
        int[] twos = new int[r];
        Arrays.fill(twos, 2);
        PositionIterator it = new PositionIterator(twos);
        int[] ip = it.getPos();
        int j = 0;
        while (it.hasNext()) {
            int[] p = (int[])l.clone();
            boolean omit = false;
            int i2 = 0;
            while (i2 < r) {
                int pi = p[i2] + ip[i2];
                if (pi < 0 || pi >= s[i2]) {
                    omit = true;
                    break;
                }
                p[i2] = pi;
                ++i2;
            }
            if (omit) continue;
            d.getDoubleArray(results[j++], p);
        }
        int i3 = r - 1;
        while (i3 >= 0) {
            results = Maths.combineArray(is, results, f[i3], 1 << i3);
            --i3;
        }
        int k = 0;
        while (k < is) {
            values[k] = results[0][k];
            ++k;
        }
    }

    private static double[][] combineArray(int is, double[][] values, double f, int n) {
        double g = 1.0 - f;
        double[][] results = new double[n][is];
        int j = 0;
        while (j < n) {
            int tj = 2 * j;
            int k = 0;
            while (k < is) {
                results[j][k] = g * values[tj][k] + f * values[tj + 1][k];
                ++k;
            }
            ++j;
        }
        return results;
    }

    @Deprecated
    public static double getLinear(IDataset d, double x0) {
        return Maths.interpolate(DatasetUtils.convertToDataset(d), x0);
    }

    @Deprecated
    public static void getLinear(double[] values, CompoundDataset d, double x0) {
        Maths.interpolate(values, d, x0);
    }

    @Deprecated
    public static double getBilinear(IDataset d, double x0, double x1) {
        return Maths.interpolate(DatasetUtils.convertToDataset(d), x0, x1);
    }

    @Deprecated
    public static double getBilinear(IDataset d, IDataset m, double x0, double x1) {
        return Maths.interpolate(DatasetUtils.convertToDataset(d), DatasetUtils.convertToDataset(m), x0, x1);
    }

    @Deprecated
    public static void getBilinear(double[] values, CompoundDataset d, double x0, double x1) {
        Maths.interpolate(values, d, x0, x1);
    }

    private static int[] bincoeff(int n) {
        int bc;
        int[] b = new int[n + 1];
        int hn = n / 2;
        b[0] = bc = 1;
        int i = 1;
        while (i <= hn) {
            b[i] = bc = -(bc * (n - i + 1)) / i;
            ++i;
        }
        if (n % 2 != 0) {
            i = hn + 1;
            while (i <= n) {
                b[i] = -b[n - i];
                ++i;
            }
        } else {
            i = hn + 1;
            while (i <= n) {
                b[i] = b[n - i];
                ++i;
            }
        }
        return b;
    }

    private static void difference(Dataset a, Dataset out) {
        int isize = a.getElementsPerItem();
        IndexIterator it = a.getIterator();
        if (!it.hasNext()) {
            return;
        }
        int oi = it.index;
        switch (a.getDType()) {
            case 1: {
                byte[] i8data = ((ByteDataset)a).data;
                byte[] oi8data = ((ByteDataset)out).getData();
                int i = 0;
                while (it.hasNext()) {
                    oi8data[i++] = (byte)(i8data[it.index] - i8data[oi]);
                    oi = it.index;
                }
                break;
            }
            case 2: {
                short[] i16data = ((ShortDataset)a).data;
                short[] oi16data = ((ShortDataset)out).getData();
                int i = 0;
                while (it.hasNext()) {
                    oi16data[i++] = (short)(i16data[it.index] - i16data[oi]);
                    oi = it.index;
                }
                break;
            }
            case 3: {
                int[] i32data = ((IntegerDataset)a).data;
                int[] oi32data = ((IntegerDataset)out).getData();
                int i = 0;
                while (it.hasNext()) {
                    oi32data[i++] = i32data[it.index] - i32data[oi];
                    oi = it.index;
                }
                break;
            }
            case 4: {
                long[] i64data = ((LongDataset)a).data;
                long[] oi64data = ((LongDataset)out).getData();
                int i = 0;
                while (it.hasNext()) {
                    oi64data[i++] = i64data[it.index] - i64data[oi];
                    oi = it.index;
                }
                break;
            }
            case 100: {
                byte[] ai8data = ((CompoundByteDataset)a).data;
                byte[] oai8data = ((CompoundByteDataset)out).getData();
                int i = 0;
                while (it.hasNext()) {
                    int k = 0;
                    while (k < isize) {
                        oai8data[i++] = (byte)(ai8data[it.index + k] - ai8data[oi++]);
                        ++k;
                    }
                    oi = it.index;
                }
                break;
            }
            case 200: {
                short[] ai16data = ((CompoundShortDataset)a).data;
                short[] oai16data = ((CompoundShortDataset)out).getData();
                int i = 0;
                while (it.hasNext()) {
                    int k = 0;
                    while (k < isize) {
                        oai16data[i++] = (short)(ai16data[it.index + k] - ai16data[oi++]);
                        ++k;
                    }
                    oi = it.index;
                }
                break;
            }
            case 300: {
                int[] ai32data = ((CompoundIntegerDataset)a).data;
                int[] oai32data = ((CompoundIntegerDataset)out).getData();
                int i = 0;
                while (it.hasNext()) {
                    int k = 0;
                    while (k < isize) {
                        oai32data[i++] = ai32data[it.index + k] - ai32data[oi++];
                        ++k;
                    }
                    oi = it.index;
                }
                break;
            }
            case 400: {
                long[] ai64data = ((CompoundLongDataset)a).data;
                long[] oai64data = ((CompoundLongDataset)out).getData();
                int i = 0;
                while (it.hasNext()) {
                    int k = 0;
                    while (k < isize) {
                        oai64data[i++] = ai64data[it.index + k] - ai64data[oi++];
                        ++k;
                    }
                    oi = it.index;
                }
                break;
            }
            case 5: {
                float[] f32data = ((FloatDataset)a).data;
                float[] of32data = ((FloatDataset)out).getData();
                int i = 0;
                while (it.hasNext()) {
                    of32data[i++] = f32data[it.index] - f32data[oi];
                    oi = it.index;
                }
                break;
            }
            case 6: {
                double[] f64data = ((DoubleDataset)a).data;
                double[] of64data = ((DoubleDataset)out).getData();
                int i = 0;
                while (it.hasNext()) {
                    of64data[i++] = f64data[it.index] - f64data[oi];
                    oi = it.index;
                }
                break;
            }
            case 7: {
                float[] c64data = ((ComplexFloatDataset)a).data;
                float[] oc64data = ((ComplexFloatDataset)out).getData();
                int i = 0;
                while (it.hasNext()) {
                    oc64data[i++] = c64data[it.index] - c64data[oi];
                    oc64data[i++] = c64data[it.index + 1] - c64data[oi + 1];
                    oi = it.index;
                }
                break;
            }
            case 8: {
                double[] c128data = ((ComplexDoubleDataset)a).data;
                double[] oc128data = ((ComplexDoubleDataset)out).getData();
                int i = 0;
                while (it.hasNext()) {
                    oc128data[i++] = c128data[it.index] - c128data[oi];
                    oc128data[i++] = c128data[it.index + 1] - c128data[oi + 1];
                    oi = it.index;
                }
                break;
            }
            case 500: {
                float[] af32data = ((CompoundFloatDataset)a).data;
                float[] oaf32data = ((CompoundFloatDataset)out).getData();
                int i = 0;
                while (it.hasNext()) {
                    int k = 0;
                    while (k < isize) {
                        oaf32data[i++] = af32data[it.index + k] - af32data[oi++];
                        ++k;
                    }
                    oi = it.index;
                }
                break;
            }
            case 600: {
                double[] af64data = ((CompoundDoubleDataset)a).data;
                double[] oaf64data = ((CompoundDoubleDataset)out).getData();
                int i = 0;
                while (it.hasNext()) {
                    int k = 0;
                    while (k < isize) {
                        oaf64data[i++] = af64data[it.index + k] - af64data[oi++];
                        ++k;
                    }
                    oi = it.index;
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("difference does not support this dataset type");
            }
        }
    }

    private static boolean nextIndexes(IndexIterator it, int[] indexes) {
        if (!it.hasNext()) {
            return false;
        }
        int m = indexes.length;
        int i = 0;
        i = 0;
        while (i < m - 1) {
            indexes[i] = indexes[i + 1];
            ++i;
        }
        indexes[i] = it.index;
        return true;
    }

    private static void difference(Dataset a, Dataset out, int n) {
        if (n == 1) {
            Maths.difference(a, out);
            return;
        }
        int isize = a.getElementsPerItem();
        int[] coeff = Maths.bincoeff(n);
        int m = n + 1;
        int[] indexes = new int[m];
        IndexIterator it = a.getIterator();
        int i = 0;
        while (i < n) {
            indexes[i] = it.index;
            it.hasNext();
            ++i;
        }
        indexes[n] = it.index;
        switch (a.getDType()) {
            case 1: {
                byte[] i8data = ((ByteDataset)a).data;
                byte[] oi8data = ((ByteDataset)out).getData();
                int i2 = 0;
                while (Maths.nextIndexes(it, indexes)) {
                    int ox = 0;
                    int j = 0;
                    while (j < m) {
                        ox += i8data[indexes[j]] * coeff[j];
                        ++j;
                    }
                    oi8data[i2++] = (byte)ox;
                }
                break;
            }
            case 2: {
                short[] i16data = ((ShortDataset)a).data;
                short[] oi16data = ((ShortDataset)out).getData();
                int i3 = 0;
                while (Maths.nextIndexes(it, indexes)) {
                    int ox = 0;
                    int j = 0;
                    while (j < m) {
                        ox += i16data[indexes[j]] * coeff[j];
                        ++j;
                    }
                    oi16data[i3++] = (short)ox;
                }
                break;
            }
            case 3: {
                int[] i32data = ((IntegerDataset)a).data;
                int[] oi32data = ((IntegerDataset)out).getData();
                int i4 = 0;
                while (Maths.nextIndexes(it, indexes)) {
                    int ox = 0;
                    int j = 0;
                    while (j < m) {
                        ox += i32data[indexes[j]] * coeff[j];
                        ++j;
                    }
                    oi32data[i4++] = ox;
                }
                break;
            }
            case 4: {
                long[] i64data = ((LongDataset)a).data;
                long[] oi64data = ((LongDataset)out).getData();
                int i5 = 0;
                while (Maths.nextIndexes(it, indexes)) {
                    long ox = 0L;
                    int j = 0;
                    while (j < m) {
                        ox += i64data[indexes[j]] * (long)coeff[j];
                        ++j;
                    }
                    oi64data[i5++] = ox;
                }
                break;
            }
            case 100: {
                byte[] ai8data = ((CompoundByteDataset)a).data;
                byte[] oai8data = ((CompoundByteDataset)out).getData();
                int[] box = new int[isize];
                int i6 = 0;
                while (Maths.nextIndexes(it, indexes)) {
                    Arrays.fill(box, 0);
                    int j = 0;
                    while (j < m) {
                        double c = coeff[j];
                        int l = indexes[j];
                        int k = 0;
                        while (k < isize) {
                            int n2 = k++;
                            box[n2] = (int)((double)box[n2] + (double)ai8data[l++] * c);
                        }
                        ++j;
                    }
                    int k = 0;
                    while (k < isize) {
                        oai8data[i6++] = (byte)box[k];
                        ++k;
                    }
                }
                break;
            }
            case 200: {
                short[] ai16data = ((CompoundShortDataset)a).data;
                short[] oai16data = ((CompoundShortDataset)out).getData();
                int[] sox = new int[isize];
                int i7 = 0;
                while (Maths.nextIndexes(it, indexes)) {
                    Arrays.fill(sox, 0);
                    int j = 0;
                    while (j < m) {
                        double c = coeff[j];
                        int l = indexes[j];
                        int k = 0;
                        while (k < isize) {
                            int n3 = k++;
                            sox[n3] = (int)((double)sox[n3] + (double)ai16data[l++] * c);
                        }
                        ++j;
                    }
                    int k = 0;
                    while (k < isize) {
                        oai16data[i7++] = (short)sox[k];
                        ++k;
                    }
                }
                break;
            }
            case 300: {
                int[] ai32data = ((CompoundIntegerDataset)a).data;
                int[] oai32data = ((CompoundIntegerDataset)out).getData();
                int[] iox = new int[isize];
                int i8 = 0;
                while (Maths.nextIndexes(it, indexes)) {
                    Arrays.fill(iox, 0);
                    int j = 0;
                    while (j < m) {
                        double c = coeff[j];
                        int l = indexes[j];
                        int k = 0;
                        while (k < isize) {
                            int n4 = k++;
                            iox[n4] = (int)((double)iox[n4] + (double)ai32data[l++] * c);
                        }
                        ++j;
                    }
                    int k = 0;
                    while (k < isize) {
                        oai32data[i8++] = iox[k];
                        ++k;
                    }
                }
                break;
            }
            case 400: {
                long[] ai64data = ((CompoundLongDataset)a).data;
                long[] oai64data = ((CompoundLongDataset)out).getData();
                long[] lox = new long[isize];
                int i9 = 0;
                while (Maths.nextIndexes(it, indexes)) {
                    Arrays.fill(lox, 0L);
                    int j = 0;
                    while (j < m) {
                        double c = coeff[j];
                        int l = indexes[j];
                        int k = 0;
                        while (k < isize) {
                            int n5 = k++;
                            lox[n5] = (long)((double)lox[n5] + (double)ai64data[l++] * c);
                        }
                        ++j;
                    }
                    int k = 0;
                    while (k < isize) {
                        oai64data[i9++] = lox[k];
                        ++k;
                    }
                }
                break;
            }
            case 5: {
                float[] f32data = ((FloatDataset)a).data;
                float[] of32data = ((FloatDataset)out).getData();
                int i10 = 0;
                while (Maths.nextIndexes(it, indexes)) {
                    float ox = 0.0f;
                    int j = 0;
                    while (j < m) {
                        ox += f32data[indexes[j]] * (float)coeff[j];
                        ++j;
                    }
                    of32data[i10++] = ox;
                }
                break;
            }
            case 6: {
                double[] f64data = ((DoubleDataset)a).data;
                double[] of64data = ((DoubleDataset)out).getData();
                int i11 = 0;
                while (Maths.nextIndexes(it, indexes)) {
                    double ox = 0.0;
                    int j = 0;
                    while (j < m) {
                        ox += f64data[indexes[j]] * (double)coeff[j];
                        ++j;
                    }
                    of64data[i11++] = ox;
                }
                break;
            }
            case 7: {
                float[] c64data = ((ComplexFloatDataset)a).data;
                float[] oc64data = ((ComplexFloatDataset)out).getData();
                int i12 = 0;
                while (Maths.nextIndexes(it, indexes)) {
                    float ox = 0.0f;
                    float oy = 0.0f;
                    int j = 0;
                    while (j < m) {
                        int l = indexes[j];
                        ox += c64data[l++] * (float)coeff[j];
                        oy += c64data[l] * (float)coeff[j];
                        ++j;
                    }
                    oc64data[i12++] = ox;
                    oc64data[i12++] = oy;
                }
                break;
            }
            case 8: {
                double[] c128data = ((ComplexDoubleDataset)a).data;
                double[] oc128data = ((ComplexDoubleDataset)out).getData();
                int i13 = 0;
                while (Maths.nextIndexes(it, indexes)) {
                    double ox = 0.0;
                    double oy = 0.0;
                    int j = 0;
                    while (j < m) {
                        int l = indexes[j];
                        ox += c128data[l++] * (double)coeff[j];
                        oy += c128data[l] * (double)coeff[j];
                        ++j;
                    }
                    oc128data[i13++] = ox;
                    oc128data[i13++] = oy;
                }
                break;
            }
            case 500: {
                float[] af32data = ((CompoundFloatDataset)a).data;
                float[] oaf32data = ((CompoundFloatDataset)out).getData();
                float[] fox = new float[isize];
                int i14 = 0;
                while (Maths.nextIndexes(it, indexes)) {
                    Arrays.fill(fox, 0.0f);
                    int j = 0;
                    while (j < m) {
                        double c = coeff[j];
                        int l = indexes[j];
                        int k = 0;
                        while (k < isize) {
                            int n6 = k++;
                            fox[n6] = (float)((double)fox[n6] + (double)af32data[l++] * c);
                        }
                        ++j;
                    }
                    int k = 0;
                    while (k < isize) {
                        oaf32data[i14++] = fox[k];
                        ++k;
                    }
                }
                break;
            }
            case 600: {
                double[] af64data = ((CompoundDoubleDataset)a).data;
                double[] oaf64data = ((CompoundDoubleDataset)out).getData();
                double[] dox = new double[isize];
                int i15 = 0;
                while (Maths.nextIndexes(it, indexes)) {
                    Arrays.fill(dox, 0.0);
                    int j = 0;
                    while (j < m) {
                        double c = coeff[j];
                        int l = indexes[j];
                        int k = 0;
                        while (k < isize) {
                            int n7 = k++;
                            dox[n7] = dox[n7] + af64data[l++] * c;
                        }
                        ++j;
                    }
                    int k = 0;
                    while (k < isize) {
                        oaf64data[i15++] = dox[k];
                        ++k;
                    }
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("difference does not support multiple-element dataset");
            }
        }
    }

    public static Dataset difference(Dataset a, int n, int axis) {
        int dt = a.getDType();
        int rank = a.getRank();
        int is = a.getElementsPerItem();
        if (axis < 0) {
            axis += rank;
        }
        if (axis < 0 || axis >= rank) {
            throw new IllegalArgumentException("Axis is out of range");
        }
        int[] nshape = a.getShape();
        if (nshape[axis] <= n) {
            nshape[axis] = 0;
            return DatasetFactory.zeros(is, nshape, dt);
        }
        int n2 = axis;
        nshape[n2] = nshape[n2] - n;
        Dataset ds = DatasetFactory.zeros(is, nshape, dt);
        if (rank == 1) {
            Maths.difference(DatasetUtils.convertToDataset(a), ds, n);
        } else {
            Dataset src = DatasetFactory.zeros(is, new int[]{a.getShapeRef()[axis]}, dt);
            Dataset dest = DatasetFactory.zeros(is, new int[]{nshape[axis]}, dt);
            PositionIterator pi = a.getPositionIterator(axis);
            int[] pos = pi.getPos();
            boolean[] hit = pi.getOmit();
            while (pi.hasNext()) {
                a.copyItemsFromAxes(pos, hit, src);
                Maths.difference(src, dest, n);
                ds.setItemsOnAxes(pos, hit, dest.getBuffer());
            }
        }
        return ds;
    }

    private static double SelectedMean(Dataset data, int Min, int Max) {
        double result = 0.0;
        int i = Min;
        int imax = data.getSize();
        while (i <= Max) {
            int pos = i;
            if (pos < 0) {
                pos = 0;
            } else if (pos >= imax) {
                pos = imax - 1;
            }
            result += data.getElementDoubleAbs(pos);
            ++i;
        }
        return result /= (double)(Max - Min + 1);
    }

    private static void SelectedMeanArray(double[] out, Dataset data, int Min, int Max) {
        int isize = out.length;
        int j = 0;
        while (j < isize) {
            out[j] = 0.0;
            ++j;
        }
        int i = Min;
        int imax = data.getSize();
        while (i <= Max) {
            int pos = i * isize;
            if (pos < 0) {
                pos = 0;
            } else if (pos >= imax) {
                pos = imax - isize;
            }
            int j2 = 0;
            while (j2 < isize) {
                int n = j2;
                out[n] = out[n] + data.getElementDoubleAbs(pos + j2);
                ++j2;
            }
            ++i;
        }
        double norm = 1.0 / ((double)(Max - Min) + 1.0);
        int j3 = 0;
        while (j3 < isize) {
            int n = j3++;
            out[n] = out[n] * norm;
        }
    }

    public static Dataset derivative(Dataset x, Dataset y, int n) {
        Dataset result;
        if (x.getRank() != 1 || y.getRank() != 1) {
            throw new IllegalArgumentException("Only one dimensional dataset supported");
        }
        if (y.getSize() > x.getSize()) {
            throw new IllegalArgumentException("Length of x dataset should be greater than or equal to y's");
        }
        int dtype = y.getDType();
        switch (dtype) {
            case 0: 
            case 1: 
            case 2: 
            case 100: 
            case 200: {
                result = DatasetFactory.zeros(y, 5);
                break;
            }
            case 3: 
            case 4: 
            case 300: 
            case 400: {
                result = DatasetFactory.zeros(y, 6);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 500: 
            case 600: {
                result = DatasetFactory.zeros(y);
                break;
            }
            default: {
                throw new UnsupportedOperationException("derivative does not support multiple-element dataset");
            }
        }
        int isize = y.getElementsPerItem();
        if (isize == 1) {
            int i = 0;
            int imax = x.getSize();
            while (i < imax) {
                double LeftValue = Maths.SelectedMean(y, i - n, i - 1);
                double RightValue = Maths.SelectedMean(y, i + 1, i + n);
                double LeftPosition = Maths.SelectedMean(x, i - n, i - 1);
                double RightPosition = Maths.SelectedMean(x, i + 1, i + n);
                result.set((Object)((RightValue - LeftValue) / (RightPosition - LeftPosition)), i);
                ++i;
            }
        } else {
            double[] leftValues = new double[isize];
            double[] rightValues = new double[isize];
            int i = 0;
            int imax = x.getSize();
            while (i < imax) {
                Maths.SelectedMeanArray(leftValues, y, i - n, i - 1);
                Maths.SelectedMeanArray(rightValues, y, i + 1, i + n);
                double delta = Maths.SelectedMean(x, i - n, i - 1);
                delta = 1.0 / (Maths.SelectedMean(x, i + 1, i + n) - delta);
                int j = 0;
                while (j < isize) {
                    int n2 = j;
                    rightValues[n2] = rightValues[n2] - leftValues[j];
                    int n3 = j++;
                    rightValues[n3] = rightValues[n3] * delta;
                }
                result.set((Object)rightValues, i);
                ++i;
            }
        }
        result.setName(String.valueOf(y.getName()) + "'");
        return result;
    }

    public static Dataset centralDifference(Dataset a, int axis) {
        int dt = a.getDType();
        int rank = a.getRank();
        int is = a.getElementsPerItem();
        if (axis < 0) {
            axis += rank;
        }
        if (axis < 0 || axis >= rank) {
            throw new IllegalArgumentException("Axis is out of range");
        }
        int len = a.getShapeRef()[axis];
        if (len < 2) {
            throw new IllegalArgumentException("Dataset should have a size > 1 along given axis");
        }
        Dataset ds = DatasetFactory.zeros(is, a.getShapeRef(), dt);
        if (rank == 1) {
            Maths.centralDifference(a, ds);
        } else {
            Dataset src = DatasetFactory.zeros(is, new int[]{len}, dt);
            Dataset dest = DatasetFactory.zeros(is, new int[]{len}, dt);
            PositionIterator pi = a.getPositionIterator(axis);
            int[] pos = pi.getPos();
            boolean[] hit = pi.getOmit();
            while (pi.hasNext()) {
                a.copyItemsFromAxes(pos, hit, src);
                Maths.centralDifference(src, dest);
                ds.setItemsOnAxes(pos, hit, dest.getBuffer());
            }
        }
        return ds;
    }

    private static void centralDifference(Dataset a, Dataset out) {
        int isize = a.getElementsPerItem();
        int dt = a.getDType();
        int nlen = (out.getShapeRef()[0] - 1) * isize;
        if (nlen < 1) {
            throw new IllegalArgumentException("Dataset should have a size > 1 along given axis");
        }
        IndexIterator it = a.getIterator();
        if (!it.hasNext()) {
            return;
        }
        int oi = it.index;
        if (!it.hasNext()) {
            return;
        }
        int pi = it.index;
        switch (dt) {
            case 1: {
                byte[] i8data = ((ByteDataset)a).data;
                byte[] oi8data = ((ByteDataset)out).getData();
                oi8data[0] = (byte)(i8data[pi] - i8data[oi]);
                int i = 1;
                while (it.hasNext()) {
                    oi8data[i] = (byte)((i8data[it.index] - i8data[oi]) / 2);
                    oi = pi;
                    pi = it.index;
                    ++i;
                }
                oi8data[nlen] = (byte)(i8data[pi] - i8data[oi]);
                break;
            }
            case 2: {
                short[] i16data = ((ShortDataset)a).data;
                short[] oi16data = ((ShortDataset)out).getData();
                oi16data[0] = (short)(i16data[pi] - i16data[oi]);
                int i = 1;
                while (it.hasNext()) {
                    oi16data[i] = (short)((i16data[it.index] - i16data[oi]) / 2);
                    oi = pi;
                    pi = it.index;
                    ++i;
                }
                oi16data[nlen] = (short)(i16data[pi] - i16data[oi]);
                break;
            }
            case 3: {
                int[] i32data = ((IntegerDataset)a).data;
                int[] oi32data = ((IntegerDataset)out).getData();
                oi32data[0] = i32data[pi] - i32data[oi];
                int i = 1;
                while (it.hasNext()) {
                    oi32data[i] = (i32data[it.index] - i32data[oi]) / 2;
                    oi = pi;
                    pi = it.index;
                    ++i;
                }
                oi32data[nlen] = i32data[pi] - i32data[oi];
                break;
            }
            case 4: {
                long[] i64data = ((LongDataset)a).data;
                long[] oi64data = ((LongDataset)out).getData();
                oi64data[0] = i64data[pi] - i64data[oi];
                int i = 1;
                while (it.hasNext()) {
                    oi64data[i] = (i64data[it.index] - i64data[oi]) / 2L;
                    oi = pi;
                    pi = it.index;
                    ++i;
                }
                oi64data[nlen] = i64data[pi] - i64data[oi];
                break;
            }
            case 100: {
                byte[] ai8data = ((CompoundByteDataset)a).data;
                byte[] oai8data = ((CompoundByteDataset)out).getData();
                int k = 0;
                while (k < isize) {
                    oai8data[k] = (byte)(ai8data[pi + k] - ai8data[oi + k]);
                    ++k;
                }
                int i = isize;
                while (it.hasNext()) {
                    int l = it.index;
                    int k2 = 0;
                    while (k2 < isize) {
                        oai8data[i++] = (byte)((ai8data[l++] - ai8data[oi++]) / 2);
                        ++k2;
                    }
                    oi = pi;
                    pi = it.index;
                }
                k = 0;
                while (k < isize) {
                    oai8data[nlen + k] = (byte)(ai8data[pi + k] - ai8data[oi + k]);
                    ++k;
                }
                break;
            }
            case 200: {
                short[] ai16data = ((CompoundShortDataset)a).data;
                short[] oai16data = ((CompoundShortDataset)out).getData();
                int k = 0;
                while (k < isize) {
                    oai16data[k] = (short)(ai16data[pi + k] - ai16data[oi + k]);
                    ++k;
                }
                int i = isize;
                while (it.hasNext()) {
                    int l = it.index;
                    int k3 = 0;
                    while (k3 < isize) {
                        oai16data[i++] = (short)((ai16data[l++] - ai16data[oi++]) / 2);
                        ++k3;
                    }
                    oi = pi;
                    pi = it.index;
                }
                k = 0;
                while (k < isize) {
                    oai16data[nlen + k] = (short)(ai16data[pi + k] - ai16data[oi + k]);
                    ++k;
                }
                break;
            }
            case 300: {
                int[] ai32data = ((CompoundIntegerDataset)a).data;
                int[] oai32data = ((CompoundIntegerDataset)out).getData();
                int k = 0;
                while (k < isize) {
                    oai32data[k] = ai32data[pi + k] - ai32data[oi + k];
                    ++k;
                }
                int i = isize;
                while (it.hasNext()) {
                    int l = it.index;
                    int k4 = 0;
                    while (k4 < isize) {
                        oai32data[i++] = (ai32data[l++] - ai32data[oi++]) / 2;
                        ++k4;
                    }
                    oi = pi;
                    pi = it.index;
                }
                k = 0;
                while (k < isize) {
                    oai32data[nlen + k] = ai32data[pi + k] - ai32data[oi + k];
                    ++k;
                }
                break;
            }
            case 400: {
                long[] ai64data = ((CompoundLongDataset)a).data;
                long[] oai64data = ((CompoundLongDataset)out).getData();
                int k = 0;
                while (k < isize) {
                    oai64data[k] = ai64data[pi + k] - ai64data[oi + k];
                    ++k;
                }
                int i = isize;
                while (it.hasNext()) {
                    int l = it.index;
                    int k5 = 0;
                    while (k5 < isize) {
                        oai64data[i++] = (ai64data[l++] - ai64data[oi++]) / 2L;
                        ++k5;
                    }
                    oi = pi;
                    pi = it.index;
                }
                k = 0;
                while (k < isize) {
                    oai64data[nlen + k] = ai64data[pi + k] - ai64data[oi + k];
                    ++k;
                }
                break;
            }
            case 5: {
                float[] f32data = ((FloatDataset)a).data;
                float[] of32data = ((FloatDataset)out).getData();
                of32data[0] = f32data[pi] - f32data[oi];
                int i = 1;
                while (it.hasNext()) {
                    of32data[i] = (f32data[it.index] - f32data[oi]) * 0.5f;
                    oi = pi;
                    pi = it.index;
                    ++i;
                }
                of32data[nlen] = f32data[pi] - f32data[oi];
                break;
            }
            case 6: {
                double[] f64data = ((DoubleDataset)a).data;
                double[] of64data = ((DoubleDataset)out).getData();
                of64data[0] = f64data[pi] - f64data[oi];
                int i = 1;
                while (it.hasNext()) {
                    of64data[i] = (f64data[it.index] - f64data[oi]) * 0.5;
                    oi = pi;
                    pi = it.index;
                    ++i;
                }
                of64data[nlen] = f64data[pi] - f64data[oi];
                break;
            }
            case 7: {
                float[] c64data = ((ComplexFloatDataset)a).data;
                float[] oc64data = ((ComplexFloatDataset)out).getData();
                oc64data[0] = c64data[pi] - c64data[oi];
                oc64data[1] = c64data[pi + 1] - c64data[oi + 1];
                int i = 2;
                while (it.hasNext()) {
                    oc64data[i++] = (c64data[it.index] - c64data[oi++]) * 0.5f;
                    oc64data[i++] = (c64data[it.index + 1] - c64data[oi]) * 0.5f;
                    oi = pi;
                    pi = it.index;
                }
                oc64data[nlen] = c64data[pi] - c64data[oi];
                oc64data[nlen + 1] = c64data[pi + 1] - c64data[oi + 1];
                break;
            }
            case 8: {
                double[] c128data = ((ComplexDoubleDataset)a).data;
                double[] oc128data = ((ComplexDoubleDataset)out).getData();
                oc128data[0] = c128data[pi] - c128data[oi];
                oc128data[1] = c128data[pi + 1] - c128data[oi + 1];
                int i = 2;
                while (it.hasNext()) {
                    oc128data[i++] = (c128data[it.index] - c128data[oi++]) * 0.5;
                    oc128data[i++] = (c128data[it.index + 1] - c128data[oi]) * 0.5;
                    oi = pi;
                    pi = it.index;
                }
                oc128data[nlen] = c128data[pi] - c128data[oi];
                oc128data[nlen + 1] = c128data[pi + 1] - c128data[oi + 1];
                break;
            }
            case 500: {
                float[] af32data = ((CompoundFloatDataset)a).data;
                float[] oaf32data = ((CompoundFloatDataset)out).getData();
                int k = 0;
                while (k < isize) {
                    oaf32data[k] = af32data[pi + k] - af32data[oi + k];
                    ++k;
                }
                int i = isize;
                while (it.hasNext()) {
                    int l = it.index;
                    int k6 = 0;
                    while (k6 < isize) {
                        oaf32data[i++] = (af32data[l++] - af32data[oi++]) * 0.5f;
                        ++k6;
                    }
                    oi = pi;
                    pi = it.index;
                }
                k = 0;
                while (k < isize) {
                    oaf32data[nlen + k] = af32data[pi + k] - af32data[oi + k];
                    ++k;
                }
                break;
            }
            case 600: {
                double[] af64data = ((CompoundDoubleDataset)a).data;
                double[] oaf64data = ((CompoundDoubleDataset)out).getData();
                int k = 0;
                while (k < isize) {
                    oaf64data[k] = af64data[pi + k] - af64data[oi + k];
                    ++k;
                }
                int i = isize;
                while (it.hasNext()) {
                    int l = it.index;
                    int k7 = 0;
                    while (k7 < isize) {
                        oaf64data[i++] = (af64data[l++] - af64data[oi++]) * 0.5;
                        ++k7;
                    }
                    oi = pi;
                    pi = it.index;
                }
                k = 0;
                while (k < isize) {
                    oaf64data[nlen + k] = af64data[pi + k] - af64data[oi + k];
                    ++k;
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("difference does not support this dataset type");
            }
        }
    }

    public static List<Dataset> gradient(Dataset y, Dataset ... x) {
        Dataset g;
        int rank = y.getRank();
        if (x.length > 0) {
            if (x.length != rank) {
                throw new IllegalArgumentException("Number of dependent datasets must be equal to rank of first argument");
            }
            int a = 0;
            while (a < rank) {
                int rx = x[a].getRank();
                if (rx != rank && rx != 1) {
                    throw new IllegalArgumentException("Dependent datasets must be 1-D or match rank of first argument");
                }
                if (rx == 1) {
                    if (y.getShapeRef()[a] != x[a].getShapeRef()[0]) {
                        throw new IllegalArgumentException("Length of dependent dataset must match axis length");
                    }
                } else {
                    y.checkCompatibility(x[a]);
                }
                ++a;
            }
        }
        ArrayList<Dataset> grad = new ArrayList<Dataset>(rank);
        int a = 0;
        while (a < rank) {
            g = Maths.centralDifference(y, a);
            grad.add(g);
            ++a;
        }
        if (x.length > 0) {
            a = 0;
            while (a < rank) {
                g = (Dataset)grad.get(a);
                Dataset dx = x[a];
                int r = dx.getRank();
                if (r == rank) {
                    g.idivide(Maths.centralDifference(dx, a));
                } else {
                    int dt = dx.getDType();
                    int is = dx.getElementsPerItem();
                    Dataset bdx = DatasetFactory.zeros(is, y.getShapeRef(), dt);
                    PositionIterator pi = y.getPositionIterator(a);
                    int[] pos = pi.getPos();
                    boolean[] hit = pi.getOmit();
                    dx = Maths.centralDifference(dx, 0);
                    while (pi.hasNext()) {
                        bdx.setItemsOnAxes(pos, hit, dx.getBuffer());
                    }
                    g.idivide(bdx);
                }
                ++a;
            }
        }
        return grad;
    }
}

