/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.IndexIterator;
import org.eclipse.january.dataset.IntegerDataset;
import org.eclipse.january.dataset.IntegerIterator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IntegerIteratorTest {
    Dataset a;
    Dataset b;

    @Before
    public void setUpClass() {
        this.a = DatasetFactory.createFromObject((Object)new double[]{0.0, 1.0, 3.0, 5.0, -7.0, -9.0});
        this.b = DatasetFactory.createFromObject((Object)new double[]{0.01, 1.2, 2.9, 5.0, -7.1, -9.0});
    }

    @Test
    public void testEqualTo() {
        Dataset c = this.a.clone().reshape(new int[]{2, 3});
        int[] nArray = new int[3];
        nArray[1] = 3;
        nArray[2] = 4;
        IntegerDataset s = (IntegerDataset)DatasetFactory.createFromObject(IntegerDataset.class, (Object)nArray, null);
        ArrayList<Integer> inds = new ArrayList<Integer>();
        IntegerIterator iter = new IntegerIterator((Dataset)s, c.getSize());
        while (iter.hasNext()) {
            inds.add((int)c.getElementLongAbs(iter.index));
        }
        int[] nArray2 = new int[3];
        nArray2[1] = 5;
        nArray2[2] = -7;
        this.checkDatasets((IntegerDataset)DatasetFactory.createFromList(IntegerDataset.class, inds), (IntegerDataset)DatasetFactory.createFromObject(IntegerDataset.class, (Object)nArray2, null));
    }

    public void checkDatasets(IntegerDataset calc, IntegerDataset expected) {
        IndexIterator at = calc.getIterator(true);
        IndexIterator bt = expected.getIterator();
        int is = calc.getElementsPerItem();
        while (at.hasNext() && bt.hasNext()) {
            int j = 0;
            while (j < is) {
                Assert.assertEquals((String)("Value does not match at " + Arrays.toString(at.getPos()) + "; " + j + ": "), (long)expected.getAbs(at.index + j), (long)calc.getAbs(bt.index + j));
                ++j;
            }
        }
    }
}

