/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.util.Arrays;
import org.apache.commons.math3.complex.Complex;
import org.eclipse.january.dataset.BroadcastIterator;
import org.eclipse.january.dataset.BroadcastSelfIterator;
import org.eclipse.january.dataset.ComplexDoubleDataset;
import org.eclipse.january.dataset.CompoundFloatDataset;
import org.eclipse.january.dataset.DTypeUtils;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.FloatDataset;
import org.eclipse.january.dataset.IDataset;
import org.eclipse.january.dataset.IndexIterator;
import org.eclipse.january.dataset.ShapeUtils;
import org.eclipse.january.dataset.Slice;
import org.eclipse.january.dataset.SliceIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComplexFloatDataset
extends CompoundFloatDataset {
    private static final long serialVersionUID = -6891075135217265625L;
    private static final Logger logger = LoggerFactory.getLogger(ComplexFloatDataset.class);
    private static final int ISIZE = 2;

    ComplexFloatDataset() {
        super(2);
    }

    ComplexFloatDataset(int ... shape) {
        super(2, shape);
    }

    ComplexFloatDataset(float[] data, int ... shape) {
        super(2, data, shape);
    }

    ComplexFloatDataset(ComplexFloatDataset dataset) {
        super(dataset);
    }

    ComplexFloatDataset(float[] realData, float[] imagData, int ... shape) {
        int dsize;
        if (realData == null || imagData == null) {
            throw new IllegalArgumentException("Data must not be null");
        }
        int n = dsize = realData.length > imagData.length ? imagData.length : realData.length;
        if (shape == null || shape.length == 0) {
            shape = new int[]{dsize};
        }
        this.isize = 2;
        this.size = ShapeUtils.calcSize(shape);
        if (this.size != dsize) {
            throw new IllegalArgumentException(String.format("Shape %s is not compatible with size of data array, %d", Arrays.toString(shape), dsize));
        }
        this.shape = this.size == 0 ? null : (int[])shape.clone();
        try {
            this.data = this.createArray(this.size);
            this.odata = this.data;
        }
        catch (Throwable t) {
            logger.error("Could not create a dataset of shape {}", (Object)Arrays.toString(shape), (Object)t);
            throw new IllegalArgumentException(t);
        }
        int i = 0;
        int n2 = 0;
        while (i < this.size) {
            this.data[n2++] = realData[i];
            this.data[n2++] = imagData[i];
            ++i;
        }
    }

    ComplexFloatDataset(Dataset real, Dataset imag) {
        super(2, real.getShapeRef());
        real.checkCompatibility(imag);
        IndexIterator riter = real.getIterator();
        IndexIterator iiter = imag.getIterator();
        int i = 0;
        while (riter.hasNext() && iiter.hasNext()) {
            this.data[i++] = (float)real.getElementDoubleAbs(riter.index);
            this.data[i++] = (float)imag.getElementDoubleAbs(iiter.index);
        }
    }

    ComplexFloatDataset(Dataset dataset) {
        super(2, dataset.getShapeRef());
        ComplexFloatDataset.copyToView(dataset, this, true, false);
        this.offset = 0;
        this.stride = null;
        this.base = null;
        try {
            this.data = this.createArray(this.size);
            this.odata = this.data;
        }
        catch (Throwable t) {
            logger.error("Could not create a dataset of shape {}", (Object)Arrays.toString(this.shape), (Object)t);
            throw new IllegalArgumentException(t);
        }
        IndexIterator iter = dataset.getIterator();
        if (dataset.isComplex()) {
            int i = 0;
            while (iter.hasNext()) {
                this.data[i] = (float)dataset.getElementDoubleAbs(iter.index);
                this.data[i + 1] = (float)dataset.getElementDoubleAbs(iter.index + 1);
                i += this.isize;
            }
        } else {
            int i = 0;
            while (iter.hasNext()) {
                this.data[i] = (float)dataset.getElementDoubleAbs(iter.index);
                i += this.isize;
            }
        }
    }

    @Override
    public ComplexFloatDataset clone() {
        return new ComplexFloatDataset(this);
    }

    static ComplexFloatDataset createFromObject(Object obj) {
        ComplexFloatDataset result = new ComplexFloatDataset();
        result.shape = ShapeUtils.getShapeFromObject(obj);
        result.size = ShapeUtils.calcSize(result.shape);
        try {
            result.data = result.createArray(result.size);
            result.odata = result.data;
        }
        catch (Throwable t) {
            logger.error("Could not create a dataset of shape {}", (Object)Arrays.toString(result.shape), (Object)t);
            throw new IllegalArgumentException(t);
        }
        int[] pos = new int[result.shape.length];
        result.fillData(obj, 0, pos);
        return result;
    }

    static ComplexFloatDataset createRange(double stop) {
        return ComplexFloatDataset.createRange(0.0, stop, 1.0);
    }

    static ComplexFloatDataset createRange(double start, double stop, double step) {
        int size = ComplexFloatDataset.calcSteps(start, stop, step);
        ComplexFloatDataset result = new ComplexFloatDataset(new int[]{size});
        int i = 0;
        while (i < size) {
            result.data[i * 2] = (float)(start + (double)i * step);
            ++i;
        }
        return result;
    }

    static ComplexFloatDataset ones(int ... shape) {
        return new ComplexFloatDataset(shape).fill(1);
    }

    @Override
    public boolean isComplex() {
        return true;
    }

    @Override
    public ComplexFloatDataset fill(Object obj) {
        this.setDirty();
        float vr = (float)DTypeUtils.toReal(obj);
        float vi = (float)DTypeUtils.toImag(obj);
        IndexIterator iter = this.getIterator();
        while (iter.hasNext()) {
            this.data[iter.index] = vr;
            this.data[iter.index + 1] = vi;
        }
        return this;
    }

    @Override
    public ComplexFloatDataset getView(boolean deepCopyMetadata) {
        ComplexFloatDataset view = new ComplexFloatDataset();
        ComplexFloatDataset.copyToView(this, view, true, deepCopyMetadata);
        view.data = this.data;
        return view;
    }

    public Complex getComplexAbs(int index) {
        return new Complex((double)this.data[index], (double)this.data[index + 1]);
    }

    @Override
    public Object getObjectAbs(int index) {
        return new Complex((double)this.data[index], (double)this.data[index + 1]);
    }

    @Override
    public String getStringAbs(int index) {
        float di = this.data[index + 1];
        if (this.stringFormat == null) {
            return di >= 0.0f ? String.format("%.8g + %.8gj", Float.valueOf(this.data[index]), Float.valueOf(di)) : String.format("%.8g - %.8gj", Float.valueOf(this.data[index]), Float.valueOf(-di));
        }
        StringBuilder s = new StringBuilder();
        s.append(this.stringFormat.format(Float.valueOf(this.data[index])));
        if (di >= 0.0f) {
            s.append(" + ");
            s.append(this.stringFormat.format(Float.valueOf(di)));
        } else {
            s.append(" - ");
            s.append(this.stringFormat.format(Float.valueOf(-di)));
        }
        s.append('j');
        return s.toString();
    }

    public void setAbs(int index, Complex val) {
        this.setAbs(index, (float)val.getReal(), (float)val.getImaginary());
    }

    @Override
    public void setObjectAbs(int index, Object obj) {
        this.setAbs(index, (float)DTypeUtils.toReal(obj), (float)DTypeUtils.toImag(obj));
    }

    public void setAbs(int index, float real, float imag) {
        this.setDirty();
        this.data[index] = real;
        this.data[index + 1] = imag;
    }

    public Complex get() {
        int n = this.getFirst1DIndex();
        Complex z = new Complex((double)this.data[n], (double)this.data[n + 1]);
        return z;
    }

    public Complex get(int i) {
        int n = this.get1DIndex(i);
        Complex z = new Complex((double)this.data[n], (double)this.data[n + 1]);
        return z;
    }

    public Complex get(int i, int j) {
        int n = this.get1DIndex(i, j);
        Complex z = new Complex((double)this.data[n], (double)this.data[n + 1]);
        return z;
    }

    public Complex get(int ... pos) {
        int n = this.get1DIndex(pos);
        Complex z = new Complex((double)this.data[n], (double)this.data[n + 1]);
        return z;
    }

    @Override
    public Object getObject() {
        return this.get();
    }

    @Override
    public Object getObject(int i) {
        return this.get(i);
    }

    @Override
    public Object getObject(int i, int j) {
        return this.get(i, j);
    }

    @Override
    public Object getObject(int ... pos) {
        return this.getComplex(pos);
    }

    public float getReal() {
        return (float)this.getFirstValue();
    }

    public float getReal(int i) {
        return (float)this.getFirstValue(i);
    }

    public float getReal(int i, int j) {
        return (float)this.getFirstValue(i, j);
    }

    public float getReal(int ... pos) {
        return (float)this.getFirstValue(pos);
    }

    public float getImag() {
        return this.data[this.getFirst1DIndex() + 1];
    }

    public float getImag(int i) {
        return this.data[this.get1DIndex(i) + 1];
    }

    public float getImag(int i, int j) {
        return this.data[this.get1DIndex(i, j) + 1];
    }

    public float getImag(int ... pos) {
        return this.data[this.get1DIndex(pos) + 1];
    }

    public Complex getComplex() {
        return this.get();
    }

    public Complex getComplex(int i) {
        return this.get(i);
    }

    public Complex getComplex(int i, int j) {
        return this.get(i, j);
    }

    public Complex getComplex(int ... pos) {
        return this.get(pos);
    }

    @Override
    public void set(Object obj, int i) {
        this.setItem(new float[]{(float)DTypeUtils.toReal(obj), (float)DTypeUtils.toImag(obj)}, i);
    }

    @Override
    public void set(Object obj, int i, int j) {
        this.setItem(new float[]{(float)DTypeUtils.toReal(obj), (float)DTypeUtils.toImag(obj)}, i, j);
    }

    @Override
    public void set(Object obj, int ... pos) {
        if (pos == null || pos.length == 0 && this.shape.length > 0) {
            pos = new int[this.shape.length];
        }
        this.setItem(new float[]{(float)DTypeUtils.toReal(obj), (float)DTypeUtils.toImag(obj)}, pos);
    }

    public void set(float dr, float di, int i) {
        this.setItem(new float[]{dr, di}, i);
    }

    public void set(float dr, float di, int i, int j) {
        this.setItem(new float[]{dr, di}, i, j);
    }

    public void set(float dr, float di, int ... pos) {
        this.setItem(new float[]{dr, di}, pos);
    }

    @Override
    public FloatDataset getRealPart() {
        return this.getElements(0);
    }

    @Override
    public FloatDataset getRealView() {
        return this.getElementsView(0);
    }

    public FloatDataset getImaginaryPart() {
        return this.getElements(1);
    }

    public FloatDataset getImaginaryView() {
        return this.getElementsView(1);
    }

    @Override
    public Number max(boolean ... switches) {
        throw new UnsupportedOperationException("Cannot compare complex numbers");
    }

    @Override
    public Number min(boolean ... switches) {
        throw new UnsupportedOperationException("Cannot compare complex numbers");
    }

    @Override
    public Object sum(boolean ... switches) {
        double[] sum = (double[])super.sum(switches);
        return new Complex(sum[0], sum[1]);
    }

    @Override
    public Object mean(boolean ... switches) {
        double[] mean = (double[])super.mean(switches);
        return new Complex(mean[0], mean[1]);
    }

    @Override
    public int[] maxPos(boolean ... switches) {
        throw new UnsupportedOperationException("Cannot compare complex numbers");
    }

    @Override
    public int[] minPos(boolean ... switches) {
        throw new UnsupportedOperationException("Cannot compare complex numbers");
    }

    @Override
    public ComplexFloatDataset getSlice(SliceIterator siter) {
        ComplexFloatDataset result = new ComplexFloatDataset(siter.getShape());
        float[] rdata = result.data;
        IndexIterator riter = result.getIterator();
        while (siter.hasNext() && riter.hasNext()) {
            rdata[riter.index] = this.data[siter.index];
            rdata[riter.index + 1] = this.data[siter.index + 1];
        }
        result.setName(String.valueOf(this.name) + '[' + Slice.createString(siter.shape, siter.start, siter.stop, siter.step) + ']');
        return result;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    ComplexFloatDataset setSlicedView(Dataset view, Dataset d) {
        block2: {
            this.setDirty();
            it = BroadcastSelfIterator.createIterator(view, d);
            if (!(d instanceof ComplexFloatDataset) && !(d instanceof ComplexFloatDataset)) ** GOTO lbl11
            while (it.hasNext()) {
                this.data[it.aIndex] = (float)it.bDouble;
                this.data[it.aIndex + 1] = (float)d.getElementDoubleAbs(it.bIndex + 1);
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                this.data[it.aIndex] = (float)it.bDouble;
                this.data[it.aIndex + 1] = 0.0f;
lbl11:
                // 2 sources

                ** while (it.hasNext())
            }
        }
        return this;
    }

    @Override
    public ComplexFloatDataset setSlice(Object o, IndexIterator siter) {
        this.setDirty();
        if (o instanceof ComplexFloatDataset) {
            ComplexFloatDataset zds = (ComplexFloatDataset)o;
            if (!ShapeUtils.areShapesCompatible(siter.getShape(), zds.shape)) {
                throw new IllegalArgumentException(String.format("Input dataset is not compatible with slice: %s cf %s", Arrays.toString(zds.shape), Arrays.toString(siter.getShape())));
            }
            IndexIterator oiter = zds.getIterator();
            float[] odata = zds.data;
            while (siter.hasNext() && oiter.hasNext()) {
                this.data[siter.index] = odata[oiter.index];
                this.data[siter.index + 1] = odata[oiter.index + 1];
            }
        } else if (o instanceof ComplexDoubleDataset) {
            ComplexDoubleDataset zds = (ComplexDoubleDataset)o;
            if (!ShapeUtils.areShapesCompatible(siter.getShape(), zds.shape)) {
                throw new IllegalArgumentException(String.format("Input dataset is not compatible with slice: %s cf %s", Arrays.toString(zds.shape), Arrays.toString(siter.getShape())));
            }
            IndexIterator oiter = zds.getIterator();
            double[] odata = zds.data;
            while (siter.hasNext() && oiter.hasNext()) {
                this.data[siter.index] = (float)odata[oiter.index];
                this.data[siter.index + 1] = (float)odata[oiter.index + 1];
            }
        } else if (o instanceof IDataset) {
            super.setSlice(o, siter);
        } else {
            try {
                float vr = (float)DTypeUtils.toReal(o);
                float vi = (float)DTypeUtils.toImag(o);
                while (siter.hasNext()) {
                    this.data[siter.index] = vr;
                    this.data[siter.index + 1] = vi;
                }
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Object for setting slice is not a dataset or number");
            }
        }
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public ComplexFloatDataset iadd(Object b) {
        block11: {
            block12: {
                block10: {
                    this.setDirty();
                    bds = b instanceof Dataset != false ? (Dataset)b : DatasetFactory.createFromObject(b);
                    useLong = bds.getElementClass().equals(Long.class);
                    if (bds.getSize() != 1) break block10;
                    it = this.getIterator();
                    bOffset = bds.getOffset();
                    if (useLong) {
                        lb = bds.getElementLongAbs(bOffset);
                        while (it.hasNext()) {
                            v0 = it.index;
                            this.data[v0] = this.data[v0] + (float)lb;
                        }
                    } else {
                        db = bds.getElementDoubleAbs(bOffset);
                        if (!bds.isComplex() || bds.getElementDoubleAbs(bOffset + 1) == 0.0) {
                            while (it.hasNext()) {
                                v1 = it.index;
                                this.data[v1] = (float)((double)this.data[v1] + db);
                            }
                        } else {
                            vi = bds.getElementDoubleAbs(bOffset + 1);
                            while (it.hasNext()) {
                                v2 = it.index;
                                this.data[v2] = (float)((double)this.data[v2] + db);
                                v3 = it.index + 1;
                                this.data[v3] = (float)((double)this.data[v3] + vi);
                            }
                        }
                    }
                    break block11;
                }
                it = BroadcastSelfIterator.createIterator(this, bds);
                it.setOutputDouble(useLong == false);
                if (!useLong) break block12;
                while (it.hasNext()) {
                    v4 = it.aIndex;
                    this.data[v4] = this.data[v4] + (float)it.bLong;
                }
                break block11;
            }
            if (!bds.isComplex()) ** GOTO lbl49
            while (it.hasNext()) {
                v5 = it.aIndex;
                this.data[v5] = (float)((double)this.data[v5] + it.bDouble);
                v6 = it.aIndex + 1;
                this.data[v6] = (float)((double)this.data[v6] + bds.getElementDoubleAbs(it.bIndex + 1));
            }
            break block11;
lbl-1000:
            // 1 sources

            {
                v7 = it.aIndex;
                this.data[v7] = (float)((double)this.data[v7] + it.bDouble);
lbl49:
                // 2 sources

                ** while (it.hasNext())
            }
        }
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public ComplexFloatDataset isubtract(Object b) {
        block11: {
            block12: {
                block10: {
                    this.setDirty();
                    bds = b instanceof Dataset != false ? (Dataset)b : DatasetFactory.createFromObject(b);
                    useLong = bds.getElementClass().equals(Long.class);
                    if (bds.getSize() != 1) break block10;
                    it = this.getIterator();
                    bOffset = bds.getOffset();
                    if (useLong) {
                        lb = bds.getElementLongAbs(bOffset);
                        while (it.hasNext()) {
                            v0 = it.index;
                            this.data[v0] = this.data[v0] - (float)lb;
                        }
                    } else {
                        db = bds.getElementDoubleAbs(bOffset);
                        if (!bds.isComplex() || bds.getElementDoubleAbs(bOffset + 1) == 0.0) {
                            while (it.hasNext()) {
                                v1 = it.index;
                                this.data[v1] = (float)((double)this.data[v1] - db);
                            }
                        } else {
                            vi = bds.getElementDoubleAbs(bOffset + 1);
                            while (it.hasNext()) {
                                v2 = it.index;
                                this.data[v2] = (float)((double)this.data[v2] - db);
                                v3 = it.index + 1;
                                this.data[v3] = (float)((double)this.data[v3] - vi);
                            }
                        }
                    }
                    break block11;
                }
                it = BroadcastSelfIterator.createIterator(this, bds);
                it.setOutputDouble(useLong == false);
                if (!useLong) break block12;
                while (it.hasNext()) {
                    v4 = it.aIndex;
                    this.data[v4] = this.data[v4] - (float)it.bLong;
                }
                break block11;
            }
            if (!bds.isComplex()) ** GOTO lbl49
            while (it.hasNext()) {
                v5 = it.aIndex;
                this.data[v5] = (float)((double)this.data[v5] - it.bDouble);
                v6 = it.aIndex + 1;
                this.data[v6] = (float)((double)this.data[v6] - bds.getElementDoubleAbs(it.bIndex + 1));
            }
            break block11;
lbl-1000:
            // 1 sources

            {
                v7 = it.aIndex;
                this.data[v7] = (float)((double)this.data[v7] - it.bDouble);
lbl49:
                // 2 sources

                ** while (it.hasNext())
            }
        }
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public ComplexFloatDataset imultiply(Object b) {
        block11: {
            block12: {
                block10: {
                    this.setDirty();
                    bds = b instanceof Dataset != false ? (Dataset)b : DatasetFactory.createFromObject(b);
                    useLong = bds.getElementClass().equals(Long.class);
                    if (bds.getSize() != 1) break block10;
                    it = this.getIterator();
                    bOffset = bds.getOffset();
                    if (useLong) {
                        r2 = bds.getElementLongAbs(bOffset);
                        while (it.hasNext()) {
                            v0 = it.index;
                            this.data[v0] = this.data[v0] * (float)r2;
                            v1 = it.index + 1;
                            this.data[v1] = this.data[v1] * (float)r2;
                        }
                    } else {
                        r2 = bds.getElementDoubleAbs(bOffset);
                        if (!bds.isComplex() || bds.getElementDoubleAbs(bOffset + 1) == 0.0) {
                            while (it.hasNext()) {
                                v2 = it.index;
                                this.data[v2] = (float)((double)this.data[v2] * r2);
                                v3 = it.index + 1;
                                this.data[v3] = (float)((double)this.data[v3] * r2);
                            }
                        } else {
                            i2 = bds.getElementDoubleAbs(bOffset + 1);
                            while (it.hasNext()) {
                                r1 = this.data[it.index];
                                i1 = this.data[it.index + 1];
                                this.data[it.index] = (float)(r1 * r2 - i1 * i2);
                                this.data[it.index + 1] = (float)(r1 * i2 + i1 * r2);
                            }
                        }
                    }
                    break block11;
                }
                it = BroadcastIterator.createIterator(this, bds);
                it.setOutputDouble(useLong == false);
                if (!useLong) break block12;
                while (it.hasNext()) {
                    v4 = it.aIndex;
                    this.data[v4] = (float)((double)this.data[v4] * it.bDouble);
                    v5 = it.aIndex + 1;
                    this.data[v5] = (float)((double)this.data[v5] * it.bDouble);
                }
                break block11;
            }
            if (!bds.isComplex()) ** GOTO lbl59
            while (it.hasNext()) {
                r1 = it.aDouble;
                r2 = it.bDouble;
                i1 = this.data[it.aIndex + 1];
                i2 = bds.getElementDoubleAbs(it.bIndex + 1);
                this.data[it.aIndex] = (float)(r1 * r2 - i1 * i2);
                this.data[it.aIndex + 1] = (float)(r1 * i2 + i1 * r2);
            }
            break block11;
lbl-1000:
            // 1 sources

            {
                v6 = it.aIndex;
                this.data[v6] = (float)((double)this.data[v6] * it.bDouble);
                v7 = it.aIndex + 1;
                this.data[v7] = (float)((double)this.data[v7] * it.bDouble);
lbl59:
                // 2 sources

                ** while (it.hasNext())
            }
        }
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public ComplexFloatDataset idivide(Object b) {
        block12: {
            block15: {
                block10: {
                    block14: {
                        block13: {
                            block11: {
                                this.setDirty();
                                bds = b instanceof Dataset != false ? (Dataset)b : DatasetFactory.createFromObject(b);
                                useLong = bds.getElementClass().equals(Long.class);
                                if (bds.getSize() != 1) break block10;
                                it = this.getIterator();
                                bOffset = bds.getOffset();
                                if (!useLong) break block11;
                                r2 = bds.getElementLongAbs(bOffset);
                                while (it.hasNext()) {
                                    v0 = it.index;
                                    this.data[v0] = this.data[v0] / (float)r2;
                                    v1 = it.index + 1;
                                    this.data[v1] = this.data[v1] / (float)r2;
                                }
                                break block12;
                            }
                            r2 = bds.getElementDoubleAbs(bOffset);
                            if (bds.isComplex() && bds.getElementDoubleAbs(bOffset + 1) != 0.0) break block13;
                            while (it.hasNext()) {
                                v2 = it.index;
                                this.data[v2] = (float)((double)this.data[v2] / r2);
                                v3 = it.index + 1;
                                this.data[v3] = (float)((double)this.data[v3] / r2);
                            }
                            break block12;
                        }
                        i2 = bds.getElementDoubleAbs(bOffset + 1);
                        if (!(Math.abs(r2) < Math.abs(i2))) break block14;
                        q = r2 / i2;
                        den = r2 * q + i2;
                        while (it.hasNext()) {
                            r1 = this.data[it.index];
                            i1 = this.data[it.index + 1];
                            this.data[it.index] = (float)((r1 * q + i1) / den);
                            this.data[it.index + 1] = (float)((i1 * q - r1) / den);
                        }
                        break block12;
                    }
                    q = i2 / r2;
                    den = i2 * q + r2;
                    if (den != 0.0) ** GOTO lbl51
                    while (it.hasNext()) {
                        this.data[it.index] = NaNf;
                        this.data[it.index + 1] = NaNf;
                    }
                    break block12;
lbl-1000:
                    // 1 sources

                    {
                        r1 = this.data[it.index];
                        i1 = this.data[it.index + 1];
                        this.data[it.index] = (float)((i1 * q + r1) / den);
                        this.data[it.index + 1] = (float)((i1 - r1 * q) / den);
lbl51:
                        // 2 sources

                        ** while (it.hasNext())
                    }
lbl52:
                    // 1 sources

                    break block12;
                }
                it = BroadcastIterator.createIterator(this, bds);
                it.setOutputDouble(useLong == false);
                if (!useLong) break block15;
                while (it.hasNext()) {
                    v4 = it.aIndex;
                    this.data[v4] = this.data[v4] / (float)it.bLong;
                    v5 = it.aIndex + 1;
                    this.data[v5] = this.data[v5] / (float)it.bLong;
                }
                break block12;
            }
            if (!bds.isComplex()) ** GOTO lbl91
            while (it.hasNext()) {
                r1 = it.aDouble;
                r2 = it.bDouble;
                i1 = this.data[it.aIndex + 1];
                i2 = bds.getElementDoubleAbs(it.bIndex + 1);
                if (Math.abs(r2) < Math.abs(i2)) {
                    q = r2 / i2;
                    den = r2 * q + i2;
                    this.data[it.aIndex] = (float)((r1 * q + i1) / den);
                    this.data[it.aIndex + 1] = (float)((i1 * q - r1) / den);
                    continue;
                }
                q = i2 / r2;
                den = i2 * q + r2;
                if (den == 0.0) {
                    this.data[it.aIndex] = NaNf;
                    this.data[it.aIndex + 1] = NaNf;
                    continue;
                }
                this.data[it.aIndex] = (float)((i1 * q + r1) / den);
                this.data[it.aIndex + 1] = (float)((i1 - r1 * q) / den);
            }
            break block12;
lbl-1000:
            // 1 sources

            {
                v6 = it.aIndex;
                this.data[v6] = (float)((double)this.data[v6] / it.bDouble);
                v7 = it.aIndex + 1;
                this.data[v7] = (float)((double)this.data[v7] / it.bDouble);
lbl91:
                // 2 sources

                ** while (it.hasNext())
            }
        }
        return this;
    }

    @Override
    public ComplexFloatDataset iremainder(Object b) {
        throw new UnsupportedOperationException("Unsupported method for class");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public ComplexFloatDataset ipower(Object b) {
        block7: {
            block6: {
                this.setDirty();
                v0 = bds = b instanceof Dataset != false ? (Dataset)b : DatasetFactory.createFromObject(b);
                if (bds.getSize() != 1) break block6;
                it = this.getIterator();
                bOffset = bds.getOffset();
                r2 = bds.getElementDoubleAbs(bOffset);
                if (!bds.isComplex() || bds.getElementDoubleAbs(bOffset + 1) == 0.0) {
                    while (it.hasNext()) {
                        zd = new Complex((double)this.data[it.index], (double)this.data[it.index + 1]).pow(r2);
                        this.data[it.index] = (float)zd.getReal();
                        this.data[it.index + 1] = (float)zd.getImaginary();
                    }
                } else {
                    zv = new Complex(r2, bds.getElementDoubleAbs(bOffset + 1));
                    while (it.hasNext()) {
                        zd = new Complex((double)this.data[it.index], (double)this.data[it.index + 1]).pow(zv);
                        this.data[it.index] = (float)zd.getReal();
                        this.data[it.index + 1] = (float)zd.getImaginary();
                    }
                }
                break block7;
            }
            it = BroadcastIterator.createIterator(this, bds);
            it.setOutputDouble(true);
            if (!bds.isComplex()) ** GOTO lbl35
            while (it.hasNext()) {
                zv = new Complex(it.bDouble, bds.getElementDoubleAbs(it.bIndex + 1));
                zd = new Complex(it.aDouble, (double)this.data[it.aIndex + 1]).pow(zv);
                this.data[it.aIndex] = (float)zd.getReal();
                this.data[it.aIndex + 1] = (float)zd.getImaginary();
            }
            break block7;
lbl-1000:
            // 1 sources

            {
                zd = new Complex(it.aDouble, (double)this.data[it.aIndex + 1]).pow(it.bDouble);
                this.data[it.aIndex] = (float)zd.getReal();
                this.data[it.aIndex + 1] = (float)zd.getImaginary();
lbl35:
                // 2 sources

                ** while (it.hasNext())
            }
        }
        return this;
    }

    @Override
    public double residual(Object b, Dataset w, boolean ignoreNaNs) {
        Dataset bds = b instanceof Dataset ? (Dataset)b : DatasetFactory.createFromObject(b);
        BroadcastIterator it = BroadcastIterator.createIterator(this, bds);
        it.setOutputDouble(true);
        double sum = 0.0;
        double comp = 0.0;
        int bis = bds.getElementsPerItem();
        if (bis == 1) {
            if (w == null) {
                while (it.hasNext()) {
                    double diffr = it.aDouble - it.bDouble;
                    double diffi = this.data[it.aIndex + 1];
                    if (ignoreNaNs && (Double.isNaN(diffr) || Double.isNaN(diffi))) continue;
                    double err = diffr * diffr - comp;
                    double temp = sum + err;
                    comp = temp - sum - err;
                    sum = temp;
                    err = diffi * diffi - comp;
                    temp = sum + err;
                    comp = temp - sum - err;
                    sum = temp;
                }
            } else {
                IndexIterator itw = w.getIterator();
                while (it.hasNext() && itw.hasNext()) {
                    double dw = w.getElementDoubleAbs(itw.index);
                    double diffr = it.aDouble - it.bDouble;
                    double diffi = this.data[it.aIndex + 1];
                    if (ignoreNaNs && (Double.isNaN(diffr) || Double.isNaN(diffi))) continue;
                    double err = diffr * diffr * dw - comp;
                    double temp = sum + err;
                    comp = temp - sum - err;
                    sum = temp;
                    err = diffi * diffi * dw - comp;
                    temp = sum + err;
                    comp = temp - sum - err;
                    sum = temp;
                }
            }
        } else if (w == null) {
            while (it.hasNext()) {
                double diffr = it.aDouble - it.bDouble;
                double diffi = (double)this.data[it.aIndex] - bds.getElementDoubleAbs(it.bIndex + 1);
                if (ignoreNaNs && (Double.isNaN(diffr) || Double.isNaN(diffi))) continue;
                double err = diffr * diffr - comp;
                double temp = sum + err;
                comp = temp - sum - err;
                sum = temp;
                err = diffi * diffi - comp;
                temp = sum + err;
                comp = temp - sum - err;
                sum = temp;
            }
        } else {
            IndexIterator itw = w.getIterator();
            while (it.hasNext() && itw.hasNext()) {
                double dw = w.getElementDoubleAbs(itw.index);
                double diffr = it.aDouble - it.bDouble;
                double diffi = (double)this.data[it.aIndex] - bds.getElementDoubleAbs(it.bIndex + 1);
                if (ignoreNaNs && (Double.isNaN(diffr) || Double.isNaN(diffi))) continue;
                double err = diffr * diffr * dw - comp;
                double temp = sum + err;
                comp = temp - sum - err;
                sum = temp;
                err = diffi * diffi * dw - comp;
                temp = sum + err;
                comp = temp - sum - err;
                sum = temp;
            }
        }
        return sum;
    }
}

