/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import org.eclipse.january.dataset.IndexIterator;
import org.eclipse.january.dataset.ShapeUtils;
import org.eclipse.january.dataset.SliceND;

public class SliceNDIterator
extends IndexIterator {
    private final int[] shape;
    private final int[] start;
    private final int[] stop;
    private final int[] step;
    private final int endrank;
    private final boolean[] omit;
    private final int[] pos;
    private final int[] end;
    private boolean once;
    private SliceND cSlice;
    private int sRank;
    private final SliceND iSlice;
    private final SliceND sSlice;
    private final int[] sStart;
    private final int[] sStop;
    private SliceND dSlice;
    private int[] dStart;
    private int[] dStop;

    public SliceNDIterator(SliceND slice, int ... axes) {
        this.cSlice = slice.clone();
        int[] sShape = this.cSlice.getSourceShape();
        this.shape = (int[])this.cSlice.getShape().clone();
        this.start = this.cSlice.getStart();
        this.stop = this.cSlice.getStop();
        int[] nArray = this.step = this.cSlice.getStep();
        int n = this.step.length;
        int n2 = 0;
        while (n2 < n) {
            int s = nArray[n2];
            if (s < 0) {
                throw new UnsupportedOperationException("Negative steps not implemented");
            }
            ++n2;
        }
        int rank = this.shape.length;
        this.endrank = rank - 1;
        this.omit = new boolean[rank];
        this.dSlice = new SliceND(this.shape);
        this.dStart = this.dSlice.getStart();
        this.dStop = this.dSlice.getStop();
        this.sRank = rank;
        if (axes != null) {
            int[] nArray2 = axes = ShapeUtils.checkAxes(rank, axes);
            int n3 = axes.length;
            n = 0;
            while (n < n3) {
                int a = nArray2[n];
                if (a >= 0 && a <= this.endrank) {
                    --this.sRank;
                    this.omit[a] = true;
                    this.shape[a] = 1;
                } else if (a > this.endrank) {
                    throw new IllegalArgumentException("Specified axis exceeds dataset rank");
                }
                ++n;
            }
        }
        this.cSlice = this.cSlice.clone();
        this.pos = this.cSlice.getStart();
        this.end = this.cSlice.getStop();
        if (this.sRank == rank) {
            this.sStart = this.pos;
            this.sStop = null;
            this.iSlice = null;
            this.sSlice = this.cSlice;
        } else {
            int[] dShape = this.dSlice.getShape();
            int[] oShape = new int[this.sRank];
            int[] iShape = new int[rank - this.sRank];
            int i = 0;
            int j = 0;
            int k = 0;
            while (i < rank) {
                if (this.omit[i]) {
                    iShape[j++] = sShape[i];
                } else {
                    oShape[k++] = sShape[i];
                    dShape[i] = 1;
                }
                ++i;
            }
            this.sSlice = new SliceND(oShape);
            this.sStart = this.sSlice.getStart();
            this.sStop = this.sSlice.getStop();
            this.iSlice = new SliceND(iShape);
            i = 0;
            j = 0;
            k = 0;
            while (i < rank) {
                if (this.omit[i]) {
                    this.iSlice.setSlice(j++, this.start[i], this.stop[i], this.step[i]);
                } else {
                    this.sSlice.setSlice(k++, this.start[i], this.stop[i], this.step[i]);
                }
                ++i;
            }
        }
        this.reset();
    }

    @Override
    public boolean hasNext() {
        if (this.once) {
            this.once = false;
            return true;
        }
        int k = this.sRank - 1;
        int j = this.endrank;
        while (j >= 0) {
            if (!this.omit[j]) {
                int n = j;
                this.pos[n] = this.pos[n] + this.step[j];
                this.end[j] = this.pos[j] + this.step[j];
                int n2 = j;
                this.dStart[n2] = this.dStart[n2] + 1;
                int n3 = j;
                this.dStop[n3] = this.dStop[n3] + 1;
                if (this.pos[j] >= this.stop[j]) {
                    this.pos[j] = this.start[j];
                    this.end[j] = this.pos[j] + this.step[j];
                    this.dStart[j] = 0;
                    this.dStop[j] = 1;
                    if (this.sStop != null) {
                        this.sStart[k] = this.pos[j];
                        this.sStop[k] = this.end[j];
                        --k;
                    }
                } else {
                    if (this.sStop != null) {
                        this.sStart[k] = this.pos[j];
                        this.sStop[k] = this.end[j];
                        --k;
                    }
                    return true;
                }
            }
            --j;
        }
        return false;
    }

    @Override
    public int[] getPos() {
        return this.pos;
    }

    public SliceND getOmittedSlice() {
        return this.iSlice;
    }

    public SliceND getOutputSlice() {
        return this.dSlice;
    }

    public SliceND getCurrentSlice() {
        return this.cSlice;
    }

    public int[] getUsedPos() {
        return this.sStart;
    }

    public SliceND getUsedSlice() {
        return this.sSlice;
    }

    public boolean[] getOmit() {
        return this.omit;
    }

    @Override
    public void reset() {
        int i;
        int i2 = 0;
        int k = 0;
        while (i2 <= this.endrank) {
            int b = this.start[i2];
            int d = this.step[i2];
            if (!this.omit[i2]) {
                this.cSlice.setSlice(i2, b, b + d, d);
                this.dStart[i2] = 0;
                this.dStop[i2] = 1;
                if (this.sStop != null) {
                    this.sSlice.setSlice(k++, b, b + d, d);
                }
            } else {
                this.cSlice.setSlice(i2, b, this.end[i2], d);
            }
            ++i2;
        }
        int j = 0;
        while (j <= this.endrank) {
            if (!this.omit[j]) break;
            ++j;
        }
        if (j > this.endrank) {
            this.once = true;
            return;
        }
        if (this.omit[this.endrank]) {
            this.pos[this.endrank] = this.start[this.endrank];
            i = this.endrank - 1;
            while (i >= 0) {
                if (!this.omit[i]) {
                    this.end[i] = this.pos[i];
                    int n = i;
                    this.pos[n] = this.pos[n] - this.step[i];
                    int n2 = i;
                    this.dStart[n2] = this.dStart[n2] - 1;
                    int n3 = i;
                    this.dStop[n3] = this.dStop[n3] - 1;
                    break;
                }
                --i;
            }
        } else {
            this.end[this.endrank] = this.pos[this.endrank];
            int n = this.endrank;
            this.pos[n] = this.pos[n] - this.step[this.endrank];
            int n4 = this.endrank;
            this.dStart[n4] = this.dStart[n4] - 1;
            int n5 = this.endrank;
            this.dStop[n5] = this.dStop[n5] - 1;
        }
        if (this.sStart != this.pos) {
            i = 0;
            int k2 = 0;
            while (i <= this.endrank) {
                if (!this.omit[i]) {
                    this.sStart[k2++] = this.pos[i];
                }
                ++i;
            }
        }
    }

    @Override
    public int[] getShape() {
        return this.shape;
    }
}

