/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.TreeMap;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.stat.descriptive.moment.Kurtosis;
import org.apache.commons.math3.stat.descriptive.moment.Skewness;
import org.eclipse.january.dataset.AbstractDataset;
import org.eclipse.january.dataset.ComplexDoubleDataset;
import org.eclipse.january.dataset.ComplexFloatDataset;
import org.eclipse.january.dataset.CompoundDataset;
import org.eclipse.january.dataset.CompoundDoubleDataset;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.DatasetUtils;
import org.eclipse.january.dataset.DoubleDataset;
import org.eclipse.january.dataset.IndexIterator;
import org.eclipse.january.dataset.LinearAlgebra;
import org.eclipse.january.dataset.Maths;
import org.eclipse.january.dataset.PositionIterator;
import org.eclipse.january.dataset.ShapeUtils;

public class Stats {
    private static final String STORE_KURTOSIS = "kurtosis";
    private static final String STORE_SKEWNESS = "skewness";
    private static final String STORE_MEDIAN = "median";
    private static final String STORE_QUARTILE1 = "quartile1";
    private static final String STORE_QUARTILE3 = "quartile3";

    private static Dataset calcQuartileStats(AbstractDataset a) {
        Dataset s = null;
        int is = a.getElementsPerItem();
        if (is == 1) {
            s = DatasetUtils.sort(a);
            a.setStoredValue(STORE_MEDIAN, Stats.pQuantile(s, 0.5));
            a.setStoredValue(STORE_QUARTILE1, Stats.pQuantile(s, 0.25));
            a.setStoredValue(STORE_QUARTILE3, Stats.pQuantile(s, 0.75));
        } else {
            Dataset w = DatasetFactory.zeros(a.getShapeRef(), a.getDType());
            a.setStoredValue(STORE_MEDIAN, new double[is]);
            a.setStoredValue(STORE_QUARTILE1, new double[is]);
            a.setStoredValue(STORE_QUARTILE3, new double[is]);
            int j = 0;
            while (j < is) {
                ((CompoundDataset)((Object)a)).copyElements(w, j);
                w.sort(null);
                double[] store = (double[])a.getStoredValue(STORE_MEDIAN);
                store[j] = Stats.pQuantile(w, 0.5);
                store = (double[])a.getStoredValue(STORE_QUARTILE1);
                store[j] = Stats.pQuantile(w, 0.25);
                store = (double[])a.getStoredValue(STORE_QUARTILE3);
                store[j] = Stats.pQuantile(w, 0.75);
                if (j == 0) {
                    s = w.clone();
                }
                ++j;
            }
        }
        return s;
    }

    private static Object getQStatistics(AbstractDataset a, String stat) {
        Object m = a.getStoredValue(stat);
        if (m == null) {
            Stats.calcQuartileStats(a);
            m = a.getStoredValue(stat);
        }
        return m;
    }

    private static Dataset getQStatistics(AbstractDataset a, int axis, String stat) {
        axis = a.checkAxis(axis);
        Object obj = a.getStoredValue(stat);
        int is = a.getElementsPerItem();
        if (obj == null) {
            if (is == 1) {
                AbstractDataset s = DatasetUtils.sort(a, axis);
                a.setStoredValue("median-" + axis, Stats.pQuantile(s, axis, 0.5));
                a.setStoredValue("quartile1-" + axis, Stats.pQuantile(s, axis, 0.25));
                a.setStoredValue("quartile3-" + axis, Stats.pQuantile(s, axis, 0.75));
            } else {
                Dataset w = DatasetFactory.zeros(a.getShapeRef(), a.getDType());
                int j = 0;
                while (j < is) {
                    CompoundDoubleDataset s;
                    ((CompoundDataset)((Object)a)).copyElements(w, j);
                    w.sort(axis);
                    Dataset c = Stats.pQuantile(w, axis, 0.5);
                    if (j == 0) {
                        s = (CompoundDoubleDataset)DatasetFactory.zeros(is, c.getShapeRef(), c.getDType());
                        a.setStoredValue("median-" + axis, s);
                        s = (CompoundDoubleDataset)DatasetFactory.zeros(is, c.getShapeRef(), c.getDType());
                        a.setStoredValue("quartile1-" + axis, s);
                        s = (CompoundDoubleDataset)DatasetFactory.zeros(is, c.getShapeRef(), c.getDType());
                        a.setStoredValue("quartile3-" + axis, s);
                    }
                    s = (CompoundDoubleDataset)a.getStoredValue("median-" + axis);
                    s.setElements(c, j);
                    s = (CompoundDoubleDataset)a.getStoredValue("quartile1-" + axis);
                    s.setElements(Stats.pQuantile(w, axis, 0.25), j);
                    s = (CompoundDoubleDataset)a.getStoredValue("quartile3-" + axis);
                    s.setElements(Stats.pQuantile(w, axis, 0.75), j);
                    ++j;
                }
            }
            obj = a.getStoredValue(stat);
        }
        return (Dataset)obj;
    }

    private static double pQuantile(Dataset s, double q) {
        double f = (double)(s.getSize() - 1) * q;
        if (f < 0.0) {
            return Double.NaN;
        }
        int qpt = (int)Math.floor(f);
        f -= (double)qpt;
        double quantile = s.getElementDoubleAbs(qpt);
        if (f > 0.0) {
            quantile = (1.0 - f) * quantile + f * s.getElementDoubleAbs(qpt + 1);
        }
        return quantile;
    }

    private static Dataset pQuantile(Dataset s, int axis, double q) {
        int rank = s.getRank();
        int is = s.getElementsPerItem();
        int[] oshape = s.getShape();
        double f = (double)(oshape[axis] - 1) * q;
        int qpt = (int)Math.floor(f);
        f -= (double)qpt;
        oshape[axis] = 1;
        int[] qshape = ShapeUtils.squeezeShape(oshape, false);
        Dataset qds = DatasetFactory.zeros(is, qshape, 6);
        IndexIterator qiter = qds.getIterator(true);
        int[] qpos = qiter.getPos();
        int[] spos = oshape;
        while (qiter.hasNext()) {
            int i = 0;
            while (i < axis) {
                spos[i] = qpos[i];
                ++i;
            }
            spos[i++] = qpt;
            while (i < rank) {
                spos[i] = qpos[i - 1];
                ++i;
            }
            Object obj = s.getObject(spos);
            qds.set(obj, qpos);
        }
        if (f > 0.0) {
            qiter = qds.getIterator(true);
            qpos = qiter.getPos();
            ++qpt;
            Dataset rds = DatasetFactory.zeros(is, qshape, 6);
            while (qiter.hasNext()) {
                int i = 0;
                while (i < axis) {
                    spos[i] = qpos[i];
                    ++i;
                }
                spos[i++] = qpt;
                while (i < rank) {
                    spos[i] = qpos[i - 1];
                    ++i;
                }
                Object obj = s.getObject(spos);
                rds.set(obj, qpos);
            }
            rds.imultiply(f);
            qds.imultiply(1.0 - f);
            qds.iadd(rds);
        }
        return qds;
    }

    public static double quantile(Dataset a, double q) {
        if (q < 0.0 || q > 1.0) {
            throw new IllegalArgumentException("Quantile requested is outside [0,1]");
        }
        Dataset s = Stats.calcQuartileStats(DatasetUtils.convertToAbstractDataset(a));
        return Stats.pQuantile(s, q);
    }

    public static double[] quantile(Dataset a, double ... values) {
        double[] points = new double[values.length];
        Dataset s = Stats.calcQuartileStats(DatasetUtils.convertToAbstractDataset(a));
        int i = 0;
        while (i < points.length) {
            double q = values[i];
            if (q < 0.0 || q > 1.0) {
                throw new IllegalArgumentException("Quantile requested is outside [0,1]");
            }
            points[i] = Stats.pQuantile(s, q);
            ++i;
        }
        return points;
    }

    public static Dataset[] quantile(Dataset a, int axis, double ... values) {
        Dataset[] points = new Dataset[values.length];
        int is = a.getElementsPerItem();
        if (is == 1) {
            Dataset s = DatasetUtils.sort(a, axis);
            int i = 0;
            while (i < points.length) {
                double q = values[i];
                if (q < 0.0 || q > 1.0) {
                    throw new IllegalArgumentException("Quantile requested is outside [0,1]");
                }
                points[i] = Stats.pQuantile(s, axis, q);
                ++i;
            }
        } else {
            Dataset w = DatasetFactory.zeros(a.getShapeRef(), a.getDType());
            int j = 0;
            while (j < is) {
                ((CompoundDataset)a).copyElements(w, j);
                w.sort(axis);
                int i = 0;
                while (i < points.length) {
                    double q = values[i];
                    if (q < 0.0 || q > 1.0) {
                        throw new IllegalArgumentException("Quantile requested is outside [0,1]");
                    }
                    Dataset c = Stats.pQuantile(w, axis, q);
                    if (j == 0) {
                        points[i] = DatasetFactory.zeros(is, c.getShapeRef(), c.getDType());
                    }
                    ((CompoundDoubleDataset)points[i]).setElements(c, j);
                    ++i;
                }
                ++j;
            }
        }
        return points;
    }

    public static Dataset median(Dataset a, int axis) {
        return Stats.getQStatistics(DatasetUtils.convertToAbstractDataset(a), axis, "median-" + axis);
    }

    public static Object median(Dataset a) {
        return Stats.getQStatistics(DatasetUtils.convertToAbstractDataset(a), STORE_MEDIAN);
    }

    public static Object iqr(Dataset a) {
        AbstractDataset aa = DatasetUtils.convertToAbstractDataset(a);
        int is = aa.getElementsPerItem();
        if (is == 1) {
            double q3 = (Double)Stats.getQStatistics(aa, STORE_QUARTILE3);
            return q3 - (Double)aa.getStoredValue(STORE_QUARTILE1);
        }
        double[] q1 = (double[])Stats.getQStatistics(aa, STORE_QUARTILE1);
        double[] q3 = (double[])Stats.getQStatistics(aa, STORE_QUARTILE3);
        int j = 0;
        while (j < is) {
            int n = j;
            q3[n] = q3[n] - q1[j];
            ++j;
        }
        return q3;
    }

    public static Dataset iqr(Dataset a, int axis) {
        AbstractDataset aa = DatasetUtils.convertToAbstractDataset(a);
        Dataset q3 = Stats.getQStatistics(aa, axis, "quartile3-" + axis);
        return Maths.subtract(q3, aa.getStoredValue("quartile1-" + axis));
    }

    private static Object getHigherStatistic(AbstractDataset a, boolean ignoreNaNs, String stat) {
        Object obj = a.getStoredValue(stat);
        if (obj == null) {
            Stats.calculateHigherMoments(a, ignoreNaNs);
            obj = a.getStoredValue(stat);
        }
        return obj;
    }

    private static DoubleDataset getHigherStatistic(AbstractDataset a, boolean ignoreNaNs, int axis, String stat) {
        axis = a.checkAxis(axis);
        DoubleDataset obj = (DoubleDataset)a.getStoredValue(stat);
        if (obj == null) {
            Stats.calculateHigherMoments(a, ignoreNaNs, axis);
            obj = (DoubleDataset)a.getStoredValue(stat);
        }
        return obj;
    }

    /*
     * Unable to fully structure code
     */
    private static void calculateHigherMoments(AbstractDataset a, boolean ignoreNaNs) {
        block12: {
            block13: {
                block10: {
                    block11: {
                        is = a.getElementsPerItem();
                        iter = a.getIterator();
                        if (is != 1) break block10;
                        s = new Skewness();
                        k = new Kurtosis();
                        if (!ignoreNaNs) ** GOTO lbl17
                        while (iter.hasNext()) {
                            x = a.getElementDoubleAbs(iter.index);
                            if (Double.isNaN(x)) continue;
                            s.increment(x);
                            k.increment(x);
                        }
                        break block11;
lbl-1000:
                        // 1 sources

                        {
                            x = a.getElementDoubleAbs(iter.index);
                            s.increment(x);
                            k.increment(x);
lbl17:
                            // 2 sources

                            ** while (iter.hasNext())
                        }
                    }
                    a.setStoredValue(AbstractDataset.storeName(ignoreNaNs, "skewness"), s.getResult());
                    a.setStoredValue(AbstractDataset.storeName(ignoreNaNs, "kurtosis"), k.getResult());
                    break block12;
                }
                s = new Skewness[is];
                k = new Kurtosis[is];
                j = 0;
                while (j < is) {
                    s[j] = new Skewness();
                    k[j] = new Kurtosis();
                    ++j;
                }
                if (!ignoreNaNs) ** GOTO lbl58
                while (iter.hasNext()) {
                    skip = false;
                    j = 0;
                    while (j < is) {
                        if (Double.isNaN(a.getElementDoubleAbs(iter.index + j))) {
                            skip = true;
                            break;
                        }
                        ++j;
                    }
                    if (skip) continue;
                    j = 0;
                    while (j < is) {
                        val = a.getElementDoubleAbs(iter.index + j);
                        s[j].increment(val);
                        k[j].increment(val);
                        ++j;
                    }
                }
                break block13;
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        val = a.getElementDoubleAbs(iter.index + j);
                        s[j].increment(val);
                        k[j].increment(val);
                        ++j;
                    }
lbl58:
                    // 2 sources

                    ** while (iter.hasNext())
                }
            }
            ts = new double[is];
            tk = new double[is];
            j = 0;
            while (j < is) {
                ts[j] = s[j].getResult();
                tk[j] = k[j].getResult();
                ++j;
            }
            a.setStoredValue(AbstractDataset.storeName(ignoreNaNs, "skewness"), ts);
            a.setStoredValue(AbstractDataset.storeName(ignoreNaNs, "kurtosis"), tk);
        }
    }

    private static void calculateHigherMoments(AbstractDataset a, boolean ignoreNaNs, int axis) {
        Dataset ku;
        Dataset sk;
        int rank = a.getRank();
        int is = a.getElementsPerItem();
        int[] oshape = a.getShape();
        int alen = oshape[axis];
        oshape[axis] = 1;
        int[] nshape = ShapeUtils.squeezeShape(oshape, false);
        if (is == 1) {
            sk = DatasetFactory.zeros(DoubleDataset.class, nshape);
            ku = DatasetFactory.zeros(DoubleDataset.class, nshape);
            IndexIterator qiter = sk.getIterator(true);
            int[] qpos = qiter.getPos();
            int[] spos = oshape;
            while (qiter.hasNext()) {
                double val;
                int j;
                int i = 0;
                while (i < axis) {
                    spos[i] = qpos[i];
                    ++i;
                }
                spos[i++] = 0;
                while (i < rank) {
                    spos[i] = qpos[i - 1];
                    ++i;
                }
                Skewness s = new Skewness();
                Kurtosis k = new Kurtosis();
                if (ignoreNaNs) {
                    j = 0;
                    while (j < alen) {
                        spos[axis] = j;
                        val = a.getDouble(spos);
                        if (!Double.isNaN(val)) {
                            s.increment(val);
                            k.increment(val);
                        }
                        ++j;
                    }
                } else {
                    j = 0;
                    while (j < alen) {
                        spos[axis] = j++;
                        val = a.getDouble(spos);
                        s.increment(val);
                        k.increment(val);
                    }
                }
                sk.set((Object)s.getResult(), spos);
                ku.set((Object)k.getResult(), spos);
            }
        } else {
            sk = DatasetFactory.createFromObject(is, CompoundDoubleDataset.class, nshape);
            ku = DatasetFactory.createFromObject(is, CompoundDoubleDataset.class, nshape);
            IndexIterator qiter = sk.getIterator(true);
            int[] qpos = qiter.getPos();
            int[] spos = oshape;
            Skewness[] s = new Skewness[is];
            Kurtosis[] k = new Kurtosis[is];
            double[] ts = new double[is];
            double[] tk = new double[is];
            int j = 0;
            while (j < is) {
                s[j] = new Skewness();
                k[j] = new Kurtosis();
                ++j;
            }
            while (qiter.hasNext()) {
                int j2;
                int i = 0;
                while (i < axis) {
                    spos[i] = qpos[i];
                    ++i;
                }
                spos[i++] = 0;
                while (i < rank) {
                    spos[i] = qpos[i - 1];
                    ++i;
                }
                int j3 = 0;
                while (j3 < is) {
                    s[j3].clear();
                    k[j3].clear();
                    ++j3;
                }
                int index = a.get1DIndex(spos);
                if (ignoreNaNs) {
                    boolean skip = false;
                    int j4 = 0;
                    while (j4 < is) {
                        if (Double.isNaN(a.getElementDoubleAbs(index + j4))) {
                            skip = true;
                            break;
                        }
                        ++j4;
                    }
                    if (!skip) {
                        j4 = 0;
                        while (j4 < is) {
                            double val = a.getElementDoubleAbs(index + j4);
                            s[j4].increment(val);
                            k[j4].increment(val);
                            ++j4;
                        }
                    }
                } else {
                    j2 = 0;
                    while (j2 < is) {
                        double val = a.getElementDoubleAbs(index + j2);
                        s[j2].increment(val);
                        k[j2].increment(val);
                        ++j2;
                    }
                }
                j2 = 0;
                while (j2 < is) {
                    ts[j2] = s[j2].getResult();
                    tk[j2] = k[j2].getResult();
                    ++j2;
                }
                sk.set((Object)ts, spos);
                ku.set((Object)tk, spos);
            }
        }
        a.setStoredValue(AbstractDataset.storeName(ignoreNaNs, "skewness-" + axis), sk);
        a.setStoredValue(AbstractDataset.storeName(ignoreNaNs, "kurtosis-" + axis), ku);
    }

    public static Object skewness(Dataset a) {
        return Stats.skewness(a, false);
    }

    public static Object skewness(Dataset a, boolean ignoreNaNs) {
        return Stats.getHigherStatistic(DatasetUtils.convertToAbstractDataset(a), ignoreNaNs, AbstractDataset.storeName(ignoreNaNs, STORE_SKEWNESS));
    }

    public static Object kurtosis(Dataset a) {
        return Stats.kurtosis(a, false);
    }

    public static Object kurtosis(Dataset a, boolean ignoreNaNs) {
        return Stats.getHigherStatistic(DatasetUtils.convertToAbstractDataset(a), ignoreNaNs, AbstractDataset.storeName(ignoreNaNs, STORE_KURTOSIS));
    }

    public static Dataset skewness(Dataset a, int axis) {
        return Stats.skewness(a, false, axis);
    }

    public static Dataset skewness(Dataset a, boolean ignoreNaNs, int axis) {
        return Stats.getHigherStatistic(DatasetUtils.convertToAbstractDataset(a), ignoreNaNs, axis, AbstractDataset.storeName(ignoreNaNs, "skewness-" + axis));
    }

    public static Dataset kurtosis(Dataset a, int axis) {
        return Stats.kurtosis(a, false, axis);
    }

    public static Dataset kurtosis(Dataset a, boolean ignoreNaNs, int axis) {
        return Stats.getHigherStatistic(DatasetUtils.convertToAbstractDataset(a), ignoreNaNs, axis, AbstractDataset.storeName(ignoreNaNs, "kurtosis-" + axis));
    }

    public static Object product(Dataset a) {
        return Stats.product(a, false);
    }

    public static Object product(Dataset a, boolean ignoreNaNs) {
        return Stats.typedProduct(a, a.getDType(), ignoreNaNs);
    }

    public static Object typedProduct(Dataset a, int dtype) {
        return Stats.typedProduct(a, dtype, false);
    }

    /*
     * Unable to fully structure code
     */
    public static Object typedProduct(Dataset a, int dtype, boolean ignoreNaNs) {
        block21: {
            block22: {
                if (!a.isComplex()) break block21;
                it = a.getIterator();
                rv = 1.0;
                iv = 0.0;
                if (!ignoreNaNs) ** GOTO lbl20
                while (it.hasNext()) {
                    r1 = a.getElementDoubleAbs(it.index);
                    i1 = a.getElementDoubleAbs(it.index + 1);
                    if (Double.isNaN(r1) || Double.isNaN(i1)) continue;
                    tv = r1 * rv - i1 * iv;
                    iv = r1 * iv + i1 * rv;
                    rv = tv;
                }
                break block22;
lbl-1000:
                // 1 sources

                {
                    r1 = a.getElementDoubleAbs(it.index);
                    i1 = a.getElementDoubleAbs(it.index + 1);
                    tv = r1 * rv - i1 * iv;
                    iv = r1 * iv + i1 * rv;
                    rv = tv;
lbl20:
                    // 2 sources

                    ** while (it.hasNext())
                }
            }
            return new Complex(rv, iv);
        }
        it = a.getIterator();
        switch (dtype) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                lresult = 1L;
                while (it.hasNext()) {
                    lresult *= a.getElementLongAbs(it.index);
                }
                return new Long(lresult);
            }
            case 100: 
            case 200: 
            case 300: 
            case 400: {
                lresult = 1L;
                is = a.getElementsPerItem();
                lresults = new long[is];
                j = 0;
                while (j < is) {
                    lresults[j] = 1L;
                    ++j;
                }
                while (it.hasNext()) {
                    j = 0;
                    while (j < is) {
                        v0 = j;
                        lresults[v0] = lresults[v0] * a.getElementLongAbs(it.index + j);
                        ++j;
                    }
                }
                return lresults;
            }
            case 5: 
            case 6: {
                dresult = 1.0;
                if (!ignoreNaNs) ** GOTO lbl60
                while (it.hasNext()) {
                    x = a.getElementDoubleAbs(it.index);
                    if (Double.isNaN(x)) continue;
                    dresult *= x;
                }
                ** GOTO lbl61
lbl-1000:
                // 1 sources

                {
                    dresult *= a.getElementDoubleAbs(it.index);
lbl60:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl61:
                // 2 sources

                return dresult;
            }
            case 500: 
            case 600: {
                is = a.getElementsPerItem();
                dresults = new double[is];
                j = 0;
                while (j < is) {
                    dresults[j] = 1.0;
                    ++j;
                }
                if (!ignoreNaNs) ** GOTO lbl95
                while (it.hasNext()) {
                    skip = false;
                    j = 0;
                    while (j < is) {
                        if (Double.isNaN(a.getElementDoubleAbs(it.index + j))) {
                            skip = true;
                            break;
                        }
                        ++j;
                    }
                    if (skip) continue;
                    j = 0;
                    while (j < is) {
                        v1 = j;
                        dresults[v1] = dresults[v1] * a.getElementDoubleAbs(it.index + j);
                        ++j;
                    }
                }
                ** GOTO lbl96
lbl-1000:
                // 1 sources

                {
                    j = 0;
                    while (j < is) {
                        v2 = j;
                        dresults[v2] = dresults[v2] * a.getElementDoubleAbs(it.index + j);
                        ++j;
                    }
lbl95:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl96:
                // 2 sources

                return dresults;
            }
        }
        return null;
    }

    public static Dataset product(Dataset a, int axis) {
        return Stats.product(a, false, axis);
    }

    public static Dataset product(Dataset a, boolean ignoreNaNs, int axis) {
        return Stats.typedProduct(a, a.getDType(), ignoreNaNs, axis);
    }

    public static Dataset typedProduct(Dataset a, int dtype, int axis) {
        return Stats.typedProduct(a, dtype, false, axis);
    }

    public static Dataset typedProduct(Dataset a, int dtype, boolean ignoreNaNs, int axis) {
        axis = a.checkAxis(axis);
        int[] oshape = a.getShape();
        int is = a.getElementsPerItem();
        int alen = oshape[axis];
        oshape[axis] = 1;
        Dataset result = DatasetFactory.zeros(is, oshape, dtype);
        IndexIterator qiter = result.getIterator(true);
        int[] qpos = qiter.getPos();
        while (qiter.hasNext()) {
            int[] spos = (int[])qpos.clone();
            if (a.isComplex()) {
                double rv = 1.0;
                double iv = 0.0;
                switch (dtype) {
                    case 7: {
                        ComplexFloatDataset af = (ComplexFloatDataset)a;
                        if (ignoreNaNs) {
                            int j = 0;
                            while (j < alen) {
                                spos[axis] = j;
                                float r1 = af.getReal(spos);
                                float i1 = af.getImag(spos);
                                if (!Float.isNaN(r1) && !Float.isNaN(i1)) {
                                    double tv = (double)r1 * rv - (double)i1 * iv;
                                    iv = (double)r1 * iv + (double)i1 * rv;
                                    rv = tv;
                                }
                                ++j;
                            }
                        } else {
                            int j = 0;
                            while (j < alen) {
                                spos[axis] = j++;
                                float r1 = af.getReal(spos);
                                float i1 = af.getImag(spos);
                                double tv = (double)r1 * rv - (double)i1 * iv;
                                iv = (double)r1 * iv + (double)i1 * rv;
                                rv = tv;
                            }
                        }
                        break;
                    }
                    case 8: {
                        double tv;
                        ComplexDoubleDataset ad = (ComplexDoubleDataset)a;
                        if (ignoreNaNs) {
                            int j = 0;
                            while (j < alen) {
                                spos[axis] = j;
                                double r1 = ad.getReal(spos);
                                double i1 = ad.getImag(spos);
                                if (!Double.isNaN(r1) && !Double.isNaN(i1)) {
                                    tv = r1 * rv - i1 * iv;
                                    iv = r1 * iv + i1 * rv;
                                    rv = tv;
                                }
                                ++j;
                            }
                        } else {
                            int j = 0;
                            while (j < alen) {
                                spos[axis] = j++;
                                double r1 = ad.getReal(spos);
                                double i1 = ad.getImag(spos);
                                tv = r1 * rv - i1 * iv;
                                iv = r1 * iv + i1 * rv;
                                rv = tv;
                            }
                        }
                        break;
                    }
                }
                result.set((Object)new Complex(rv, iv), qpos);
                continue;
            }
            switch (dtype) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    long lresult = 1L;
                    int j = 0;
                    while (j < alen) {
                        spos[axis] = j++;
                        lresult *= (long)a.getInt(spos);
                    }
                    result.set((Object)lresult, qpos);
                    break;
                }
                case 100: {
                    long[] lresults = new long[is];
                    int k = 0;
                    while (k < is) {
                        lresults[k] = 1L;
                        ++k;
                    }
                    int j = 0;
                    while (j < alen) {
                        spos[axis] = j;
                        byte[] va = (byte[])a.getObject(spos);
                        int k2 = 0;
                        while (k2 < is) {
                            int n = k2;
                            lresults[n] = lresults[n] * (long)va[k2];
                            ++k2;
                        }
                        ++j;
                    }
                    result.set((Object)lresults, qpos);
                    break;
                }
                case 200: {
                    long[] lresults = new long[is];
                    int k = 0;
                    while (k < is) {
                        lresults[k] = 1L;
                        ++k;
                    }
                    int j = 0;
                    while (j < alen) {
                        spos[axis] = j;
                        short[] va = (short[])a.getObject(spos);
                        int k3 = 0;
                        while (k3 < is) {
                            int n = k3;
                            lresults[n] = lresults[n] * (long)va[k3];
                            ++k3;
                        }
                        ++j;
                    }
                    result.set((Object)lresults, qpos);
                    break;
                }
                case 300: {
                    long[] lresults = new long[is];
                    int k = 0;
                    while (k < is) {
                        lresults[k] = 1L;
                        ++k;
                    }
                    int j = 0;
                    while (j < alen) {
                        spos[axis] = j;
                        int[] va = (int[])a.getObject(spos);
                        int k4 = 0;
                        while (k4 < is) {
                            int n = k4;
                            lresults[n] = lresults[n] * (long)va[k4];
                            ++k4;
                        }
                        ++j;
                    }
                    result.set((Object)lresults, qpos);
                    break;
                }
                case 400: {
                    long[] lresults = new long[is];
                    int k = 0;
                    while (k < is) {
                        lresults[k] = 1L;
                        ++k;
                    }
                    int j = 0;
                    while (j < alen) {
                        spos[axis] = j;
                        long[] va = (long[])a.getObject(spos);
                        int k5 = 0;
                        while (k5 < is) {
                            int n = k5;
                            lresults[n] = lresults[n] * va[k5];
                            ++k5;
                        }
                        ++j;
                    }
                    result.set((Object)lresults, qpos);
                    break;
                }
                case 5: 
                case 6: {
                    int j;
                    double dresult = 1.0;
                    if (ignoreNaNs) {
                        j = 0;
                        while (j < alen) {
                            spos[axis] = j;
                            double x = a.getDouble(spos);
                            if (!Double.isNaN(x)) {
                                dresult *= x;
                            }
                            ++j;
                        }
                    } else {
                        j = 0;
                        while (j < alen) {
                            spos[axis] = j++;
                            dresult *= a.getDouble(spos);
                        }
                    }
                    result.set((Object)dresult, qpos);
                    break;
                }
                case 500: {
                    int j;
                    double[] dresults = new double[is];
                    int k = 0;
                    while (k < is) {
                        dresults[k] = 1.0;
                        ++k;
                    }
                    if (ignoreNaNs) {
                        j = 0;
                        while (j < alen) {
                            spos[axis] = j;
                            float[] va = (float[])a.getObject(spos);
                            boolean skip = false;
                            int k6 = 0;
                            while (k6 < is) {
                                if (Float.isNaN(va[k6])) {
                                    skip = true;
                                    break;
                                }
                                ++k6;
                            }
                            if (!skip) {
                                k6 = 0;
                                while (k6 < is) {
                                    int n = k6;
                                    dresults[n] = dresults[n] * (double)va[k6];
                                    ++k6;
                                }
                            }
                            ++j;
                        }
                    } else {
                        j = 0;
                        while (j < alen) {
                            spos[axis] = j;
                            float[] va = (float[])a.getObject(spos);
                            int k7 = 0;
                            while (k7 < is) {
                                int n = k7;
                                dresults[n] = dresults[n] * (double)va[k7];
                                ++k7;
                            }
                            ++j;
                        }
                    }
                    result.set((Object)dresults, qpos);
                    break;
                }
                case 600: {
                    int j;
                    double[] dresults = new double[is];
                    int k = 0;
                    while (k < is) {
                        dresults[k] = 1.0;
                        ++k;
                    }
                    if (ignoreNaNs) {
                        j = 0;
                        while (j < alen) {
                            spos[axis] = j;
                            double[] va = (double[])a.getObject(spos);
                            boolean skip = false;
                            int k8 = 0;
                            while (k8 < is) {
                                if (Double.isNaN(va[k8])) {
                                    skip = true;
                                    break;
                                }
                                ++k8;
                            }
                            if (!skip) {
                                k8 = 0;
                                while (k8 < is) {
                                    int n = k8;
                                    dresults[n] = dresults[n] * va[k8];
                                    ++k8;
                                }
                            }
                            ++j;
                        }
                    } else {
                        j = 0;
                        while (j < alen) {
                            spos[axis] = j;
                            double[] va = (double[])a.getObject(spos);
                            int k9 = 0;
                            while (k9 < is) {
                                int n = k9;
                                dresults[n] = dresults[n] * va[k9];
                                ++k9;
                            }
                            ++j;
                        }
                    }
                    result.set((Object)dresults, qpos);
                }
            }
        }
        result.setShape(ShapeUtils.squeezeShape(oshape, axis));
        return result;
    }

    public static Dataset cumulativeProduct(Dataset a) {
        return Stats.cumulativeProduct(a, false);
    }

    public static Dataset cumulativeProduct(Dataset a, boolean ignoreNaNs) {
        return Stats.cumulativeProduct(a.flatten(), ignoreNaNs, 0);
    }

    public static Dataset cumulativeProduct(Dataset a, int axis) {
        return Stats.cumulativeProduct(a, false, axis);
    }

    public static Dataset cumulativeProduct(Dataset a, boolean ignoreNaNs, int axis) {
        axis = a.checkAxis(axis);
        int dtype = a.getDType();
        int[] oshape = a.getShape();
        int alen = oshape[axis];
        oshape[axis] = 1;
        Dataset result = DatasetFactory.zeros(a);
        PositionIterator pi = result.getPositionIterator(axis);
        int[] pos = pi.getPos();
        block14: while (pi.hasNext()) {
            if (a.isComplex()) {
                double rv = 1.0;
                double iv = 0.0;
                switch (dtype) {
                    case 7: {
                        ComplexFloatDataset af = (ComplexFloatDataset)a;
                        if (ignoreNaNs) {
                            int j = 0;
                            while (j < alen) {
                                pos[axis] = j;
                                float r1 = af.getReal(pos);
                                float i1 = af.getImag(pos);
                                if (!Float.isNaN(r1) && !Float.isNaN(i1)) {
                                    double tv = (double)r1 * rv - (double)i1 * iv;
                                    iv = (double)r1 * iv + (double)i1 * rv;
                                    rv = tv;
                                    af.set((float)rv, (float)iv, pos);
                                }
                                ++j;
                            }
                        } else {
                            int j = 0;
                            while (j < alen) {
                                pos[axis] = j++;
                                float r1 = af.getReal(pos);
                                float i1 = af.getImag(pos);
                                double tv = (double)r1 * rv - (double)i1 * iv;
                                iv = (double)r1 * iv + (double)i1 * rv;
                                rv = tv;
                                af.set((float)rv, (float)iv, pos);
                            }
                        }
                        break;
                    }
                    case 8: {
                        double tv;
                        ComplexDoubleDataset ad = (ComplexDoubleDataset)a;
                        if (ignoreNaNs) {
                            int j = 0;
                            while (j < alen) {
                                pos[axis] = j;
                                double r1 = ad.getReal(pos);
                                double i1 = ad.getImag(pos);
                                if (!Double.isNaN(r1) && !Double.isNaN(i1)) {
                                    tv = r1 * rv - i1 * iv;
                                    iv = r1 * iv + i1 * rv;
                                    rv = tv;
                                    ad.set(rv, iv, pos);
                                }
                                ++j;
                            }
                        } else {
                            int j = 0;
                            while (j < alen) {
                                pos[axis] = j++;
                                double r1 = ad.getReal(pos);
                                double i1 = ad.getImag(pos);
                                tv = r1 * rv - i1 * iv;
                                iv = r1 * iv + i1 * rv;
                                rv = tv;
                                ad.set(rv, iv, pos);
                            }
                        }
                        break;
                    }
                }
                result.set((Object)new Complex(rv, iv), pos);
                continue;
            }
            switch (dtype) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    long lresult = 1L;
                    int j = 0;
                    while (j < alen) {
                        pos[axis] = j++;
                        result.set((Object)(lresult *= (long)a.getInt(pos)), pos);
                    }
                    continue block14;
                }
                case 100: {
                    int is = a.getElementsPerItem();
                    long[] lresults = new long[is];
                    int k = 0;
                    while (k < is) {
                        lresults[k] = 1L;
                        ++k;
                    }
                    int j = 0;
                    while (j < alen) {
                        pos[axis] = j;
                        byte[] va = (byte[])a.getObject(pos);
                        int k2 = 0;
                        while (k2 < is) {
                            int n = k2;
                            lresults[n] = lresults[n] * (long)va[k2];
                            ++k2;
                        }
                        result.set((Object)lresults, pos);
                        ++j;
                    }
                    continue block14;
                }
                case 200: {
                    int is = a.getElementsPerItem();
                    long[] lresults = new long[is];
                    int k = 0;
                    while (k < is) {
                        lresults[k] = 1L;
                        ++k;
                    }
                    int j = 0;
                    while (j < alen) {
                        pos[axis] = j;
                        short[] va = (short[])a.getObject(pos);
                        int k3 = 0;
                        while (k3 < is) {
                            int n = k3;
                            lresults[n] = lresults[n] * (long)va[k3];
                            ++k3;
                        }
                        result.set((Object)lresults, pos);
                        ++j;
                    }
                    continue block14;
                }
                case 300: {
                    int is = a.getElementsPerItem();
                    long[] lresults = new long[is];
                    int k = 0;
                    while (k < is) {
                        lresults[k] = 1L;
                        ++k;
                    }
                    int j = 0;
                    while (j < alen) {
                        pos[axis] = j;
                        int[] va = (int[])a.getObject(pos);
                        int k4 = 0;
                        while (k4 < is) {
                            int n = k4;
                            lresults[n] = lresults[n] * (long)va[k4];
                            ++k4;
                        }
                        result.set((Object)lresults, pos);
                        ++j;
                    }
                    continue block14;
                }
                case 400: {
                    int is = a.getElementsPerItem();
                    long[] lresults = new long[is];
                    int k = 0;
                    while (k < is) {
                        lresults[k] = 1L;
                        ++k;
                    }
                    int j = 0;
                    while (j < alen) {
                        pos[axis] = j;
                        long[] va = (long[])a.getObject(pos);
                        int k5 = 0;
                        while (k5 < is) {
                            int n = k5;
                            lresults[n] = lresults[n] * va[k5];
                            ++k5;
                        }
                        result.set((Object)lresults, pos);
                        ++j;
                    }
                    continue block14;
                }
                case 5: 
                case 6: {
                    double dresult = 1.0;
                    if (ignoreNaNs) {
                        int j = 0;
                        while (j < alen) {
                            pos[axis] = j;
                            double x = a.getDouble(pos);
                            if (!Double.isNaN(x)) {
                                result.set((Object)(dresult *= x), pos);
                            }
                            ++j;
                        }
                        continue block14;
                    }
                    int j = 0;
                    while (j < alen) {
                        pos[axis] = j++;
                        result.set((Object)(dresult *= a.getDouble(pos)), pos);
                    }
                    continue block14;
                }
                case 500: {
                    int k;
                    int j;
                    int is = a.getElementsPerItem();
                    double[] dresults = new double[is];
                    int k6 = 0;
                    while (k6 < is) {
                        dresults[k6] = 1.0;
                        ++k6;
                    }
                    if (ignoreNaNs) {
                        j = 0;
                        while (j < alen) {
                            pos[axis] = j;
                            float[] va = (float[])a.getObject(pos);
                            boolean skip = false;
                            k = 0;
                            while (k < is) {
                                if (Float.isNaN(va[k])) {
                                    skip = true;
                                    break;
                                }
                                ++k;
                            }
                            if (!skip) {
                                k = 0;
                                while (k < is) {
                                    int n = k;
                                    dresults[n] = dresults[n] * (double)va[k];
                                    ++k;
                                }
                            }
                            result.set((Object)dresults, pos);
                            ++j;
                        }
                        continue block14;
                    }
                    j = 0;
                    while (j < alen) {
                        pos[axis] = j;
                        float[] va = (float[])a.getObject(pos);
                        int k7 = 0;
                        while (k7 < is) {
                            int n = k7;
                            dresults[n] = dresults[n] * (double)va[k7];
                            ++k7;
                        }
                        result.set((Object)dresults, pos);
                        ++j;
                    }
                    continue block14;
                }
                case 600: {
                    int j;
                    int k;
                    int is = a.getElementsPerItem();
                    double[] dresults = new double[is];
                    int k8 = 0;
                    while (k8 < is) {
                        dresults[k8] = 1.0;
                        ++k8;
                    }
                    if (ignoreNaNs) {
                        j = 0;
                        while (j < alen) {
                            pos[axis] = j;
                            double[] va = (double[])a.getObject(pos);
                            boolean skip = false;
                            k = 0;
                            while (k < is) {
                                if (Double.isNaN(va[k])) {
                                    skip = true;
                                    break;
                                }
                                ++k;
                            }
                            if (!skip) {
                                k = 0;
                                while (k < is) {
                                    int n = k;
                                    dresults[n] = dresults[n] * va[k];
                                    ++k;
                                }
                            }
                            result.set((Object)dresults, pos);
                            ++j;
                        }
                        continue block14;
                    }
                    j = 0;
                    while (j < alen) {
                        pos[axis] = j;
                        double[] va = (double[])a.getObject(pos);
                        int k9 = 0;
                        while (k9 < is) {
                            int n = k9;
                            dresults[n] = dresults[n] * va[k9];
                            ++k9;
                        }
                        result.set((Object)dresults, pos);
                        ++j;
                    }
                    continue block14;
                }
            }
        }
        return result;
    }

    public static Dataset cumulativeSum(Dataset a) {
        return Stats.cumulativeSum(a, false);
    }

    public static Dataset cumulativeSum(Dataset a, boolean ignoreNaNs) {
        return Stats.cumulativeSum(a.flatten(), ignoreNaNs, 0);
    }

    public static Dataset cumulativeSum(Dataset a, int axis) {
        return Stats.cumulativeSum(a, false, axis);
    }

    public static Dataset cumulativeSum(Dataset a, boolean ignoreNaNs, int axis) {
        axis = a.checkAxis(axis);
        int dtype = a.getDType();
        int[] oshape = a.getShape();
        int alen = oshape[axis];
        oshape[axis] = 1;
        Dataset result = DatasetFactory.zeros(a);
        PositionIterator pi = result.getPositionIterator(axis);
        int[] pos = pi.getPos();
        block14: while (pi.hasNext()) {
            if (a.isComplex()) {
                double rv = 0.0;
                double iv = 0.0;
                switch (dtype) {
                    case 7: {
                        ComplexFloatDataset af = (ComplexFloatDataset)a;
                        if (ignoreNaNs) {
                            int j = 0;
                            while (j < alen) {
                                pos[axis] = j;
                                float x = af.getReal(pos);
                                float y = af.getImag(pos);
                                if (!Float.isNaN(x) && !Float.isNaN(y)) {
                                    af.set((float)(rv += (double)x), (float)(iv += (double)y), pos);
                                }
                                ++j;
                            }
                        } else {
                            int j = 0;
                            while (j < alen) {
                                pos[axis] = j++;
                                af.set((float)(rv += (double)af.getReal(pos)), (float)(iv += (double)af.getImag(pos)), pos);
                            }
                        }
                        break;
                    }
                    case 8: {
                        ComplexDoubleDataset ad = (ComplexDoubleDataset)a;
                        if (ignoreNaNs) {
                            int j = 0;
                            while (j < alen) {
                                pos[axis] = j;
                                double x = ad.getReal(pos);
                                double y = ad.getImag(pos);
                                if (!Double.isNaN(x) && !Double.isNaN(y)) {
                                    ad.set(rv += x, iv += y, pos);
                                }
                                ++j;
                            }
                        } else {
                            int j = 0;
                            while (j < alen) {
                                pos[axis] = j++;
                                ad.set(rv += ad.getReal(pos), iv += ad.getImag(pos), pos);
                            }
                        }
                        break;
                    }
                }
                result.set((Object)new Complex(rv, iv), pos);
                continue;
            }
            switch (dtype) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    long lresult = 0L;
                    int j = 0;
                    while (j < alen) {
                        pos[axis] = j++;
                        result.set((Object)(lresult += (long)a.getInt(pos)), pos);
                    }
                    continue block14;
                }
                case 100: {
                    int is = a.getElementsPerItem();
                    long[] lresults = new long[is];
                    int j = 0;
                    while (j < alen) {
                        pos[axis] = j;
                        byte[] va = (byte[])a.getObject(pos);
                        int k = 0;
                        while (k < is) {
                            int n = k;
                            lresults[n] = lresults[n] + (long)va[k];
                            ++k;
                        }
                        result.set((Object)lresults, pos);
                        ++j;
                    }
                    continue block14;
                }
                case 200: {
                    int is = a.getElementsPerItem();
                    long[] lresults = new long[is];
                    int j = 0;
                    while (j < alen) {
                        pos[axis] = j;
                        short[] va = (short[])a.getObject(pos);
                        int k = 0;
                        while (k < is) {
                            int n = k;
                            lresults[n] = lresults[n] + (long)va[k];
                            ++k;
                        }
                        result.set((Object)lresults, pos);
                        ++j;
                    }
                    continue block14;
                }
                case 300: {
                    int is = a.getElementsPerItem();
                    long[] lresults = new long[is];
                    int j = 0;
                    while (j < alen) {
                        pos[axis] = j;
                        int[] va = (int[])a.getObject(pos);
                        int k = 0;
                        while (k < is) {
                            int n = k;
                            lresults[n] = lresults[n] + (long)va[k];
                            ++k;
                        }
                        result.set((Object)lresults, pos);
                        ++j;
                    }
                    continue block14;
                }
                case 400: {
                    int is = a.getElementsPerItem();
                    long[] lresults = new long[is];
                    int j = 0;
                    while (j < alen) {
                        pos[axis] = j;
                        long[] va = (long[])a.getObject(pos);
                        int k = 0;
                        while (k < is) {
                            int n = k;
                            lresults[n] = lresults[n] + va[k];
                            ++k;
                        }
                        result.set((Object)lresults, pos);
                        ++j;
                    }
                    continue block14;
                }
                case 5: 
                case 6: {
                    double dresult = 0.0;
                    if (ignoreNaNs) {
                        int j = 0;
                        while (j < alen) {
                            pos[axis] = j;
                            double x = a.getDouble(pos);
                            if (!Double.isNaN(x)) {
                                result.set((Object)(dresult += x), pos);
                            }
                            ++j;
                        }
                        continue block14;
                    }
                    int j = 0;
                    while (j < alen) {
                        pos[axis] = j++;
                        result.set((Object)(dresult += a.getDouble(pos)), pos);
                    }
                    continue block14;
                }
                case 500: {
                    int k;
                    int is = a.getElementsPerItem();
                    double[] dresults = new double[is];
                    if (ignoreNaNs) {
                        int j = 0;
                        while (j < alen) {
                            pos[axis] = j;
                            float[] va = (float[])a.getObject(pos);
                            boolean skip = false;
                            k = 0;
                            while (k < is) {
                                if (Float.isNaN(va[k])) {
                                    skip = true;
                                    break;
                                }
                                ++k;
                            }
                            if (!skip) {
                                k = 0;
                                while (k < is) {
                                    int n = k;
                                    dresults[n] = dresults[n] + (double)va[k];
                                    ++k;
                                }
                            }
                            result.set((Object)dresults, pos);
                            ++j;
                        }
                        continue block14;
                    }
                    int j = 0;
                    while (j < alen) {
                        pos[axis] = j;
                        float[] va = (float[])a.getObject(pos);
                        int k2 = 0;
                        while (k2 < is) {
                            int n = k2;
                            dresults[n] = dresults[n] + (double)va[k2];
                            ++k2;
                        }
                        result.set((Object)dresults, pos);
                        ++j;
                    }
                    continue block14;
                }
                case 600: {
                    int k;
                    int is = a.getElementsPerItem();
                    double[] dresults = new double[is];
                    if (ignoreNaNs) {
                        int j = 0;
                        while (j < alen) {
                            pos[axis] = j;
                            double[] va = (double[])a.getObject(pos);
                            boolean skip = false;
                            k = 0;
                            while (k < is) {
                                if (Double.isNaN(va[k])) {
                                    skip = true;
                                    break;
                                }
                                ++k;
                            }
                            if (!skip) {
                                k = 0;
                                while (k < is) {
                                    int n = k;
                                    dresults[n] = dresults[n] + va[k];
                                    ++k;
                                }
                            }
                            result.set((Object)dresults, pos);
                            ++j;
                        }
                        continue block14;
                    }
                    int j = 0;
                    while (j < alen) {
                        pos[axis] = j;
                        double[] va = (double[])a.getObject(pos);
                        int k3 = 0;
                        while (k3 < is) {
                            int n = k3;
                            dresults[n] = dresults[n] + va[k3];
                            ++k3;
                        }
                        result.set((Object)dresults, pos);
                        ++j;
                    }
                    continue block14;
                }
            }
        }
        return result;
    }

    public static Object averageDeviation(Dataset a) {
        IndexIterator it = a.getIterator();
        int is = a.getElementsPerItem();
        if (is == 1) {
            double mean = (Double)a.mean(new boolean[0]);
            double sum = 0.0;
            while (it.hasNext()) {
                sum += Math.abs(a.getElementDoubleAbs(it.index) - mean);
            }
            return sum / (double)a.getSize();
        }
        double[] means = (double[])a.mean(new boolean[0]);
        double[] sums = new double[is];
        while (it.hasNext()) {
            int j = 0;
            while (j < is) {
                int n = j;
                sums[n] = sums[n] + Math.abs(a.getElementDoubleAbs(it.index + j) - means[j]);
                ++j;
            }
        }
        double n = a.getSize();
        int j = 0;
        while (j < is) {
            int n2 = j++;
            sums[n2] = sums[n2] / n;
        }
        return sums;
    }

    public static double residual(Dataset a, Dataset b) {
        return a.residual(b);
    }

    public static double weightedResidual(Dataset a, Dataset b, Dataset w) {
        return a.residual(b, w, false);
    }

    public static double[] outlierValues(Dataset a, double lo, double hi, int length) {
        if (lo <= 0.0 || hi <= 0.0 || lo >= hi || hi >= 100.0 || Double.isNaN(lo) || Double.isNaN(hi)) {
            throw new IllegalArgumentException("Thresholds must be between (0,100) and in order");
        }
        int size = a.getSize();
        int nl = Math.max((int)(lo * (double)size / 100.0), 1);
        if (length > 0 && nl > length) {
            nl = length;
        }
        int nh = Math.max((int)((100.0 - hi) * (double)size / 100.0), 1);
        if (length > 0 && nh > length) {
            nh = length;
        }
        double[] results = Math.max(nl, nh) > 640 ? Stats.outlierValuesMap(a, nl, nh) : Stats.outlierValuesList(a, nl, nh);
        results[2] = results[2] * 100.0 / (double)size;
        results[3] = 100.0 - results[3] * 100.0 / (double)size;
        return results;
    }

    static double[] outlierValuesMap(Dataset a, int nl, int nh) {
        double hx;
        TreeMap<Double, Integer> lMap = new TreeMap<Double, Integer>();
        TreeMap<Double, Integer> hMap = new TreeMap<Double, Integer>();
        int ml = 0;
        int mh = 0;
        IndexIterator it = a.getIterator();
        while (it.hasNext()) {
            Integer i;
            Double k;
            Double x = a.getElementDoubleAbs(it.index);
            if (ml == nl) {
                k = (Double)lMap.lastKey();
                if (x < k) {
                    i = (Integer)lMap.get(k) - 1;
                    if (i == 0) {
                        lMap.remove(k);
                    } else {
                        lMap.put(k, i);
                    }
                    i = (Integer)lMap.get(x);
                    if (i == null) {
                        lMap.put(x, 1);
                    } else {
                        lMap.put(x, i + 1);
                    }
                }
            } else {
                i = (Integer)lMap.get(x);
                if (i == null) {
                    lMap.put(x, 1);
                } else {
                    lMap.put(x, i + 1);
                }
                ++ml;
            }
            if (mh == nh) {
                k = (Double)hMap.firstKey();
                if (!(x > k)) continue;
                i = (Integer)hMap.get(k) - 1;
                if (i == 0) {
                    hMap.remove(k);
                } else {
                    hMap.put(k, i);
                }
                i = (Integer)hMap.get(x);
                if (i == null) {
                    hMap.put(x, 1);
                    continue;
                }
                hMap.put(x, i + 1);
                continue;
            }
            i = (Integer)hMap.get(x);
            if (i == null) {
                hMap.put(x, 1);
            } else {
                hMap.put(x, i + 1);
            }
            ++mh;
        }
        double lx = (Double)lMap.lastKey();
        if (lx >= (hx = ((Double)hMap.firstKey()).doubleValue())) {
            Double h = hMap.higherKey(lx);
            if (h != null) {
                hx = h;
                --mh;
            } else {
                Double l = lMap.lowerKey(hx);
                if (l != null) {
                    lx = l;
                    --ml;
                }
            }
        }
        return new double[]{(Double)lMap.lastKey(), (Double)hMap.firstKey(), ml, mh};
    }

    static double[] outlierValuesList(Dataset a, int nl, int nh) {
        ArrayList<Double> lList = new ArrayList<Double>(nl);
        ArrayList<Double> hList = new ArrayList<Double>(nh);
        double lx = Double.POSITIVE_INFINITY;
        double hx = Double.NEGATIVE_INFINITY;
        IndexIterator it = a.getIterator();
        while (it.hasNext()) {
            double x = a.getElementDoubleAbs(it.index);
            if (x < lx) {
                if (lList.size() == nl) {
                    lList.remove(lx);
                }
                lList.add(x);
                lx = (Double)Collections.max(lList);
            } else if (x == lx && lList.size() < nl) {
                lList.add(x);
            }
            if (x > hx) {
                if (hList.size() == nh) {
                    hList.remove(hx);
                }
                hList.add(x);
                hx = (Double)Collections.min(hList);
                continue;
            }
            if (x != hx || hList.size() >= nh) continue;
            hList.add(x);
        }
        nl = lList.size();
        nh = hList.size();
        if (lx >= hx) {
            Collections.sort(hList);
            Iterator iterator = hList.iterator();
            while (iterator.hasNext()) {
                double h = (Double)iterator.next();
                if (h > hx) {
                    hx = h;
                    break;
                }
                --nh;
            }
            if (lx >= hx) {
                Collections.sort(lList);
                Collections.reverse(lList);
                iterator = lList.iterator();
                while (iterator.hasNext()) {
                    double l = (Double)iterator.next();
                    if (l < lx) {
                        lx = l;
                        break;
                    }
                    --nl;
                }
            }
        }
        return new double[]{lx, hx, nl, nh};
    }

    public static Dataset covariance(Dataset a) {
        return Stats.covariance(a, true, false, null);
    }

    public static Dataset covariance(Dataset a, Boolean rowvar, Boolean bias, Integer ddof) {
        return Stats.covariance(a, null, rowvar, bias, ddof);
    }

    public static Dataset covariance(Dataset a, Dataset b) {
        return Stats.covariance(a, b, true, false, null);
    }

    public static Dataset covariance(Dataset a, Dataset b, Boolean rowvar, Boolean bias, Integer ddof) {
        double norm_fact;
        int axis;
        int nr;
        Dataset vars = a.clone();
        if (a.getRank() == 1) {
            vars.setShape(1, a.getShape()[0]);
        }
        if (vars.getShape()[0] == 1) {
            rowvar = true;
        }
        if (rowvar.booleanValue()) {
            nr = vars.getShape()[1];
            axis = 0;
        } else {
            nr = vars.getShape()[0];
            axis = 1;
        }
        if (ddof == null) {
            ddof = bias == false ? Integer.valueOf(1) : Integer.valueOf(0);
        }
        if ((norm_fact = (double)(nr - ddof)) <= 0.0) {
            norm_fact = 0.0;
        }
        if (b != null) {
            Dataset extraVars = b.clone();
            if (b.getRank() == 1) {
                extraVars.setShape(1, a.getShape()[0]);
            }
            vars = DatasetUtils.concatenate(new Dataset[]{vars, extraVars}, axis);
        }
        Dataset varsMean = vars.mean(false, 1 - axis);
        int[] meanShape = vars.getShape();
        meanShape[1 - axis] = 1;
        varsMean.setShape(meanShape);
        vars.isubtract(varsMean);
        Dataset cov = rowvar != false ? Maths.divide(LinearAlgebra.dotProduct(vars, Maths.conjugate(vars.transpose(new int[0]))), norm_fact).squeeze() : Maths.divide(LinearAlgebra.dotProduct(vars.transpose(new int[0]), Maths.conjugate(vars)), norm_fact).squeeze();
        return cov;
    }
}

