/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.lang.reflect.Array;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.complex.Complex;
import org.eclipse.january.dataset.BooleanDataset;
import org.eclipse.january.dataset.ByteDataset;
import org.eclipse.january.dataset.ComplexDoubleDataset;
import org.eclipse.january.dataset.ComplexFloatDataset;
import org.eclipse.january.dataset.CompoundByteDataset;
import org.eclipse.january.dataset.CompoundDoubleDataset;
import org.eclipse.january.dataset.CompoundFloatDataset;
import org.eclipse.january.dataset.CompoundIntegerDataset;
import org.eclipse.january.dataset.CompoundLongDataset;
import org.eclipse.january.dataset.CompoundShortDataset;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DateDataset;
import org.eclipse.january.dataset.DoubleDataset;
import org.eclipse.january.dataset.FloatDataset;
import org.eclipse.january.dataset.IDataset;
import org.eclipse.january.dataset.ILazyDataset;
import org.eclipse.january.dataset.IntegerDataset;
import org.eclipse.january.dataset.LazyDatasetBase;
import org.eclipse.january.dataset.LongDataset;
import org.eclipse.january.dataset.ObjectDataset;
import org.eclipse.january.dataset.RGBDataset;
import org.eclipse.january.dataset.ShortDataset;
import org.eclipse.january.dataset.StringDataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DTypeUtils {
    protected static final Logger logger = LoggerFactory.getLogger(DTypeUtils.class);
    private static final Map<Class<? extends Dataset>, Integer> interface2DTypes = DTypeUtils.createInterfaceMap();
    private static final transient Map<Class<?>, Integer> class2DType = DTypeUtils.createElementClassMap();

    private static Map<Class<? extends Dataset>, Integer> createInterfaceMap() {
        HashMap<Class<? extends Dataset>, Integer> map = new HashMap<Class<? extends Dataset>, Integer>();
        map.put(BooleanDataset.class, 0);
        map.put(ByteDataset.class, 1);
        map.put(ShortDataset.class, 2);
        map.put(IntegerDataset.class, 3);
        map.put(LongDataset.class, 4);
        map.put(FloatDataset.class, 5);
        map.put(DoubleDataset.class, 6);
        map.put(CompoundByteDataset.class, 100);
        map.put(CompoundShortDataset.class, 200);
        map.put(CompoundIntegerDataset.class, 300);
        map.put(CompoundLongDataset.class, 400);
        map.put(CompoundFloatDataset.class, 500);
        map.put(CompoundDoubleDataset.class, 600);
        map.put(ComplexFloatDataset.class, 7);
        map.put(ComplexDoubleDataset.class, 8);
        map.put(ObjectDataset.class, 10);
        map.put(StringDataset.class, 9);
        map.put(DateDataset.class, 11);
        map.put(RGBDataset.class, 203);
        map.put(ObjectDataset.class, 10);
        return map;
    }

    private static Map<Class<?>, Integer> createElementClassMap() {
        HashMap result = new HashMap();
        result.put(Boolean.class, 0);
        result.put(Byte.class, 1);
        result.put(Short.class, 2);
        result.put(Integer.class, 3);
        result.put(Long.class, 4);
        result.put(Float.class, 5);
        result.put(Double.class, 6);
        result.put(Boolean.TYPE, 0);
        result.put(Byte.TYPE, 1);
        result.put(Short.TYPE, 2);
        result.put(Integer.TYPE, 3);
        result.put(Long.TYPE, 4);
        result.put(Float.TYPE, 5);
        result.put(Double.TYPE, 6);
        result.put(Complex.class, 8);
        result.put(String.class, 9);
        result.put(Date.class, 11);
        result.put(Object.class, 10);
        return result;
    }

    public static String getDTypeName(Dataset a) {
        return DTypeUtils.getDTypeName(a.getDType(), a.getElementsPerItem());
    }

    public static String getDTypeName(ILazyDataset a) {
        return DTypeUtils.getDTypeName(DTypeUtils.getDTypeFromClass(a.getElementClass()), a.getElementsPerItem());
    }

    public static String getDTypeName(int dtype, int itemSize) {
        String prefix;
        int bytes = DTypeUtils.getItemBytes(dtype, itemSize);
        if (DTypeUtils.isDTypeComplex(dtype)) {
            return "COMPLEX" + bytes * 8;
        }
        if (dtype == 203) {
            return "RGB";
        }
        String string = prefix = itemSize > 1 ? "ARRAY of " + itemSize + " " : "";
        if (DTypeUtils.isDTypeFloating(dtype)) {
            return String.valueOf(prefix) + "FLOAT" + bytes * 8;
        }
        switch (dtype) {
            case 0: {
                return String.valueOf(prefix) + "BOOLEAN";
            }
            case 9: {
                return String.valueOf(prefix) + "STRING";
            }
            case 11: {
                return String.valueOf(prefix) + "DATE";
            }
            case 10: {
                return String.valueOf(prefix) + "OBJECT";
            }
        }
        return String.valueOf(prefix) + "INT" + bytes * 8;
    }

    public static int getDType(Class<? extends Dataset> clazz) {
        if (!interface2DTypes.containsKey(clazz)) {
            throw new IllegalArgumentException("Interface class not allowed or supported");
        }
        return interface2DTypes.get(clazz);
    }

    public static boolean isDTypeElemental(int dtype) {
        return dtype <= 11;
    }

    public static boolean isDTypeInteger(int dtype) {
        return dtype == 1 || dtype == 2 || dtype == 3 || dtype == 4 || dtype == 100 || dtype == 200 || dtype == 300 || dtype == 400 || dtype == 203;
    }

    public static boolean isDTypeFloating(int dtype) {
        return dtype == 5 || dtype == 6 || dtype == 7 || dtype == 8 || dtype == 500 || dtype == 600;
    }

    public static boolean isDTypeComplex(int dtype) {
        return dtype == 7 || dtype == 8;
    }

    public static boolean isDTypeNumerical(int dtype) {
        return DTypeUtils.isDTypeInteger(dtype) || DTypeUtils.isDTypeFloating(dtype) || dtype == 0;
    }

    public static int getBestDType(int atype, int btype) {
        int besttype;
        int b;
        int a = atype >= 100 ? atype / 100 : atype;
        int n = b = btype >= 100 ? btype / 100 : btype;
        if (DTypeUtils.isDTypeFloating(a)) {
            if (!DTypeUtils.isDTypeFloating(b)) {
                b = DTypeUtils.getBestFloatDType(b);
                if (DTypeUtils.isDTypeComplex(a)) {
                    b += 2;
                }
            }
        } else if (DTypeUtils.isDTypeFloating(b)) {
            a = DTypeUtils.getBestFloatDType(a);
            if (DTypeUtils.isDTypeComplex(b)) {
                a += 2;
            }
        }
        int n2 = besttype = a > b ? a : b;
        if (atype >= 100 || btype >= 100) {
            if (besttype >= 7) {
                throw new IllegalArgumentException("Complex type cannot be promoted to compound type");
            }
            besttype *= 100;
        }
        return besttype;
    }

    public static int getBestFloatDType(int otype) {
        int btype;
        switch (otype) {
            case 0: 
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 100: 
            case 200: 
            case 203: 
            case 500: {
                btype = 5;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 300: 
            case 400: 
            case 600: {
                btype = 6;
                break;
            }
            default: {
                btype = otype;
            }
        }
        return btype;
    }

    public static int getBestFloatDType(Class<? extends Object> cls) {
        return DTypeUtils.getBestFloatDType(DTypeUtils.getDTypeFromClass(cls));
    }

    public static int getDTypeFromClass(Class<? extends Object> cls) {
        return DTypeUtils.getDTypeFromClass(cls, 1);
    }

    public static int getDTypeFromClass(Class<? extends Object> cls, int isize) {
        Integer dtype = class2DType.get(cls);
        if (dtype == null) {
            throw new IllegalArgumentException("Class of object not supported");
        }
        if (isize != 1 && dtype < 6) {
            dtype = dtype * 100;
        }
        return dtype;
    }

    public static int getDTypeFromObject(Object obj) {
        int dtype = -1;
        if (obj == null) {
            return dtype;
        }
        if (obj instanceof List) {
            List jl = (List)obj;
            int l = jl.size();
            int i = 0;
            while (i < l) {
                int ldtype = DTypeUtils.getDTypeFromObject(jl.get(i));
                if (ldtype > dtype) {
                    dtype = ldtype;
                }
                ++i;
            }
        } else if (obj.getClass().isArray()) {
            Class<?> ca = obj.getClass().getComponentType();
            if (DTypeUtils.isClassSupportedAsElement(ca)) {
                return DTypeUtils.getDTypeFromClass(ca);
            }
            int l = Array.getLength(obj);
            int i = 0;
            while (i < l) {
                Object lo = Array.get(obj, i);
                int ldtype = DTypeUtils.getDTypeFromObject(lo);
                if (ldtype > dtype) {
                    dtype = ldtype;
                }
                ++i;
            }
        } else {
            if (obj instanceof Dataset) {
                return ((Dataset)obj).getDType();
            }
            dtype = obj instanceof ILazyDataset ? DTypeUtils.getDTypeFromClass(((ILazyDataset)obj).getElementClass(), ((ILazyDataset)obj).getElementsPerItem()) : DTypeUtils.getDTypeFromClass(obj.getClass());
        }
        return dtype;
    }

    public static int getDType(ILazyDataset d) {
        if (d instanceof LazyDatasetBase) {
            return ((LazyDatasetBase)d).getDType();
        }
        return DTypeUtils.getDTypeFromClass(d.getElementClass(), d.getElementsPerItem());
    }

    public static int getLargestDType(int otype) {
        switch (otype) {
            case 0: 
            case 1: 
            case 2: {
                return 3;
            }
            case 3: 
            case 4: {
                return 4;
            }
            case 5: 
            case 6: {
                return 6;
            }
            case 7: 
            case 8: {
                return 8;
            }
            case 100: 
            case 200: {
                return 300;
            }
            case 300: 
            case 400: {
                return 400;
            }
            case 500: 
            case 600: {
                return 600;
            }
            case 9: 
            case 10: 
            case 11: 
            case 203: {
                return otype;
            }
        }
        throw new IllegalArgumentException("Unsupported dataset type");
    }

    public static int getElementalDType(int otype) {
        switch (otype) {
            case 7: {
                return 5;
            }
            case 8: {
                return 6;
            }
            case 100: {
                return 1;
            }
            case 200: 
            case 203: {
                return 2;
            }
            case 300: {
                return 3;
            }
            case 400: {
                return 4;
            }
            case 500: {
                return 5;
            }
            case 600: {
                return 6;
            }
        }
        return otype;
    }

    public static boolean isClassSupportedAsElement(Class<? extends Object> comp) {
        return comp.isPrimitive() || Number.class.isAssignableFrom(comp) || comp.equals(Boolean.class) || comp.equals(Complex.class) || comp.equals(String.class) || comp.equals(Date.class);
    }

    public static int getElementsPerItem(int dtype) {
        switch (dtype) {
            case 100: 
            case 200: 
            case 300: 
            case 400: 
            case 500: 
            case 600: {
                throw new UnsupportedOperationException("Multi-element type unsupported");
            }
            case 7: 
            case 8: {
                return 2;
            }
            case 203: {
                return 3;
            }
        }
        return 1;
    }

    public static int getItemBytes(int dtype) {
        return DTypeUtils.getItemBytes(dtype, DTypeUtils.getElementsPerItem(dtype));
    }

    public static int getItemBytes(int dtype, int isize) {
        int size;
        switch (dtype) {
            case 0: {
                size = 1;
                break;
            }
            case 1: 
            case 100: {
                size = 1;
                break;
            }
            case 2: 
            case 200: 
            case 203: {
                size = 2;
                break;
            }
            case 3: 
            case 300: {
                size = 4;
                break;
            }
            case 4: 
            case 400: {
                size = 8;
                break;
            }
            case 5: 
            case 7: 
            case 500: {
                size = 4;
                break;
            }
            case 6: 
            case 8: 
            case 600: {
                size = 8;
                break;
            }
            default: {
                size = 0;
            }
        }
        return size * isize;
    }

    public static boolean toBoolean(Object b) {
        if (b instanceof Number) {
            return ((Number)b).longValue() != 0L;
        }
        if (b instanceof Boolean) {
            return (Boolean)b;
        }
        if (b instanceof Complex) {
            return ((Complex)b).getReal() != 0.0;
        }
        if (b instanceof Dataset) {
            Dataset db = (Dataset)b;
            if (db.getSize() != 1) {
                logger.error("Given dataset must have only one item");
                throw new IllegalArgumentException("Given dataset must have only one item");
            }
            return DTypeUtils.toBoolean(db.getObjectAbs(0));
        }
        if (b instanceof IDataset) {
            IDataset db = (IDataset)b;
            if (db.getSize() != 1) {
                logger.error("Given dataset must have only one item");
                throw new IllegalArgumentException("Given dataset must have only one item");
            }
            return DTypeUtils.toBoolean(db.getObject(new int[db.getRank()]));
        }
        logger.error("Argument is of unsupported class");
        throw new IllegalArgumentException("Argument is of unsupported class");
    }

    public static long toLong(Object b) {
        if (b instanceof Number) {
            return ((Number)b).longValue();
        }
        if (b instanceof Boolean) {
            return (Boolean)b != false ? 1 : 0;
        }
        if (b instanceof Complex) {
            return (long)((Complex)b).getReal();
        }
        if (b instanceof Dataset) {
            Dataset db = (Dataset)b;
            if (db.getSize() != 1) {
                logger.error("Given dataset must have only one item");
                throw new IllegalArgumentException("Given dataset must have only one item");
            }
            return DTypeUtils.toLong(db.getObjectAbs(0));
        }
        if (b instanceof IDataset) {
            IDataset db = (IDataset)b;
            if (db.getSize() != 1) {
                logger.error("Given dataset must have only one item");
                throw new IllegalArgumentException("Given dataset must have only one item");
            }
            return DTypeUtils.toLong(db.getObject(new int[db.getRank()]));
        }
        logger.error("Argument is of unsupported class");
        throw new IllegalArgumentException("Argument is of unsupported class");
    }

    public static double toReal(Object b) {
        if (b instanceof Number) {
            return ((Number)b).doubleValue();
        }
        if (b instanceof Boolean) {
            return (Boolean)b != false ? 1 : 0;
        }
        if (b instanceof Complex) {
            return ((Complex)b).getReal();
        }
        if (b.getClass().isArray()) {
            if (Array.getLength(b) == 0) {
                return 0.0;
            }
            return DTypeUtils.toReal(Array.get(b, 0));
        }
        if (b instanceof Dataset) {
            Dataset db = (Dataset)b;
            if (db.getSize() != 1) {
                logger.error("Given dataset must have only one item");
                throw new IllegalArgumentException("Given dataset must have only one item");
            }
            return DTypeUtils.toReal(db.getObjectAbs(0));
        }
        if (b instanceof IDataset) {
            Dataset db = (Dataset)b;
            if (db.getSize() != 1) {
                logger.error("Given dataset must have only one item");
                throw new IllegalArgumentException("Given dataset must have only one item");
            }
            return DTypeUtils.toReal(db.getObject(new int[db.getRank()]));
        }
        logger.error("Argument is of unsupported class");
        throw new IllegalArgumentException("Argument is of unsupported class");
    }

    public static double toImag(Object b) {
        if (b instanceof Number) {
            return 0.0;
        }
        if (b instanceof Boolean) {
            return 0.0;
        }
        if (b instanceof Complex) {
            return ((Complex)b).getImaginary();
        }
        if (b.getClass().isArray()) {
            if (Array.getLength(b) < 2) {
                return 0.0;
            }
            return DTypeUtils.toReal(Array.get(b, 1));
        }
        if (b instanceof Dataset) {
            Dataset db = (Dataset)b;
            if (db.getSize() != 1) {
                logger.error("Given dataset must have only one item");
                throw new IllegalArgumentException("Given dataset must have only one item");
            }
            return DTypeUtils.toImag(db.getObjectAbs(0));
        }
        if (b instanceof IDataset) {
            Dataset db = (Dataset)b;
            if (db.getSize() != 1) {
                logger.error("Given dataset must have only one item");
                throw new IllegalArgumentException("Given dataset must have only one item");
            }
            return DTypeUtils.toImag(db.getObject(new int[db.getRank()]));
        }
        logger.error("Argument is of unsupported class");
        throw new IllegalArgumentException("Argument is of unsupported class");
    }

    public static double[] toDoubleArray(Object b, int itemSize) {
        double[] result = null;
        if (b instanceof Number) {
            result = new double[itemSize];
            double val = ((Number)b).doubleValue();
            int i = 0;
            while (i < itemSize) {
                result[i] = val;
                ++i;
            }
        } else if (b instanceof double[]) {
            result = (double[])b;
            if (result.length < itemSize) {
                result = new double[itemSize];
                int ilen = result.length;
                int i = 0;
                while (i < ilen) {
                    result[i] = ((double[])b)[i];
                    ++i;
                }
            }
        } else if (b instanceof List) {
            result = new double[itemSize];
            List jl = (List)b;
            int ilen = jl.size();
            if (ilen > 0 && !(jl.get(0) instanceof Number)) {
                logger.error("Given array was not of a numerical primitive type");
                throw new IllegalArgumentException("Given array was not of a numerical primitive type");
            }
            ilen = Math.min(itemSize, ilen);
            int i = 0;
            while (i < ilen) {
                result[i] = DTypeUtils.toReal(jl.get(i));
                ++i;
            }
        } else if (b.getClass().isArray()) {
            result = new double[itemSize];
            int ilen = Array.getLength(b);
            if (ilen > 0 && !(Array.get(b, 0) instanceof Number)) {
                logger.error("Given array was not of a numerical primitive type");
                throw new IllegalArgumentException("Given array was not of a numerical primitive type");
            }
            ilen = Math.min(itemSize, ilen);
            int i = 0;
            while (i < ilen) {
                result[i] = ((Number)Array.get(b, i)).doubleValue();
                ++i;
            }
        } else if (b instanceof Complex) {
            if (itemSize > 2) {
                logger.error("Complex number will not fit in compound dataset");
                throw new IllegalArgumentException("Complex number will not fit in compound dataset");
            }
            Complex cb = (Complex)b;
            switch (itemSize) {
                default: {
                    break;
                }
                case 1: {
                    result = new double[]{cb.getReal()};
                    break;
                }
                case 2: {
                    result = new double[]{cb.getReal(), cb.getImaginary()};
                    break;
                }
            }
        } else {
            if (b instanceof Dataset) {
                Dataset db = (Dataset)b;
                if (db.getSize() != 1) {
                    logger.error("Given dataset must have only one item");
                    throw new IllegalArgumentException("Given dataset must have only one item");
                }
                return DTypeUtils.toDoubleArray(db.getObjectAbs(0), itemSize);
            }
            if (b instanceof IDataset) {
                Dataset db = (Dataset)b;
                if (db.getSize() != 1) {
                    logger.error("Given dataset must have only one item");
                    throw new IllegalArgumentException("Given dataset must have only one item");
                }
                return DTypeUtils.toDoubleArray(db.getObject(new int[db.getRank()]), itemSize);
            }
        }
        return result;
    }

    public static float[] toFloatArray(Object b, int itemSize) {
        float[] result = null;
        if (b instanceof Number) {
            result = new float[itemSize];
            float val = ((Number)b).floatValue();
            int i = 0;
            while (i < itemSize) {
                result[i] = val;
                ++i;
            }
        } else if (b instanceof float[]) {
            result = (float[])b;
            if (result.length < itemSize) {
                result = new float[itemSize];
                int ilen = result.length;
                int i = 0;
                while (i < ilen) {
                    result[i] = ((float[])b)[i];
                    ++i;
                }
            }
        } else if (b instanceof List) {
            result = new float[itemSize];
            List jl = (List)b;
            int ilen = jl.size();
            if (ilen > 0 && !(jl.get(0) instanceof Number)) {
                logger.error("Given array was not of a numerical primitive type");
                throw new IllegalArgumentException("Given array was not of a numerical primitive type");
            }
            ilen = Math.min(itemSize, ilen);
            int i = 0;
            while (i < ilen) {
                result[i] = (float)DTypeUtils.toReal(jl.get(i));
                ++i;
            }
        } else if (b.getClass().isArray()) {
            result = new float[itemSize];
            int ilen = Array.getLength(b);
            if (ilen > 0 && !(Array.get(b, 0) instanceof Number)) {
                logger.error("Given array was not of a numerical primitive type");
                throw new IllegalArgumentException("Given array was not of a numerical primitive type");
            }
            ilen = Math.min(itemSize, ilen);
            int i = 0;
            while (i < ilen) {
                result[i] = ((Number)Array.get(b, i)).floatValue();
                ++i;
            }
        } else if (b instanceof Complex) {
            if (itemSize > 2) {
                logger.error("Complex number will not fit in compound dataset");
                throw new IllegalArgumentException("Complex number will not fit in compound dataset");
            }
            Complex cb = (Complex)b;
            switch (itemSize) {
                default: {
                    break;
                }
                case 1: {
                    result = new float[]{(float)cb.getReal()};
                    break;
                }
                case 2: {
                    result = new float[]{(float)cb.getReal(), (float)cb.getImaginary()};
                    break;
                }
            }
        } else {
            if (b instanceof Dataset) {
                Dataset db = (Dataset)b;
                if (db.getSize() != 1) {
                    logger.error("Given dataset must have only one item");
                    throw new IllegalArgumentException("Given dataset must have only one item");
                }
                return DTypeUtils.toFloatArray(db.getObjectAbs(0), itemSize);
            }
            if (b instanceof IDataset) {
                Dataset db = (Dataset)b;
                if (db.getSize() != 1) {
                    logger.error("Given dataset must have only one item");
                    throw new IllegalArgumentException("Given dataset must have only one item");
                }
                return DTypeUtils.toFloatArray(db.getObject(new int[db.getRank()]), itemSize);
            }
        }
        return result;
    }

    public static long[] toLongArray(Object b, int itemSize) {
        long[] result = null;
        if (b instanceof Number) {
            result = new long[itemSize];
            long val = ((Number)b).longValue();
            int i = 0;
            while (i < itemSize) {
                result[i] = val;
                ++i;
            }
        } else if (b instanceof long[]) {
            result = (long[])b;
            if (result.length < itemSize) {
                result = new long[itemSize];
                int ilen = result.length;
                int i = 0;
                while (i < ilen) {
                    result[i] = ((long[])b)[i];
                    ++i;
                }
            }
        } else if (b instanceof List) {
            result = new long[itemSize];
            List jl = (List)b;
            int ilen = jl.size();
            if (ilen > 0 && !(jl.get(0) instanceof Number)) {
                logger.error("Given array was not of a numerical primitive type");
                throw new IllegalArgumentException("Given array was not of a numerical primitive type");
            }
            ilen = Math.min(itemSize, ilen);
            int i = 0;
            while (i < ilen) {
                result[i] = DTypeUtils.toLong(jl.get(i));
                ++i;
            }
        } else if (b.getClass().isArray()) {
            result = new long[itemSize];
            int ilen = Array.getLength(b);
            if (ilen > 0 && !(Array.get(b, 0) instanceof Number)) {
                logger.error("Given array was not of a numerical primitive type");
                throw new IllegalArgumentException("Given array was not of a numerical primitive type");
            }
            ilen = Math.min(itemSize, ilen);
            int i = 0;
            while (i < ilen) {
                result[i] = ((Number)Array.get(b, i)).longValue();
                ++i;
            }
        } else if (b instanceof Complex) {
            if (itemSize > 2) {
                logger.error("Complex number will not fit in compound dataset");
                throw new IllegalArgumentException("Complex number will not fit in compound dataset");
            }
            Complex cb = (Complex)b;
            switch (itemSize) {
                default: {
                    break;
                }
                case 1: {
                    result = new long[]{(long)cb.getReal()};
                    break;
                }
                case 2: {
                    result = new long[]{(long)cb.getReal(), (long)cb.getImaginary()};
                    break;
                }
            }
        } else {
            if (b instanceof Dataset) {
                Dataset db = (Dataset)b;
                if (db.getSize() != 1) {
                    logger.error("Given dataset must have only one item");
                    throw new IllegalArgumentException("Given dataset must have only one item");
                }
                return DTypeUtils.toLongArray(db.getObjectAbs(0), itemSize);
            }
            if (b instanceof IDataset) {
                Dataset db = (Dataset)b;
                if (db.getSize() != 1) {
                    logger.error("Given dataset must have only one item");
                    throw new IllegalArgumentException("Given dataset must have only one item");
                }
                return DTypeUtils.toLongArray(db.getObject(new int[db.getRank()]), itemSize);
            }
        }
        return result;
    }

    public static int[] toIntegerArray(Object b, int itemSize) {
        int[] result = null;
        if (b instanceof Number) {
            result = new int[itemSize];
            int val = ((Number)b).intValue();
            int i = 0;
            while (i < itemSize) {
                result[i] = val;
                ++i;
            }
        } else if (b instanceof int[]) {
            result = (int[])b;
            if (result.length < itemSize) {
                result = new int[itemSize];
                int ilen = result.length;
                int i = 0;
                while (i < ilen) {
                    result[i] = ((int[])b)[i];
                    ++i;
                }
            }
        } else if (b instanceof List) {
            result = new int[itemSize];
            List jl = (List)b;
            int ilen = jl.size();
            if (ilen > 0 && !(jl.get(0) instanceof Number)) {
                logger.error("Given array was not of a numerical primitive type");
                throw new IllegalArgumentException("Given array was not of a numerical primitive type");
            }
            ilen = Math.min(itemSize, ilen);
            int i = 0;
            while (i < ilen) {
                result[i] = (int)DTypeUtils.toLong(jl.get(i));
                ++i;
            }
        } else if (b.getClass().isArray()) {
            result = new int[itemSize];
            int ilen = Array.getLength(b);
            if (ilen > 0 && !(Array.get(b, 0) instanceof Number)) {
                logger.error("Given array was not of a numerical primitive type");
                throw new IllegalArgumentException("Given array was not of a numerical primitive type");
            }
            ilen = Math.min(itemSize, ilen);
            int i = 0;
            while (i < ilen) {
                result[i] = (int)((Number)Array.get(b, i)).longValue();
                ++i;
            }
        } else if (b instanceof Complex) {
            if (itemSize > 2) {
                logger.error("Complex number will not fit in compound dataset");
                throw new IllegalArgumentException("Complex number will not fit in compound dataset");
            }
            Complex cb = (Complex)b;
            switch (itemSize) {
                default: {
                    break;
                }
                case 1: {
                    result = new int[]{(int)cb.getReal()};
                    break;
                }
                case 2: {
                    result = new int[]{(int)cb.getReal(), (int)cb.getImaginary()};
                    break;
                }
            }
        } else {
            if (b instanceof Dataset) {
                Dataset db = (Dataset)b;
                if (db.getSize() != 1) {
                    logger.error("Given dataset must have only one item");
                    throw new IllegalArgumentException("Given dataset must have only one item");
                }
                return DTypeUtils.toIntegerArray(db.getObjectAbs(0), itemSize);
            }
            if (b instanceof IDataset) {
                Dataset db = (Dataset)b;
                if (db.getSize() != 1) {
                    logger.error("Given dataset must have only one item");
                    throw new IllegalArgumentException("Given dataset must have only one item");
                }
                return DTypeUtils.toIntegerArray(db.getObject(new int[db.getRank()]), itemSize);
            }
        }
        return result;
    }

    public static short[] toShortArray(Object b, int itemSize) {
        short[] result = null;
        if (b instanceof Number) {
            result = new short[itemSize];
            short val = ((Number)b).shortValue();
            int i = 0;
            while (i < itemSize) {
                result[i] = val;
                ++i;
            }
        } else if (b instanceof short[]) {
            result = (short[])b;
            if (result.length < itemSize) {
                result = new short[itemSize];
                int ilen = result.length;
                int i = 0;
                while (i < ilen) {
                    result[i] = ((short[])b)[i];
                    ++i;
                }
            }
        } else if (b instanceof List) {
            result = new short[itemSize];
            List jl = (List)b;
            int ilen = jl.size();
            if (ilen > 0 && !(jl.get(0) instanceof Number)) {
                logger.error("Given array was not of a numerical primitive type");
                throw new IllegalArgumentException("Given array was not of a numerical primitive type");
            }
            ilen = Math.min(itemSize, ilen);
            int i = 0;
            while (i < ilen) {
                result[i] = (short)DTypeUtils.toLong(jl.get(i));
                ++i;
            }
        } else if (b.getClass().isArray()) {
            result = new short[itemSize];
            int ilen = Array.getLength(b);
            if (ilen > 0 && !(Array.get(b, 0) instanceof Number)) {
                logger.error("Given array was not of a numerical primitive type");
                throw new IllegalArgumentException("Given array was not of a numerical primitive type");
            }
            ilen = Math.min(itemSize, ilen);
            int i = 0;
            while (i < ilen) {
                result[i] = (short)((Number)Array.get(b, i)).longValue();
                ++i;
            }
        } else if (b instanceof Complex) {
            if (itemSize > 2) {
                logger.error("Complex number will not fit in compound dataset");
                throw new IllegalArgumentException("Complex number will not fit in compound dataset");
            }
            Complex cb = (Complex)b;
            switch (itemSize) {
                default: {
                    break;
                }
                case 1: {
                    result = new short[]{(short)cb.getReal()};
                    break;
                }
                case 2: {
                    result = new short[]{(short)cb.getReal(), (short)cb.getImaginary()};
                    break;
                }
            }
        } else {
            if (b instanceof Dataset) {
                Dataset db = (Dataset)b;
                if (db.getSize() != 1) {
                    logger.error("Given dataset must have only one item");
                    throw new IllegalArgumentException("Given dataset must have only one item");
                }
                return DTypeUtils.toShortArray(db.getObjectAbs(0), itemSize);
            }
            if (b instanceof IDataset) {
                Dataset db = (Dataset)b;
                if (db.getSize() != 1) {
                    logger.error("Given dataset must have only one item");
                    throw new IllegalArgumentException("Given dataset must have only one item");
                }
                return DTypeUtils.toShortArray(db.getObject(new int[db.getRank()]), itemSize);
            }
        }
        return result;
    }

    public static byte[] toByteArray(Object b, int itemSize) {
        byte[] result = null;
        if (b instanceof Number) {
            result = new byte[itemSize];
            byte val = ((Number)b).byteValue();
            int i = 0;
            while (i < itemSize) {
                result[i] = val;
                ++i;
            }
        } else if (b instanceof byte[]) {
            result = (byte[])b;
            if (result.length < itemSize) {
                result = new byte[itemSize];
                int ilen = result.length;
                int i = 0;
                while (i < ilen) {
                    result[i] = ((byte[])b)[i];
                    ++i;
                }
            }
        } else if (b instanceof List) {
            result = new byte[itemSize];
            List jl = (List)b;
            int ilen = jl.size();
            if (ilen > 0 && !(jl.get(0) instanceof Number)) {
                logger.error("Given array was not of a numerical primitive type");
                throw new IllegalArgumentException("Given array was not of a numerical primitive type");
            }
            ilen = Math.min(itemSize, ilen);
            int i = 0;
            while (i < ilen) {
                result[i] = (byte)DTypeUtils.toLong(jl.get(i));
                ++i;
            }
        } else if (b.getClass().isArray()) {
            result = new byte[itemSize];
            int ilen = Array.getLength(b);
            if (ilen > 0 && !(Array.get(b, 0) instanceof Number)) {
                logger.error("Given array was not of a numerical primitive type");
                throw new IllegalArgumentException("Given array was not of a numerical primitive type");
            }
            ilen = Math.min(itemSize, ilen);
            int i = 0;
            while (i < ilen) {
                result[i] = (byte)((Number)Array.get(b, i)).longValue();
                ++i;
            }
        } else if (b instanceof Complex) {
            if (itemSize > 2) {
                logger.error("Complex number will not fit in compound dataset");
                throw new IllegalArgumentException("Complex number will not fit in compound dataset");
            }
            Complex cb = (Complex)b;
            switch (itemSize) {
                default: {
                    break;
                }
                case 1: {
                    result = new byte[]{(byte)cb.getReal()};
                    break;
                }
                case 2: {
                    result = new byte[]{(byte)cb.getReal(), (byte)cb.getImaginary()};
                    break;
                }
            }
        } else {
            if (b instanceof Dataset) {
                Dataset db = (Dataset)b;
                if (db.getSize() != 1) {
                    logger.error("Given dataset must have only one item");
                    throw new IllegalArgumentException("Given dataset must have only one item");
                }
                return DTypeUtils.toByteArray(db.getObjectAbs(0), itemSize);
            }
            if (b instanceof IDataset) {
                Dataset db = (Dataset)b;
                if (db.getSize() != 1) {
                    logger.error("Given dataset must have only one item");
                    throw new IllegalArgumentException("Given dataset must have only one item");
                }
                return DTypeUtils.toByteArray(db.getObject(new int[db.getRank()]), itemSize);
            }
        }
        return result;
    }

    public static Object fromDoublesToBiggestPrimitives(double[] x, int dtype) {
        switch (dtype) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                int[] i32 = new int[x.length];
                int i = 0;
                while (i < x.length) {
                    i32[i] = (int)x[i];
                    ++i;
                }
                return i32;
            }
            case 4: {
                long[] i64 = new long[x.length];
                int i = 0;
                while (i < x.length) {
                    i64[i] = (long)x[i];
                    ++i;
                }
                return i64;
            }
            case 5: {
                float[] f32 = new float[x.length];
                int i = 0;
                while (i < x.length) {
                    f32[i] = (float)x[i];
                    ++i;
                }
                return f32;
            }
            case 6: {
                return x;
            }
        }
        return null;
    }

    public static Number fromDoubleToBiggestNumber(double x, int dtype) {
        switch (dtype) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return (int)x;
            }
            case 4: {
                return (long)x;
            }
            case 5: {
                return Float.valueOf((float)x);
            }
            case 6: {
                return x;
            }
        }
        return null;
    }

    public static final int getLength(Object b) {
        if (b instanceof Number) {
            return 1;
        }
        if (b instanceof Complex) {
            return 1;
        }
        if (b instanceof List) {
            List jl = (List)b;
            return jl.size();
        }
        if (b.getClass().isArray()) {
            return Array.getLength(b);
        }
        if (b instanceof IDataset) {
            Dataset db = (Dataset)b;
            return db.getSize();
        }
        throw new IllegalArgumentException("Cannot find length as object not supported");
    }

    public static Class<?> getElementClass(int dtype) {
        switch (dtype) {
            case 0: {
                return Boolean.class;
            }
            case 1: 
            case 100: {
                return Byte.class;
            }
            case 2: 
            case 200: 
            case 203: {
                return Short.class;
            }
            case 3: 
            case 300: {
                return Integer.class;
            }
            case 4: 
            case 400: {
                return Long.class;
            }
            case 5: 
            case 500: {
                return Float.class;
            }
            case 6: 
            case 600: {
                return Double.class;
            }
            case 7: {
                return Float.class;
            }
            case 8: {
                return Double.class;
            }
            case 9: {
                return String.class;
            }
            case 11: {
                return Date.class;
            }
        }
        return Object.class;
    }
}

