/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.javatest.util.PropertyUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;

public class WizEdit {
    private static final ResourceBundle i18n = Interview.i18n;
    private Interview interview;
    private boolean considerCase = false;
    private boolean word = false;
    private boolean verbose;
    private PrintStream out = System.err;

    public WizEdit(Interview interview) {
        this.interview = interview;
    }

    public static void main(String ... args) {
        try {
            Interview interview;
            Vector<String> v = new Vector<String>();
            File interviewFile = null;
            File outFileName = null;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-o") && i + 1 < args.length) {
                    outFileName = new File(args[++i]);
                    continue;
                }
                if (args[i].equals("-e")) {
                    v.add(args[++i]);
                    continue;
                }
                if (args[i].startsWith("-")) {
                    throw new BadArgs(i18n, "edit.badOption", (Object)args[i]);
                }
                if (i == args.length - 1 && args[i].endsWith(".jti")) {
                    interviewFile = new File(args[i]);
                    continue;
                }
                throw new BadArgs(i18n, "edit.badOption", (Object)args[i]);
            }
            if (interviewFile == null) {
                throw new BadArgs(i18n, "edit.noInterview");
            }
            try {
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(interviewFile));
                Map<String, String> stringProps = PropertyUtils.load(in);
                String interviewClassName = stringProps.get("INTERVIEW");
                if (interviewClassName == null) {
                    throw new Fault(i18n, "edit.noInterview");
                }
                Class<Interview> ic = Class.forName(interviewClassName).asSubclass(Interview.class);
                interview = ic.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                interview.load(stringProps, false);
            }
            catch (FileNotFoundException e) {
                throw new Fault(i18n, "edit.cantFindFile", (Object)interviewFile);
            }
            catch (IOException e) {
                throw new Fault(i18n, "edit.cantReadFile", (Object)e);
            }
            String[] cmds = v.toArray(new String[v.size()]);
            WizEdit editor = new WizEdit(interview);
            editor.edit(cmds);
            try {
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outFileName));
                Properties p = new Properties();
                interview.save(PropertyUtils.convertToStringProps(p));
                p.store(out, "Interview: " + interview.getTitle());
            }
            catch (IOException e) {
                throw new Fault(i18n, "edit.cantWriteFile", (Object)e);
            }
        }
        catch (BadArgs e) {
            System.err.println("Error: " + e.getMessage());
            System.exit(1);
        }
        catch (Interview.Fault e) {
            System.err.println("Problem reading file: " + e);
            System.exit(2);
        }
        catch (ClassNotFoundException e) {
            System.err.println("Problem reading file: the interview could not be loaded because some classes that are required by the interview were not found on your classpath. The specific exception that occurred was: " + e);
            System.exit(2);
        }
        catch (IllegalAccessException e) {
            System.err.println("Problem reading file: the interview could not be loaded because some classes that are required by the interview caused access violations. The specific exception that occurred was: " + e);
            System.exit(2);
        }
        catch (InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            System.err.println("Problem reading file: the interview could not be loaded because some classes that are required by the interview could not be instantiated. The specific exception that occurred was: " + e);
            System.exit(2);
        }
        catch (Fault e) {
            System.err.println(e.getMessage());
            System.exit(2);
        }
    }

    private static int match(String s1, String s2, boolean considerCase, boolean word) {
        int s1len = s1.length();
        int s2len = s2.length();
        for (int i = 0; i <= s2len - s1len; ++i) {
            if (!s1.regionMatches(!considerCase, 0, s2, i, s1len) || word && (!word || i != 0 && !WizEdit.isBoundaryCh(s2.charAt(i - 1)) || i + s1len != s2.length() && !WizEdit.isBoundaryCh(s2.charAt(i + s1len)))) continue;
            return i;
        }
        return -1;
    }

    private static boolean isBoundaryCh(char c) {
        return !Character.isUnicodeIdentifierStart(c) && !Character.isUnicodeIdentifierPart(c);
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setVerbose(boolean verbose, PrintStream out) {
        this.verbose = verbose;
        this.out = out;
    }

    public void edit(String ... cmds) throws Fault {
        for (String cmd : cmds) {
            this.edit(cmd);
        }
    }

    public void edit(String cmd) throws Fault {
        Question[] path;
        int left;
        if (cmd == null || cmd.isEmpty()) {
            throw new Fault(i18n, "edit.nullCmd");
        }
        char delim = cmd.charAt(0);
        int center = cmd.indexOf(delim, (left = 0) + 1);
        if (center == -1) {
            throw new Fault(i18n, "edit.badCmd", (Object)cmd);
        }
        int right = cmd.indexOf(delim, center + 1);
        String searchText = cmd.substring(left + 1, center);
        String replaceText = cmd.substring(center + 1, right);
        if (searchText.isEmpty()) {
            throw new Fault(i18n, "edit.badCmd", (Object)cmd);
        }
        Hashtable<String, String> answers = new Hashtable<String, String>();
        this.interview.save(answers);
        for (Question q : path = this.interview.getPath()) {
            try {
                String answer = (String)answers.get(q.getTag());
                if (answer == null || !answer.equalsIgnoreCase(searchText)) continue;
                q.setValue(replaceText);
                if (!this.verbose) continue;
                Hashtable<String, String> h = new Hashtable<String, String>();
                q.save(h);
                this.out.println("Question:     " + q.getSummary());
                this.out.println("changed from: " + answer);
                this.out.println("          to: " + (String)h.get(q.getTag()));
            }
            catch (Interview.Fault e) {
                throw new Fault(i18n, "edit.cantSetValue", q.getSummary(), e.getMessage());
            }
        }
    }

    public static class Fault
    extends Exception {
        Fault(ResourceBundle i18n, String s) {
            super(i18n.getString(s));
        }

        Fault(ResourceBundle i18n, String s, Object o) {
            super(MessageFormat.format(i18n.getString(s), o));
        }

        Fault(ResourceBundle i18n, String s, Object ... o) {
            super(MessageFormat.format(i18n.getString(s), o));
        }
    }

    public static class BadArgs
    extends Exception {
        BadArgs(ResourceBundle i18n, String s) {
            super(i18n.getString(s));
        }

        BadArgs(ResourceBundle i18n, String s, Object o) {
            super(MessageFormat.format(i18n.getString(s), o));
        }

        BadArgs(ResourceBundle i18n, String s, Object ... o) {
            super(MessageFormat.format(i18n.getString(s), o));
        }
    }
}

