/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.nonpositiveinteger.minexclusive.minexclusive_4;

import jakarta.xml.bind.*;
import jakarta.xml.bind.TypeConstraintException;
import javasoft.sqe.javatest.Status;
import java.io.PrintWriter;
import javasoft.sqe.tests.api.jakarta.xml.bind.CTTest;

public class minExclusive4_ValidateCTTests extends CTTest {

    /**
     * Command line starter.
     */
    public static void main(String[] args) {
        minExclusive4_ValidateCTTests test = new minExclusive4_ValidateCTTests();
        PrintWriter err = new PrintWriter(System.err, true);
        PrintWriter out = new PrintWriter(System.out, true);
        Status status = test.run(args, err, out);
        err.flush();
        out.flush();
        status.exit();
    }

    final Long[] validValues = {new Long("-990226385260806197"), new Long("-9902263"), 
                                      new Long("-1"), new Long("0")};
    final Long[] invalidValues = {new Long("-990226385260806198"), new Long("-990226385260806199"), 
                                        new Long("1"), new Long("990226385260806197")};
    
    JAXBElement<Long> elemObj;

    Status testInvalid() {
        for (int i = 0; i < invalidValues.length; ++i){
            
                elemObj.setValue(invalidValues[i]);
                Status status = validate(elemObj);
                if (status.isPassed()) {
                    return Status.failed("" + invalidValues[i] + " is unexpectedly valid");
                }
            
        }
        return Status.passed("OK");
    }

    Status testValid() {
        for (int i = 0; i < validValues.length; ++i){
            elemObj.setValue(validValues[i]);
            Status status = validate(elemObj);
            if (!status.isPassed()){
                return Status.failed("" + validValues[i] + " is unexpectedly invalid");
            }
        }
        return Status.passed("OKAY");
    }

    public Status Validate001( ) {
        String xmlDocName = "minExclusive-4-1.xml";
        elemObj = (JAXBElement<Long>)unmarshal(xmlDocName);
        return testValid();
    }

    public Status Validate002( ) {
        String xmlDocName = "minExclusive-4-1.xml";
        elemObj = (JAXBElement<Long>)unmarshal(xmlDocName);
        return testInvalid();
    }

    public Status Validate003( ) {
        elemObj = (JAXBElement<Long>)(new ObjectFactory()).createNISTSchemaNonPositiveIntegerMinExclusive4(new Long("-10"));
        
        return testValid();
    }

    public Status Validate004( ) {
        elemObj = (JAXBElement<Long>)(new ObjectFactory()).createNISTSchemaNonPositiveIntegerMinExclusive4(new Long("-10"));
        
        return testInvalid();
    }


}

