/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests._byte.pattern.pattern_3;

import jakarta.xml.bind.*;
import javasoft.sqe.javatest.Status;
import java.io.PrintWriter;
import javasoft.sqe.tests.api.jakarta.xml.bind.CTTest;

public class pattern3_GetSetCTTests extends CTTest {

    /**
     * Command line starter.
     */
    public static void main(String[] args) {
        pattern3_GetSetCTTests test = new pattern3_GetSetCTTests();
        PrintWriter err = new PrintWriter(System.err, true);
        PrintWriter out = new PrintWriter(System.out, true);
        Status status = test.run(args, err, out);
        err.flush();
        out.flush();
        status.exit();
    }

    public Status GetSet001( ) {
        String[] xmlDocNames = {
            "pattern-3-1.xml", "pattern-3-2.xml", "pattern-3-3.xml",
            "pattern-3-4.xml", "pattern-3-5.xml"
        };
        byte[] expectedValues = {(byte)-7, (byte)-2, (byte)-5, (byte)-9, (byte)-3};
        byte[] anExpectedValues = {(byte)-6, (byte)-1, (byte)-4, (byte)-8, (byte)-3};
        
        for (int i = 0; i < xmlDocNames.length; ++i){
            JAXBElement<Byte> elemObj = (JAXBElement<Byte>)unmarshal(xmlDocNames[i]);
            if (elemObj.getValue() != expectedValues[i]){
                return Status.failed("used XML document: " + xmlDocNames[i] + ", elemObj.getValue() != " + expectedValues[i]);
            }
            elemObj.setValue(anExpectedValues[i]);
            if (elemObj.getValue() != anExpectedValues[i]){
                return Status.failed("used XML document: " + xmlDocNames[i] + ", elemObj.setValue(" + anExpectedValues[i] + 
                    ") invoked, " + "elemObj.getValue() != " + anExpectedValues[i]);
            }
        }
        return Status.passed("OKAY");
    }

    public Status GetSet002( ) {
        byte[] setValues = {(byte)-7, (byte)-2, (byte)-5, (byte)-9, (byte)-3};
        byte[] anSetValues = {(byte)-6, (byte)-1, (byte)-4, (byte)-8, (byte)-3};
        JAXBElement<Byte> elemObj = null;
        for (int i = 0; i < setValues.length; ++i){
            
                elemObj = (JAXBElement<Byte>)(new ObjectFactory()).createNISTSchemaBytePattern3(setValues[i]);
            
            if (elemObj.getValue() != setValues[i]){
                return Status.failed("dynamically created JAXBElement<Byte>, elemObj.getValue() != " + setValues[i]);
            }
            elemObj.setValue(anSetValues[i]);
            if (elemObj.getValue() != anSetValues[i]){
                return Status.failed("dynamically created JAXBElement<Byte>, elemObj.setValue(" + anSetValues[i] + 
                    ") invoked, " + "elemObj.getValue() != " + anSetValues[i]);
            }
        }
        return Status.passed("OKAY");
    }


}

