/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */


/*
 *  @(#)W3CDomHandler.test.xml	1.3 07/03/21 Igor Tseytin
 * Generated from : api/jakarta_xml/bind/annotation/W3CDomHandler/W3CDomHandler.test.xml
 *
 * Provides W3CDomHandler implementation tests
 */

package javasoft.sqe.tests.api.jakarta.xml.bind.annotation.W3CDomHandler;

import jakarta.xml.bind.ValidationEventHandler;
import jakarta.xml.bind.annotation.W3CDomHandler;
import jakarta.xml.bind.util.ValidationEventCollector;
import javasoft.sqe.javatest.Status;
import javasoft.sqe.javatest.lib.MultiTest;
import javax.xml.parsers.*;
import javax.xml.transform.*;
import org.w3c.dom.Document;


public class W3CDomHandlerTests extends MultiTest {

    void assertT( boolean val, String msg ){
        if( !val )
            throw new RuntimeException(msg);
    }

    /* standalone interface */
    public static void main(String argv[]) {
        W3CDomHandlerTests test = new W3CDomHandlerTests();
        test.run(argv, System.err, System.out).exit();
    }

    /**
     * Functional tests for W3CDomHandler,
     * the test creates instance of W3CDomHandler object. no exceptions expected.
     */
    public Status Ctor001() {
        W3CDomHandler instance = new W3CDomHandler();
        return Status.passed("Ok");
        }

    /**
     * Functional tests for W3CDomHandler,
     * the test creates instance of W3CDomHandler object. no exceptions expected.
     */
    public Status Ctor002() {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            W3CDomHandler instance = new W3CDomHandler( builder );
            assertT( instance.getBuilder() == builder, "W3CDomHandler.getBuilder() returns unexpected builder." );
        } catch(ParserConfigurationException x){
            x.printStackTrace( ref );
            return Status.failed( x.toString() );
        }
        return Status.passed("Ok");
        }

    /**
     * Functional tests for W3CDomHandler,
     * the test creates instance of W3CDomHandler object. no exceptions expected.
     */
    public Status Ctor003() {
        W3CDomHandler instance = new W3CDomHandler();
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            instance.setBuilder( builder );
            assertT( instance.getBuilder() == builder, "W3CDomHandler.getBuilder() returns unexpected builder." );
        } catch(ParserConfigurationException x){
            x.printStackTrace( ref );
            return Status.failed( x.toString() );
        }
        return Status.passed("Ok");
        }
}
