/*
 * Copyright (c) 2013, 2020 Oracle and/or its affiliates and others.
 * All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

package com.sun.ts.tests.websocket.common.client;

import com.sun.ts.tests.common.webclient.http.HttpRequest;

public class ApacheRequestAdapter extends HttpRequest {

	public ApacheRequestAdapter(String protocol, String requestLine, String host, int port) {
		super("GET " + requestLine.replace(protocol + "://", "http://") + " HTTP/1.1", host, port);
	}

	/**
	 * <code>getRequestPath</code> returns the request path for this particular
	 * request.
	 * 
	 * @return String request path
	 */
	@Override
	public String getRequestPath() {
		return super.getRequestPath();
	}

}
