/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.ee.jakarta.websocket.session11.server;

import com.sun.ts.tests.websocket.common.client.WebSocketCommonClient;
import com.sun.ts.tests.websocket.common.impl.StringPongMessage;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.session11.common.TypeEnum;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class WSCClientIT
extends WebSocketCommonClient {
    private static final long serialVersionUID = 0L;
    protected static final String ECHO = "Echo message";
    protected static final String ECHO_PARTIAL = "second part send partially";
    protected static final String ANYTHING = "Anything";

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"wsc_ee_jakarta_websocket_session11_server_web.war");
        archive.addPackages(true, new String[]{"com.sun.ts.tests.websocket.ee.jakarta.websocket.session11.server"});
        archive.addPackages(true, new String[]{"com.sun.ts.tests.websocket.common"});
        archive.addPackages(true, new String[]{"com.sun.ts.tests.websocket.ee.jakarta.websocket.session11.common"});
        return archive;
    }

    public WSCClientIT() throws Exception {
        this.setContextRoot("wsc_ee_jakarta_websocket_session11_server_web");
        this.logExceptionOnInvocation(false);
    }

    @Test
    public void linkedListHashSetTextHandlerTest() throws Exception {
        this.invoke(TypeEnum.LINKEDLIST_HASHSET_TEXT.name().toLowerCase(), (Object)ECHO, "LinkedListHashSetMessageHandler says: ", ECHO);
        WSCClientIT.logMsg("addMessageHandler(LinkedList<HashSet<String>>.class, Whole<LinkedList<HashSet<String>>>) works as expected.");
    }

    @Test
    public void linkedListTextHandlerTest() throws Exception {
        this.invoke(TypeEnum.LIST_TEXT.name().toLowerCase(), (Object)ECHO, "StringListWholeMessageHandler says: ", ECHO);
        WSCClientIT.logMsg("addMessageHandler(StringList.class, Whole<StringList>) works as expected.");
    }

    @Test
    public void textStringBeanHandlerTest() throws Exception {
        this.invoke(TypeEnum.STRINGBEAN.name().toLowerCase(), (Object)ECHO, "StringBeanMessageHandler says: ", ECHO);
        WSCClientIT.logMsg("addMessageHandler(StringBean.class, Whole<StringBean>) works as expected.");
    }

    @Test
    public void textStreamStringBeanHandlerTest() throws Exception {
        this.invoke(TypeEnum.STRINGBEANSTREAM.name().toLowerCase(), (Object)ECHO, "StringBeanMessageHandler says: ", ECHO);
        WSCClientIT.logMsg("addMessageHandler(StringBean.class, Whole<StringBean>) works as expected.");
    }

    @Test
    public void stringTextHandlerTest() throws Exception {
        this.invoke(TypeEnum.STRING_WHOLE.name().toLowerCase(), (Object)ECHO, "StringWholeMessageHandler says: ", ECHO);
        WSCClientIT.logMsg("addMessageHandler(String.class, Whole<String>) works as expected.");
    }

    @Test
    public void readerMessageHandlerTest() throws Exception {
        this.invoke(TypeEnum.READER.name().toLowerCase(), (Object)ECHO, "ReaderMessageHandler says: ", ECHO);
        WSCClientIT.logMsg("addMessageHandler(Reader.class, Whole<Reader>) works as expected.");
    }

    @Test
    public void pongMessageHandlerTest() throws Exception {
        this.invoke(TypeEnum.PONG.name().toLowerCase(), (Object)new StringPongMessage(ECHO), "PongMessageHandler says: ", ECHO);
        WSCClientIT.logMsg("addMessageHandler(PongMessage.class, Whole<PongMessage>) works as expected.");
    }

    @Test
    public void byteBufferMessageHandlerTest() throws Exception {
        this.invoke(TypeEnum.BYTEBUFFER_WHOLE.name().toLowerCase(), (Object)ByteBuffer.wrap(ECHO.getBytes()), "ByteBufferMessageHandler says: ", ECHO);
        WSCClientIT.logMsg("addMessageHandler(ByteBuffer.class, Whole<ByteBuffer>) works as expected.");
    }

    @Test
    public void byteArrayMessageHandlerTest() throws Exception {
        this.invoke(TypeEnum.BYTEARRAY_WHOLE.name().toLowerCase(), (Object)ByteBuffer.wrap(ECHO.getBytes()), "ByteArrayMessageHandler says: ", ECHO);
        WSCClientIT.logMsg("addMessageHandler(byte[].class, Whole<byte[]>) works as expected.");
    }

    @Test
    public void inputStreamMessageHandlerTest() throws Exception {
        this.invoke(TypeEnum.INPUTSTREAM.name().toLowerCase(), (Object)ByteBuffer.wrap(ECHO.getBytes()), "InputStreamMessageHandler says: ", ECHO);
        WSCClientIT.logMsg("addMessageHandler(InputStream.class, Whole<InputStream>) works as expected.");
    }

    @Test
    public void binaryStringBeanMessageHandlerTest() throws Exception {
        this.invoke(TypeEnum.STRINGBEANBINARY.name().toLowerCase(), (Object)ByteBuffer.wrap(ECHO.getBytes()), "StringBeanMessageHandler says: ", ECHO);
        WSCClientIT.logMsg("addMessageHandler(StringBean.class, Whole<StringBean>) works as expected.");
    }

    @Test
    public void binaryStreamStringBeanMessageHandlerTest() throws Exception {
        this.invoke(TypeEnum.STRINGBEANBINARYSTREAM.name().toLowerCase(), (Object)ByteBuffer.wrap(ECHO.getBytes()), "StringBeanMessageHandler says: ", ECHO);
        WSCClientIT.logMsg("addMessageHandler(StringBean.class, Whole<StringBean>) works as expected.");
    }

    @Test
    public void stringPartialHandlerTest() throws Exception {
        this.setEntity(ECHO, ECHO_PARTIAL);
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, "StringPartialMessageHandler says: ");
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, ECHO);
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, ECHO_PARTIAL);
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(TypeEnum.STRING_PARTIAL.name().toLowerCase()));
        this.invoke();
        WSCClientIT.logMsg("addMessageHandler(String.class, Partial<String>) works as expected.");
    }

    @Test
    public void byteBufferPartialMessageHandlerTest() throws Exception {
        this.setEntity(ByteBuffer.wrap(ECHO.getBytes()), ByteBuffer.wrap(ECHO_PARTIAL.getBytes()));
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, "ByteBufferPartialMessageHandler says: ");
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, ECHO);
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, ECHO_PARTIAL);
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(TypeEnum.BYTEBUFFER_PARTIAL.name().toLowerCase()));
        this.invoke();
        WSCClientIT.logMsg("addMessageHandler(ByteBuffer.class, Partial<ByteBuffer>) works as expected.");
    }

    @Test
    public void byteArrayPartialMessageHandlerTest() throws Exception {
        this.setEntity(ByteBuffer.wrap(ECHO.getBytes()), ByteBuffer.wrap(ECHO_PARTIAL.getBytes()));
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, "ByteArrayPartialMessageHandler says: ");
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, ECHO);
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, ECHO_PARTIAL);
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(TypeEnum.BYTEARRAY_PARTIAL.name().toLowerCase()));
        this.invoke();
        WSCClientIT.logMsg("addMessageHandler(byte[].class, Partial<byte[]>) works as expected.");
    }

    @Test
    public void binaryAnnotatedStringBeanMessageHandlerTest() throws Exception {
        this.invoke("annotatedbinary", (Object)ByteBuffer.wrap(ECHO.getBytes()), "StringBeanMessageHandler says: ", ECHO);
        WSCClientIT.logMsg("addMessageHandler(StringBean.class, Whole<StringBean>) works as expected.");
    }

    @Test
    public void textAnnotatedStringBeanMessageHandlerTest() throws Exception {
        this.invoke("annotatedtext", (Object)ECHO, "StringBeanMessageHandler says: ", ECHO);
        WSCClientIT.logMsg("addMessageHandler(StringBean.class, Whole<StringBean>) works as expected.");
    }

    @Test
    public void addMessageHandlerPongMessageThrowsExceptionTest() throws Exception {
        this.setEntity(new StringPongMessage(ECHO));
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest("exception"));
        this.setProperty(WebSocketCommonClient.Property.UNEXPECTED_RESPONSE_MATCH, "Exception: ");
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, "PongMessageHandler says: ");
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, ECHO);
        this.invoke();
        this.setEntity(new StringPongMessage(TypeEnum.PONG.name()));
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest("exception"));
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, "Exception: ");
        this.invoke(false);
        WSCClientIT.logMsg("addMessageHandler(PongMessage.class, Partial<PongMessage>) throws RuntimeException as expected when called twice:", this.getResponseAsString().split(": ")[1]);
    }

    @Test
    public void addMessageHandlerStringPartialMessageThrowsExceptionTest() throws Exception {
        this.setEntity(ECHO, ECHO_PARTIAL);
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest("exception"));
        this.setProperty(WebSocketCommonClient.Property.UNEXPECTED_RESPONSE_MATCH, "Exception: ");
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, "StringPartialMessageHandler says: ");
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, ECHO);
        this.invoke();
        this.setEntity(TypeEnum.STRING_PARTIAL.name(), TypeEnum.STRING_PARTIAL.name());
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest("exception"));
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, "Exception: ");
        this.invoke(false);
        WSCClientIT.logMsg("addMessageHandler(String.class, Partial<String>) throws RuntimeException as expected when called twice:", this.getResponseAsString().split(": ")[1]);
    }

    @Test
    public void addMessageHandlerInputStreamThrowsExceptionTest() throws Exception {
        this.setEntity(ByteBuffer.wrap(ECHO.getBytes()));
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest("exception"));
        this.setProperty(WebSocketCommonClient.Property.UNEXPECTED_RESPONSE_MATCH, "Exception: ");
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, "InputStreamMessageHandler says: ");
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, ECHO);
        this.invoke();
        this.setEntity(ByteBuffer.wrap(TypeEnum.INPUTSTREAM.name().getBytes()));
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest("exception"));
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, "Exception: ");
        this.invoke(false);
        WSCClientIT.logMsg("addMessageHandler(InputStream.class, Whole<InputStream>) throws RuntimeException as expected when called twice:", this.getResponseAsString().split(": ")[1]);
    }
}

