/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.usercoder.asyncwithhandler;

import com.sun.ts.tests.websocket.common.impl.WaitingSendHandler;
import com.sun.ts.tests.websocket.common.util.IOUtil;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.usercoder.OPS;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.usercoder.WSCSuperEndpoint;
import jakarta.websocket.EncodeException;
import jakarta.websocket.SendHandler;
import jakarta.websocket.SendResult;
import jakarta.websocket.Session;
import java.io.IOException;

public abstract class WSCCommonServer
implements WSCSuperEndpoint {
    private static final System.Logger logger = System.getLogger(WSCCommonServer.class.getName());

    public void onMessage(String msg, Session session) throws IOException, EncodeException {
        OPS op = OPS.valueOf(msg);
        WaitingSendHandler handler = new WaitingSendHandler();
        switch (op) {
            case BOOL: {
                session.getAsyncRemote().sendObject((Object)true, (SendHandler)handler);
                break;
            }
            case BYTE: {
                session.getAsyncRemote().sendObject((Object)NUMERIC, (SendHandler)handler);
                break;
            }
            case CHAR: {
                session.getAsyncRemote().sendObject((Object)Character.valueOf('1'), (SendHandler)handler);
                break;
            }
            case DOUBLE: {
                session.getAsyncRemote().sendObject((Object)NUMERIC.doubleValue(), (SendHandler)handler);
                break;
            }
            case FLOAT: {
                session.getAsyncRemote().sendObject((Object)Float.valueOf(NUMERIC.floatValue()), (SendHandler)handler);
                break;
            }
            case INT: {
                session.getAsyncRemote().sendObject((Object)NUMERIC.intValue(), (SendHandler)handler);
                break;
            }
            case LONG: {
                session.getAsyncRemote().sendObject((Object)NUMERIC.longValue(), (SendHandler)handler);
                break;
            }
            case SHORT: {
                session.getAsyncRemote().sendObject((Object)NUMERIC.shortValue(), (SendHandler)handler);
            }
        }
        SendResult result = handler.waitForResult(4L);
        if (!result.isOK() || result.getException() != null) {
            throw new RuntimeException(result.getException());
        }
    }

    public void onError(Session session, Throwable t) throws IOException {
        logger.log(System.Logger.Level.INFO, "@OnError in " + this.getClass().getName());
        t.printStackTrace();
        String message = "Exception: " + IOUtil.printStackTrace(t);
        session.getBasicRemote().sendText(message);
    }
}

