/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.basic;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.websocket.common.client.BinaryAndTextClientEndpoint;
import com.sun.ts.tests.websocket.common.client.ClientEndpoint;
import com.sun.ts.tests.websocket.common.client.WebSocketCommonClient;
import com.sun.ts.tests.websocket.common.impl.StringPingMessage;
import com.sun.ts.tests.websocket.common.impl.StringPongMessage;
import com.sun.ts.tests.websocket.common.impl.WaitingSendHandler;
import com.sun.ts.tests.websocket.common.stringbean.StringBeanTextEncoder;
import com.sun.ts.tests.websocket.common.util.IOUtil;
import com.sun.ts.tests.websocket.common.util.StringUtil;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.PongMessageClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.basic.BasicEndpointCallback;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.basic.OPS;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.basic.PokingEndpointCallback;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.basic.ThrowingEncoder;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.basic.WSCServerSideServer;
import jakarta.websocket.ClientEndpointConfig;
import jakarta.websocket.RemoteEndpoint;
import java.io.IOException;
import java.util.LinkedList;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class WSClientIT
extends WebSocketCommonClient {
    private static final long serialVersionUID = -8530759310254161854L;
    static final String[] RESPONSE = WSCServerSideServer.RESPONSE;
    static final String ECHO = "echo";

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"wsc_ee_jakarta_websocket_remoteendpoint_basic_web.war");
        archive.addPackages(true, Filters.exclude((Class[])new Class[]{WSClientIT.class}), new String[]{"com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.basic"});
        archive.addPackages(true, new String[]{"com.sun.ts.tests.websocket.common.stringbean"});
        archive.addClasses(new Class[]{WaitingSendHandler.class});
        archive.addClasses(new Class[]{IOUtil.class});
        return archive;
    }

    public WSClientIT() throws Exception {
        this.setContextRoot("wsc_ee_jakarta_websocket_remoteendpoint_basic_web");
    }

    @Test
    public void sendBinaryOnServerTest() throws Exception {
        this.sendOnServer(OPS.SENDBINARY);
    }

    @Test
    public void sendBinaryOnClientTest() throws Exception {
        this.sendOnClient(OPS.SENDBINARY);
    }

    @Test
    public void sendBinaryPartialOnServerTest() throws Exception {
        this.sendOnServer(OPS.SENDBINARYPART1, OPS.SENDBINARYPART1.name() + OPS.SENDBINARYPART2.name() + OPS.SENDBINARYPART3.name());
    }

    @Test
    public void sendBinaryPartialOnClientTest() throws Exception {
        this.sendOnClient(OPS.SENDBINARYPART1, OPS.SENDBINARYPART1.name() + OPS.SENDBINARYPART2.name() + OPS.SENDBINARYPART3.name());
    }

    @Test
    public void sendBinaryThrowsIAEOnServerTest() throws Exception {
        this.invoke("server", (Object)OPS.SENDBINARYTHROWS.name(), RESPONSE[0]);
    }

    @Test
    public void sendBinaryThrowsIAEOnClientTest() throws Exception {
        this.sendOnClientThrows(OPS.SENDBINARYTHROWS);
    }

    @Test
    public void sendObjectOnServerTest() throws Exception {
        this.sendOnServer(OPS.SENDOBJECT);
    }

    @Test
    public void sendObjectOnClientTest() throws Exception {
        this.sendOnClient(OPS.SENDOBJECT);
    }

    @Test
    public void sendObjectBooleanOnServerTest() throws Exception {
        this.sendOnServer(OPS.SENDOBJECT_BOOL, false);
    }

    @Test
    public void sendObjectBooleanOnClientTest() throws Exception {
        this.sendOnClient(OPS.SENDOBJECT_BOOL, String.valueOf(false));
    }

    @Test
    public void sendObjectByteOnServerTest() throws Exception {
        this.sendOnServer(OPS.SENDOBJECT_BYTE, -100);
    }

    @Test
    public void sendObjectByteOnClientTest() throws Exception {
        this.sendOnClient(OPS.SENDOBJECT_BYTE, "-100");
    }

    @Test
    public void sendObjectCharOnServerTest() throws Exception {
        this.sendOnServer(OPS.SENDOBJECT_CHAR, String.valueOf('j'));
    }

    @Test
    public void sendObjectCharOnClientTest() throws Exception {
        this.sendOnClient(OPS.SENDOBJECT_CHAR, String.valueOf('j'));
    }

    @Test
    public void sendObjectDoubleOnServerTest() throws Exception {
        this.sendOnServer(OPS.SENDOBJECT_DOUBLE, -105.0);
    }

    @Test
    public void sendObjectDoubleOnClientTest() throws Exception {
        this.sendOnClient(OPS.SENDOBJECT_DOUBLE, "-105");
    }

    @Test
    public void sendObjectFloatOnServerTest() throws Exception {
        this.sendOnServer(OPS.SENDOBJECT_FLOAT, Float.valueOf(-104.0f));
    }

    @Test
    public void sendObjectFloatOnClientTest() throws Exception {
        this.sendOnClient(OPS.SENDOBJECT_FLOAT, "-104");
    }

    @Test
    public void sendObjectIntOnServerTest() throws Exception {
        this.sendOnServer(OPS.SENDOBJECT_INT, -102);
    }

    @Test
    public void sendObjectIntOnClientTest() throws Exception {
        this.sendOnClient(OPS.SENDOBJECT_INT, "-102");
    }

    @Test
    public void sendObjectLongOnServerTest() throws Exception {
        this.sendOnServer(OPS.SENDOBJECT_LONG, -103L);
    }

    @Test
    public void sendObjectLongOnClientTest() throws Exception {
        this.sendOnClient(OPS.SENDOBJECT_LONG, "-103");
    }

    @Test
    public void sendObjectShortOnServerTest() throws Exception {
        this.sendOnServer(OPS.SENDOBJECT_SHORT, -101);
    }

    @Test
    public void sendObjectShortOnClientTest() throws Exception {
        this.sendOnClient(OPS.SENDOBJECT_SHORT, "-101");
    }

    @Test
    public void sendObjectThrowsIAEOnServerTest() throws Exception {
        this.invoke("server", (Object)OPS.SENDOBJECTTHROWS.name(), RESPONSE[0]);
    }

    @Test
    public void sendObjectThrowsIAEOnClientTest() throws Exception {
        this.sendOnClientThrows(OPS.SENDOBJECTTHROWS);
    }

    @Test
    public void sendObjectThrowsEncodeExceptionOnServerTest() throws Exception {
        this.invoke("server", (Object)OPS.SENDOBJECTTHROWSENCODEEEXCEPTION.name(), RESPONSE[0]);
    }

    @Test
    public void sendObjectThrowsEncodeExceptionOnClientTest() throws Exception {
        this.sendOnClientThrowsException(OPS.SENDOBJECTTHROWSENCODEEEXCEPTION, "EncodeException");
    }

    @Test
    public void sendTextOnServerTest() throws Exception {
        this.sendOnServer(OPS.SENDTEXT);
    }

    @Test
    public void sendTextOnClientTest() throws Exception {
        this.sendOnClient(OPS.SENDTEXT);
    }

    @Test
    public void sendTextPartialOnServerTest() throws Exception {
        this.sendOnServer(OPS.SENDTEXTPART1, OPS.SENDTEXTPART1.name() + OPS.SENDTEXTPART2.name() + OPS.SENDTEXTPART3.name());
    }

    @Test
    public void sendTextPartialOnClientTest() throws Exception {
        this.sendOnClient(OPS.SENDTEXTPART1, OPS.SENDTEXTPART1.name() + OPS.SENDTEXTPART2.name() + OPS.SENDTEXTPART3.name());
    }

    @Test
    public void sendTextThrowsIAEOnServerTest() throws Exception {
        this.invoke("server", (Object)OPS.SENDTEXTTHROWS.name(), RESPONSE[0]);
    }

    @Test
    public void sendTextThrowsIAEOnClientTest() throws Exception {
        this.sendOnClientThrows(OPS.SENDTEXTTHROWS);
    }

    @Test
    public void getSendStreamOnServerTest() throws Exception {
        this.sendOnServer(OPS.SENDSTREAM);
    }

    @Test
    public void getSendStreamOnClientTest() throws Exception {
        this.sendOnClient(OPS.SENDSTREAM);
    }

    @Test
    public void getSendWriterOnServerTest() throws Exception {
        this.sendOnServer(OPS.SENDWRITER);
    }

    @Test
    public void getSendWriterOnClientTest() throws Exception {
        this.sendOnClient(OPS.SENDWRITER);
    }

    @Test
    public void batchingAllowedOnServerTest() throws Exception {
        this.sendOnServer(OPS.BATCHING_ALLOWED);
    }

    @Test
    public void batchingAllowedOnClientTest() throws Exception {
        this.sendOnClient(OPS.BATCHING_ALLOWED);
    }

    @Test
    public void sendPingOnServerTest() throws Exception {
        this.setCountDownLatchCount(2);
        this.setProperty(WebSocketCommonClient.Property.CONTENT, OPS.SEND_PING.name());
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest("server"));
        this.setProperty(WebSocketCommonClient.Property.UNORDERED_SEARCH_STRING, this.search(new Object[]{RESPONSE[0], OPS.SEND_PING}));
        this.invoke();
    }

    @Test
    public void sendPingOnClientTest() throws Exception {
        this.setClientEndpoint(PongMessageClientEndpoint.class);
        this.sendOnClient(OPS.SEND_PING);
    }

    @Test
    public void sendPingDelaysTimoutOnServerTest() throws Exception {
        StringPingMessage ping = new StringPingMessage(OPS.POKE.name());
        this.setClientEndpoint(PongMessageClientEndpoint.class);
        this.invoke("server", (Object)OPS.IDLE.name(), OPS.IDLE.name(), false);
        TestUtil.sleepMsec((int)500);
        this.invokeAgain(ping, OPS.POKE.name(), false);
        TestUtil.sleepMsec((int)500);
        this.invokeAgain(ping, OPS.POKE.name(), false);
        TestUtil.sleepMsec((int)500);
        this.invokeAgain(ping, OPS.POKE.name(), false);
        TestUtil.sleepMsec((int)500);
        this.invokeAgain(OPS.POKE.name(), OPS.POKE.name(), true);
    }

    @Test
    public void sendPingDelaysTimoutOnClientTest() throws Exception {
        this.setClientEndpoint(PongMessageClientEndpoint.class);
        this.invoke("server", (Object)OPS.POKE.name(), OPS.POKE.name(), false);
        this.getSession().setMaxIdleTimeout(1500L);
        this.setCountDownLatchCount(5);
        this.setProperty(WebSocketCommonClient.Property.CONTENT, OPS.PING_4_TIMES.name());
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, OPS.POKE.name(), OPS.POKE.name(), OPS.POKE.name(), OPS.POKE.name());
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING_IGNORE_CASE, new String[0]);
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING_IGNORE_CASE, RESPONSE[0]);
        this.invokeAgain(true);
    }

    @Test
    public void sendPingThrowsOnServerTest() throws Exception {
        this.invoke("server", OPS.SEND_PING_THROWS, RESPONSE[0]);
    }

    @Test
    public void sendPingThrowsOnClientTest() throws Exception {
        this.sendOnClientThrows(OPS.SEND_PING_THROWS);
    }

    @Test
    public void sendPongOnServerTest() throws Exception {
        this.sendOnServer(OPS.SEND_PONG, OPS.SEND_PONG.name(), PongMessageClientEndpoint.class);
    }

    @Test
    public void sendPongOnClientTest() throws Exception {
        this.sendOnClient(OPS.SEND_PONG);
    }

    @Test
    public void sendPongDelaysTimoutOnServerTest() throws Exception {
        StringPongMessage ping = new StringPongMessage(OPS.POKE.name());
        this.setClientEndpoint(PongMessageClientEndpoint.class);
        this.invoke("server", (Object)OPS.IDLE.name(), OPS.IDLE.name(), false);
        TestUtil.sleepMsec((int)500);
        this.invokeAgain(ping, OPS.POKE.name(), false);
        TestUtil.sleepMsec((int)500);
        this.invokeAgain(ping, OPS.POKE.name(), false);
        TestUtil.sleepMsec((int)500);
        this.invokeAgain(ping, OPS.POKE.name(), false);
        TestUtil.sleepMsec((int)500);
        this.invokeAgain(OPS.POKE.name(), OPS.POKE.name(), true);
    }

    @Test
    public void sendPongDelaysTimoutOnClientTest() throws Exception {
        this.setClientEndpoint(PongMessageClientEndpoint.class);
        this.invoke("server", (Object)OPS.POKE.name(), OPS.POKE.name(), false);
        this.getSession().setMaxIdleTimeout(1500L);
        this.setCountDownLatchCount(5);
        this.setProperty(WebSocketCommonClient.Property.CONTENT, OPS.PONG_4_TIMES.name());
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, OPS.POKE.name(), OPS.POKE.name(), OPS.POKE.name(), OPS.POKE.name());
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING_IGNORE_CASE, new String[0]);
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING_IGNORE_CASE, RESPONSE[0]);
        this.invokeAgain(true);
    }

    @Test
    public void sendPongThrowsOnServerTest() throws Exception {
        this.invoke("server", OPS.SEND_PONG_THROWS, RESPONSE[0]);
    }

    @Test
    public void sendPongThrowsOnClientTest() throws Exception {
        this.sendOnClientThrows(OPS.SEND_PONG_THROWS);
    }

    private String search(Object ... ops) {
        return StringUtil.objectsToStringWithDelimiter("|", ops);
    }

    private void sendOnServer(OPS ops) throws Exception {
        this.sendOnServer(ops, (Object)ops);
    }

    private void sendOnServer(OPS ops, Object search) throws Exception {
        this.sendOnServer(ops, search, BinaryAndTextClientEndpoint.class);
    }

    private void sendOnServer(OPS ops, Object search, Class<? extends ClientEndpoint<?>> endpoint) throws Exception {
        this.setCountDownLatchCount(3);
        this.setProperty(WebSocketCommonClient.Property.CONTENT, ops.name());
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest("server"));
        this.setProperty(WebSocketCommonClient.Property.UNORDERED_SEARCH_STRING, this.search(new Object[]{search, OPS.POKE, RESPONSE[0]}));
        PokingEndpointCallback callback = new PokingEndpointCallback(this.entity);
        this.setClientCallback(callback);
        this.setClientEndpoint(endpoint);
        this.invoke();
    }

    private void sendOnClient(OPS op) throws Exception {
        this.sendOnClient(op, op.name());
    }

    private void sendOnClient(final OPS op, String search) throws Exception {
        BasicEndpointCallback callback = new BasicEndpointCallback(){

            @Override
            void doBasic(RemoteEndpoint.Basic basicRemote) throws Exception {
                String ret = null;
                String method = null;
                switch (op) {
                    case SENDBINARY: {
                        ret = WSCServerSideServer.sendBinary(basicRemote);
                        method = "sendBinary(ByteBuffer)";
                        break;
                    }
                    case SENDBINARYPART1: {
                        ret = WSCServerSideServer.sendBinaryPartial(basicRemote);
                        method = "sendBinary(ByteBuffer, boolean)";
                        break;
                    }
                    case SENDOBJECT: {
                        ret = WSCServerSideServer.sendObject(basicRemote);
                        method = "sendObject(Object)";
                        break;
                    }
                    case SENDOBJECT_BOOL: {
                        ret = WSCServerSideServer.sendObject(basicRemote, Boolean.TYPE);
                        method = "sendObject(boolean)";
                        break;
                    }
                    case SENDOBJECT_BYTE: {
                        ret = WSCServerSideServer.sendObject(basicRemote, Byte.TYPE);
                        method = "sendObject(byte)";
                        break;
                    }
                    case SENDOBJECT_CHAR: {
                        ret = WSCServerSideServer.sendObject(basicRemote, Character.TYPE);
                        method = "sendObject(char)";
                        break;
                    }
                    case SENDOBJECT_DOUBLE: {
                        ret = WSCServerSideServer.sendObject(basicRemote, Double.TYPE);
                        method = "sendObject(double)";
                        break;
                    }
                    case SENDOBJECT_FLOAT: {
                        ret = WSCServerSideServer.sendObject(basicRemote, Float.TYPE);
                        method = "sendObject(float)";
                        break;
                    }
                    case SENDOBJECT_INT: {
                        ret = WSCServerSideServer.sendObject(basicRemote, Integer.TYPE);
                        method = "sendObject(int)";
                        break;
                    }
                    case SENDOBJECT_LONG: {
                        ret = WSCServerSideServer.sendObject(basicRemote, Long.TYPE);
                        method = "sendObject(long)";
                        break;
                    }
                    case SENDOBJECT_SHORT: {
                        ret = WSCServerSideServer.sendObject(basicRemote, Short.TYPE);
                        method = "sendObject(short)";
                        break;
                    }
                    case SENDTEXT: {
                        ret = WSCServerSideServer.sendText(basicRemote);
                        method = "sendText(String)";
                        break;
                    }
                    case SENDTEXTPART1: {
                        ret = WSCServerSideServer.sendTextPartial(basicRemote);
                        method = "sendText(String, boolean)";
                        break;
                    }
                    case SENDSTREAM: {
                        ret = WSCServerSideServer.getSendStream(basicRemote);
                        method = "getSendStream()";
                        break;
                    }
                    case SENDWRITER: {
                        ret = WSCServerSideServer.getSendWriter(basicRemote);
                        method = "getSendWriter()";
                        break;
                    }
                    case BATCHING_ALLOWED: {
                        ret = WSCServerSideServer.batchingAllowed(basicRemote);
                        method = "setBatchingAllowed(!getBatchingAllowed)";
                        break;
                    }
                    case SEND_PING: {
                        ret = WSCServerSideServer.sendPing(basicRemote);
                        method = "sendPing(ByteBuffer)";
                        break;
                    }
                    case SEND_PONG: {
                        ret = WSCServerSideServer.sendPong(basicRemote);
                        method = "sendPong(ByteBuffer)";
                        break;
                    }
                    default: {
                        new Exception("Method " + op + " not implemented");
                    }
                }
                WebSocketCommonClient.assertEquals(RESPONSE[0], ret, method, "did not endup as expected");
                WebSocketCommonClient.logMsg(method, "works as expected");
            }
        };
        this.setClientCallback(callback);
        LinkedList<Class<StringBeanTextEncoder>> list = new LinkedList<Class<StringBeanTextEncoder>>();
        list.add(StringBeanTextEncoder.class);
        ClientEndpointConfig config = ClientEndpointConfig.Builder.create().encoders(list).build();
        this.setClientEndpointConfig(config);
        this.invoke("client", (Object)"anything", search);
    }

    private void sendOnClientThrows(final OPS op) throws Exception {
        BasicEndpointCallback callback = new BasicEndpointCallback(){

            @Override
            void doBasic(RemoteEndpoint.Basic basicRemote) throws Exception {
                String ret = null;
                String method = null;
                switch (op) {
                    case SENDBINARYTHROWS: {
                        ret = WSCServerSideServer.sendBinaryThrows(basicRemote);
                        method = "sendBinary(ByteBuffer)";
                        break;
                    }
                    case SENDOBJECTTHROWS: {
                        ret = WSCServerSideServer.sendObjectThrows(basicRemote);
                        method = "sendObject(Object)";
                        break;
                    }
                    case SENDTEXTTHROWS: {
                        ret = WSCServerSideServer.sendTextThrows(basicRemote);
                        method = "sendText(String)";
                        break;
                    }
                    case SEND_PING_THROWS: {
                        ret = WSCServerSideServer.sendPingThrows(basicRemote);
                        method = "sendPing(<too_long_message>)";
                        break;
                    }
                    case SEND_PONG_THROWS: {
                        ret = WSCServerSideServer.sendPongThrows(basicRemote);
                        method = "sendPong(<too_long_message>)";
                        break;
                    }
                    default: {
                        new Exception("Method " + op + " not implemented");
                    }
                }
                WebSocketCommonClient.assertEquals(RESPONSE[0], ret, method, "does not throw IllegalArgumentException as expected");
                WebSocketCommonClient.logMsg(method, "throws IllegalArgumentException as expected");
                try {
                    basicRemote.sendText(WSClientIT.this.entity.getEntityAt(String.class, 0));
                }
                catch (IOException e) {
                    new Exception(e);
                }
            }
        };
        this.setClientCallback(callback);
        this.invoke("client", (Object)ECHO, ECHO);
    }

    private void sendOnClientThrowsException(final OPS op, final String exception) throws Exception {
        BasicEndpointCallback callback = new BasicEndpointCallback(){

            @Override
            void doBasic(RemoteEndpoint.Basic basicRemote) throws Exception {
                String ret = null;
                String method = null;
                switch (op) {
                    case SENDOBJECTTHROWSENCODEEEXCEPTION: {
                        ret = WSCServerSideServer.sendObjectThrowsEncodeException(basicRemote);
                        method = "sendObject(Object)";
                        break;
                    }
                    default: {
                        new Exception("Method " + op + " not implemented");
                    }
                }
                WebSocketCommonClient.assertEquals(RESPONSE[0], ret, method, "does not throw", exception, "as expected");
                WebSocketCommonClient.logMsg(method, "throws", exception, "as expected");
                try {
                    basicRemote.sendText(WSClientIT.this.entity.getEntityAt(String.class, 0));
                }
                catch (IOException e) {
                    new Exception(e);
                }
            }
        };
        LinkedList<Class<ThrowingEncoder>> list = new LinkedList<Class<ThrowingEncoder>>();
        list.add(ThrowingEncoder.class);
        ClientEndpointConfig config = ClientEndpointConfig.Builder.create().encoders(list).build();
        this.setClientEndpointConfig(config);
        this.setClientCallback(callback);
        this.invoke("client", (Object)ECHO, ECHO);
    }
}

