/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointreturntype;

import com.sun.ts.tests.websocket.common.client.AnnotatedClientEndpoint;
import com.sun.ts.tests.websocket.common.client.ByteBufferClientEndpoint;
import com.sun.ts.tests.websocket.common.client.EndpointCallback;
import com.sun.ts.tests.websocket.common.client.WebSocketCommonClient;
import com.sun.ts.tests.websocket.common.stringbean.StringBean;
import com.sun.ts.tests.websocket.common.stringbean.StringBeanBinaryEncoder;
import com.sun.ts.tests.websocket.common.stringbean.StringBeanBinaryStreamEncoder;
import com.sun.ts.tests.websocket.common.stringbean.StringBeanTextEncoder;
import com.sun.ts.tests.websocket.common.stringbean.StringBeanTextStreamEncoder;
import com.sun.ts.tests.websocket.common.util.IOUtil;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointreturntype.WSCBinaryEncoderClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointreturntype.WSCBinaryStreamEncoderClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointreturntype.WSCByteArrayClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointreturntype.WSCByteBufferClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointreturntype.WSCFullBooleanClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointreturntype.WSCFullByteClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointreturntype.WSCFullCharClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointreturntype.WSCFullDoubleClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointreturntype.WSCFullFloatClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointreturntype.WSCFullIntClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointreturntype.WSCFullLongClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointreturntype.WSCFullShortClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointreturntype.WSCPrimitiveBooleanClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointreturntype.WSCPrimitiveByteClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointreturntype.WSCPrimitiveCharClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointreturntype.WSCPrimitiveDoubleClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointreturntype.WSCPrimitiveFloatClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointreturntype.WSCPrimitiveIntClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointreturntype.WSCPrimitiveLongClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointreturntype.WSCPrimitiveShortClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointreturntype.WSCServer;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointreturntype.WSCTextEncoderClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointreturntype.WSCTextStreamEncoderClientEndpoint;
import jakarta.websocket.CloseReason;
import jakarta.websocket.Session;
import java.io.IOException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class WSClientIT
extends WebSocketCommonClient {
    private static final long serialVersionUID = 3375865828117749296L;

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"wsc_ee_clientendpointreturntype_web.war");
        archive.addClasses(new Class[]{WSCServer.class});
        archive.addClasses(new Class[]{StringBean.class, StringBeanBinaryEncoder.class, StringBeanBinaryStreamEncoder.class, StringBeanTextEncoder.class, StringBeanTextStreamEncoder.class});
        archive.addClasses(new Class[]{IOUtil.class});
        return archive;
    }

    public WSClientIT() throws Exception {
        this.setContextRoot("wsc_ee_clientendpointreturntype_web");
    }

    @Test
    public void dataTypesTest() throws Exception {
        this.invokeSequence("true", new WSCPrimitiveBooleanClientEndpoint(), new WSCFullBooleanClientEndpoint());
        this.invokeSequence("123", new WSCPrimitiveByteClientEndpoint(), new WSCFullByteClientEndpoint());
        this.invokeSequence(String.valueOf(Short.MAX_VALUE), new WSCPrimitiveShortClientEndpoint(), new WSCFullShortClientEndpoint());
        this.invokeSequence(String.valueOf(Short.MIN_VALUE), new WSCPrimitiveIntClientEndpoint(), new WSCFullIntClientEndpoint());
        this.invokeSequence(String.valueOf(Short.MIN_VALUE), new WSCPrimitiveLongClientEndpoint(), new WSCFullLongClientEndpoint());
        this.invokeSequence(String.valueOf(123.456f), new WSCPrimitiveFloatClientEndpoint(), new WSCFullFloatClientEndpoint());
        this.invokeSequence(String.valueOf(789.012), new WSCPrimitiveDoubleClientEndpoint(), new WSCFullDoubleClientEndpoint());
        this.invokeSequence(String.valueOf('A'), new WSCPrimitiveCharClientEndpoint(), new WSCFullCharClientEndpoint());
    }

    @Test
    public void textEncoderTest() throws Exception {
        this.invokeSequence("textEncoderTest", new WSCTextEncoderClientEndpoint());
    }

    @Test
    public void textStreamEncoderTest() throws Exception {
        this.invokeSequence("textStreamEncoderTest", new WSCTextStreamEncoderClientEndpoint());
    }

    @Test
    public void binaryEncoderTest() throws Exception {
        this.setClientEndpoint(ByteBufferClientEndpoint.class);
        this.invokeSequence("binaryEncoderTest", new WSCBinaryEncoderClientEndpoint());
    }

    @Test
    public void binaryStreamEncoderTest() throws Exception {
        this.setClientEndpoint(ByteBufferClientEndpoint.class);
        this.invokeSequence("binaryStreamEncoderTest", new WSCBinaryStreamEncoderClientEndpoint());
    }

    @Test
    public void byteArrayTest() throws Exception {
        this.setClientEndpoint(ByteBufferClientEndpoint.class);
        this.invokeSequence("byteArrayTest", new WSCByteArrayClientEndpoint());
    }

    @Test
    public void byteBufferTest() throws Exception {
        this.setClientEndpoint(ByteBufferClientEndpoint.class);
        this.invokeSequence("byteBufferTest", new WSCByteBufferClientEndpoint());
    }

    private void invokeSequence(String search, AnnotatedClientEndpoint<?> ... endpoints) throws Exception {
        for (AnnotatedClientEndpoint<?> endpoint : endpoints) {
            this.setCountDownLatchCount(3);
            this.setAnnotatedClientEndpoint(endpoint);
            this.addClientCallback(new EndpointCallback(){

                @Override
                public void onClose(Session session, CloseReason closeReason) {
                    this.getCountDownLatch().countDown();
                    super.onClose(session, closeReason);
                }
            });
            this.invoke("srv", (Object)search, search);
        }
    }
}

