/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.common.impl;

import com.sun.ts.tests.websocket.common.client.WebSocketCommonClient;
import com.sun.ts.tests.websocket.common.util.StringUtil;
import jakarta.websocket.ClientEndpointConfig;
import jakarta.websocket.HandshakeResponse;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ClientConfigurator
extends ClientEndpointConfig.Configurator {
    private Map<String, List<String>> requestMap = new TreeMap<String, List<String>>();
    private Map<String, List<String>> responseMap = new TreeMap<String, List<String>>();
    private boolean hasBeenAfterResponse = false;
    private boolean hasBeenBeforeRequest = false;

    public boolean hasBeenBeforeRequest() {
        return this.hasBeenBeforeRequest;
    }

    public boolean hasBeenAfterResponse() {
        return this.hasBeenAfterResponse;
    }

    public void addToRequest(String key, String ... values) {
        this.requestMap.put(key, Arrays.asList(values));
    }

    public void addToResponse(String key, String ... values) {
        this.responseMap.put(key, Arrays.asList(values));
    }

    public void addToRequestAndResponse(String key, String ... values) {
        this.addToRequest(key, values);
        this.addToResponse(key, values);
    }

    public void beforeRequest(Map<String, List<String>> headers) {
        super.beforeRequest(headers);
        for (Map.Entry<String, List<String>> set : this.requestMap.entrySet()) {
            headers.put(set.getKey(), set.getValue());
        }
        this.hasBeenBeforeRequest = true;
    }

    public void afterResponse(HandshakeResponse hr) {
        super.afterResponse(hr);
        Map headers = hr.getHeaders();
        for (Map.Entry<String, List<String>> set : this.responseMap.entrySet()) {
            String key = set.getKey();
            ClientConfigurator.assertTrue(headers.containsKey(key), "key", key, "was not found in HandshakeResponse headers");
            ClientConfigurator.assertTrue(StringUtil.contains((List)headers.get(key), set.getValue(), false), "value \"", StringUtil.collectionToString((Collection)set.getValue()), "\"", "was not found for key", key, "only \"", StringUtil.collectionToString((Collection)headers.get(key)), "\" has been found");
            WebSocketCommonClient.logTrace("found expected pair [", key, ",", headers.get(key), "]");
        }
        this.hasBeenAfterResponse = true;
    }

    public void assertAfterResponseHasBeenCalled() {
        ClientConfigurator.assertTrue(this.hasBeenAfterResponse(), "Configurator#afterResponse has not been called");
        WebSocketCommonClient.logTrace("Configurator#afterResponse has been called as expected", "");
    }

    public void assertBeforeRequestHasBeenCalled() {
        ClientConfigurator.assertTrue(this.hasBeenBeforeRequest(), "Configurator#beforeRequest has not been called");
        WebSocketCommonClient.logTrace("Configurator#beforeRequest has been called as expected", "");
    }

    protected static void assertTrue(boolean t, String ... msg) {
        if (!t) {
            throw new RuntimeException(StringUtil.objectsToString(msg));
        }
    }
}

