/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.common.client;

import com.sun.ts.tests.common.webclient.TestFailureException;
import com.sun.ts.tests.common.webclient.WebTestCase;
import com.sun.ts.tests.common.webclient.http.HttpRequest;
import com.sun.ts.tests.common.webclient.http.HttpResponse;
import com.sun.ts.tests.common.webclient.validation.ValidationFactory;
import com.sun.ts.tests.common.webclient.validation.ValidationStrategy;
import com.sun.ts.tests.websocket.common.client.AnnotatedClientEndpoint;
import com.sun.ts.tests.websocket.common.client.ApacheRequestAdapter;
import com.sun.ts.tests.websocket.common.client.ApacheResponseAdapter;
import com.sun.ts.tests.websocket.common.client.ClientEndpoint;
import com.sun.ts.tests.websocket.common.client.EndpointCallback;
import com.sun.ts.tests.websocket.common.client.SendMessageCallback;
import com.sun.ts.tests.websocket.common.client.StringClientEndpoint;
import com.sun.ts.tests.websocket.common.client.TextCaser;
import com.sun.ts.tests.websocket.common.client.WebSocketCommonClient;
import jakarta.websocket.ClientEndpointConfig;
import jakarta.websocket.CloseReason;
import jakarta.websocket.ContainerProvider;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.HandshakeResponse;
import jakarta.websocket.Session;
import jakarta.websocket.WebSocketContainer;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class WebSocketTestCase
extends WebTestCase {
    private static final System.Logger logger = System.getLogger(WebSocketTestCase.class.getName());
    protected HttpResponse _response;
    protected WebSocketCommonClient client;
    protected Class<? extends ClientEndpoint<?>> endpoint = StringClientEndpoint.class;
    protected ClientEndpoint<?> endpointInstance = null;
    protected AnnotatedClientEndpoint<?> annotatedEndpoint = null;
    protected volatile EndpointCallback clientCallback = null;
    protected List<EndpointCallback> slaveClientCallbacks = null;
    protected TextCaser textCaser = TextCaser.NONE;
    protected ValidationStrategy strategy = null;
    protected volatile Session session;
    protected int countDownLatchCount = 1;
    protected ClientEndpointConfig clientEndpointConfig = null;
    protected List<ClientEndpointConfig.Configurator> configurators = null;
    protected boolean printClientCall = true;

    public WebSocketTestCase(WebSocketCommonClient client) {
        this.client = client;
        this.clientEndpointConfig = ClientEndpointConfig.Builder.create().build();
        this.strategy = ValidationFactory.getInstance((String)"com.sun.ts.tests.common.webclient.validation.TokenizedValidator");
        this.configurators = new LinkedList<ClientEndpointConfig.Configurator>();
        this.slaveClientCallbacks = new LinkedList<EndpointCallback>();
        ClientEndpoint.ClientEndpointData.resetData();
        WebSocketTestCase.logTrace("A new test case has been created");
    }

    public void execute() throws TestFailureException {
        this.verifyValidationStrategy();
        this.verifySettings();
        this.addAllConfiguratorsToClientEndpointConfig();
        try {
            WebSocketContainer clientContainer = ContainerProvider.getWebSocketContainer();
            String path = this.client.TEST_PROPS.get((Object)WebSocketCommonClient.Property.REQUEST);
            if (this.printClientCall) {
                WebSocketTestCase.logTrace("\n-----------\n", this.printClientCall(), "-----------\n");
            }
            WebSocketTestCase.logMsg("Connecting to", path);
            if (this.slaveClientCallbacks.size() != 0) {
                this.clientCallback = this.createMasterEndpointCallback();
            }
            if (this.client.entity != null) {
                ClientEndpoint.ClientEndpointData.callback = this.clientCallback != null ? this.clientCallback : new SendMessageCallback(this.client.entity);
            }
            this.client.setupWebSocketContainerBeforeConnect(clientContainer);
            this.newCountDown();
            this.session = this.connectToServer(clientContainer, path);
            this.awaitCountDown();
        }
        catch (Throwable t) {
            String message = t.getMessage();
            StringBuilder sb = new StringBuilder();
            sb.append("[FATAL] Unexpected failure during test execution.\n");
            if (this.client.logExceptionOnInvoke) {
                sb.append(this.printClientCall().toString());
            }
            sb.append(message == null ? t.toString() : message);
            throw new TestFailureException(sb.toString(), t);
        }
    }

    protected void validate() throws TestFailureException {
        if (!this.strategy.validate((WebTestCase)this)) {
            throw new TestFailureException("Test FAILED!");
        }
    }

    protected StringBuilder printClientCall() {
        StringBuilder sb = new StringBuilder();
        if (this.client.entity != null && this.client.entity.isInstance(String.class)) {
            sb.append("class ").append(this.endpoint.getSimpleName());
            sb.append(" extends Endpoint implements MessageHandler.Whole<String>");
            sb.append(" {\n");
            sb.append("  public void onOpen(Session session, EndpointConfig config) {\n");
            sb.append("    session.addMessageHandler(this);\n");
            sb.append("    RemoteEndpoint.Basic endpoint = session.getBasicRemote();\n");
            sb.append("    try {\n");
            sb.append("      endpoint.sendText(\"");
            sb.append(this.client.entity.getEntityAt(String.class, 0));
            sb.append("\");\n");
            sb.append("    } catch (IOException e) {\n");
            sb.append("      throw new RuntimeException(e);\n");
            sb.append("    }\n");
            sb.append("  }\n");
            sb.append("  public void onMessage(String message) {\n");
            sb.append("    logger.log(Logger.Level.INFO,message);\n");
            sb.append("    messageLatch.countDown()");
            sb.append("  }\n");
            sb.append("};\n");
        }
        sb.append("CountDownLatch messageLatch;\n");
        sb.append("public void test() {\n");
        sb.append("  WebSocketContainer clientContainer = ContainerProvider");
        sb.append(".getWebSocketContainer();\n");
        sb.append("  messageLatch = new CountDownLatch(");
        sb.append(this.countDownLatchCount).append(");\n");
        sb.append("  Session session = clientContainer.connectToServer(");
        sb.append(this.endpoint.getSimpleName()).append(".class,\n");
        sb.append("                    ");
        sb.append("ClientEndpointConfig.Builder.create()");
        ClientEndpointConfig.Configurator configurator = this.clientEndpointConfig.getConfigurator();
        if (configurator != null) {
            sb.append(".config(new ").append(configurator.getClass().getName()).append("())");
        }
        sb.append(".build(),\n");
        sb.append("                    ");
        sb.append("new URI(\"").append(this.client.TEST_PROPS.get((Object)WebSocketCommonClient.Property.REQUEST));
        sb.append("\"));\n");
        sb.append("  messageLatch.await(").append(this.client._ws_wait);
        sb.append(", TimeUnit.SECONDS);\n");
        sb.append("}\n");
        return sb;
    }

    protected Session connectToServer(WebSocketContainer clientContainer, String path) throws Exception {
        WebSocketCommonClient.assertTrue(this.endpointInstance == null || this.annotatedEndpoint == null, "Either a ClientEndpoint instance or Annotated endpoint can be used, not both");
        this.session = this.annotatedEndpoint != null ? clientContainer.connectToServer(this.annotatedEndpoint, new URI(path)) : (this.endpointInstance != null ? clientContainer.connectToServer(this.endpointInstance, this.clientEndpointConfig, new URI(path)) : clientContainer.connectToServer(this.endpoint, this.clientEndpointConfig, new URI(path)));
        WebSocketTestCase.logTrace("Connection session id:", this.session.getId());
        return this.session;
    }

    protected void addAllConfiguratorsToClientEndpointConfig() {
        if (!this.configurators.isEmpty()) {
            ClientEndpointConfig.Configurator masterConfigurator = this.createMasterConfigurator();
            ClientEndpointConfig.Builder builder = this.cloneConfigWithoutConfigurator();
            builder.configurator(masterConfigurator);
            this.clientEndpointConfig = builder.build();
        }
    }

    protected ClientEndpointConfig.Builder cloneConfigWithoutConfigurator() {
        ClientEndpointConfig.Builder builder = ClientEndpointConfig.Builder.create();
        builder.decoders(this.clientEndpointConfig.getDecoders());
        builder.encoders(this.clientEndpointConfig.getEncoders());
        builder.extensions(this.clientEndpointConfig.getExtensions());
        builder.preferredSubprotocols(this.clientEndpointConfig.getPreferredSubprotocols());
        return builder;
    }

    protected ClientEndpointConfig.Configurator createMasterConfigurator() {
        ClientEndpointConfig.Configurator master = new ClientEndpointConfig.Configurator(){
            final ClientEndpointConfig.Configurator original;
            {
                this.original = WebSocketTestCase.this.clientEndpointConfig.getConfigurator();
            }

            public void afterResponse(HandshakeResponse hr) {
                if (WebSocketTestCase.this.configurators != null) {
                    for (ClientEndpointConfig.Configurator configurator : WebSocketTestCase.this.configurators) {
                        configurator.afterResponse(hr);
                    }
                }
                if (this.original != null) {
                    this.original.afterResponse(hr);
                }
            }

            public void beforeRequest(Map<String, List<String>> headers) {
                if (WebSocketTestCase.this.configurators != null) {
                    for (ClientEndpointConfig.Configurator configurator : WebSocketTestCase.this.configurators) {
                        configurator.beforeRequest(headers);
                    }
                }
                if (this.original != null) {
                    this.original.beforeRequest(headers);
                }
                this.printHeaders(headers);
            }

            void printHeaders(Map<String, List<String>> headers) {
                for (Map.Entry<String, List<String>> set : headers.entrySet()) {
                    WebSocketTestCase.logMsg(set.getKey(), ":", WebSocketCommonClient.objectsToString(set.getValue().toArray()));
                }
            }
        };
        return master;
    }

    protected EndpointCallback createMasterEndpointCallback() {
        EndpointCallback master = new EndpointCallback(){
            EndpointCallback original;
            {
                this.original = WebSocketTestCase.this.clientCallback == null ? new SendMessageCallback(WebSocketTestCase.this.client.entity) : WebSocketTestCase.this.clientCallback;
            }

            @Override
            public void onOpen(Session session, EndpointConfig config) {
                this.original.onOpen(session, config);
                for (EndpointCallback callback : WebSocketTestCase.this.slaveClientCallbacks) {
                    callback.onOpen(session, config);
                }
            }

            @Override
            public void onMessage(Object o) {
                this.original.onMessage(o);
                for (EndpointCallback callback : WebSocketTestCase.this.slaveClientCallbacks) {
                    callback.onMessage(o);
                }
            }

            @Override
            public void onError(Session session, Throwable t) {
                this.original.onError(session, t);
                for (EndpointCallback callback : WebSocketTestCase.this.slaveClientCallbacks) {
                    callback.onError(session, t);
                }
            }

            @Override
            public void onClose(Session session, CloseReason closeReason) {
                this.original.onClose(session, closeReason);
                for (EndpointCallback callback : WebSocketTestCase.this.slaveClientCallbacks) {
                    callback.onClose(session, closeReason);
                }
            }
        };
        return master;
    }

    protected void verifyValidationStrategy() {
        try {
            this.getStrategy();
        }
        catch (NullPointerException e) {
            throw new IllegalStateException("[FATAL] No Validator available.");
        }
    }

    protected void verifySettings() throws TestFailureException {
        if (this.client.getContextRoot() == null) {
            throw new TestFailureException("No resource url request set");
        }
    }

    protected void awaitCountDown() {
        WebSocketTestCase.logTrace("Setting CountDownLatch to", this.client._ws_wait, "seconds, should be hit", this.countDownLatchCount, "times");
        ClientEndpoint.ClientEndpointData.awaitCountDown(this.client._ws_wait);
    }

    protected void newCountDown() {
        ClientEndpoint.ClientEndpointData.newCountDown(this.countDownLatchCount);
    }

    public HttpRequest getRequest() {
        if (super.getRequest() == null) {
            super.setRequest((HttpRequest)new ApacheRequestAdapter(this.client.requestProtocol, this.client.TEST_PROPS.get((Object)WebSocketCommonClient.Property.REQUEST), this.client._hostname, this.client._port));
        }
        return super.getRequest();
    }

    public HttpResponse getResponse() {
        try {
            if (this._response == null) {
                this._response = new ApacheResponseAdapter(this.client._hostname, this.client._port, this.textCaser);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this._response;
    }

    public void setStrategy(String validator) {
        ValidationStrategy strat = ValidationFactory.getInstance((String)validator);
        if (strat != null) {
            this.strategy = strat;
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append("[WebTestCase][WARNING] An attempt was made to use a ");
            sb.append("non-existing validator (");
            sb.append(validator);
            sb.append(").  Falling back to the TokenizedValidator");
            logger.log(System.Logger.Level.DEBUG, sb.toString());
        }
    }

    protected TextCaser getTextCaser() {
        return this.textCaser;
    }

    protected void setClientEndpoint(Class<? extends ClientEndpoint<?>> endpoint) {
        this.endpoint = endpoint;
    }

    protected void setClientEndpointInstance(ClientEndpoint<?> endpointInstance) {
        this.endpointInstance = endpointInstance;
    }

    protected void setAnnotatedClientEndpoint(AnnotatedClientEndpoint<?> annotatedEndpoint) {
        this.annotatedEndpoint = annotatedEndpoint;
    }

    protected void setCountDownLatchCount(int countDownLatchCount) {
        this.countDownLatchCount = countDownLatchCount;
    }

    protected int getCountDownLatchTotalCount() {
        return this.countDownLatchCount;
    }

    protected long getCountDownLatchRemainingHits() {
        long hits = ClientEndpoint.ClientEndpointData.getCount();
        return hits;
    }

    protected void setCallback(EndpointCallback callback) {
        this.clientCallback = callback;
    }

    protected void addClientCallback(EndpointCallback callback) {
        this.slaveClientCallbacks.add(callback);
    }

    protected Session getSession() {
        return this.session;
    }

    protected String getResponseAsString() {
        return ClientEndpoint.getMessageBuilder().toString();
    }

    protected <T> T getLastResponse(Class<T> type) {
        return (T)ClientEndpoint.ClientEndpointData.lastMessage;
    }

    protected void setClientEndpointConfig(ClientEndpointConfig clientEndpointConfig) {
        this.clientEndpointConfig = clientEndpointConfig;
    }

    protected void addClientConfigurator(ClientEndpointConfig.Configurator config) {
        this.configurators.add(config);
    }

    protected void printClientCall(boolean printClientCall) {
        this.printClientCall = printClientCall;
    }

    static void logMsg(Object ... msg) {
        WebSocketCommonClient.logMsg("[WebSocketCommonClient]", msg);
    }

    static void logTrace(Object ... msg) {
        WebSocketCommonClient.logTrace("[WebSocketCommonClient]", msg);
    }

    protected ClientEndpointConfig getEndpointConfig() {
        return this.clientEndpointConfig;
    }
}

