/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.merge;

import com.sun.tdk.signaturetest.Result;
import com.sun.tdk.signaturetest.core.AppContext;
import com.sun.tdk.signaturetest.core.Erasurator;
import com.sun.tdk.signaturetest.core.Log;
import com.sun.tdk.signaturetest.core.context.MergeOptions;
import com.sun.tdk.signaturetest.core.context.Option;
import com.sun.tdk.signaturetest.loaders.VirtualClassDescriptionLoader;
import com.sun.tdk.signaturetest.merge.MergedSigFile;
import com.sun.tdk.signaturetest.model.AnnotationItem;
import com.sun.tdk.signaturetest.model.ClassDescription;
import com.sun.tdk.signaturetest.model.ConstructorDescr;
import com.sun.tdk.signaturetest.model.FieldDescr;
import com.sun.tdk.signaturetest.model.InnerDescr;
import com.sun.tdk.signaturetest.model.MemberDescription;
import com.sun.tdk.signaturetest.model.MethodDescr;
import com.sun.tdk.signaturetest.model.Modifier;
import com.sun.tdk.signaturetest.model.SuperClass;
import com.sun.tdk.signaturetest.model.SuperInterface;
import com.sun.tdk.signaturetest.sigfile.FeaturesHolder;
import com.sun.tdk.signaturetest.util.I18NResourceBundle;
import com.sun.tdk.signaturetest.util.SwissKnife;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;

public class JSR68Merger
extends FeaturesHolder {
    private static final I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(JSR68Merger.class);
    private final MergeOptions mo = AppContext.getContext().getBean(MergeOptions.class);
    private final Log log;
    private final Result result;
    private final Erasurator erasurator;

    public JSR68Merger(Log log, Result result, FeaturesHolder fh) {
        this.log = log;
        this.result = result;
        this.erasurator = new Erasurator();
        this.setFeatures(fh.getSupportedFeatures());
    }

    /*
     * Unable to fully structure code
     */
    public VirtualClassDescriptionLoader merge(MergedSigFile[] files) {
        result = new VirtualClassDescriptionLoader();
        for (i = 0; i < files.length; ++i) {
            mf = files[i];
            for (ClassDescription cd : mf.getClassSet().values()) {
                unique = true;
                sameClasses = new ArrayList();
                filesForSameClasses = new ArrayList<MergedSigFile>();
                sameClasses.add(cd);
                filesForSameClasses.add(mf);
                for (j = 0; j < files.length; ++j) {
                    if (i == j || !(mfOther = files[j]).getClassSet().containsKey(cd.getQualifiedName())) continue;
                    unique = false;
                    sameClasses.add(mfOther.getClassSet().get(cd.getQualifiedName()));
                    filesForSameClasses.add(mfOther);
                }
                if (unique) {
                    result.add(cd);
                    continue;
                }
                resultedClass = new ClassDescription();
                resultedClass.setupClassName(cd.getQualifiedName());
                classes = sameClasses.toArray(new ClassDescription[0]);
                if (!this.merge(classes, resultedClass, filesForClasses = filesForSameClasses.toArray(new MergedSigFile[0])) || !this.merge2(classes, resultedClass)) continue;
                result.add(resultedClass);
            }
        }
        it = result.getClassIterator();
        innersToRemove = new ArrayList<ClassDescription>();
        block9: while (it.hasNext()) {
            cd = it.next();
            try {
                result.load(cd.getPackageName());
                this.error(JSR68Merger.i18n.getString("Merger.error.packageconflict", cd.getPackageName()));
            }
            catch (ClassNotFoundException cd) {
                // empty catch block
            }
            if (!cd.getQualifiedName().contains("$")) continue;
            try {
                outer = result.load(cd.getDeclaringClassName());
                for (InnerDescr innerDescr : dc = outer.getDeclaredClasses()) {
                    if (innerDescr.getQualifiedName().equals(cd.getQualifiedName())) continue block9;
                }
                it2 = result.getClassIterator();
                while (it2.hasNext()) {
                    similarInner = it2.next();
                    if (!similarInner.getQualifiedName().contains("$") || !similarInner.getName().equals(cd.getName())) continue;
                    parent = outer;
                    try {
                        block12: while (true) {
                            parent = result.load(parent.getSuperClass().getQualifiedName());
                            if (!similarInner.getDeclaringClassName().equals(parent.getQualifiedName())) continue;
                            i = 0;
                            while (true) {
                                if (i < files.length) ** break;
                                continue block12;
                                if (files[i].getClassSet().containsKey(cd.getQualifiedName())) {
                                    for (j = 0; j < files.length; ++j) {
                                        if (files[j].getClassSet().containsKey(similarInner.getQualifiedName()) && j == i) continue block9;
                                    }
                                    innersToRemove.add(cd);
                                    continue block9;
                                }
                                ++i;
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                    }
                }
                d = new InnerDescr();
                d.setupClassName(cd.getQualifiedName());
                d.setModifiers(cd.getModifiers());
                newInners = new InnerDescr[dc.length + 1];
                System.arraycopy(dc, 0, newInners, 0, dc.length);
                newInners[dc.length] = d;
                outer.setNestedClasses(newInners);
            }
            catch (ClassNotFoundException ex) {
                SwissKnife.reportThrowable(ex);
            }
        }
        it = result.getClassIterator();
        while (it.hasNext()) {
            if (!innersToRemove.contains(it.next())) continue;
            it.remove();
        }
        return result;
    }

    private boolean merge(ClassDescription[] similarClasses, ClassDescription result, MergedSigFile[] sigfiles) {
        boolean mAbs = similarClasses[0].isAbstract();
        for (int i = 1; i < similarClasses.length; ++i) {
            if (similarClasses[i].isAbstract() == mAbs) continue;
            this.error(similarClasses[0].getQualifiedName() + " " + i18n.getString("Merger.error.modifierconfict", "abstract"));
            return false;
        }
        boolean mInt = similarClasses[0].isInterface();
        for (int i = 1; i < similarClasses.length; ++i) {
            if (similarClasses[i].isInterface() == mInt) continue;
            this.error(similarClasses[0].getQualifiedName() + i18n.getString("Merger.error.classwithinterface"));
            return false;
        }
        if (!this.mergeMod(similarClasses, result)) {
            return false;
        }
        if (!this.mergeSuprs(similarClasses, result, sigfiles)) {
            return false;
        }
        return this.mergeInterfaces(similarClasses, result);
    }

    private boolean merge2(ClassDescription[] similarClasses, ClassDescription result) {
        if (this.prepareGenerics(similarClasses, result)) {
            this.mergeAnnotations(similarClasses, result);
            this.mergeTypeParameters(similarClasses, result);
            if (!this.mergeMembers(similarClasses, result)) {
                return false;
            }
            this.checkGenerics(result);
        }
        return true;
    }

    private void checkGenerics(ClassDescription result) {
        String s;
        int i;
        ClassDescription eResult = this.erasurator.fullErasure(result);
        ConstructorDescr[] genCostr = eResult.getDeclaredConstructors();
        MethodDescr[] genMeth = eResult.getDeclaredMethods();
        FieldDescr[] genFld = eResult.getDeclaredFields();
        HashSet<String> sims = new HashSet<String>();
        for (i = 0; i < genCostr.length; ++i) {
            s = genCostr[i].getSignature();
            if (sims.contains(s)) {
                this.error(JSR68Merger.show(genCostr[i]) + i18n.getString("Merger.error.typeconflict"), new Object[]{result.getDeclaredConstructors()[i], s});
            }
            sims.add(s);
        }
        for (i = 0; i < genMeth.length; ++i) {
            s = genMeth[i].getSignature();
            if (sims.contains(s)) {
                this.error(JSR68Merger.show(genCostr[i]) + i18n.getString("Merger.error.typeconflict"), new Object[]{result.getDeclaredMethods()[i], s});
            }
            sims.add(s);
        }
        for (i = 0; i < genFld.length; ++i) {
            s = genFld[i].getName();
            if (sims.contains(s)) {
                this.error(JSR68Merger.show(genCostr[i]) + i18n.getString("Merger.error.typeconflict"), new Object[]{result.getDeclaredFields()[i], s});
            }
            sims.add(s);
        }
    }

    private boolean prepareGenerics(ClassDescription[] similarClasses, ClassDescription result) {
        ArrayList<ClassDescription> hasGen = new ArrayList<ClassDescription>();
        ArrayList<ClassDescription> noGen = new ArrayList<ClassDescription>();
        int noGenPos = -1;
        int genPos = -1;
        for (int i = 0; i < similarClasses.length; ++i) {
            if (this.isGeneralized(similarClasses[i])) {
                hasGen.add(similarClasses[i]);
                genPos = i;
                continue;
            }
            noGen.add(similarClasses[i]);
            noGenPos = i;
        }
        if (hasGen.isEmpty() || noGen.isEmpty()) {
            return true;
        }
        if (hasGen.size() == 1 && noGen.size() == 1) {
            int j;
            int i;
            ClassDescription hasGenCD = similarClasses[genPos];
            ConstructorDescr[] genCostr = hasGenCD.getDeclaredConstructors();
            MethodDescr[] genMeth = hasGenCD.getDeclaredMethods();
            FieldDescr[] genFld = hasGenCD.getDeclaredFields();
            ClassDescription noGenCD = similarClasses[noGenPos];
            ClassDescription hasGenEraCD = this.erasurator.fullErasure(hasGenCD);
            if (noGenCD.equals(hasGenEraCD)) {
                noGenCD.setTypeParameters(hasGenCD.getTypeParameters());
            }
            ConstructorDescr[] noGenCostr = noGenCD.getDeclaredConstructors();
            ConstructorDescr[] eraCostr = hasGenEraCD.getDeclaredConstructors();
            MethodDescr[] noGenMeth = noGenCD.getDeclaredMethods();
            MethodDescr[] eraMeth = hasGenEraCD.getDeclaredMethods();
            FieldDescr[] noGenFld = noGenCD.getDeclaredFields();
            FieldDescr[] eraFld = hasGenEraCD.getDeclaredFields();
            block1: for (i = 0; i < noGenCostr.length; ++i) {
                ConstructorDescr c = noGenCostr[i];
                for (j = 0; j < eraCostr.length; ++j) {
                    ConstructorDescr c2 = eraCostr[j];
                    ConstructorDescr c3 = genCostr[j];
                    if (!c.equals(c2) || c.equals(c3)) continue;
                    noGenCD.setConstructor(i, (ConstructorDescr)c3.clone());
                    continue block1;
                }
            }
            block3: for (i = 0; i < noGenMeth.length; ++i) {
                MethodDescr m = noGenMeth[i];
                for (j = 0; j < eraMeth.length; ++j) {
                    MethodDescr m2 = eraMeth[j];
                    MethodDescr m3 = genMeth[j];
                    if (!m.getSignature().equals(m2.getSignature()) || !m.getType().equals(m2.getType())) continue;
                    noGenCD.setMethod(i, (MethodDescr)m3.clone());
                    continue block3;
                }
            }
            block5: for (i = 0; i < noGenFld.length; ++i) {
                FieldDescr f = noGenFld[i];
                for (j = 0; j < eraFld.length; ++j) {
                    FieldDescr f2 = eraFld[j];
                    FieldDescr f3 = genFld[j];
                    if (!f.equals(f2) || !f.getType().equals(f2.getType())) continue;
                    noGenCD.setField(i, (FieldDescr)f3.clone());
                    continue block5;
                }
            }
            return true;
        }
        if (hasGen.size() >= 1 || noGen.size() >= 1) {
            ClassDescription res1 = (ClassDescription)result.clone();
            ClassDescription res2 = (ClassDescription)result.clone();
            if (noGen.size() >= 0) {
                this.merge2(noGen.toArray(new ClassDescription[0]), res1);
            } else {
                res1 = (ClassDescription)noGen.get(0);
            }
            if (hasGen.size() >= 0) {
                this.merge2(hasGen.toArray(new ClassDescription[0]), res2);
            } else {
                res1 = (ClassDescription)hasGen.get(0);
            }
            this.merge2(new ClassDescription[]{res1, res2}, result);
            return false;
        }
        return true;
    }

    private boolean isGeneralized(ClassDescription clazz) {
        if (clazz.getTypeParameters() != null) {
            return true;
        }
        Iterator<MemberDescription> it = clazz.getMembersIterator();
        while (it.hasNext()) {
            MemberDescription md = it.next();
            if (!md.getDeclaringClassName().equals(clazz.getQualifiedName()) || md.getTypeParameters() == null) continue;
            return true;
        }
        return false;
    }

    private boolean mergeMod(MemberDescription[] x, MemberDescription z) {
        for (MemberDescription x3 : x) {
            z.setModifiers(z.getModifiers() | x3.getModifiers());
        }
        int visibilityBits = Modifier.PUBLIC.getValue() | Modifier.PROTECTED.getValue() | Modifier.PRIVATE.getValue();
        z.setModifiers(z.getModifiers() & ~visibilityBits);
        int vis = 0;
        for (MemberDescription x2 : x) {
            vis |= x2.getModifiers() & visibilityBits;
        }
        if ((vis & Modifier.PUBLIC.getValue()) != 0) {
            z.setModifiers(z.getModifiers() | Modifier.PUBLIC.getValue());
        } else if ((vis & Modifier.PROTECTED.getValue()) != 0) {
            z.setModifiers(z.getModifiers() | Modifier.PROTECTED.getValue());
        } else if ((vis & Modifier.PRIVATE.getValue()) == 0) {
            z.setModifiers(z.getModifiers() | Modifier.PRIVATE.getValue());
        }
        for (MemberDescription x1 : x) {
            if (x1.isFinal()) continue;
            z.setModifiers(z.getModifiers() & ~Modifier.FINAL.getValue());
            break;
        }
        boolean mStat = x[0].isStatic();
        for (int i = 1; i < x.length; ++i) {
            if (x[i].isStatic() == mStat) continue;
            this.error(JSR68Merger.show(x[0]) + " " + i18n.getString("Merger.error.modifierconfict", "static"));
            return false;
        }
        return true;
    }

    private boolean mergeSuprs(ClassDescription[] similarClasses, ClassDescription result, MergedSigFile[] sigfiles) {
        ArrayList<SuperClass> superclasses = new ArrayList<SuperClass>();
        for (ClassDescription similarClass : similarClasses) {
            SuperClass sc = similarClass.getSuperClass();
            if (sc == null || superclasses.contains(sc)) continue;
            superclasses.add(sc);
        }
        if (superclasses.isEmpty()) {
            return true;
        }
        if (superclasses.size() == 1) {
            result.setSuperClass((SuperClass)superclasses.iterator().next());
            return true;
        }
        for (MergedSigFile file : sigfiles) {
            boolean all = true;
            for (SuperClass sc : superclasses) {
                if (file.getClassSet().containsKey(sc.getQualifiedName())) continue;
                all = false;
                break;
            }
            if (!all) continue;
            for (int j = 0; j < superclasses.size(); ++j) {
                SuperClass scSub = (SuperClass)superclasses.get(j);
                boolean subSuperFound = true;
                for (int k = 0; k < superclasses.size(); ++k) {
                    try {
                        if (k == j) continue;
                        SuperClass scSuper = (SuperClass)superclasses.get(k);
                        if (file.getClassHierarchy().isSubclass(scSub.getQualifiedName(), scSuper.getQualifiedName())) continue;
                        subSuperFound = false;
                        break;
                    }
                    catch (ClassNotFoundException ex) {
                        SwissKnife.reportThrowable(ex);
                    }
                }
                if (!subSuperFound) continue;
                result.setSuperClass(scSub);
                return true;
            }
        }
        this.error(JSR68Merger.show(result) + " " + i18n.getString("Merger.error.superclassesnotrelated"));
        System.out.println("Can't merge superclasses");
        return false;
    }

    private boolean mergeInterfaces(ClassDescription[] similarClasses, ClassDescription result) {
        TreeSet<SuperInterface> ts = new TreeSet<SuperInterface>(new Comparator<SuperInterface>(){

            @Override
            public int compare(SuperInterface s1, SuperInterface s2) {
                return s1.getQualifiedName().compareTo(s2.getQualifiedName());
            }
        });
        ts.addAll(Arrays.asList(similarClasses[0].getInterfaces()));
        for (int i = 1; i < similarClasses.length; ++i) {
            ts.addAll(Arrays.asList(similarClasses[i].getInterfaces()));
        }
        result.createInterfaces(ts.size());
        Iterator it = ts.iterator();
        int i = 0;
        while (it.hasNext()) {
            SuperInterface si = (SuperInterface)((SuperInterface)it.next()).clone();
            si.setDirect(true);
            result.setInterface(i++, si);
        }
        return true;
    }

    private boolean mergeMembers(ClassDescription[] similarClasses, ClassDescription result) {
        this.makeMethods(similarClasses, result);
        this.makeCtors(similarClasses, result);
        this.makeFields(similarClasses, result);
        this.makeHiders(similarClasses, result);
        return true;
    }

    private boolean makeHiders(ClassDescription[] similarClasses, ClassDescription result) {
        HashSet<String> internalFields = new HashSet<String>(similarClasses[0].getInternalFields());
        HashSet<String> internalClasses = new HashSet<String>(similarClasses[0].getInternalClasses());
        HashSet<String> xFields = new HashSet<String>(similarClasses[0].getXFields());
        HashSet<String> xClasses = new HashSet<String>(similarClasses[0].getXClasses());
        for (int i = 1; i < similarClasses.length; ++i) {
            internalFields.retainAll(similarClasses[i].getInternalFields());
            internalClasses.retainAll(similarClasses[i].getInternalClasses());
            xFields.retainAll(similarClasses[i].getXFields());
            xClasses.retainAll(similarClasses[i].getXClasses());
        }
        result.setInternalClasses(internalClasses);
        result.setInternalFields(internalFields);
        result.setXFields(xFields);
        result.setXClasses(xFields);
        return true;
    }

    private boolean makeFields(ClassDescription[] similarClasses, ClassDescription result) {
        ArrayList<FieldDescr> fields = new ArrayList<FieldDescr>();
        HashSet<String> h = new HashSet<String>();
        for (int i = 0; i < similarClasses.length; ++i) {
            FieldDescr[] fds;
            for (FieldDescr fd : fds = similarClasses[i].getDeclaredFields()) {
                if (!this.isFeatureSupported(FeaturesHolder.NonStaticConstants) && !fd.isStatic()) {
                    fd.setConstantValue(null);
                }
                ArrayList<FieldDescr> sameFields = new ArrayList<FieldDescr>();
                sameFields.add(fd);
                boolean isUnique = true;
                for (int k = 0; k < similarClasses.length; ++k) {
                    FieldDescr[] fd2;
                    if (k == i) continue;
                    for (FieldDescr fieldDescr : fd2 = similarClasses[k].getDeclaredFields()) {
                        if (!fieldDescr.getName().equals(fd.getName())) continue;
                        isUnique = false;
                        sameFields.add(fieldDescr);
                    }
                }
                if (isUnique) {
                    if (!h.contains(fd.getName())) {
                        fields.add(fd);
                    }
                    h.add(fd.getName());
                    continue;
                }
                FieldDescr f = new FieldDescr();
                if (!this.mergeFields(sameFields.toArray(FieldDescr.EMPTY_ARRAY), f)) continue;
                if (!h.contains(f.getName())) {
                    fields.add(f);
                }
                h.add(f.getName());
            }
        }
        result.setFields(fields.toArray(FieldDescr.EMPTY_ARRAY));
        return true;
    }

    private boolean mergeFields(FieldDescr[] similarFileds, FieldDescr result) {
        String type = similarFileds[0].getType();
        String value = similarFileds[0].getConstantValue();
        for (int i = 1; i < similarFileds.length; ++i) {
            if (!type.equals(similarFileds[i].getType())) {
                this.error(JSR68Merger.show(similarFileds[0]) + i18n.getString("Merger.error.typeconflict"), new Object[]{type, similarFileds[i].getType()});
                return false;
            }
            String anotherValue = similarFileds[i].getConstantValue();
            if (value == null && anotherValue == null || value != null && anotherValue != null && value.equals(anotherValue)) continue;
            this.error(JSR68Merger.show(similarFileds[0]) + i18n.getString("Merger.error.differentvalues"), new Object[]{value, anotherValue});
            return false;
        }
        if (!this.mergeMod(similarFileds, result)) {
            return false;
        }
        result.setupMemberName(similarFileds[0].getQualifiedName());
        result.setType(type);
        result.setConstantValue(value);
        this.mergeAnnotations(similarFileds, result);
        this.mergeTypeParameters(similarFileds, result);
        return true;
    }

    private boolean makeMethods(ClassDescription[] similarClasses, ClassDescription result) {
        ArrayList<MethodDescr> methods = new ArrayList<MethodDescr>();
        HashSet<String> h = new HashSet<String>();
        for (int i = 0; i < similarClasses.length; ++i) {
            MethodDescr[] mfs;
            for (MethodDescr mf : mfs = similarClasses[i].getDeclaredMethods()) {
                ArrayList<MethodDescr> sameMethods = new ArrayList<MethodDescr>();
                ArrayList<Boolean> finalMods = new ArrayList<Boolean>();
                sameMethods.add(mf);
                finalMods.add(mf.isFinal() || similarClasses[i].isFinal());
                boolean isUnique = true;
                for (int k = 0; k < similarClasses.length; ++k) {
                    MethodDescr[] mfs2;
                    if (k == i) continue;
                    for (MethodDescr methodDescr : mfs2 = similarClasses[k].getDeclaredMethods()) {
                        if (!methodDescr.getSignature().equals(mf.getSignature())) continue;
                        isUnique = false;
                        sameMethods.add(methodDescr);
                        finalMods.add(methodDescr.isFinal() || similarClasses[k].isFinal());
                    }
                }
                if (isUnique) {
                    if (!h.contains(mf.getSignature())) {
                        methods.add(mf);
                    }
                    h.add(mf.getSignature());
                    continue;
                }
                MethodDescr m = new MethodDescr();
                if (!this.mergeMethods(sameMethods.toArray(MethodDescr.EMPTY_ARRAY), m, finalMods)) continue;
                if (!h.contains(m.getSignature())) {
                    methods.add(m);
                }
                h.add(m.getSignature());
            }
        }
        result.setMethods(methods.toArray(MethodDescr.EMPTY_ARRAY));
        return true;
    }

    private boolean makeCtors(ClassDescription[] similarClasses, ClassDescription result) {
        ArrayList<ConstructorDescr> constr = new ArrayList<ConstructorDescr>();
        HashSet<String> h = new HashSet<String>();
        for (int i = 0; i < similarClasses.length; ++i) {
            ConstructorDescr[] cds;
            for (ConstructorDescr cd : cds = similarClasses[i].getDeclaredConstructors()) {
                ArrayList<ConstructorDescr> sameConstr = new ArrayList<ConstructorDescr>();
                sameConstr.add(cd);
                boolean isUnique = true;
                for (int k = 0; k < similarClasses.length; ++k) {
                    ConstructorDescr[] cds2;
                    if (k == i) continue;
                    for (ConstructorDescr constructorDescr : cds2 = similarClasses[k].getDeclaredConstructors()) {
                        if (!constructorDescr.getSignature().equals(cd.getSignature())) continue;
                        isUnique = false;
                        sameConstr.add(constructorDescr);
                    }
                }
                if (isUnique) {
                    if (!h.contains(cd.getSignature())) {
                        constr.add(cd);
                    }
                    h.add(cd.getSignature());
                    continue;
                }
                ConstructorDescr c = new ConstructorDescr();
                if (!this.mergeConstructors(sameConstr.toArray(ConstructorDescr.EMPTY_ARRAY), c)) continue;
                if (!h.contains(c.getSignature())) {
                    constr.add(c);
                }
                h.add(c.getSignature());
            }
        }
        result.setConstructors(constr.toArray(ConstructorDescr.EMPTY_ARRAY));
        return true;
    }

    private boolean mergeMethods(MemberDescription[] similarMethods, MemberDescription result, ArrayList<Boolean> finalMods) {
        String type = similarMethods[0].getType();
        for (int i = 1; i < similarMethods.length; ++i) {
            if (type.equals(similarMethods[i].getType())) continue;
            this.error(JSR68Merger.show(similarMethods[0]) + i18n.getString("Merger.error.typeconflict"), new Object[]{type, similarMethods[i].getType()});
            return false;
        }
        if (!this.mergeMod(similarMethods, result)) {
            return false;
        }
        result.setupMemberName(similarMethods[0].getQualifiedName());
        result.setType(similarMethods[0].getType());
        this.mergeAnnotations(similarMethods, result);
        boolean notAbstract = false;
        boolean hasFinal = true;
        for (int i = 0; i < similarMethods.length; ++i) {
            if (!similarMethods[i].isAbstract()) {
                notAbstract = true;
            }
            if (finalMods.get(i).booleanValue()) continue;
            hasFinal = false;
        }
        if (notAbstract) {
            result.setModifiers(result.getModifiers() & ~Modifier.ABSTRACT.getValue());
        }
        if (hasFinal) {
            result.setModifiers(result.getModifiers() | Modifier.FINAL.getValue());
        }
        result.setArgs(similarMethods[0].getArgs());
        result.setType(similarMethods[0].getType());
        this.mergeTypeParameters(similarMethods, result);
        return this.mergeThrows(similarMethods, result);
    }

    private void mergeTypeParameters(MemberDescription[] similarMembers, MemberDescription result) {
        String tp = null;
        boolean unique = true;
        for (MemberDescription similarMember : similarMembers) {
            String tpp = similarMember.getTypeParameters();
            if (tpp == null) continue;
            if (tp == null || tpp.equals(tp)) {
                tp = tpp;
                continue;
            }
            unique = false;
        }
        if (unique) {
            result.setTypeParameters(tp);
        } else {
            this.error(JSR68Merger.show(similarMembers[0]) + i18n.getString("Merger.error.typeconflict"), new Object[]{tp, similarMembers[0].getTypeParameters()});
        }
    }

    private void mergeAnnotations(MemberDescription[] similarMembers, MemberDescription result) {
        TreeSet<AnnotationItem> annotations = new TreeSet<AnnotationItem>();
        for (MemberDescription similarMember : similarMembers) {
            AnnotationItem[] annos = similarMember.getAnnoList();
            annotations.addAll(Arrays.asList(annos));
        }
        result.setAnnoList(annotations.toArray(AnnotationItem.EMPTY_ANNOTATIONITEM_ARRAY));
    }

    private boolean mergeConstructors(ConstructorDescr[] similarCtors, ConstructorDescr result) {
        String type = similarCtors[0].getType();
        for (int i = 1; i < similarCtors.length; ++i) {
            if (type.equals(similarCtors[i].getType())) continue;
            this.error(JSR68Merger.show(similarCtors[0]) + i18n.getString("Merger.error.typeconflict"), new Object[]{type, similarCtors[i].getType()});
            return false;
        }
        if (!this.mergeMod(similarCtors, result)) {
            return false;
        }
        result.setupMemberName(similarCtors[0].getQualifiedName());
        result.setType(similarCtors[0].getType());
        result.setArgs(similarCtors[0].getArgs());
        this.mergeAnnotations(similarCtors, result);
        this.mergeTypeParameters(similarCtors, result);
        return this.mergeThrows(similarCtors, result);
    }

    private boolean mergeThrows(MemberDescription[] similarMethods, MemberDescription result) {
        if (this.mo.isSet(Option.BINARY)) {
            result.setThrowables("");
            return true;
        }
        String throwList = similarMethods[0].getThrowables();
        for (int i = 1; i < similarMethods.length; ++i) {
            if (throwList.equals(similarMethods[1].getThrowables())) continue;
            Object[] tlist = new Object[]{JSR68Merger.show(throwList), JSR68Merger.show(similarMethods[1].getThrowables())};
            this.error(JSR68Merger.show(similarMethods[0]) + i18n.getString("Merger.error.throwconflict"), tlist);
            return false;
        }
        result.setThrowables(throwList);
        return true;
    }

    private void error(String msg, Object[] params) {
        this.error(MessageFormat.format(msg, params));
    }

    private void error(String msg) {
        this.log.storeError(msg, null);
        this.result.error(i18n.getString("Merger.error"));
    }

    private static String show(MemberDescription x) {
        return x.getQualifiedName();
    }

    private static String show(String x) {
        return x;
    }
}

