/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.Deprecated;
import com.sun.javatest.Status;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestRunner;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.util.BackupPolicy;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class DefaultTestRunner
extends TestRunner {
    private static final Integer EXCEPTION = new Integer(0);
    private static final Integer ERROR = new Integer(1);
    private static final Integer THROWABLE = new Integer(2);
    private Iterator testIter;
    private Set activeThreads;
    private boolean allPassed;
    private boolean stopping;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(DefaultTestRunner.class);

    @Override
    public synchronized boolean runTests(Iterator testIter) throws InterruptedException {
        this.testIter = testIter;
        Thread[] threads = new Thread[this.getConcurrency()];
        this.activeThreads = new HashSet();
        this.allPassed = true;
        try {
            int i;
            int n = 0;
            while (!this.stopping) {
                for (i = 0; i < threads.length; ++i) {
                    Thread t = threads[i];
                    if (t != null && this.activeThreads.contains(t)) continue;
                    int prio = Math.max(1, Thread.currentThread().getPriority() - 1);
                    t = new Thread(){

                        @Override
                        public void run() {
                            try {
                                TestDescription td;
                                while ((td = DefaultTestRunner.this.nextTest()) != null) {
                                    if (DefaultTestRunner.this.runTest(td)) continue;
                                    DefaultTestRunner.this.allPassed = false;
                                }
                            }
                            finally {
                                DefaultTestRunner.this.threadExiting(this);
                            }
                        }
                    };
                    t.setName("DefaultTestRunner:Worker-" + i + ":" + n++);
                    t.start();
                    t.setPriority(prio);
                    this.activeThreads.add(t);
                    threads[i] = t;
                }
                this.wait();
            }
            for (i = 0; i < threads.length; ++i) {
                if (threads[i] == null) continue;
                while (this.activeThreads.contains(threads[i])) {
                    this.wait();
                }
                threads[i] = null;
            }
        }
        catch (InterruptedException ex) {
            this.stopping = true;
            for (Thread t : this.activeThreads) {
                t.interrupt();
            }
            long now = System.currentTimeMillis();
            try {
                while (this.activeThreads.size() > 0 && System.currentTimeMillis() - now < 2000L) {
                    this.wait(100L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            throw ex;
        }
        finally {
            for (int i = 0; i < threads.length; ++i) {
                if (threads[i] == null) continue;
                Deprecated.invokeThreadStop(threads[i]);
            }
        }
        return this.allPassed;
    }

    private synchronized void threadExiting(Thread t) {
        this.activeThreads.remove(t);
        this.notifyAll();
    }

    private synchronized TestDescription nextTest() {
        if (this.stopping) {
            return null;
        }
        if (this.testIter.hasNext()) {
            return (TestDescription)this.testIter.next();
        }
        this.stopping = true;
        return null;
    }

    /*
     * Exception decompiling
     */
    private boolean runTest(TestDescription td) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private TestResult createErrorResult(TestDescription td, String reason, Throwable t) {
        TestResult tr;
        Status s = Status.error(reason);
        if (t == null) {
            tr = new TestResult(td, s);
        } else {
            tr = new TestResult(td);
            TestResult.Section trs = tr.createSection(i18n.getString("dtr.details"));
            PrintWriter pw = trs.createOutput(i18n.getString("dtr.stackTrace"));
            t.printStackTrace(pw);
            pw.close();
            tr.setStatus(s);
        }
        WorkDirectory workDir = this.getWorkDirectory();
        BackupPolicy backupPolicy = this.getBackupPolicy();
        try {
            tr.writeResults(workDir, backupPolicy);
        }
        catch (Exception e) {
            workDir.log(i18n, "dtr.unexpectedThrowable", new Object[]{td.getRootRelativeURL(), e, EXCEPTION});
        }
        return tr;
    }

    private Integer classifyThrowable(Throwable t) {
        if (t instanceof Exception) {
            return EXCEPTION;
        }
        if (t instanceof Error) {
            return ERROR;
        }
        return THROWABLE;
    }
}

