/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.model;

import com.sun.tdk.signaturetest.model.Modifier;
import java.io.Serializable;

public final class MemberType
implements Comparable<MemberType>,
Serializable {
    private static final Modifier[] classModifiers = new Modifier[]{Modifier.PUBLIC, Modifier.PROTECTED, Modifier.PRIVATE, Modifier.ABSTRACT, Modifier.FINAL, Modifier.INTERFACE, Modifier.STATIC, Modifier.ANNOTATION, Modifier.ENUM, Modifier.ACC_STRICT, Modifier.ACC_SUPER, Modifier.ACC_SYNTHETIC, Modifier.ACC_MODULE};
    private static final Modifier[] constructorModifiers = new Modifier[]{Modifier.PUBLIC, Modifier.PROTECTED, Modifier.PRIVATE, Modifier.VARARGS, Modifier.ACC_SYNTHETIC, Modifier.ACC_STRICT, Modifier.MANDATED};
    private static final Modifier[] methodModifiers = new Modifier[]{Modifier.PUBLIC, Modifier.PROTECTED, Modifier.PRIVATE, Modifier.ABSTRACT, Modifier.NATIVE, Modifier.VARARGS, Modifier.BRIDGE, Modifier.FINAL, Modifier.HASDEFAULT, Modifier.STATIC, Modifier.SYNCHRONIZED, Modifier.ACC_SYNTHETIC, Modifier.ACC_STRICT, Modifier.MANDATED};
    private static final Modifier[] fieldModifiers = new Modifier[]{Modifier.PUBLIC, Modifier.PROTECTED, Modifier.PRIVATE, Modifier.FINAL, Modifier.STATIC, Modifier.TRANSIENT, Modifier.VOLATILE, Modifier.FIELD_ENUM, Modifier.ACC_SYNTHETIC, Modifier.MANDATED};
    private static final Modifier[] noneModifiers = new Modifier[0];
    public static final MemberType CLASS = new MemberType("CLSS", classModifiers);
    public static final MemberType INNER = new MemberType("innr", classModifiers);
    public static final MemberType SUPERCLASS = new MemberType("supr", noneModifiers);
    public static final MemberType SUPERINTERFACE = new MemberType("intf", noneModifiers);
    public static final MemberType CONSTRUCTOR = new MemberType("cons", constructorModifiers);
    public static final MemberType METHOD = new MemberType("meth", methodModifiers);
    public static final MemberType FIELD = new MemberType("fld", fieldModifiers);
    public static final MemberType MODULE = new MemberType("<module", noneModifiers);
    private final String name;
    private final Modifier[] applicableModifiers;
    private int modifiersMask;
    private int trackedModifiersMask;
    public static final MemberType[] knownTypes = new MemberType[]{CLASS, SUPERCLASS, SUPERINTERFACE, CONSTRUCTOR, METHOD, FIELD, INNER, MODULE};

    public String toString() {
        return this.name;
    }

    public static MemberType getItemType(String def) {
        for (MemberType knownType : knownTypes) {
            if (!def.startsWith(knownType.name)) continue;
            return knownType;
        }
        return null;
    }

    Modifier[] getApplicableModifiers() {
        return this.applicableModifiers;
    }

    public int getModifiersMask() {
        return this.modifiersMask;
    }

    public void setModifiersMask(int m) {
        this.modifiersMask = m;
    }

    boolean isCompatible(int m1, int m2) {
        return (m1 & this.trackedModifiersMask) == (m2 & this.trackedModifiersMask);
    }

    private MemberType(String memberType, Modifier[] applicableModifiers) {
        this.name = memberType;
        this.applicableModifiers = applicableModifiers;
        this.modifiersMask = 0;
        for (Modifier m : applicableModifiers) {
            this.modifiersMask = Modifier.addModifier(this.modifiersMask, m);
        }
        this.updateTrackedModifiersMask();
    }

    private void updateTrackedModifiersMask() {
        this.trackedModifiersMask = 0;
        for (Modifier m : this.applicableModifiers) {
            if (!m.isTracked()) continue;
            this.trackedModifiersMask = Modifier.addModifier(this.trackedModifiersMask, m);
        }
    }

    public static void setMode(boolean binary) {
        Modifier.VARARGS.setTracked(!binary);
        for (MemberType knownType : knownTypes) {
            knownType.updateTrackedModifiersMask();
        }
    }

    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + (this.name != null ? this.name.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MemberType other = (MemberType)obj;
        return true;
    }

    @Override
    public int compareTo(MemberType other) {
        return this.name.compareTo(other.name);
    }
}

