/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http.internal.websocket;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import jdk.incubator.http.WebSocket;
import jdk.incubator.http.internal.common.Log;
import jdk.incubator.http.internal.common.Utils;
import jdk.incubator.http.internal.websocket.FailWebSocketException;
import jdk.incubator.http.internal.websocket.Frame;
import jdk.incubator.http.internal.websocket.MessageStreamConsumer;
import jdk.incubator.http.internal.websocket.StatusCodes;
import jdk.incubator.http.internal.websocket.UTF8AccumulatingDecoder;

class FrameConsumer
implements Frame.Consumer {
    private final MessageStreamConsumer output;
    private final UTF8AccumulatingDecoder decoder = new UTF8AccumulatingDecoder();
    private boolean fin;
    private Frame.Opcode opcode;
    private Frame.Opcode originatingOpcode;
    private WebSocket.MessagePart part = WebSocket.MessagePart.WHOLE;
    private long payloadLen;
    private long unconsumedPayloadLen;
    private ByteBuffer binaryData;

    FrameConsumer(MessageStreamConsumer messageStreamConsumer) {
        this.output = Objects.requireNonNull(messageStreamConsumer);
    }

    MessageStreamConsumer getOutput() {
        return this.output;
    }

    @Override
    public void fin(boolean bl) {
        Log.logTrace("Reading fin: {0}", bl);
        this.fin = bl;
    }

    @Override
    public void rsv1(boolean bl) {
        Log.logTrace("Reading rsv1: {0}", bl);
        if (bl) {
            throw new FailWebSocketException("Unexpected rsv1 bit");
        }
    }

    @Override
    public void rsv2(boolean bl) {
        Log.logTrace("Reading rsv2: {0}", bl);
        if (bl) {
            throw new FailWebSocketException("Unexpected rsv2 bit");
        }
    }

    @Override
    public void rsv3(boolean bl) {
        Log.logTrace("Reading rsv3: {0}", bl);
        if (bl) {
            throw new FailWebSocketException("Unexpected rsv3 bit");
        }
    }

    @Override
    public void opcode(Frame.Opcode opcode) {
        Log.logTrace("Reading opcode: {0}", new Object[]{opcode});
        if (opcode == Frame.Opcode.PING || opcode == Frame.Opcode.PONG || opcode == Frame.Opcode.CLOSE) {
            if (!this.fin) {
                throw new FailWebSocketException("Fragmented control frame  " + (Object)((Object)opcode));
            }
            this.opcode = opcode;
        } else if (opcode == Frame.Opcode.TEXT || opcode == Frame.Opcode.BINARY) {
            if (this.originatingOpcode != null) {
                throw new FailWebSocketException(String.format("Unexpected frame %s (fin=%s)", new Object[]{opcode, this.fin}));
            }
            this.opcode = opcode;
            if (!this.fin) {
                this.originatingOpcode = opcode;
            }
        } else if (opcode == Frame.Opcode.CONTINUATION) {
            if (this.originatingOpcode == null) {
                throw new FailWebSocketException(String.format("Unexpected frame %s (fin=%s)", new Object[]{opcode, this.fin}));
            }
            this.opcode = opcode;
        } else {
            throw new FailWebSocketException("Unknown opcode " + (Object)((Object)opcode));
        }
    }

    @Override
    public void mask(boolean bl) {
        Log.logTrace("Reading mask: {0}", bl);
        if (bl) {
            throw new FailWebSocketException("Masked frame received");
        }
    }

    @Override
    public void payloadLen(long l) {
        Log.logTrace("Reading payloadLen: {0}", l);
        if (this.opcode.isControl()) {
            if (l > 125L) {
                throw new FailWebSocketException(String.format("%s's payload length %s", new Object[]{this.opcode, l}));
            }
            assert (Frame.Opcode.CLOSE.isControl());
            if (this.opcode == Frame.Opcode.CLOSE && l == 1L) {
                throw new FailWebSocketException("Incomplete status code");
            }
        }
        this.payloadLen = l;
        this.unconsumedPayloadLen = l;
    }

    @Override
    public void maskingKey(int n) {
        throw new InternalError();
    }

    @Override
    public void payloadData(ByteBuffer byteBuffer) {
        boolean bl;
        Log.logTrace("Reading payloadData: data={0}", byteBuffer);
        this.unconsumedPayloadLen -= (long)byteBuffer.remaining();
        boolean bl2 = bl = this.unconsumedPayloadLen == 0L;
        if (this.opcode.isControl()) {
            if (this.binaryData != null) {
                this.binaryData.put(byteBuffer);
            } else if (!bl) {
                int n = byteBuffer.remaining();
                assert (n < 125) : Utils.dump(n);
                this.binaryData = ByteBuffer.allocate(125).put(byteBuffer);
            } else {
                this.binaryData = ByteBuffer.allocate(byteBuffer.remaining()).put(byteBuffer);
            }
        } else {
            boolean bl3;
            this.part = this.determinePart(bl);
            boolean bl4 = bl3 = this.opcode == Frame.Opcode.TEXT || this.originatingOpcode == Frame.Opcode.TEXT;
            if (!bl3) {
                this.output.onBinary(this.part, byteBuffer.slice());
                byteBuffer.position(byteBuffer.limit());
            } else {
                CharBuffer charBuffer;
                boolean bl5 = byteBuffer.hasRemaining();
                try {
                    charBuffer = this.decoder.decode(byteBuffer, this.part == WebSocket.MessagePart.WHOLE || this.part == WebSocket.MessagePart.LAST);
                }
                catch (CharacterCodingException characterCodingException) {
                    throw new FailWebSocketException("Invalid UTF-8 in frame " + (Object)((Object)this.opcode), 1007).initCause(characterCodingException);
                }
                if (!bl5 || charBuffer.hasRemaining()) {
                    this.output.onText(this.part, charBuffer);
                }
            }
        }
    }

    @Override
    public void endFrame() {
        if (this.opcode.isControl()) {
            this.binaryData.flip();
        }
        switch (this.opcode) {
            case CLOSE: {
                char c = '\u03ed';
                String string = "";
                if (this.payloadLen != 0L) {
                    int n = this.binaryData.remaining();
                    assert (2 <= n && n <= 125) : Utils.dump(n, this.payloadLen);
                    c = this.binaryData.getChar();
                    if (!StatusCodes.isLegalToReceiveFromServer(c)) {
                        throw new FailWebSocketException("Illegal status code: " + c);
                    }
                    try {
                        string = StandardCharsets.UTF_8.newDecoder().decode(this.binaryData).toString();
                    }
                    catch (CharacterCodingException characterCodingException) {
                        throw new FailWebSocketException("Illegal close reason").initCause(characterCodingException);
                    }
                }
                this.output.onClose(c, string);
                break;
            }
            case PING: {
                this.output.onPing(this.binaryData);
                this.binaryData = null;
                break;
            }
            case PONG: {
                this.output.onPong(this.binaryData);
                this.binaryData = null;
                break;
            }
            default: {
                assert (this.opcode == Frame.Opcode.TEXT || this.opcode == Frame.Opcode.BINARY || this.opcode == Frame.Opcode.CONTINUATION) : Utils.dump(new Object[]{this.opcode});
                if (!this.fin) break;
                this.originatingOpcode = null;
            }
        }
        this.payloadLen = 0L;
        this.opcode = null;
    }

    private WebSocket.MessagePart determinePart(boolean bl) {
        boolean bl2 = this.fin && bl;
        switch (this.part) {
            case LAST: 
            case WHOLE: {
                return bl2 ? WebSocket.MessagePart.WHOLE : WebSocket.MessagePart.FIRST;
            }
            case FIRST: 
            case PART: {
                return bl2 ? WebSocket.MessagePart.LAST : WebSocket.MessagePart.PART;
            }
        }
        throw new InternalError(String.valueOf((Object)this.part));
    }
}

