/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.bb.localaccess.mdbtaccesstest;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.bb.localaccess.mdbtaccesstest.ALocal;
import com.sun.ts.tests.ejb.ee.bb.localaccess.mdbtaccesstest.ALocalHome;
import com.sun.ts.tests.ejb.ee.bb.localaccess.mdbtaccesstest.BLocal;
import com.sun.ts.tests.ejb.ee.bb.localaccess.mdbtaccesstest.BLocalHome;
import com.sun.ts.tests.ejb.ee.bb.localaccess.mdbtaccesstest.CLocal;
import com.sun.ts.tests.ejb.ee.bb.localaccess.mdbtaccesstest.CLocalHome;
import com.sun.ts.tests.ejb.ee.bb.localaccess.mdbtaccesstest.DLocal;
import com.sun.ts.tests.ejb.ee.bb.localaccess.mdbtaccesstest.DLocalHome;
import com.sun.ts.tests.jms.commonee.ParentMsgBean;
import jakarta.ejb.MessageDrivenContext;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.TextMessage;
import java.util.Properties;

public class TestBeanMDBT
extends ParentMsgBean {
    private QueueSender qSender = null;
    private MessageDrivenContext mdc = null;
    private Properties harnessProps = null;
    private static final String ALocal = "java:comp/env/ejb/AEJBLocal";
    private static final String BLocal = "java:comp/env/ejb/BEJBLocal";
    private static final String CLocal = "java:comp/env/ejb/CEJBLocal";
    private static final String DLocal = "java:comp/env/ejb/DEJBLocal";
    private ALocal aLocalRef = null;
    private ALocalHome aLocalHome = null;
    private BLocal bLocalRef = null;
    private BLocalHome bLocalHome = null;
    private CLocal cLocalRef = null;
    private CLocalHome cLocalHome = null;
    private DLocal dLocalRef = null;
    private DLocalHome dLocalHome = null;

    private ALocal createA(int id, String name, int value) throws Exception {
        TestUtil.logTrace((String)"createA");
        this.aLocalHome = (ALocalHome)this.context.lookup(ALocal);
        this.aLocalRef = this.aLocalHome.createA(id, name, value);
        return this.aLocalRef;
    }

    private BLocal createB() throws Exception {
        TestUtil.logTrace((String)"createB");
        this.bLocalHome = (BLocalHome)this.context.lookup(BLocal);
        this.bLocalRef = this.bLocalHome.createB();
        return this.bLocalRef;
    }

    private CLocal createC(Properties p, int id, String name, int value) throws Exception {
        TestUtil.logTrace((String)"createC");
        this.cLocalHome = (CLocalHome)this.context.lookup(CLocal);
        this.cLocalRef = this.cLocalHome.createC(p, id, name, value);
        return this.cLocalRef;
    }

    private DLocal createD() throws Exception {
        TestUtil.logTrace((String)"createD");
        this.dLocalHome = (DLocalHome)this.context.lookup(DLocal);
        this.dLocalRef = this.dLocalHome.create();
        return this.dLocalRef;
    }

    @Override
    protected void runTests(Message msg, QueueSession qSession, String testName, Properties p) {
        boolean result = false;
        try {
            if (msg.getIntProperty("TestCaseNum") > 0) {
                switch (msg.getIntProperty("TestCaseNum")) {
                    case 1: {
                        result = this.test1();
                        break;
                    }
                    case 2: {
                        result = this.test2();
                        break;
                    }
                    case 3: {
                        result = this.test3();
                        break;
                    }
                    case 4: {
                        result = this.test4();
                        break;
                    }
                    default: {
                        TestUtil.logTrace((String)"Error in mdb - ");
                        TestUtil.logTrace((String)("No test match for TestCaseNum: " + msg.getIntProperty("TestCaseNum")));
                    }
                }
            }
            TestUtil.logTrace((String)"from TestBeanMDBT - sending response");
            String testcase = msg.getStringProperty("COM_SUN_JMS_TESTNAME");
            if (testName.equals("remove_stateful_bean")) {
                TestUtil.logTrace((String)"Removing stateful session bean");
                this.cleanUpStatefulBean();
                return;
            }
            TestUtil.logTrace((String)("for testcase: " + testcase));
            TestUtil.logTrace((String)("Result sent to replyQ is " + result));
            this.sendResponseToQ(testcase, qSession, result);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void sendResponseToQ(String testcase, QueueSession qSession, boolean result) {
        TextMessage msg = null;
        try {
            this.qSender = qSession.createSender(this.queueR);
            msg = qSession.createTextMessage();
            msg.setStringProperty("TestCase", testcase);
            msg.setText(testcase);
            if (result) {
                msg.setStringProperty("Status", "Pass");
            } else {
                msg.setStringProperty("Status", "Fail");
            }
            this.qSender.send((Message)msg);
        }
        catch (JMSException je) {
            TestUtil.printStackTrace((Throwable)je);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    public boolean test1() {
        TestUtil.logTrace((String)"test1");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Lookup local home of Entity Bean (CMP) and do create");
            this.aLocalRef = this.createA(1, "a1", 1);
            String s = this.aLocalRef.whoAmI();
            TestUtil.logMsg((String)("Calling local business method: " + s));
            if (!s.equals("entity-cmp")) {
                TestUtil.logErr((String)("Wrong string returned: got: " + s + ", expected: entity-cmp"));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        finally {
            try {
                this.aLocalRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        return pass;
    }

    public boolean test2() {
        TestUtil.logTrace((String)"test2");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Lookup local home of Session Bean (SF) and do create");
            this.bLocalRef = this.createB();
            String s = this.bLocalRef.whoAmI();
            TestUtil.logMsg((String)("Calling local business method: " + s));
            if (!s.equals("session-stateful")) {
                TestUtil.logErr((String)("Wrong string returned: got: " + s + ", expected: session-stateful"));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        return pass;
    }

    public boolean test3() {
        TestUtil.logTrace((String)"test3");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Lookup local home of Entity Bean (BMP) and do create");
            this.cLocalRef = this.createC(this.p, 1, "c1", 1);
            String s = this.cLocalRef.whoAmI();
            TestUtil.logMsg((String)("Calling local business method: " + s));
            if (!s.equals("entity-bmp")) {
                TestUtil.logErr((String)("Wrong string returned: got: " + s + ", expected: entity-bmp"));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        finally {
            try {
                this.cLocalRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        return pass;
    }

    public boolean test4() {
        TestUtil.logTrace((String)"test4");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Lookup local home of Session Bean (SL) and do create");
            this.dLocalRef = this.createD();
            String s = this.dLocalRef.whoAmI();
            TestUtil.logMsg((String)("Calling local business method: " + s));
            if (!s.equals("session-stateless")) {
                TestUtil.logErr((String)("Wrong string returned: got: " + s + ", expected: session-stateless"));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        finally {
            try {
                this.dLocalRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        return pass;
    }

    public void cleanUpStatefulBean() {
        TestUtil.logTrace((String)"cleanUpStatefulBean");
        try {
            if (this.bLocalRef != null) {
                this.bLocalRef.remove();
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception caught trying to remove bLocalRef");
        }
    }
}

