/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.pm.selfXself;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.pm.selfXself.Department;
import com.sun.ts.tests.ejb.ee.pm.selfXself.DepartmentLocal;
import com.sun.ts.tests.ejb.ee.pm.selfXself.DepartmentLocalHome;
import com.sun.ts.tests.ejb.ee.pm.selfXself.Employee;
import com.sun.ts.tests.ejb.ee.pm.selfXself.EmployeeLocal;
import com.sun.ts.tests.ejb.ee.pm.selfXself.EmployeeLocalHome;
import jakarta.ejb.CreateException;
import jakarta.ejb.EJBException;
import jakarta.ejb.EntityBean;
import jakarta.ejb.EntityContext;
import jakarta.ejb.RemoveException;
import java.util.Date;
import java.util.Properties;

public abstract class EmployeeEJB
implements EntityBean {
    private static final String DepartmentLocal = "java:comp/env/ejb/DepartmentLocal";
    private static final String EmployeeLocal = "java:comp/env/ejb/EmployeeLocal";
    private EntityContext ectx = null;
    private TSNamingContext nctx = null;

    public abstract Integer getId();

    public abstract void setId(Integer var1);

    public abstract String getFirstName();

    public abstract void setFirstName(String var1);

    public abstract String getLastName();

    public abstract void setLastName(String var1);

    public abstract Date getHireDate();

    public abstract void setHireDate(Date var1);

    public abstract float getSalary();

    public abstract void setSalary(float var1);

    public abstract DepartmentLocal getDepartment();

    public abstract void setDepartment(DepartmentLocal var1);

    public abstract EmployeeLocal getManager();

    public abstract void setManager(EmployeeLocal var1);

    public Integer ejbCreate(Integer id, String firstName, String lastName, Date hireDate, float salary) throws CreateException {
        TestUtil.logTrace((String)"ejbCreate");
        try {
            this.setId(id);
            this.setFirstName(firstName);
            this.setLastName(lastName);
            this.setHireDate(hireDate);
            this.setSalary(salary);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException("Exception occurred: " + e);
        }
        return null;
    }

    public void ejbPostCreate(Integer id, String firstName, String lastName, Date hireDate, float salary) throws CreateException {
        TestUtil.logTrace((String)"ejbPostCreate");
    }

    public void setEntityContext(EntityContext c) {
        TestUtil.logTrace((String)"setEntityContext");
        this.ectx = c;
    }

    public void unsetEntityContext() {
        TestUtil.logTrace((String)"unsetEntityContext");
    }

    public void ejbRemove() throws RemoveException {
        TestUtil.logTrace((String)"ejbRemove");
    }

    public void ejbActivate() {
        TestUtil.logTrace((String)"ejbActivate");
    }

    public void ejbPassivate() {
        TestUtil.logTrace((String)"ejbPassivate");
    }

    public void ejbStore() {
        TestUtil.logTrace((String)"ejbStore");
    }

    public void ejbLoad() {
        TestUtil.logTrace((String)"ejbLoad");
    }

    public void addDepartment(Department d) {
        TestUtil.logTrace((String)"addDepartment");
        try {
            TSNamingContext nctx = new TSNamingContext();
            Integer deptPK = (Integer)d.getPrimaryKey();
            DepartmentLocalHome deptLocalHome = (DepartmentLocalHome)nctx.lookup(DepartmentLocal);
            DepartmentLocal deptLocal = deptLocalHome.findByPrimaryKey(deptPK);
            this.setDepartment(deptLocal);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("addDepartment:" + e);
        }
    }

    public void addManager(Employee e) {
        TestUtil.logTrace((String)"addManager");
        try {
            Integer employeePK = (Integer)e.getPrimaryKey();
            EmployeeLocalHome empLocalHome = (EmployeeLocalHome)this.ectx.getEJBLocalHome();
            EmployeeLocal empLocal = empLocalHome.findByPrimaryKey(employeePK);
            this.setManager(empLocal);
        }
        catch (Exception ex) {
            TestUtil.printStackTrace((Throwable)ex);
            throw new EJBException("addManager:" + ex);
        }
    }

    public void initLogging(Properties p) {
        TestUtil.logTrace((String)"initLogging");
        try {
            TestUtil.init((Properties)p);
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    private boolean nullTest() {
        EmployeeLocal eOne = null;
        EmployeeLocal m1 = null;
        try {
            TestUtil.logTrace((String)"nullTest");
            EmployeeLocalHome empLocalHome = (EmployeeLocalHome)this.ectx.getEJBLocalHome();
            eOne = empLocalHome.findByPrimaryKey(new Integer(8));
            m1 = eOne.getManager();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            TestUtil.logErr((String)"Exception occurred in nullTest: ", (Throwable)e);
        }
        return m1 == null;
    }

    public boolean test3() {
        TestUtil.logTrace((String)"test3");
        return this.nullTest();
    }

    public boolean test4() {
        try {
            TestUtil.logTrace((String)"test4");
            EmployeeLocalHome empLocalHome = (EmployeeLocalHome)this.ectx.getEJBLocalHome();
            EmployeeLocal eOne = empLocalHome.findByPrimaryKey(new Integer(1));
            EmployeeLocal eTwo = empLocalHome.findByPrimaryKey(new Integer(2));
            EmployeeLocal mOne = empLocalHome.findByPrimaryKey(new Integer(3));
            EmployeeLocal mTwo = empLocalHome.findByPrimaryKey(new Integer(4));
            mOne = eOne.getManager();
            mTwo = eTwo.getManager();
            TestUtil.logTrace((String)"set eOne manager to mTwo manager");
            eOne.setManager(mTwo);
            EmployeeLocal m1 = eOne.getManager();
            EmployeeLocal m2 = eTwo.getManager();
            TestUtil.logTrace((String)"test4");
            if (m1.isIdentical(mTwo) && m2 == null) {
                TestUtil.logMsg((String)"Relationship assignment passed");
                return true;
            }
            TestUtil.logMsg((String)"Relationship assignment failed");
            if (!m1.isIdentical(mTwo)) {
                TestUtil.logErr((String)"m1 not identical to m2");
            }
            if (m2 != null) {
                TestUtil.logErr((String)"m2 not null");
            }
            return false;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception occurred: " + e), (Throwable)e);
            return false;
        }
    }
}

