/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.deploy.session.stateless.single;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.tests.ejb.ee.deploy.session.stateless.single.TestBean;
import com.sun.ts.tests.ejb.ee.deploy.session.stateless.single.TestBeanHome;
import java.rmi.RemoteException;
import java.util.Properties;

public class Client
extends EETest {
    private static final String lookupName = "java:comp/env/ejb/TestBean";
    private static final String beanClassName = "com.sun.ts.tests.ejb.ee.deploy.session.stateless.single.TestBean";
    private TSNamingContext nctx = null;
    private TestBeanHome home = null;
    private TestBean bean = null;
    private Properties props = null;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        try {
            this.nctx = new TSNamingContext();
            this.logMsg("Client: Looked up home!");
            this.home = (TestBeanHome)this.nctx.lookup(lookupName, TestBeanHome.class);
            this.logMsg("Client: Setup OK!");
        }
        catch (Exception e) {
            throw new EETest.Fault("Client: Setup failed:" + e, e);
        }
    }

    public void testIsSession() throws EETest.Fault {
        try {
            if (!this.home.getEJBMetaData().isSession()) {
                throw new EETest.Fault("isSession() test failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("isSession() test failed: " + e, e);
        }
    }

    public void testIsStateless() throws EETest.Fault {
        try {
            boolean pass = this.home.getEJBMetaData().isStatelessSession();
            if (!pass) {
                this.logErr("Client: isStatelessSession() reported '" + pass + "'");
                throw new EETest.Fault("isStatelessSession() test failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("isStatelessSession() test failed: " + e, e);
        }
    }

    public void testGetPrimaryKey() throws EETest.Fault {
        Object pkey = null;
        try {
            this.bean = this.home.create();
            this.bean.initLogging(this.props);
            pkey = this.bean.getPrimaryKey();
            this.bean.remove();
            throw new EETest.Fault("getPrimaryKey() test failed");
        }
        catch (RemoteException remoteException) {
        }
        catch (Exception e) {
            throw new EETest.Fault("getPrimaryKey() test failed: " + e, e);
        }
    }

    public void testIdentity() throws EETest.Fault {
        TestBean bean1 = null;
        TestBean bean2 = null;
        boolean pass = false;
        try {
            bean1 = this.home.create();
            bean1.initLogging(this.props);
            bean2 = this.home.create();
            bean2.initLogging(this.props);
            pass = bean1.isIdentical(bean1) && bean2.isIdentical(bean2) && bean1.isIdentical(bean2) && bean2.isIdentical(bean1);
            bean1.remove();
            bean2.remove();
            if (!pass) {
                throw new EETest.Fault("isIdentical() test failed.");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("isIdentical() test failed: " + e, e);
        }
    }

    public void testHomeInterface() throws EETest.Fault {
        Class runtimeHome = null;
        boolean pass = false;
        try {
            runtimeHome = this.home.getEJBMetaData().getHomeInterfaceClass();
            pass = runtimeHome.getName().equals("com.sun.ts.tests.ejb.ee.deploy.session.stateless.single.TestBeanHome");
            if (!pass) {
                throw new EETest.Fault("getHomeInterface() test failed ");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("getHomeInterface() test failed: " + e, e);
        }
    }

    public void testRemoteInterface() throws EETest.Fault {
        Class runtimeRemote = null;
        boolean pass = false;
        try {
            runtimeRemote = this.home.getEJBMetaData().getRemoteInterfaceClass();
            pass = runtimeRemote.getName().equals(beanClassName);
            if (!pass) {
                throw new EETest.Fault("getRemoteInterface() test failed ");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("getRemoteInterface() test failed: " + e, e);
        }
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("Client: cleanup()");
    }
}

