/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.tx.sessionLocal.stateful.bm.TxR_GlobalSingle;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.tx.txbeanLocal.TxBean;
import com.sun.ts.tests.ejb.ee.tx.txbeanLocal.TxBeanHome;
import jakarta.ejb.CreateException;
import jakarta.ejb.EJBException;
import jakarta.ejb.SessionBean;
import jakarta.ejb.SessionContext;
import jakarta.transaction.UserTransaction;
import java.util.Properties;
import java.util.Vector;

public class TestBeanEJB
implements SessionBean {
    private Properties testProps = null;
    private TSNamingContext jctx = null;
    private SessionContext sctx = null;
    private String tName = null;
    private Integer tSize = null;
    private Integer fromKey1 = null;
    private Integer fromKey2 = null;
    private Integer toKey2 = null;
    private static final String txBeanRequired = "java:comp/env/ejb/TxRequired";
    private TxBeanHome beanHome = null;
    private TxBean beanRef = null;

    public void ejbCreate() throws CreateException {
        TestUtil.logTrace((String)"ejbCreate");
        try {
            TestUtil.logMsg((String)"Getting Naming Context");
            this.jctx = new TSNamingContext();
            this.tSize = (Integer)this.jctx.lookup("java:comp/env/size");
            TestUtil.logTrace((String)("tSize: " + this.tSize));
            this.fromKey1 = (Integer)this.jctx.lookup("java:comp/env/fromKey1");
            TestUtil.logTrace((String)("fromKey1: " + this.fromKey1));
            this.fromKey2 = (Integer)this.jctx.lookup("java:comp/env/fromKey2");
            TestUtil.logTrace((String)("fromKey2: " + this.fromKey2));
            this.toKey2 = (Integer)this.jctx.lookup("java:comp/env/toKey2");
            TestUtil.logTrace((String)("toKey2: " + this.toKey2));
            TestUtil.logMsg((String)"Looking up the TxBean Home interface of java:comp/env/ejb/TxRequired");
            this.beanHome = (TxBeanHome)this.jctx.lookup(txBeanRequired);
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Create exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    public void setSessionContext(SessionContext sc) {
        TestUtil.logTrace((String)"setSessionContext");
        this.sctx = sc;
    }

    public void ejbRemove() {
        TestUtil.logTrace((String)"ejbRemove");
    }

    public void ejbActivate() {
        TestUtil.logTrace((String)"ejbActivate");
    }

    public void ejbPassivate() {
        TestUtil.logTrace((String)"ejbPassivate");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean test1() {
        TestUtil.logTrace((String)"test1");
        TestUtil.logTrace((String)"Insert/Delete followed by a commit to a single table");
        Vector dbResults = new Vector();
        boolean testResult = false;
        boolean b2 = false;
        boolean b1 = false;
        String tName = this.tName;
        int size = this.tSize;
        int tRng = this.fromKey1;
        UserTransaction ut = null;
        try {
            TestUtil.logTrace((String)"Creating EJB instance of java:comp/env/ejb/TxRequired");
            this.beanRef = this.beanHome.create();
            TestUtil.logTrace((String)"Logging data from server");
            this.beanRef.initLogging(this.testProps);
            TestUtil.logTrace((String)"Getting the UserTransaction interface");
            ut = this.sctx.getUserTransaction();
            TestUtil.logTrace((String)"Creating the table");
            ut.begin();
            this.beanRef.createData(tName);
            ut.commit();
            TestUtil.logTrace((String)"Insert and delete some rows");
            ut.begin();
            TestUtil.logTrace((String)"Inserting 2 new rows");
            if (this.beanRef.insert(tName, size + 1)) {
                ++size;
            }
            if (this.beanRef.insert(tName, size + 1)) {
                ++size;
            }
            TestUtil.logTrace((String)"Deleting a row");
            this.beanRef.delete(tName, tRng, tRng);
            ut.commit();
            TestUtil.logTrace((String)"Get test results");
            dbResults = this.beanRef.getResults(tName);
            TestUtil.logTrace((String)"Verifying the test results");
            if (!dbResults.contains(new Integer(tRng))) {
                b1 = true;
            }
            for (int i = 1; i <= size; ++i) {
                if (i == tRng) continue;
                if (dbResults.contains(new Integer(i))) {
                    b2 = true;
                    continue;
                }
                b2 = false;
                break;
            }
            if (b1 && b2) {
                testResult = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            try {
                this.beanRef.destroyData(tName);
                this.beanRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        return testResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean test2() {
        TestUtil.logTrace((String)"test2");
        TestUtil.logTrace((String)"Insert/Delete followed by a rollback to a single table");
        Vector dbResults = new Vector();
        boolean testResult = false;
        boolean b2 = false;
        boolean b1 = false;
        String tName = this.tName;
        int size = this.tSize;
        int sizeOrig = this.tSize;
        int tRngFrom = this.fromKey2;
        int tRngTo = this.toKey2;
        UserTransaction ut = null;
        try {
            TestUtil.logTrace((String)"Creating EJB instance of java:comp/env/ejb/TxRequired");
            this.beanRef = this.beanHome.create();
            TestUtil.logTrace((String)("beanRef=" + this.beanRef));
            TestUtil.logTrace((String)"Logging data from server");
            this.beanRef.initLogging(this.testProps);
            TestUtil.logTrace((String)"Getting the UserTransaction interface");
            ut = this.sctx.getUserTransaction();
            TestUtil.logTrace((String)"Creating the table");
            ut.begin();
            this.beanRef.createData(tName);
            ut.commit();
            TestUtil.logTrace((String)"Insert and delete some rows");
            ut.begin();
            TestUtil.logTrace((String)"Inserting 2 new rows");
            if (this.beanRef.insert(tName, size + 1)) {
                ++size;
            }
            if (this.beanRef.insert(tName, size + 1)) {
                ++size;
            }
            TestUtil.logTrace((String)"Deleting a row");
            this.beanRef.delete(tName, tRngFrom, tRngTo);
            ut.rollback();
            TestUtil.logTrace((String)"Get test results");
            dbResults = this.beanRef.getResults(tName);
            TestUtil.logTrace((String)"Verifying the test results");
            for (int i = 1; i <= sizeOrig; ++i) {
                if (!dbResults.contains(new Integer(i))) {
                    b1 = false;
                    break;
                }
                b1 = true;
            }
            for (int j = size; j > sizeOrig; --j) {
                if (dbResults.contains(new Integer(j))) {
                    b2 = false;
                    break;
                }
                b2 = true;
            }
            if (b1) {
                TestUtil.logTrace((String)"b1 true");
            }
            if (b2) {
                TestUtil.logTrace((String)"b2 true");
            }
            if (b1 && b2) {
                testResult = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            try {
                this.beanRef.destroyData(tName);
                this.beanRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        return testResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean test3() {
        TestUtil.logTrace((String)"test3");
        TestUtil.logTrace((String)"Insert/Delete followed by a commit, and checking TxStatus");
        Vector dbResults = new Vector();
        boolean testResult = false;
        boolean b3 = false;
        boolean b2 = false;
        boolean b1 = false;
        String tName = this.tName;
        int size = this.tSize;
        int tRng = this.fromKey1;
        UserTransaction ut = null;
        try {
            TestUtil.logTrace((String)"Creating EJB instance of java:comp/env/ejb/TxRequired");
            this.beanRef = this.beanHome.create();
            TestUtil.logTrace((String)("beanRef=" + this.beanRef));
            TestUtil.logTrace((String)"Logging data from server");
            this.beanRef.initLogging(this.testProps);
            TestUtil.logTrace((String)"Getting the UserTransaction interface");
            ut = this.sctx.getUserTransaction();
            int txStatus1 = ut.getStatus();
            TestUtil.logTrace((String)("Tx Status: " + txStatus1));
            TestUtil.logTrace((String)"BEGIN transaction");
            ut.begin();
            int txStatus2 = ut.getStatus();
            TestUtil.logTrace((String)("Tx Status: " + txStatus2));
            this.beanRef.createData(tName);
            TestUtil.logTrace((String)"Inserting 2 new rows");
            if (this.beanRef.insert(tName, size + 1)) {
                ++size;
            }
            if (this.beanRef.insert(tName, size + 1)) {
                ++size;
            }
            TestUtil.logTrace((String)"Deleting a row");
            this.beanRef.delete(tName, tRng, tRng);
            TestUtil.logTrace((String)"COMMIT transaction");
            ut.commit();
            int txStatus3 = ut.getStatus();
            TestUtil.logTrace((String)("Tx Status: " + txStatus3));
            TestUtil.logTrace((String)"Verifying the test results");
            if (txStatus1 == 6) {
                b1 = true;
            }
            if (txStatus2 == 0) {
                b2 = true;
            }
            if (txStatus3 == 6) {
                b3 = true;
            }
            if (b1 && b2 && b3) {
                testResult = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            try {
                this.beanRef.destroyData(tName);
                this.beanRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        return testResult;
    }

    public void initLogging(Properties p) {
        TestUtil.logTrace((String)"initLogging");
        this.testProps = p;
        this.tName = TestUtil.getTableName((String)this.testProps.getProperty("TxBean_Tab1_Delete"));
        TestUtil.logTrace((String)("tName: " + this.tName));
        try {
            TestUtil.init((Properties)p);
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }
}

