/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.basic;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.basic.Order;
import java.util.Properties;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void updateOrderTest() throws EETest.Fault {
        int i;
        boolean pass = true;
        int count = 6;
        Order order = null;
        this.getEntityTransaction().begin();
        for (i = 1; i < 6; ++i) {
            order = new Order(i, 100 * i);
            this.getEntityManager().persist((Object)order);
            TestUtil.logTrace((String)("persisted order " + order));
        }
        this.getEntityTransaction().commit();
        TestUtil.logTrace((String)"find and removing the previously persisted orders");
        this.getEntityTransaction().begin();
        for (i = 1; i < 6; ++i) {
            order = (Order)this.getEntityManager().find(Order.class, (Object)i);
            if (order != null) {
                this.getEntityManager().remove((Object)order);
                TestUtil.logTrace((String)("Found and removed order " + order));
                continue;
            }
            TestUtil.logErr((String)("persisted order[" + i + "] DOES NOT EXIST"));
            pass = false;
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            TestUtil.logTrace((String)"clearing the persistence context");
            this.clearCache();
            TestUtil.logTrace((String)"verify the previously removed orders were removed");
            for (i = 1; i < 6; ++i) {
                order = (Order)this.getEntityManager().find(Order.class, (Object)i);
                if (order == null) {
                    TestUtil.logTrace((String)("persisted order[" + i + "] was removed successfully"));
                    continue;
                }
                TestUtil.logErr((String)("order[" + i + "] was NOT removed"));
                pass = false;
            }
        }
        if (!pass) {
            throw new EETest.Fault("updateOrderTest failed");
        }
    }

    public void newEntityTest() throws EETest.Fault {
        boolean pass = false;
        TestUtil.logTrace((String)"Instantiate an order ");
        Order order = new Order(1, 101);
        TestUtil.logTrace((String)"Try to find it");
        Order order2 = (Order)this.getEntityManager().find(Order.class, (Object)1);
        if (order2 == null) {
            TestUtil.logTrace((String)"Did not find order as expected");
            pass = true;
        } else {
            TestUtil.logErr((String)("Found order when it should not exist" + order2.toString()));
        }
        if (!pass) {
            throw new EETest.Fault("newEntityTest failed");
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM PURCHASE_ORDER").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

