/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jdbc.ee.connection.connection1;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TSNamingContextInterface;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jdbc.ee.common.DataSourceConnection;
import com.sun.ts.tests.jdbc.ee.common.DriverManagerConnection;
import com.sun.ts.tests.jdbc.ee.common.JDBCTestMsg;
import com.sun.ts.tests.jdbc.ee.common.dbSchema;
import com.sun.ts.tests.jdbc.ee.common.rsSchema;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.sql.DataSource;

public class connectionClient1
extends ServiceEETest
implements Serializable {
    private static final String testName = "jdbc.ee.connection.connection1";
    private TSNamingContextInterface jc = null;
    private transient Connection conn = null;
    private ResultSet rs = null;
    private Statement stmt = null;
    private transient DatabaseMetaData dbmd = null;
    private DataSource ds1 = null;
    private dbSchema dbSch = null;
    private rsSchema rsSch = null;
    private String drManager = null;
    private Properties props = null;
    private String sVehicle = null;
    private JDBCTestMsg msg = null;

    public static void main(String[] args) {
        connectionClient1 theTests = new connectionClient1();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            try {
                this.drManager = p.getProperty("DriverManager", "");
                this.sVehicle = p.getProperty("vehicle");
                if (this.drManager.length() == 0) {
                    throw new EETest.Fault("Invalid DriverManager Name");
                }
                this.props = p;
                if (this.drManager.equals("yes")) {
                    this.logTrace("Using DriverManager");
                    DriverManagerConnection dmCon = new DriverManagerConnection();
                    this.conn = dmCon.getConnection(p);
                } else {
                    this.logTrace("Using DataSource");
                    DataSourceConnection dsCon = new DataSourceConnection();
                    this.conn = dsCon.getConnection(p);
                }
                this.stmt = this.conn.createStatement();
                this.dbSch = new dbSchema();
                this.dbSch.createData(p, this.conn);
                this.dbmd = this.conn.getMetaData();
                this.rsSch = new rsSchema();
                this.msg = new JDBCTestMsg();
            }
            catch (SQLException ex) {
                this.logErr("SQL Exception : " + ex.getMessage(), ex);
            }
        }
        catch (Exception e) {
            this.logErr("Setup Failed!");
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    public void testClose() throws EETest.Fault {
        boolean closeFlag = false;
        Connection con = null;
        try {
            if (this.drManager.equals("yes")) {
                DriverManagerConnection dmCon = new DriverManagerConnection();
                con = dmCon.getConnection(this.props);
            } else {
                DataSourceConnection dsCon = new DataSourceConnection();
                con = dsCon.getConnection(this.props);
            }
            this.msg.setMsg("Calling Close() method ");
            con.close();
            closeFlag = con.isClosed();
            if (closeFlag) {
                this.msg.setMsg("close method closes the Connection object ");
            } else {
                this.msg.printTestError("close method does not close the Connection object", "test Close method Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to Close is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to Close is Failed!");
        }
    }

    public void testCreateStatement01() throws EETest.Fault {
        Statement statemt = null;
        try {
            this.msg.setMsg("Calling createStatement() method ");
            statemt = this.conn.createStatement();
            if (statemt instanceof Statement) {
                this.msg.setMsg("createStatement method creates a Statement object");
            } else {
                this.msg.printTestError("createStatement method does not create a Statement object", "test createStatement Failed!");
            }
            statemt.close();
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to createStatement is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to createStatement is Failed!");
        }
    }

    public void testGetCatalog() throws EETest.Fault {
        Object catalogName = null;
        Object url = null;
        String retValue = null;
        String extValue = null;
        boolean flag = false;
        try {
            this.msg.setMsg("Calling getCatalog() method ");
            retValue = this.conn.getCatalog();
            this.msg.setMsg("Catalog Name   " + retValue);
            if (retValue != null) {
                ResultSet rs = this.dbmd.getCatalogs();
                while (rs.next()) {
                    extValue = rs.getString("TABLE_CAT");
                    this.msg.setMsg("Catalog Name   " + extValue);
                    if (!retValue.equals(extValue)) continue;
                    flag = true;
                    break;
                }
                if (flag) {
                    this.msg.setMsg("getCatalog returns the Catalog name" + retValue);
                } else {
                    this.msg.printTestError("getCatalog does not return the catalog name", "test getCatalog Failed!");
                }
            } else {
                this.msg.setMsg("getCatalog returns a null String Object");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getCatalog is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getCatalog is Failed!");
        }
    }

    public void testGetMetaData() throws EETest.Fault {
        DatabaseMetaData rsmd = null;
        try {
            this.msg.setMsg("Calling getMetaData() method ");
            rsmd = this.conn.getMetaData();
            if (rsmd instanceof DatabaseMetaData) {
                this.msg.setMsg("getMetaData returns the DatabaseMetaData object ");
            } else {
                this.msg.printTestError("getMetaData does not return the DatabaseMetaData object", "test getMetaData Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getMetaData is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getMetaData is Failed!");
        }
    }

    public void testGetTransactionIsolation() throws EETest.Fault {
        int transIsolateVal = 0;
        try {
            this.msg.setMsg("Calling getTransactionIsolation() method ");
            transIsolateVal = this.conn.getTransactionIsolation();
            if (transIsolateVal == 0) {
                this.msg.setMsg("getTransactionIsolation method returns Transaction Isolation mode as " + transIsolateVal);
            } else if (transIsolateVal == 2) {
                this.msg.setMsg("getTransactionIsolation method returns Transaction Isolation mode as " + transIsolateVal);
            } else if (transIsolateVal == 1) {
                this.msg.setMsg("getTransactionIsolation method returns Transaction Isolation mode as " + transIsolateVal);
            } else if (transIsolateVal == 4) {
                this.msg.setMsg("getTransactionIsolation method returns Transaction Isolation mode as " + transIsolateVal);
            } else if (transIsolateVal == 8) {
                this.msg.setMsg("getTransactionIsolation method returns Transaction Isolation mode as " + transIsolateVal);
            } else {
                this.msg.printTestError("getTransactionIsolation method returns an invalid value", "test getTransactionIsolation is Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getTransactionIsolation is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getTransactionIsolation is Failed!");
        }
    }

    public void testIsClosed01() throws EETest.Fault {
        boolean closeFlag = false;
        Connection con = null;
        try {
            if (this.drManager.equals("yes")) {
                DriverManagerConnection dmCon = new DriverManagerConnection();
                con = dmCon.getConnection(this.props);
            } else {
                DataSourceConnection dsCon = new DataSourceConnection();
                con = dsCon.getConnection(this.props);
            }
            this.msg.setMsg("Calling isClosed Method");
            closeFlag = con.isClosed();
            if (!closeFlag) {
                this.msg.setMsg("isClosed method returns  " + closeFlag);
            } else {
                this.msg.printTestError("isClosed method returns an invalid value", "test isClosed Failed!");
            }
            con.close();
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to isClosed is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to isClosed is Failed!");
        }
    }

    public void testIsClosed02() throws EETest.Fault {
        boolean closeFlag = false;
        Connection con = null;
        try {
            if (this.drManager.equals("yes")) {
                DriverManagerConnection dmCon = new DriverManagerConnection();
                con = dmCon.getConnection(this.props);
            } else {
                DataSourceConnection dsCon = new DataSourceConnection();
                con = dsCon.getConnection(this.props);
            }
            con.close();
            this.msg.setMsg("Calling isClosed() method ");
            closeFlag = con.isClosed();
            if (closeFlag) {
                this.msg.setMsg("isClosed method returns  " + closeFlag);
            } else {
                this.msg.printTestError("isClosed method returns an invalid value", "test isClosed Failed");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to isClosed is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to isClosed is Failed!");
        }
    }

    public void testIsReadOnly() throws EETest.Fault {
        boolean errorFlag = true;
        try {
            this.msg.setMsg("Testing in " + this.sVehicle + " vehicle");
            if (this.sVehicle.equalsIgnoreCase("ejb")) {
                boolean b = this.conn.isReadOnly();
                errorFlag = false;
            } else {
                this.msg.setMsg("invoking the setReadOnly method");
                this.conn.setReadOnly(false);
                this.msg.setMsg("Calling isReadOnly() method ");
                errorFlag = this.conn.isReadOnly();
            }
            if (!errorFlag) {
                this.msg.setMsg("isReadOnly method is Successful");
            } else {
                this.msg.printTestError("isReadOnly method returns an invalid value", "test isReadOnly Failed");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to isReadOnly is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to isReadOnly is Failed!");
        }
    }

    public void testNativeSQL() throws EETest.Fault {
        String sSqlStmt = null;
        String nativeSql = null;
        try {
            sSqlStmt = this.props.getProperty("Escape_Seq_Query", "");
            this.msg.setMsg("SQL Statement with Escape Syntax" + sSqlStmt);
            this.msg.setMsg("Calling nativeSQL method ");
            nativeSql = this.conn.nativeSQL(sSqlStmt);
            if (nativeSql instanceof String) {
                this.msg.setMsg("nativeSQL method returns :  " + nativeSql);
            } else {
                this.msg.printTestError("nativeSQL method does not return the System native SQL grammar", "Call to nativeSQL is Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to nativeSQL is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to nativeSQL is Failed!");
        }
    }

    public void cleanup() throws EETest.Fault {
        try {
            this.dbSch.destroyData(this.conn);
            this.stmt.close();
            this.rsSch.dbUnConnect(this.conn);
            this.logMsg("Cleanup ok;");
        }
        catch (Exception e) {
            this.logErr("An error occurred while closing the database connection", e);
        }
    }
}

