/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jdbc.ee.callStmt.callStmt5;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TSNamingContextInterface;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jdbc.ee.common.DataSourceConnection;
import com.sun.ts.tests.jdbc.ee.common.DriverManagerConnection;
import com.sun.ts.tests.jdbc.ee.common.JDBCTestMsg;
import com.sun.ts.tests.jdbc.ee.common.rsSchema;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class callStmtClient5
extends ServiceEETest
implements Serializable {
    private static final String testName = "jdbc.ee.callStmt.callStmt5";
    private TSNamingContextInterface jc = null;
    private transient Connection conn = null;
    private rsSchema rsSch = null;
    private JDBCTestMsg msg = null;
    private String drManager = null;
    private Properties sqlp = null;
    private transient DatabaseMetaData dbmd = null;
    private CallableStatement cstmt = null;
    private Properties props = null;

    public static void main(String[] args) {
        callStmtClient5 theTests = new callStmtClient5();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            try {
                this.props = p;
                this.drManager = p.getProperty("DriverManager", "");
                if (this.drManager.length() == 0) {
                    throw new EETest.Fault("Invalid DriverManager Name");
                }
                this.sqlp = p;
                if (this.drManager.equals("yes")) {
                    this.logTrace("Using DriverManager");
                    DriverManagerConnection dmCon = new DriverManagerConnection();
                    this.conn = dmCon.getConnection(p);
                } else {
                    this.logTrace("Using DataSource");
                    DataSourceConnection dsCon = new DataSourceConnection();
                    this.conn = dsCon.getConnection(p);
                }
                this.rsSch = new rsSchema();
                this.msg = new JDBCTestMsg();
            }
            catch (SQLException ex) {
                this.logErr("SQL Exception : " + ex.getMessage(), ex);
            }
        }
        catch (Exception e) {
            this.logErr("Setup Failed!");
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetObject41() throws EETest.Fault {
        try {
            this.rsSch.createTab("Decimal_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Decimal_Proc(?,?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 3, 15);
            this.cstmt.registerOutParameter(2, 3, 15);
            this.cstmt.registerOutParameter(3, 3, 15);
            this.msg.setMsg("execute the procedure");
            this.cstmt.execute();
            this.msg.setMsg("invoke getObject method");
            BigDecimal oRetVal = (BigDecimal)this.cstmt.getObject(2);
            String sRetStr = this.rsSch.extractVal("Decimal_Tab", 2, this.sqlp, this.conn);
            BigDecimal oExtVal = new BigDecimal(sRetStr);
            this.msg.addOutputMsg(sRetStr, oRetVal.toString());
            if (oRetVal.compareTo(oExtVal) == 0) {
                this.msg.setMsg("getObject returns the Minimum value for type BigDecimal(JDBC DECIMAL) ");
            } else {
                this.msg.printTestError("getObject did not return the Minimum value for type BigDecimal(JDBC DECIMAL) ", "test getObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getObject Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Decimal_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void testGetObject42() throws EETest.Fault {
        try {
            this.rsSch.createTab("Decimal_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Decimal_Proc(?,?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 3, 15);
            this.cstmt.registerOutParameter(2, 3, 15);
            this.cstmt.registerOutParameter(3, 3, 15);
            this.msg.setMsg("execute the procedure");
            this.cstmt.execute();
            this.msg.setMsg("invoke getObject method");
            BigDecimal oRetVal = (BigDecimal)this.cstmt.getObject(3);
            this.msg.addOutputMsg("null", "" + oRetVal);
            if (oRetVal == null) {
                this.msg.setMsg("getObject returns the Null value for type BigDecimal(JDBC DECIMAL) " + oRetVal);
            } else {
                this.msg.printTestError("getObject did not return the Null value for type BigDecimal(JDBC DECIMAL)", "test getObject failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getObject Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Decimal_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetObject43() throws EETest.Fault {
        String binarySize = null;
        Statement pstmt = null;
        try {
            binarySize = this.props.getProperty("binarySize");
            this.msg.setMsg("Binary Table Size : " + binarySize);
            this.rsSch.createTab("Binary_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Binary_Tab_Val_Update", "");
            this.msg.setMsg("Prepared Statement String :" + sPrepStmt);
            int bytearrsize = Integer.parseInt(binarySize);
            byte[] bytearr = new byte[bytearrsize];
            String sbyteval = null;
            this.msg.setMsg("getting the bytearray value");
            for (int count = 0; count < bytearrsize; ++count) {
                sbyteval = Integer.toString(count % 255);
                bytearr[count] = Byte.parseByte(sbyteval);
            }
            this.msg.setMsg("get the PreparedStatement object");
            pstmt = this.conn.prepareStatement(sPrepStmt);
            pstmt.setBytes(1, bytearr);
            pstmt.executeUpdate();
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Binary_Proc(?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, -2);
            this.msg.setMsg("execute the procedure");
            this.cstmt.execute();
            this.msg.setMsg("invoke getObject method");
            byte[] oRetVal = (byte[])this.cstmt.getObject(1);
            for (int i = 0; i < bytearrsize; ++i) {
                this.msg.addOutputMsg(Byte.toString(bytearr[i]), Byte.toString(oRetVal[i]));
                if (oRetVal[i] == bytearr[i]) continue;
                this.msg.printTestError("getObject did not return the proper byte array values", "test getObject Failed!");
            }
            this.msg.setMsg("getObject returns the proper byte array values");
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getObject Failed!");
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Binary_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void testGetObject44() throws EETest.Fault {
        String binarySize = null;
        try {
            binarySize = this.props.getProperty("binarySize");
            this.msg.setMsg("Binary Table Size : " + binarySize);
            this.rsSch.createTab("Binary_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Binary_Proc(?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, -2);
            this.msg.setMsg("execute the procedure");
            this.cstmt.execute();
            this.msg.setMsg("invoke getObject method");
            byte[] oRetVal = (byte[])this.cstmt.getObject(1);
            this.msg.addOutputMsg("null", "" + oRetVal);
            if (oRetVal == null) {
                this.msg.setMsg("getObject returns the null value for type byte[]");
            } else {
                this.msg.printTestError("getObject did not return the null value for type byte[]", "test getObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getObject Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Binary_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetObject45() throws EETest.Fault {
        String varbinarySize = null;
        Statement pstmt = null;
        try {
            varbinarySize = this.props.getProperty("varbinarySize");
            this.msg.setMsg("varbinary Table Size : " + varbinarySize);
            this.rsSch.createTab("Varbinary_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Varbinary_Tab_Val_Update", "");
            this.msg.setMsg("Prepared Statement String :" + sPrepStmt);
            int bytearrsize = Integer.parseInt(varbinarySize);
            this.msg.setMsg("varbinary Size : " + bytearrsize);
            byte[] bytearr = new byte[bytearrsize];
            String sbyteval = null;
            this.msg.setMsg("to get the bytearray value");
            for (int count = 0; count < bytearrsize; ++count) {
                sbyteval = Integer.toString(count % 255);
                bytearr[count] = Byte.parseByte(sbyteval);
            }
            this.msg.setMsg("get the PreparedStatement object");
            pstmt = this.conn.prepareStatement(sPrepStmt);
            pstmt.setBytes(1, bytearr);
            pstmt.executeUpdate();
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Varbinary_Proc(?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, -3);
            this.msg.setMsg("execute the procedure");
            this.cstmt.execute();
            this.msg.setMsg("invoke getObject method");
            byte[] oRetVal = (byte[])this.cstmt.getObject(1);
            for (int i = 0; i < bytearrsize; ++i) {
                this.msg.addOutputMsg(Byte.toString(bytearr[i]), Byte.toString(oRetVal[i]));
                if (oRetVal[i] == bytearr[i]) continue;
                this.msg.printTestError("getObject did not return the proper byte array values", "test getObject Failed!");
            }
            this.msg.setMsg("getObject returns the proper byte array values");
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getObject Failed!");
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Varbinary_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void testGetObject46() throws EETest.Fault {
        String varbinarySize = null;
        try {
            varbinarySize = this.props.getProperty("varbinarySize");
            this.msg.setMsg("varbinary Table Size : " + varbinarySize);
            this.rsSch.createTab("Varbinary_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Varbinary_Proc(?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, -3);
            this.msg.setMsg("execute the procedure");
            this.cstmt.execute();
            this.msg.setMsg("invoke getObject method");
            byte[] oRetVal = (byte[])this.cstmt.getObject(1);
            this.msg.addOutputMsg("null", "" + oRetVal);
            if (oRetVal == null) {
                this.msg.setMsg("getObject returns the null value for type byte[]");
            } else {
                this.msg.printTestError("getObject did not return the null value for type byte[]", "test getObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getObject Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Varbinary_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetObject47() throws EETest.Fault {
        String longvarbinarySize = null;
        Statement pstmt = null;
        try {
            this.rsSch.createTab("Longvarbinary_Tab", this.sqlp, this.conn);
            longvarbinarySize = this.props.getProperty("longvarbinarySize");
            this.msg.setMsg("longvarbinary Table Size : " + longvarbinarySize);
            String sPrepStmt = this.sqlp.getProperty("Longvarbinary_Tab_Val_Update", "");
            this.msg.setMsg("Prepared Statement String :" + sPrepStmt);
            int bytearrsize = Integer.parseInt(longvarbinarySize);
            this.msg.setMsg("longvarbinary Size : " + bytearrsize);
            byte[] bytearr = new byte[bytearrsize];
            String sbyteval = null;
            this.msg.setMsg("getting the bytearray value");
            for (int count = 0; count < bytearrsize; ++count) {
                sbyteval = Integer.toString(count % 255);
                bytearr[count] = Byte.parseByte(sbyteval);
            }
            this.msg.setMsg("get the PreparedStatement object");
            pstmt = this.conn.prepareStatement(sPrepStmt);
            pstmt.setBytes(1, bytearr);
            pstmt.executeUpdate();
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Longvarbinary_Proc(?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, -4);
            this.msg.setMsg("execute the procedure");
            this.cstmt.execute();
            this.msg.setMsg("invoke getObject method");
            byte[] oRetVal = (byte[])this.cstmt.getObject(1);
            for (int i = 0; i < bytearrsize; ++i) {
                this.msg.addOutputMsg(Byte.toString(bytearr[i]), Byte.toString(oRetVal[i]));
                if (oRetVal[i] == bytearr[i]) continue;
                this.msg.printTestError("getObject did not return the proper byte array values", "test getObject Failed!");
            }
            this.msg.setMsg("getObject returns the proper byte array values");
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getObject Failed!");
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Longvarbinary_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void testGetObject48() throws EETest.Fault {
        try {
            this.rsSch.createTab("Longvarbinary_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Longvarbinary_Proc(?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, -4);
            this.msg.setMsg("execute the procedure");
            this.cstmt.execute();
            this.msg.setMsg("invoke getObject method");
            byte[] oRetVal = (byte[])this.cstmt.getObject(1);
            this.msg.addOutputMsg("null", "" + oRetVal);
            if (oRetVal == null) {
                this.msg.setMsg("getObject returns the null value for type byte[]");
            } else {
                this.msg.printTestError("getObject did not return the null value for type byte[]", "test getObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getObject Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Longvarbinary_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetFloat01() throws EETest.Fault {
        try {
            this.rsSch.createTab("Real_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Real_Proc(?,?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 7);
            this.cstmt.registerOutParameter(2, 7);
            this.cstmt.registerOutParameter(3, 7);
            this.msg.setMsg("execute the procedure");
            this.cstmt.execute();
            this.msg.setMsg("invoke getFloat method");
            float fRetVal = this.cstmt.getFloat(1);
            String sRetStr = this.rsSch.extractVal("Real_Tab", 1, this.sqlp, this.conn);
            float fExtVal = Float.parseFloat(sRetStr);
            this.msg.addOutputMsg(sRetStr, new Float(fExtVal).toString());
            if (fRetVal == fExtVal) {
                this.msg.setMsg("getFloat returns the Maximum Value " + fRetVal);
            } else {
                this.msg.printTestError("getFloat did not return the Maximum Value", "test getFloat Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getFloat is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getFloat Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Real_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetFloat02() throws EETest.Fault {
        try {
            this.rsSch.createTab("Real_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Real_Proc(?,?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 7);
            this.cstmt.registerOutParameter(2, 7);
            this.cstmt.registerOutParameter(3, 7);
            this.msg.setMsg("execute the procedure");
            this.cstmt.execute();
            this.msg.setMsg("invoke getFloat method ");
            float fRetVal = this.cstmt.getFloat(2);
            String sRetStr = this.rsSch.extractVal("Real_Tab", 2, this.sqlp, this.conn);
            float fExtVal = Float.parseFloat(sRetStr);
            this.msg.addOutputMsg(sRetStr, new Float(fExtVal).toString());
            if (fRetVal == fExtVal) {
                this.msg.setMsg("getFloat returns the Minimum Value " + fRetVal);
            } else {
                this.msg.printTestError("getFloat did not return the Minimum Value ", "test getFloat Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getFloat is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getFloat Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Real_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void testGetFloat03() throws EETest.Fault {
        try {
            this.rsSch.createTab("Real_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Real_Proc(?,?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 7);
            this.cstmt.registerOutParameter(2, 7);
            this.cstmt.registerOutParameter(3, 7);
            this.msg.setMsg("execute the procedure");
            this.cstmt.execute();
            this.msg.setMsg("invoke getFloat method");
            float fRetVal = this.cstmt.getFloat(3);
            this.msg.addOutputMsg("null", new Float(fRetVal).toString());
            if (this.cstmt.wasNull()) {
                this.msg.setMsg("getFloat returns the Null Value " + fRetVal);
            } else {
                this.msg.printTestError("getFloat did not return the Null Value ", "test getFloat Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getFloat is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getFloat Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Real_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void testGetString03() throws EETest.Fault {
        try {
            this.rsSch.createTab("Varchar_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Varchar_Proc(?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 12);
            this.cstmt.registerOutParameter(2, 12);
            this.msg.setMsg("execute the procedure");
            this.cstmt.execute();
            this.msg.setMsg("invoke getString method");
            String oRetVal = this.cstmt.getString(1);
            String oExtVal = this.rsSch.extractVal("Varchar_Tab", 1, this.sqlp, this.conn);
            oExtVal = oExtVal.trim();
            oRetVal = oRetVal.trim();
            this.msg.addOutputMsg(oExtVal, oRetVal);
            if (oRetVal.equals(oExtVal.substring(1, oExtVal.length() - 1))) {
                this.msg.setMsg("getString returns the Name ");
            } else {
                this.msg.printTestError("getString did not return the Name ", "test getString Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getString Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Varchar_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void testGetString04() throws EETest.Fault {
        try {
            this.rsSch.createTab("Varchar_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Varchar_Proc(?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 12);
            this.cstmt.registerOutParameter(2, 12);
            this.msg.setMsg("execute the procedure");
            this.cstmt.execute();
            this.msg.setMsg("Calling CallableStatement.getString(NullValue(JDBC VARCHAR))");
            this.msg.setMsg("invoke getString method");
            String oRetVal = this.cstmt.getString(2);
            this.msg.addOutputMsg("null", oRetVal);
            if (oRetVal == null) {
                this.msg.setMsg("getString returns the null value ");
            } else {
                this.msg.printTestError("getString did not return the null value", "test getString Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getString is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getString Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Varchar_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void testGetString05() throws EETest.Fault {
        try {
            this.rsSch.createTab("Longvarchar_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Longvarchar_Proc(?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, -1);
            this.msg.setMsg("execute the procedure");
            this.cstmt.execute();
            this.msg.setMsg("invoke getString method");
            String oRetVal = this.cstmt.getString(1);
            String oExtVal = this.rsSch.extractVal("Longvarchar_Tab", 1, this.sqlp, this.conn);
            oExtVal = oExtVal.trim();
            oRetVal = oRetVal.trim();
            this.msg.addOutputMsg(oExtVal, oRetVal);
            if (oRetVal.equals(oExtVal.substring(1, oExtVal.length() - 1))) {
                this.msg.setMsg("getString returns the Name " + oRetVal);
            } else {
                this.msg.printTestError("getString did not return the Name", "test getString Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getString is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getString Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Longvarchar_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void testGetString06() throws EETest.Fault {
        try {
            this.rsSch.createTab("Longvarcharnull_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Lvarcharnull_Proc(?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, -1);
            this.msg.setMsg("execute the procedure");
            this.cstmt.execute();
            this.msg.setMsg("Calling CallableStatement.getString(NullValue(JDBC LONGVARCHAR))");
            this.msg.setMsg("invoke getString method");
            String oRetVal = this.cstmt.getString(1);
            this.msg.addOutputMsg("null", oRetVal);
            if (oRetVal == null) {
                this.msg.setMsg("getString returns the null value ");
            } else {
                this.msg.printTestError("getString did not return the null value", "test getString Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getString is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getString Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Longvarcharnull_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetBigDecimal04() throws EETest.Fault {
        try {
            this.rsSch.createTab("Decimal_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Decimal_Proc(?,?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 3, 15);
            this.cstmt.registerOutParameter(2, 3, 15);
            this.cstmt.registerOutParameter(3, 3, 15);
            this.msg.setMsg("execute the procedure");
            this.cstmt.execute();
            this.msg.setMsg("invoke getBigDecimal method");
            BigDecimal oRetVal = this.cstmt.getBigDecimal(1);
            String sRetStr = this.rsSch.extractVal("Decimal_Tab", 1, this.sqlp, this.conn);
            BigDecimal oExtVal = new BigDecimal(sRetStr);
            this.msg.addOutputMsg(sRetStr, oRetVal.toString());
            if (oRetVal.compareTo(oExtVal) == 0) {
                this.msg.setMsg("getBigDecimal returns the Maximum value " + oRetVal);
            } else {
                this.msg.printTestError("getBigDecimal did not return the Maximum value", "test getBigDecimal Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getBigDecimal is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getBigDecimal Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Decimal_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetBigDecimal05() throws EETest.Fault {
        try {
            this.rsSch.createTab("Decimal_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Decimal_Proc(?,?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 3, 15);
            this.cstmt.registerOutParameter(2, 3, 15);
            this.cstmt.registerOutParameter(3, 3, 15);
            this.msg.setMsg("execute the procedure");
            this.cstmt.execute();
            this.msg.setMsg("invoke getBigDecimal method");
            BigDecimal oRetVal = this.cstmt.getBigDecimal(2);
            String sRetStr = this.rsSch.extractVal("Decimal_Tab", 2, this.sqlp, this.conn);
            BigDecimal oExtVal = new BigDecimal(sRetStr);
            this.msg.addOutputMsg(sRetStr, oRetVal.toString());
            if (oRetVal.compareTo(oExtVal) == 0) {
                this.msg.setMsg("getBigDecimal returns the Minimum value " + oRetVal);
            } else {
                this.msg.printTestError("getBigDecimal did not return the Minimum value", "test getBigDecimal Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getBigDecimal is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getBigDecimal Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Decimal_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void testGetBigDecimal06() throws EETest.Fault {
        try {
            this.rsSch.createTab("Decimal_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Decimal_Proc(?,?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 3, 15);
            this.cstmt.registerOutParameter(2, 3, 15);
            this.cstmt.registerOutParameter(3, 3, 15);
            this.msg.setMsg("execute the procedure");
            this.cstmt.execute();
            this.msg.setMsg("invoke getBigDecimal method");
            BigDecimal oRetVal = this.cstmt.getBigDecimal(3);
            this.msg.addOutputMsg("null", "" + oRetVal);
            if (oRetVal == null) {
                this.msg.setMsg("getBigDecimal returns the Null value " + oRetVal);
            } else {
                this.msg.printTestError("getBigDecimal did not return the Null value", "test getBigDecimal Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getBigDecimal is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getBigDecimal Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Decimal_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetBytes01() throws EETest.Fault {
        String binarySize = null;
        Statement pstmt = null;
        try {
            this.rsSch.createTab("Binary_Tab", this.sqlp, this.conn);
            binarySize = this.props.getProperty("binarySize");
            String sPrepStmt = this.sqlp.getProperty("Binary_Tab_Val_Update", "");
            this.msg.setMsg("Prepared Statement String :" + sPrepStmt);
            int bytearrsize = Integer.parseInt(binarySize);
            this.msg.setMsg("Binary Size : " + bytearrsize);
            byte[] bytearr = new byte[bytearrsize];
            String sbyteval = null;
            this.msg.setMsg("getting the bytearray value");
            for (int count = 0; count < bytearrsize; ++count) {
                sbyteval = Integer.toString(count % 255);
                bytearr[count] = Byte.parseByte(sbyteval);
            }
            this.msg.setMsg("get the PreparedStatement object");
            pstmt = this.conn.prepareStatement(sPrepStmt);
            pstmt.setBytes(1, bytearr);
            pstmt.executeUpdate();
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Binary_Proc(?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, -2);
            this.msg.setMsg("execute the procedure");
            this.cstmt.execute();
            this.msg.setMsg("invoke getBytes method");
            byte[] oRetVal = this.cstmt.getBytes(1);
            for (int i = 0; i < bytearrsize; ++i) {
                this.msg.addOutputMsg(Byte.toString(bytearr[i]), Byte.toString(oRetVal[i]));
                if (oRetVal[i] == bytearr[i]) continue;
                this.msg.printTestError("getBytes did not return the proper byte array values", "test getBytes Failed!");
            }
            this.msg.setMsg("getBytes returns the proper byte array values");
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getBytes is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getBytes Failed!");
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Binary_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void testGetBytes02() throws EETest.Fault {
        String binarySize = null;
        try {
            binarySize = this.props.getProperty("binarySize");
            this.msg.setMsg("Binary Table Size : " + binarySize);
            this.rsSch.createTab("Binary_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Binary_Proc(?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, -2);
            this.msg.setMsg("execute the procedure");
            this.cstmt.execute();
            this.msg.setMsg("invoke getBytes method");
            byte[] oRetVal = this.cstmt.getBytes(1);
            this.msg.addOutputMsg("null", "" + oRetVal);
            if (oRetVal == null) {
                this.msg.setMsg("getBytes returns the null value");
            } else {
                this.msg.printTestError("getBytes did not return the null value", "test getBytes Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getBytes is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getBytes Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Binary_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetBytes03() throws EETest.Fault {
        String varbinarySize = null;
        Statement pstmt = null;
        try {
            varbinarySize = this.props.getProperty("varbinarySize");
            this.msg.setMsg("varbinary Table Size : " + varbinarySize);
            this.rsSch.createTab("Varbinary_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Varbinary_Tab_Val_Update", "");
            this.msg.setMsg("Prepared Statement String :" + sPrepStmt);
            int bytearrsize = Integer.parseInt(varbinarySize);
            this.msg.setMsg("varbinary Size : " + bytearrsize);
            byte[] bytearr = new byte[bytearrsize];
            String sbyteval = null;
            this.msg.setMsg("to get the bytearray value");
            for (int count = 0; count < bytearrsize; ++count) {
                sbyteval = Integer.toString(count % 255);
                bytearr[count] = Byte.parseByte(sbyteval);
            }
            this.msg.setMsg("get the PreparedStatement object");
            pstmt = this.conn.prepareStatement(sPrepStmt);
            pstmt.setBytes(1, bytearr);
            pstmt.executeUpdate();
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Varbinary_Proc(?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, -3);
            this.msg.setMsg("execute the procedure");
            this.cstmt.execute();
            this.msg.setMsg("invoke getBytes method");
            byte[] oRetVal = this.cstmt.getBytes(1);
            for (int i = 0; i < bytearrsize; ++i) {
                this.msg.addOutputMsg(Byte.toString(bytearr[i]), Byte.toString(oRetVal[i]));
                if (oRetVal[i] == bytearr[i]) continue;
                this.msg.printTestError("getBytes did not return the proper byte array values", "test getBytes Failed!");
            }
            this.msg.setMsg("getBytes returns the proper byte array values");
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getBytes is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getBytes Failed!");
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Varbinary_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void testGetBytes04() throws EETest.Fault {
        String varbinarySize = null;
        try {
            varbinarySize = this.props.getProperty("varbinarySize");
            this.msg.setMsg("varbinary Table Size : " + varbinarySize);
            this.rsSch.createTab("Varbinary_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Varbinary_Proc(?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, -3);
            this.msg.setMsg("execute the procedure");
            this.cstmt.execute();
            this.msg.setMsg("invoke getObject method");
            byte[] oRetVal = this.cstmt.getBytes(1);
            this.msg.addOutputMsg("null", "" + oRetVal);
            if (oRetVal == null) {
                this.msg.setMsg("getBytes returns the null value");
            } else {
                this.msg.printTestError("getBytes did not return the null value", "test getBytes Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getBytes is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getBytes Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Varbinary_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetBytes05() throws EETest.Fault {
        String longvarbinarySize = null;
        Statement pstmt = null;
        try {
            this.rsSch.createTab("Longvarbinary_Tab", this.sqlp, this.conn);
            longvarbinarySize = this.props.getProperty("longvarbinarySize");
            this.msg.setMsg("longvarbinary Table Size : " + longvarbinarySize);
            String sPrepStmt = this.sqlp.getProperty("Longvarbinary_Tab_Val_Update", "");
            this.msg.setMsg("Prepared Statement String :" + sPrepStmt);
            int bytearrsize = Integer.parseInt(longvarbinarySize);
            this.msg.setMsg("varbinary Size : " + bytearrsize);
            byte[] bytearr = new byte[bytearrsize];
            String sbyteval = null;
            this.msg.setMsg("getting the bytearray value");
            for (int count = 0; count < bytearrsize; ++count) {
                sbyteval = Integer.toString(count % 255);
                bytearr[count] = Byte.parseByte(sbyteval);
            }
            this.msg.setMsg("get the PreparedStatement object");
            pstmt = this.conn.prepareStatement(sPrepStmt);
            pstmt.setBytes(1, bytearr);
            pstmt.executeUpdate();
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Longvarbinary_Proc(?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, -4);
            this.msg.setMsg("execute the procedure");
            this.cstmt.execute();
            this.msg.setMsg("invoke getBytes method");
            byte[] oRetVal = this.cstmt.getBytes(1);
            for (int i = 0; i < bytearrsize; ++i) {
                this.msg.addOutputMsg(Byte.toString(bytearr[i]), Byte.toString(oRetVal[i]));
                if (oRetVal[i] == bytearr[i]) continue;
                this.msg.printTestError("getBytes did not return the proper byte array values", "test getBytes Failed!");
            }
            this.msg.setMsg("getBytes returns the proper byte array values");
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getBytes is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getBytes Failed!");
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Longvarbinary_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void testGetBytes06() throws EETest.Fault {
        try {
            this.rsSch.createTab("Longvarbinary_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Longvarbinary_Proc(?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, -4);
            this.msg.setMsg("execute the procedure");
            this.cstmt.execute();
            this.msg.setMsg("invoke getBytes method");
            byte[] oRetVal = this.cstmt.getBytes(1);
            this.msg.addOutputMsg("null", "" + oRetVal);
            if (oRetVal == null) {
                this.msg.setMsg("getBytes returns the null value");
            } else {
                this.msg.printTestError("getBytes did not return the null value", "test getBytes Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getBytes is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getBytes Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Longvarbinary_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void cleanup() throws EETest.Fault {
        try {
            this.rsSch.dbUnConnect(this.conn);
            this.logMsg("Cleanup ok;");
        }
        catch (Exception e) {
            this.logErr("An error occurred while closing the database connection", e);
        }
    }
}

