/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.bb.session.stateful.remove.common;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.tests.ejb30.bb.session.stateful.remove.common.Remove2IF;
import com.sun.ts.tests.ejb30.bb.session.stateful.remove.common.RemoveIF;
import com.sun.ts.tests.ejb30.bb.session.stateful.remove.common.RemoveNotRetainIF;
import com.sun.ts.tests.ejb30.bb.session.stateful.remove.common.TestIF;
import com.sun.ts.tests.ejb30.common.appexception.AtUncheckedAppException;
import com.sun.ts.tests.ejb30.common.appexception.UncheckedAppException;
import com.sun.ts.tests.ejb30.common.helper.TLogger;
import com.sun.ts.tests.ejb30.common.helper.TestFailedException;
import com.sun.ts.tests.ejb30.common.migration.twothree.TwoRemoteHome;
import com.sun.ts.tests.ejb30.common.migration.twothree.TwoRemoteIF;
import jakarta.ejb.CreateException;
import jakarta.ejb.Handle;
import jakarta.ejb.NoSuchEJBException;
import jakarta.ejb.RemoveException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.Properties;

public abstract class ClientBase
extends EETest {
    protected Properties props;
    private RemoveIF removeBean;
    private Remove2IF removeBean2;
    private RemoveNotRetainIF removeNotRetainBean;
    private TestIF testBean;

    protected abstract RemoveIF getRemoveBean();

    protected abstract Remove2IF getRemoveBean2();

    protected abstract RemoveNotRetainIF getRemoveNotRetainBean();

    protected abstract TestIF getTestBean();

    protected abstract TwoRemoteHome getTwoRemoteHome();

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        this.removeBean = this.getRemoveBean();
        this.removeBean2 = this.getRemoveBean2();
        this.testBean = this.getTestBean();
        this.removeNotRetainBean = this.getRemoveNotRetainBean();
    }

    public void cleanup() throws EETest.Fault {
        this.removeBeans();
    }

    protected void removeBeans() {
        if (this.removeBean != null) {
            try {
                this.removeBean.remove();
                TLogger.log("Successfully removed removeBean.");
            }
            catch (Exception e) {
                TLogger.log("Exception while removing removeBean " + e);
            }
        }
        if (this.removeBean2 != null) {
            try {
                this.removeBean2.remove();
                TLogger.log("Successfully removed removeBean2.");
            }
            catch (Exception e) {
                TLogger.log("Exception while removing removeBean2 " + e);
            }
        }
    }

    public void removeBean() throws EETest.Fault {
        this.removeBean.remove();
        try {
            this.removeBean.remove();
            throw new EETest.Fault("Expecting jakarta.ejb.NoSuchEJBException, but got none.");
        }
        catch (NoSuchEJBException e) {
            TLogger.log("Got expected exception: " + e.toString());
            this.removeBean = null;
            return;
        }
    }

    public void removeBean2() throws EETest.Fault {
        try {
            this.removeBean2.remove();
        }
        catch (RemoteException e) {
            throw new EETest.Fault(e);
        }
        try {
            this.removeBean2.remove();
            throw new EETest.Fault("Expecting java.rmi.NoSuchObjectException, but got none.");
        }
        catch (NoSuchObjectException e) {
            TLogger.log("Got expected exception: " + e.toString());
            this.removeBean2 = null;
        }
        catch (RemoteException e) {
            throw new EETest.Fault(e);
        }
    }

    public void testBeanremoveBean() throws EETest.Fault {
        try {
            this.testBean.removeBean();
        }
        catch (TestFailedException e) {
            throw new EETest.Fault(e);
        }
    }

    public void testBeanremoveBeanRemote() throws EETest.Fault {
        try {
            this.testBean.removeBeanRemote();
        }
        catch (TestFailedException e) {
            throw new EETest.Fault(e);
        }
    }

    public void testBeanremoveBean2() throws EETest.Fault {
        try {
            this.testBean.removeBean2();
        }
        catch (TestFailedException e) {
            throw new EETest.Fault(e);
        }
    }

    public void testBeanremoveBean2Remote() throws EETest.Fault {
        try {
            this.testBean.removeBean2Remote();
        }
        catch (TestFailedException e) {
            throw new EETest.Fault(e);
        }
    }

    public void retainBean() throws EETest.Fault {
        try {
            this.removeBean.retain();
        }
        catch (TestFailedException testFailedException) {
            // empty catch block
        }
        try {
            this.removeBean.retain2();
        }
        catch (AtUncheckedAppException atUncheckedAppException) {
        }
        catch (UncheckedAppException uncheckedAppException) {
            // empty catch block
        }
        try {
            this.removeBean.remove();
            TLogger.log("removeBean removed successfully");
        }
        catch (NoSuchEJBException e) {
            throw new EETest.Fault("Failed to remove bean, which should be there when thismethod was called");
        }
        finally {
            this.removeBean = null;
        }
    }

    public void retainBeanOverloaded() throws EETest.Fault {
        this.removeBean.remove("This is not a remove-method. Not to remove bean.");
        this.removeBean.hi();
        try {
            this.removeBean.remove();
            TLogger.log("removeBean removed successfully");
        }
        catch (NoSuchEJBException e) {
            throw new EETest.Fault("Failed to remove bean, which should be there when thismethod was called. But got " + (Object)((Object)e));
        }
        finally {
            this.removeBean = null;
        }
    }

    public void retainBean2() throws EETest.Fault {
        try {
            this.removeBean2.retain2();
        }
        catch (AtUncheckedAppException atUncheckedAppException) {
        }
        catch (UncheckedAppException uncheckedAppException) {
        }
        catch (RemoteException e) {
            throw new EETest.Fault(e);
        }
        try {
            this.removeBean2.remove();
            TLogger.log("removeBean2 removed successfully");
        }
        catch (RemoteException e) {
            throw new EETest.Fault(e);
        }
        finally {
            this.removeBean2 = null;
        }
    }

    public void testBeanretainBean() throws EETest.Fault {
        try {
            this.testBean.retainBean();
        }
        catch (TestFailedException e) {
            throw new EETest.Fault(e);
        }
    }

    public void testBeanretainBeanOverloaded() throws EETest.Fault {
        try {
            this.testBean.retainBeanOverloaded();
        }
        catch (TestFailedException e) {
            throw new EETest.Fault(e);
        }
    }

    public void testBeanretainBeanRemote() throws EETest.Fault {
        try {
            this.testBean.retainBeanRemote();
        }
        catch (TestFailedException e) {
            throw new EETest.Fault(e);
        }
    }

    public void testBeanretainBean2() throws EETest.Fault {
        try {
            this.testBean.retainBean2();
        }
        catch (TestFailedException e) {
            throw new EETest.Fault(e);
        }
    }

    public void testBeanretainBean2Remote() throws EETest.Fault {
        try {
            this.testBean.retainBean2Remote();
        }
        catch (TestFailedException e) {
            throw new EETest.Fault(e);
        }
    }

    public void removeNotRetainBean() throws EETest.Fault {
        try {
            this.removeNotRetainBean.remove();
        }
        catch (TestFailedException e) {
            TLogger.log("Got expected exception, and bean should have been removeddespite the exception");
        }
        try {
            this.removeNotRetainBean.remove();
            throw new EETest.Fault("Expecting jakarta.ejb.NoSuchEJBException, but got none.");
        }
        catch (NoSuchEJBException e) {
            TLogger.log("Got expected exception: " + e.toString());
            this.removeNotRetainBean = null;
        }
        catch (TestFailedException e) {
            try {
                throw new EETest.Fault("Unexpected exception", e);
            }
            catch (Throwable throwable) {
                this.removeNotRetainBean = null;
                throw throwable;
            }
        }
    }

    /*
     * Exception decompiling
     */
    public void removeNotRetainBean2() throws EETest.Fault {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void alwaysRemoveAfterSystemException() throws EETest.Fault {
        try {
            this.removeNotRetainBean.alwaysRemoveAfterSystemException();
        }
        catch (Exception e) {
            TLogger.log("Got expected exception, and bean should have been removed after the system exception: " + e);
        }
        try {
            try {
                this.removeNotRetainBean.alwaysRemoveAfterSystemException();
                throw new EETest.Fault("Expecting jakarta.ejb.NoSuchEJBException, but got none.");
            }
            catch (NoSuchEJBException e) {
                TLogger.log("Got expected exception: " + e.toString());
                this.removeNotRetainBean = null;
            }
        }
        catch (Throwable throwable) {
            this.removeNotRetainBean = null;
            throw throwable;
        }
    }

    public void removeTwoRemoteHome() throws EETest.Fault {
        TwoRemoteHome beanHome = this.getTwoRemoteHome();
        TwoRemoteIF bean = null;
        try {
            bean = beanHome.create();
            bean.remove();
        }
        catch (RemoveException e) {
            throw new EETest.Fault(e);
        }
        catch (CreateException e) {
            throw new EETest.Fault(e);
        }
        catch (RemoteException e) {
            throw new EETest.Fault(e);
        }
        try {
            bean.remove();
            throw new EETest.Fault("Expecting java.rmi.NoSuchObjectException, but got none.");
        }
        catch (NoSuchObjectException e) {
            TLogger.log("Got expected exception: " + e.toString());
        }
        catch (RemoveException e) {
            throw new EETest.Fault(e);
        }
        catch (RemoteException e) {
            throw new EETest.Fault(e);
        }
    }

    public void removeTwoRemoteHomeHandle() throws EETest.Fault {
        TwoRemoteHome beanHome = this.getTwoRemoteHome();
        TwoRemoteIF bean = null;
        try {
            bean = beanHome.create();
            beanHome.remove(bean);
        }
        catch (RemoveException e) {
            TLogger.log("Got expected exception " + e.toString());
        }
        catch (CreateException e) {
            throw new EETest.Fault(e);
        }
        catch (RemoteException e) {
            throw new EETest.Fault(e);
        }
        try {
            Handle handle = bean.getHandle();
            beanHome.remove(handle);
            TLogger.log("Successfully removed bean handler " + handle);
        }
        catch (RemoveException e) {
            throw new EETest.Fault(e);
        }
        catch (RemoteException e) {
            throw new EETest.Fault(e);
        }
        try {
            bean.remove();
            throw new EETest.Fault("Expecting java.rmi.NoSuchObjectException, but got none.");
        }
        catch (NoSuchObjectException e) {
            TLogger.log("Got expected exception: " + e.toString());
        }
        catch (RemoveException e) {
            throw new EETest.Fault(e);
        }
        catch (RemoteException e) {
            throw new EETest.Fault(e);
        }
    }

    public void testBeanRemoveTwoLocal() throws EETest.Fault {
        try {
            this.testBean.removeTwoLocal();
        }
        catch (TestFailedException e) {
            throw new EETest.Fault(e);
        }
    }
}

